/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.searcher.gis.google.geo;

import com.nepxion.swing.action.JSecurityAction;
import com.nepxion.swing.handle.HandleManager;
import com.nepxion.swing.icon.IconFactory;
import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.optionpane.JBasicOptionPane;
import com.nepxion.swing.searcher.gis.google.geo.GeoTableModel;
import com.nepxion.swing.searcher.gis.google.geo.JGeoPanel;
import com.nepxion.swing.searcher.gis.google.geo.JGeoTable;
import com.nepxion.swing.thread.dialog.JThreadDialog;
import com.nepxion.util.searcher.gis.google.geo.GeoSearcher;
import java.awt.event.ActionEvent;
import java.util.List;

public class GeoController {
    public static JSecurityAction getSearchAction(final JGeoPanel panel) {
        JSecurityAction action = new JSecurityAction(SwingLocale.getString("query"), IconFactory.getSwingIcon("stereo_search.png"), SwingLocale.getString("address_to_geo")){

            @Override
            public void execute(ActionEvent e) {
                JThreadDialog dialog = new JThreadDialog(HandleManager.getFrame(panel), SwingLocale.getString("address_to_geo"), SwingLocale.getString("query_and_wait")){

                    @Override
                    protected void loadForeground(Object data) throws Exception {
                        List entityList = (List)data;
                        if (entityList == null || entityList.isEmpty()) {
                            JBasicOptionPane.showMessageDialog(HandleManager.getFrame(panel), SwingLocale.getString("no_records"), SwingLocale.getString("warning"), 2);
                            return;
                        }
                        GeoTableModel tableModel = (GeoTableModel)panel.getGeoTable().getModel();
                        tableModel.setRowDatas(entityList);
                    }

                    @Override
                    protected Object loadBackground() throws Exception {
                        String address = panel.getAddress();
                        if (address.equals("")) {
                            throw new IllegalArgumentException(SwingLocale.getString("address_description"));
                        }
                        GeoSearcher searcher = new GeoSearcher();
                        List entityList = searcher.search(address);
                        return entityList;
                    }
                };
                dialog.execute();
            }
        };
        return action;
    }

    public static JSecurityAction getClearAction(final JGeoTable table) {
        JSecurityAction action = new JSecurityAction(SwingLocale.getString("clear"), IconFactory.getSwingIcon("stereo/delete_16.png"), SwingLocale.getString("clear_query_result")){

            @Override
            public void execute(ActionEvent e) {
                int selectedValue = JBasicOptionPane.showConfirmDialog(HandleManager.getFrame(table), SwingLocale.getString("confirm_to_clear_query_result"), SwingLocale.getString("confirm"), 0);
                if (selectedValue != 0) {
                    return;
                }
                GeoTableModel tableModel = (GeoTableModel)table.getModel();
                tableModel.clearRows();
            }
        };
        return action;
    }
}

