/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.panel;

import com.nepxion.swing.gradient.JGradientPainter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class JGradientPanel
extends JPanel {
    private Color gradientColor;

    public JGradientPanel(Color background) {
        this(background, null);
    }

    public JGradientPanel(LayoutManager layoutManager, Color background) {
        this(layoutManager, background, null);
    }

    public JGradientPanel(Color background, Color gradientColor) {
        this.setBackground(background);
        this.gradientColor = gradientColor;
    }

    public JGradientPanel(LayoutManager layoutManager, Color background, Color gradientColor) {
        super(layoutManager);
        this.setBackground(background);
        this.gradientColor = gradientColor;
    }

    public void setGradientColor(Color gradientColor) {
        this.gradientColor = gradientColor;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isOpaque()) {
            if (this.gradientColor == null) {
                this.gradientColor = UIManager.getColor("Panel.background");
            }
            Rectangle rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
            JGradientPainter.fastFill((Graphics2D)g, rectangle, this.gradientColor, this.getBackground(), false);
        }
    }
}

