/*
 * Decompiled with CFR 0.152.
 */
package twaver;

import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import twaver.TWaverUtil;

public class Layer
implements Serializable {
    public static final String PROPERTY_ID = "id";
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_DESCRIPTION = "description";
    public static final String PROPERTY_VISIBLE = "visible";
    public static final String PROPERTY_SELECTABLE = "selectable";
    public static final String PROPERTY_MOVABLE = "movable";
    public static final String PROPERTY_RESIZABLE = "resizable";
    public static final String PROPERTY_ALPHA = "alpha";
    private final Object H;
    private String J = null;
    private boolean B = true;
    private boolean F = true;
    private boolean C = true;
    private boolean E = true;
    private float D = 1.0f;
    private String I = null;
    private PropertyChangeSupport A = new PropertyChangeSupport(this);
    private Map G = new LinkedHashMap();

    public Layer() {
        this.H = TWaverUtil.getIdentifier(this);
    }

    public Layer(Object id) {
        this.H = id;
    }

    public Layer(Object id, String name) {
        this.H = id;
        this.J = name;
    }

    public Layer(Object id, String name, String description, boolean visible) {
        this.H = id;
        this.J = name;
        this.I = description;
        this.B = visible;
    }

    public void exportValues(Layer otherLayer) {
        otherLayer.setName(this.getName());
        otherLayer.setDescription(this.getDescription());
        otherLayer.setVisible(this.isVisible());
        otherLayer.setMovable(this.isMovable());
        otherLayer.setSelectable(this.isSelectable());
        otherLayer.setResizable(this.isResizable());
        otherLayer.setAlpha(this.getAlpha());
        Iterator it = this.getClientProperties().keySet().iterator();
        while (it.hasNext()) {
            Object propertyKey = it.next();
            Object value = this.getClientProperty(propertyKey);
            otherLayer.putClientProperty(propertyKey, value);
        }
    }

    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.A;
    }

    public Object getClientProperty(Object key) {
        return this.G.get(key);
    }

    public void putClientProperty(Object key, Object value) {
        Object newValue;
        Object oldValue = this.getClientProperty(key);
        if (oldValue != (newValue = value)) {
            this.G.put(key, value);
            String propertyName = "CP:" + key.toString();
            this.A.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public Map getClientProperties() {
        return this.G;
    }

    public String getName() {
        return this.J;
    }

    public void setName(String name) {
        String oldValue = this.J;
        this.J = name;
        this.getPropertyChangeSupport().firePropertyChange(PROPERTY_NAME, oldValue, name);
    }

    public boolean isVisible() {
        return this.B;
    }

    public void setVisible(boolean visible) {
        boolean oldValue = this.B;
        this.B = visible;
        this.getPropertyChangeSupport().firePropertyChange(PROPERTY_VISIBLE, oldValue, visible);
    }

    public Object getID() {
        return this.H;
    }

    public String getDescription() {
        return this.I;
    }

    public void setDescription(String description) {
        String oldValue = this.I;
        this.I = description;
        this.getPropertyChangeSupport().firePropertyChange(PROPERTY_DESCRIPTION, oldValue, description);
    }

    public float getAlpha() {
        return this.D;
    }

    public void setAlpha(float alpha) {
        if (alpha != this.D && alpha >= 0.0f && alpha <= 1.0f) {
            float oldValue = this.D;
            this.D = alpha;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_ALPHA, new Float(oldValue), new Float(alpha));
        }
    }

    public boolean isMovable() {
        return this.C;
    }

    public void setMovable(boolean movable) {
        boolean oldValue = this.C;
        this.C = movable;
        this.getPropertyChangeSupport().firePropertyChange(PROPERTY_MOVABLE, oldValue, movable);
    }

    public boolean isSelectable() {
        return this.F;
    }

    public void setSelectable(boolean selectable) {
        boolean oldValue = this.F;
        this.F = selectable;
        this.getPropertyChangeSupport().firePropertyChange(PROPERTY_SELECTABLE, oldValue, selectable);
    }

    public boolean isResizable() {
        return this.E;
    }

    public void setResizable(boolean resizable) {
        boolean oldValue = this.E;
        this.E = resizable;
        this.getPropertyChangeSupport().firePropertyChange(PROPERTY_RESIZABLE, oldValue, resizable);
    }

    public String toString() {
        return this.getName();
    }
}

