/*
 * Decompiled with CFR 0.152.
 */
package y.layout;

import java.awt.Rectangle;
import java.util.Vector;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.EdgeList;
import y.base.Graph;
import y.base.Node;
import y.base.NodeCursor;
import y.base.YCursor;
import y.base.YList;
import y.geom.YDimension;
import y.geom.YPoint;
import y.geom.YPointCursor;
import y.geom.YPointPath;
import y.geom.YRectangle;
import y.layout.EdgeLabelLayout;
import y.layout.EdgeLayout;
import y.layout.GraphLayout;
import y.layout.NodeLabelLayout;
import y.layout.NodeLayout;

public abstract class LayoutGraph
extends Graph
implements GraphLayout {
    public LayoutGraph() {
    }

    public LayoutGraph(LayoutGraph layoutGraph, YCursor yCursor) {
        super(layoutGraph, yCursor);
    }

    public abstract NodeLayout getLayout(Node var1);

    public abstract EdgeLayout getLayout(Edge var1);

    public abstract NodeLabelLayout[] getLabelLayout(Node var1);

    public abstract EdgeLabelLayout[] getLabelLayout(Edge var1);

    public abstract Node getFeature(NodeLabelLayout var1);

    public abstract Edge getFeature(EdgeLabelLayout var1);

    public NodeLayout getNodeLayout(Object object) {
        return this.getLayout((Node)object);
    }

    public EdgeLayout getEdgeLayout(Object object) {
        return this.getLayout((Edge)object);
    }

    public NodeLabelLayout[] getNodeLabelLayout(Object object) {
        return this.getLabelLayout((Node)object);
    }

    public EdgeLabelLayout[] getEdgeLabelLayout(Object object) {
        return this.getLabelLayout((Edge)object);
    }

    public double getCenterX(Node node) {
        NodeLayout nodeLayout = this.getLayout(node);
        return nodeLayout.getX() + nodeLayout.getWidth() / 2.0;
    }

    public double getCenterY(Node node) {
        NodeLayout nodeLayout = this.getLayout(node);
        return nodeLayout.getY() + nodeLayout.getHeight() / 2.0;
    }

    public YPoint getCenter(Node node) {
        return new YPoint(this.getCenterX(node), this.getCenterY(node));
    }

    public double getX(Node node) {
        return this.getLayout(node).getX();
    }

    public double getY(Node node) {
        return this.getLayout(node).getY();
    }

    public YPoint getLocation(Node node) {
        NodeLayout nodeLayout = this.getLayout(node);
        return new YPoint(nodeLayout.getX(), nodeLayout.getY());
    }

    public double getWidth(Node node) {
        return this.getLayout(node).getWidth();
    }

    public double getHeight(Node node) {
        return this.getLayout(node).getHeight();
    }

    public YDimension getSize(Node node) {
        return new YDimension(this.getWidth(node), this.getHeight(node));
    }

    public YRectangle getRectangle(Node node) {
        return new YRectangle(this.getLocation(node), this.getSize(node));
    }

    public void setCenter(Node node, YPoint yPoint) {
        this.setCenter(node, yPoint.getX(), yPoint.getY());
    }

    public void setCenter(Node node, double d2, double d3) {
        NodeLayout nodeLayout = this.getLayout(node);
        nodeLayout.setLocation(d2 - nodeLayout.getWidth() / 2.0, d3 - nodeLayout.getHeight() / 2.0);
    }

    public void setSize(Node node, double d2, double d3) {
        this.getLayout(node).setSize(d2, d3);
    }

    public void setSize(Node node, YDimension yDimension) {
        this.setSize(node, yDimension.getWidth(), yDimension.getHeight());
    }

    public void setLocation(Node node, double d2, double d3) {
        this.getLayout(node).setLocation(d2, d3);
    }

    public void setLocation(Node node, YPoint yPoint) {
        this.setLocation(node, yPoint.getX(), yPoint.getY());
    }

    public void moveBy(Node node, double d2, double d3) {
        NodeLayout nodeLayout = this.getLayout(node);
        nodeLayout.setLocation(nodeLayout.getX() + d2, nodeLayout.getY() + d3);
    }

    public YPointPath getPoints(Edge edge) {
        EdgeLayout edgeLayout = this.getLayout(edge);
        Vector<YPoint> vector = new Vector<YPoint>(edgeLayout.pointCount());
        int n = 0;
        while (n < edgeLayout.pointCount()) {
            vector.addElement(edgeLayout.getPoint(n));
            ++n;
        }
        return new YPointPath(vector);
    }

    public YList getPointList(Edge edge) {
        EdgeLayout edgeLayout = this.getLayout(edge);
        YList yList = new YList();
        int n = 0;
        while (n < edgeLayout.pointCount()) {
            yList.add(edgeLayout.getPoint(n));
            ++n;
        }
        return yList;
    }

    public YPointPath getPath(Edge edge) {
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(this.getSourcePointAbs(edge));
        YPointCursor yPointCursor = this.getPoints(edge).points();
        while (yPointCursor.ok()) {
            vector.addElement(yPointCursor.current());
            yPointCursor.next();
        }
        vector.addElement(this.getTargetPointAbs(edge));
        return new YPointPath(vector);
    }

    public YList getPathList(Edge edge) {
        YList yList = new YList();
        yList.add(this.getSourcePointAbs(edge));
        YPointCursor yPointCursor = this.getPoints(edge).points();
        while (yPointCursor.ok()) {
            yList.add(yPointCursor.current());
            yPointCursor.next();
        }
        yList.add(this.getTargetPointAbs(edge));
        return yList;
    }

    public void setPath(Edge edge, YPointPath yPointPath) {
        EdgeLayout edgeLayout = this.getLayout(edge);
        edgeLayout.clearPoints();
        YPointCursor yPointCursor = yPointPath.points();
        YPoint yPoint = yPointCursor.point();
        this.setSourcePointAbs(edge, yPoint);
        YPoint yPoint2 = yPointPath.getLast();
        yPointCursor.next();
        while (yPointCursor.current() != yPoint2) {
            yPoint = yPointCursor.point();
            edgeLayout.addPoint(yPoint.getX(), yPoint.getY());
            yPointCursor.next();
        }
        this.setTargetPointAbs(edge, yPoint2);
    }

    public void setPath(Edge edge, YList yList) {
        EdgeLayout edgeLayout = this.getLayout(edge);
        edgeLayout.clearPoints();
        YCursor yCursor = yList.cursor();
        YPoint yPoint = (YPoint)yCursor.current();
        this.setSourcePointAbs(edge, yPoint);
        YPoint yPoint2 = (YPoint)yList.last();
        yCursor.next();
        while (yCursor.current() != yPoint2) {
            yPoint = (YPoint)yCursor.current();
            edgeLayout.addPoint(yPoint.getX(), yPoint.getY());
            yCursor.next();
        }
        this.setTargetPointAbs(edge, yPoint2);
    }

    public void setPoints(Edge edge, YPointPath yPointPath) {
        EdgeLayout edgeLayout = this.getLayout(edge);
        edgeLayout.clearPoints();
        YPointCursor yPointCursor = yPointPath.points();
        while (yPointCursor.ok()) {
            YPoint yPoint = yPointCursor.point();
            edgeLayout.addPoint(yPoint.getX(), yPoint.getY());
            yPointCursor.next();
        }
    }

    public void setPoints(Edge edge, YList yList) {
        EdgeLayout edgeLayout = this.getLayout(edge);
        edgeLayout.clearPoints();
        YCursor yCursor = yList.cursor();
        while (yCursor.ok()) {
            YPoint yPoint = (YPoint)yCursor.current();
            edgeLayout.addPoint(yPoint.getX(), yPoint.getY());
            yCursor.next();
        }
    }

    public void setEndPointsAbs(Edge edge, YPoint yPoint, YPoint yPoint2) {
        this.setSourcePointAbs(edge, yPoint);
        this.setTargetPointAbs(edge, yPoint2);
    }

    public YPoint getSourcePointRel(Edge edge) {
        return this.getLayout(edge).getSourcePoint();
    }

    public YPoint getTargetPointRel(Edge edge) {
        return this.getLayout(edge).getTargetPoint();
    }

    public void setSourcePointRel(Edge edge, YPoint yPoint) {
        this.getLayout(edge).setSourcePoint(yPoint);
    }

    public void setTargetPointRel(Edge edge, YPoint yPoint) {
        this.getLayout(edge).setTargetPoint(yPoint);
    }

    public YPoint getSourcePointAbs(Edge edge) {
        YPoint yPoint = this.getLayout(edge).getSourcePoint();
        if (yPoint == null) {
            return this.getCenter(edge.source());
        }
        YPoint yPoint2 = new YPoint(this.getCenterX(edge.source()) + yPoint.getX(), this.getCenterY(edge.source()) + yPoint.getY());
        return yPoint2;
    }

    public YPoint getTargetPointAbs(Edge edge) {
        YPoint yPoint = this.getLayout(edge).getTargetPoint();
        if (yPoint == null) {
            return this.getCenter(edge.target());
        }
        YPoint yPoint2 = new YPoint(this.getCenterX(edge.target()) + yPoint.getX(), this.getCenterY(edge.target()) + yPoint.getY());
        return yPoint2;
    }

    public void setSourcePointAbs(Edge edge, YPoint yPoint) {
        YPoint yPoint2 = new YPoint(yPoint.getX() - this.getCenterX(edge.source()), yPoint.getY() - this.getCenterY(edge.source()));
        this.getLayout(edge).setSourcePoint(yPoint2);
    }

    public void setTargetPointAbs(Edge edge, YPoint yPoint) {
        YPoint yPoint2 = new YPoint(yPoint.getX() - this.getCenterX(edge.target()), yPoint.getY() - this.getCenterY(edge.target()));
        this.getLayout(edge).setTargetPoint(yPoint2);
    }

    public EdgeList getEdgeList() {
        EdgeList edgeList = new EdgeList();
        EdgeCursor edgeCursor = this.edges();
        while (edgeCursor.ok()) {
            edgeList.add(edgeCursor.edge());
            edgeCursor.next();
        }
        return edgeList;
    }

    public Rectangle getBoundingBox() {
        Object object;
        Object object2;
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MAX_VALUE;
        double d4 = -1.7976931348623157E308;
        double d5 = -1.7976931348623157E308;
        NodeCursor nodeCursor = this.nodes();
        while (nodeCursor.ok()) {
            object2 = this.getLocation(nodeCursor.node());
            object = this.getSize(nodeCursor.node());
            d3 = Math.min(((YPoint)object2).getX(), d3);
            d2 = Math.min(((YPoint)object2).getY(), d2);
            d5 = Math.max(((YPoint)object2).getX() + ((YDimension)object).getWidth(), d5);
            d4 = Math.max(((YPoint)object2).getY() + ((YDimension)object).getHeight(), d4);
            nodeCursor.next();
        }
        object2 = this.edges();
        while (object2.ok()) {
            object = this.getPoints(object2.edge()).cursor();
            while (object.ok()) {
                YPoint yPoint = (YPoint)object.current();
                d3 = Math.min(yPoint.getX(), d3);
                d2 = Math.min(yPoint.getY(), d2);
                d5 = Math.max(yPoint.getX(), d5);
                d4 = Math.max(yPoint.getY(), d4);
                object.next();
            }
            object2.next();
        }
        return new Rectangle((int)d3, (int)d2, (int)(d5 - d3), (int)(d4 - d2));
    }
}

