/*
 * Decompiled with CFR 0.152.
 */
package y.io.gml;

import java.io.IOException;
import y.base.Edge;
import y.io.GMLIOHandler;
import y.io.gml.GMLEncoder;
import y.io.gml.ObjectEncoder;
import y.view.Arrow;
import y.view.BendCursor;
import y.view.EdgeRealizer;
import y.view.Graph2D;
import y.view.NodeRealizer;

public class EdgeRealizerObjectEncoder
implements ObjectEncoder {
    public void encode(Object object, GMLEncoder gMLEncoder) throws IOException {
        EdgeRealizer edgeRealizer = (EdgeRealizer)object;
        Edge edge = edgeRealizer.getEdge();
        Graph2D graph2D = (Graph2D)edge.getGraph();
        NodeRealizer nodeRealizer = graph2D.getRealizer(edge.source());
        NodeRealizer nodeRealizer2 = graph2D.getRealizer(edge.target());
        gMLEncoder.addAttribute("width", (int)edgeRealizer.getLineType().getLineWidth());
        gMLEncoder.addAttribute("type", "line");
        gMLEncoder.addAttribute("fill", GMLIOHandler.convertColor(edgeRealizer.getLineColor()));
        if (edgeRealizer.getArrow() != Arrow.NONE) {
            gMLEncoder.addAttribute("arrow", "last");
        }
        if (edgeRealizer.getSourceArrow() != Arrow.NONE) {
            gMLEncoder.addAttribute("arrow", "first");
        }
        if (edgeRealizer.bendCount() > 0) {
            gMLEncoder.beginSection("Line");
            gMLEncoder.beginSection("point");
            gMLEncoder.addAttribute("x", (float)nodeRealizer.getCenterX());
            gMLEncoder.addAttribute("y", (float)nodeRealizer.getCenterY());
            gMLEncoder.endSection();
            BendCursor bendCursor = edgeRealizer.bends();
            while (bendCursor.ok()) {
                gMLEncoder.beginSection("point");
                gMLEncoder.addAttribute("x", (float)bendCursor.bend().getX());
                gMLEncoder.addAttribute("y", (float)bendCursor.bend().getY());
                gMLEncoder.endSection();
                bendCursor.next();
            }
            gMLEncoder.beginSection("point");
            gMLEncoder.addAttribute("x", (float)nodeRealizer2.getCenterX());
            gMLEncoder.addAttribute("y", (float)nodeRealizer2.getCenterY());
            gMLEncoder.endSection();
            gMLEncoder.endSection();
        }
    }
}

