/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.searcher.ip.local;

import com.nepxion.swing.button.ButtonManager;
import com.nepxion.swing.button.JBasicButton;
import com.nepxion.swing.dimension.DimensionManager;
import com.nepxion.swing.layout.toolbar.ToolBarLayout;
import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.scrollpane.JBasicScrollPane;
import com.nepxion.swing.searcher.ip.local.AddressController;
import com.nepxion.swing.searcher.ip.local.JAddressTable;
import com.nepxion.swing.textfield.JBasicTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class JAddressPanel
extends JPanel {
    private JBasicTextField addressTextField;
    private JAddressTable table = new JAddressTable();
    private JLabel versionDateLabel;
    private JLabel totalCountLabel;
    private JLabel countLabel;

    public JAddressPanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)new ToolBar(), "North");
        this.add((Component)new JBasicScrollPane(this.table), "Center");
        this.add((Component)new InfoBar(), "South");
    }

    public JAddressTable getAddressTable() {
        return this.table;
    }

    public String getAddress() {
        return this.addressTextField.getText().trim();
    }

    public void setAddress(String address) {
        this.addressTextField.setText(address.trim());
    }

    public void setCount(int count) {
        this.countLabel.setText(SwingLocale.getString("ip_database_matched") + " " + count);
    }

    public class InfoBar
    extends JPanel {
        public InfoBar() {
            JAddressPanel.this.versionDateLabel = new JLabel(SwingLocale.getString("ip_database_version") + " " + "2011-05-10");
            JAddressPanel.this.totalCountLabel = new JLabel(SwingLocale.getString("ip_database_capacity") + " " + 425675);
            JAddressPanel.this.countLabel = new JLabel(SwingLocale.getString("ip_database_matched") + " " + 0);
            this.setLayout(new FlowLayout(3));
            this.setPreferredSize(new Dimension(this.getPreferredSize().width, 23));
            this.add(JAddressPanel.this.versionDateLabel);
            this.add(JAddressPanel.this.totalCountLabel);
            this.add(JAddressPanel.this.countLabel);
        }
    }

    public class ToolBar
    extends JPanel {
        public ToolBar() {
            this.setLayout(new ToolBarLayout());
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
            JAddressPanel.this.addressTextField = new JBasicTextField();
            DimensionManager.setDimension(JAddressPanel.this.addressTextField, new Dimension(180, 23));
            JBasicButton searchButton = new JBasicButton(AddressController.getSearchAction(JAddressPanel.this));
            JBasicButton clearButton = new JBasicButton(AddressController.getClearAction(JAddressPanel.this.table));
            this.add(new JLabel(SwingLocale.getString("address")));
            this.add(JAddressPanel.this.addressTextField);
            this.add(searchButton);
            this.add(clearButton);
            this.add(Box.createHorizontalGlue());
            ButtonManager.updateUI(this);
        }
    }
}

