/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.util.searcher.ip.local;

import com.nepxion.util.searcher.ip.local.IPContext;
import com.nepxion.util.searcher.ip.local.IPEntity;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class IPSearcher {
    private static final int IP_RECORD_LENGTH = 7;
    private static final byte REDIRECT_MODE_1 = 1;
    private static final byte REDIRECT_MODE_2 = 2;
    private Map ipCache = new HashMap();
    private RandomAccessFile ipFile;
    private MappedByteBuffer ipByteBuffer;
    private StringBuffer ipStringBuffer = new StringBuffer();
    private long ipStart;
    private long ipEnd;
    private IPEntity ipEntity = new IPEntity();
    private byte[] buffer = new byte[1000];
    private byte[] b3 = new byte[3];
    private byte[] b4 = new byte[4];
    private static IPSearcher ipSearcher;

    public static IPSearcher getInstance() {
        if (ipSearcher == null) {
            try {
                ipSearcher = new IPSearcher();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ipSearcher;
    }

    public IPSearcher() throws Exception {
        this(IPContext.getFile());
    }

    public IPSearcher(String filePath) throws Exception {
        this(new File(filePath));
    }

    public IPSearcher(File file) throws Exception {
        try {
            this.ipFile = new RandomAccessFile(file, "r");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
        if (this.ipFile != null) {
            try {
                this.ipStart = this.readLong4(0L);
                this.ipEnd = this.readLong4(4L);
                if (this.ipStart == -1L || this.ipEnd == -1L) {
                    this.ipFile.close();
                    this.ipFile = null;
                }
            }
            catch (IOException e) {
                this.ipFile = null;
                e.printStackTrace();
                throw new Exception("Invalid IP data format file", e);
            }
        }
    }

    public List getIPEntityListDebug(String ipString) {
        ArrayList<IPEntity> list = new ArrayList<IPEntity>();
        long endOffset = this.ipEnd + 4L;
        for (long offset = this.ipStart + 4L; offset <= endOffset; offset += 7L) {
            IPEntity ipEntity;
            long value = this.readLong3(offset);
            if (value == -1L || (ipEntity = this.getIPEntity(value)).getCountry().indexOf(ipString) == -1 && ipEntity.getRegion().indexOf(ipString) == -1) continue;
            IPEntity entity = new IPEntity();
            entity.setCountry(ipEntity.getCountry());
            entity.setRegion(ipEntity.getRegion());
            this.readIP(offset - 4L, this.b4);
            entity.setStartIP(this.getString(this.b4));
            this.readIP(value, this.b4);
            entity.setEndIP(this.getString(this.b4));
            list.add(entity);
        }
        return list;
    }

    public List getIPEntityList(String ipString) {
        ArrayList<IPEntity> list = new ArrayList<IPEntity>();
        try {
            if (this.ipByteBuffer == null) {
                FileChannel fileChannel = this.ipFile.getChannel();
                this.ipByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, this.ipFile.length());
                this.ipByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            }
            int endOffset = (int)this.ipEnd;
            for (int offset = (int)this.ipStart + 4; offset <= endOffset; offset += 7) {
                IPEntity ipEntity;
                int value = this.readInt3(offset);
                if (value == -1 || (ipEntity = this.getIPEntity(value)).getCountry().indexOf(ipString) == -1 && ipEntity.getRegion().indexOf(ipString) == -1) continue;
                IPEntity entity = new IPEntity();
                entity.setCountry(ipEntity.getCountry());
                entity.setRegion(ipEntity.getRegion());
                this.readIP(offset - 4, this.b4);
                entity.setStartIP(this.getString(this.b4));
                this.readIP(value, this.b4);
                entity.setEndIP(this.getString(this.b4));
                list.add(entity);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list;
    }

    public String getCountry(byte[] ipBytes) {
        if (this.ipFile == null) {
            return "Invalid IP data file path";
        }
        String ipString = this.getString(ipBytes);
        if (this.ipCache.containsKey(ipString)) {
            IPEntity ipEntity = (IPEntity)this.ipCache.get(ipString);
            return ipEntity.getCountry();
        }
        IPEntity ipEntity = this.getIPEntity(ipBytes);
        this.ipCache.put(ipString, ipEntity.clone());
        return ipEntity.getCountry();
    }

    public String getCountry(String ipString) {
        return this.getCountry(this.getBytes(ipString));
    }

    public String getRegion(byte[] ipBytes) {
        if (this.ipFile == null) {
            return "Invalid IP data file path";
        }
        String ipString = this.getString(ipBytes);
        if (this.ipCache.containsKey(ipString)) {
            IPEntity ipEntity = (IPEntity)this.ipCache.get(ipString);
            return ipEntity.getRegion();
        }
        IPEntity ipEntity = this.getIPEntity(ipBytes);
        this.ipCache.put(ipString, ipEntity.clone());
        return ipEntity.getRegion();
    }

    public String getRegion(String ipString) {
        return this.getRegion(this.getBytes(ipString));
    }

    private String readRegion(long offset) throws IOException {
        this.ipFile.seek(offset);
        byte ipByte = this.ipFile.readByte();
        if (ipByte == 1 || ipByte == 2) {
            long regionOffset = this.readLong3(offset + 1L);
            if (regionOffset == 0L) {
                return "Unknown Region";
            }
            return this.readString(regionOffset);
        }
        return this.readString(offset);
    }

    private String readRegion(int offset) {
        this.ipByteBuffer.position(offset);
        byte ipByte = this.ipByteBuffer.get();
        if (ipByte == 1 || ipByte == 2) {
            int regionOffset = this.readInt3();
            if (regionOffset == 0) {
                return "Unknown Region";
            }
            return this.readString(regionOffset);
        }
        return this.readString(offset);
    }

    private IPEntity getIPEntity(byte[] ipBytes) {
        IPEntity ipEntity = null;
        long offset = this.locateIP(ipBytes);
        if (offset != -1L) {
            ipEntity = this.getIPEntity(offset);
        }
        if (ipEntity == null) {
            ipEntity = new IPEntity();
            ipEntity.setCountry("Unknown Country");
            ipEntity.setRegion("Unknown Region");
        }
        return ipEntity;
    }

    private IPEntity getIPEntity(long offset) {
        try {
            this.ipFile.seek(offset + 4L);
            byte ipByte = this.ipFile.readByte();
            if (ipByte == 1) {
                long countryOffset = this.readLong3();
                this.ipFile.seek(countryOffset);
                ipByte = this.ipFile.readByte();
                if (ipByte == 2) {
                    this.ipEntity.setCountry(this.readString(this.readLong3()));
                    this.ipFile.seek(countryOffset + 4L);
                } else {
                    this.ipEntity.setCountry(this.readString(countryOffset));
                }
                this.ipEntity.setRegion(this.readRegion(this.ipFile.getFilePointer()));
            } else if (ipByte == 2) {
                this.ipEntity.setCountry(this.readString(this.readLong3()));
                this.ipEntity.setRegion(this.readRegion(offset + 8L));
            } else {
                this.ipEntity.setCountry(this.readString(this.ipFile.getFilePointer() - 1L));
                this.ipEntity.setRegion(this.readRegion(this.ipFile.getFilePointer()));
            }
            return this.ipEntity;
        }
        catch (IOException e) {
            return null;
        }
    }

    private IPEntity getIPEntity(int offset) {
        this.ipByteBuffer.position(offset + 4);
        byte ipByte = this.ipByteBuffer.get();
        if (ipByte == 1) {
            int countryOffset = this.readInt3();
            this.ipByteBuffer.position(countryOffset);
            ipByte = this.ipByteBuffer.get();
            if (ipByte == 2) {
                this.ipEntity.setCountry(this.readString(this.readInt3()));
                this.ipByteBuffer.position(countryOffset + 4);
            } else {
                this.ipEntity.setCountry(this.readString(countryOffset));
            }
            this.ipEntity.setRegion(this.readRegion(this.ipByteBuffer.position()));
        } else if (ipByte == 2) {
            this.ipEntity.setCountry(this.readString(this.readInt3()));
            this.ipEntity.setRegion(this.readRegion(offset + 8));
        } else {
            this.ipEntity.setCountry(this.readString(this.ipByteBuffer.position() - 1));
            this.ipEntity.setRegion(this.readRegion(this.ipByteBuffer.position()));
        }
        return this.ipEntity;
    }

    private long locateIP(byte[] ipBytes) {
        long m = 0L;
        this.readIP(this.ipStart, this.b4);
        int r = this.compareIP(ipBytes, this.b4);
        if (r == 0) {
            return this.ipStart;
        }
        if (r < 0) {
            return -1L;
        }
        long i = this.ipStart;
        long j = this.ipEnd;
        while (i < j) {
            m = this.getMiddleOffset(i, j);
            this.readIP(m, this.b4);
            r = this.compareIP(ipBytes, this.b4);
            if (r > 0) {
                i = m;
                continue;
            }
            if (r < 0) {
                if (m == j) {
                    m = j -= 7L;
                    continue;
                }
                j = m;
                continue;
            }
            return this.readLong3(m + 4L);
        }
        m = this.readLong3(m + 4L);
        this.readIP(m, this.b4);
        r = this.compareIP(ipBytes, this.b4);
        if (r <= 0) {
            return m;
        }
        return -1L;
    }

    private void readIP(long offset, byte[] ipBytes) {
        try {
            this.ipFile.seek(offset);
            this.ipFile.readFully(ipBytes);
            byte value = ipBytes[0];
            ipBytes[0] = ipBytes[3];
            ipBytes[3] = value;
            value = ipBytes[1];
            ipBytes[1] = ipBytes[2];
            ipBytes[2] = value;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readIP(int offset, byte[] ipBytes) {
        this.ipByteBuffer.position(offset);
        this.ipByteBuffer.get(ipBytes);
        byte value = ipBytes[0];
        ipBytes[0] = ipBytes[3];
        ipBytes[3] = value;
        value = ipBytes[1];
        ipBytes[1] = ipBytes[2];
        ipBytes[2] = value;
    }

    private int compareIP(byte[] ipBytes, byte[] startIp) {
        for (int i = 0; i < 4; ++i) {
            int r = this.compareByte(ipBytes[i], startIp[i]);
            if (r == 0) continue;
            return r;
        }
        return 0;
    }

    private int compareByte(byte byte1, byte byte2) {
        if ((byte1 & 0xFF) > (byte2 & 0xFF)) {
            return 1;
        }
        if ((byte1 ^ byte2) == 0) {
            return 0;
        }
        return -1;
    }

    private int readInt3(int offset) {
        this.ipByteBuffer.position(offset);
        return this.ipByteBuffer.getInt() & 0xFFFFFF;
    }

    private int readInt3() {
        return this.ipByteBuffer.getInt() & 0xFFFFFF;
    }

    private long readLong4(long offset) {
        long value = 0L;
        try {
            this.ipFile.seek(offset);
            value |= (long)(this.ipFile.readByte() & 0xFF);
            value |= (long)(this.ipFile.readByte() << 8 & 0xFF00);
            value |= (long)(this.ipFile.readByte() << 16 & 0xFF0000);
            return value |= (long)(this.ipFile.readByte() << 24 & 0xFF000000);
        }
        catch (IOException e) {
            return -1L;
        }
    }

    private long readLong3(long offset) {
        long value = 0L;
        try {
            this.ipFile.seek(offset);
            this.ipFile.readFully(this.b3);
            value |= (long)(this.b3[0] & 0xFF);
            value |= (long)(this.b3[1] << 8 & 0xFF00);
            return value |= (long)(this.b3[2] << 16 & 0xFF0000);
        }
        catch (IOException e) {
            return -1L;
        }
    }

    private long readLong3() {
        long value = 0L;
        try {
            this.ipFile.readFully(this.b3);
            value |= (long)(this.b3[0] & 0xFF);
            value |= (long)(this.b3[1] << 8 & 0xFF00);
            return value |= (long)(this.b3[2] << 16 & 0xFF0000);
        }
        catch (IOException e) {
            return -1L;
        }
    }

    private long getMiddleOffset(long start, long end) {
        long records = (end - start) / 7L;
        if ((records >>= 1) == 0L) {
            records = 1L;
        }
        return start + records * 7L;
    }

    private byte[] getBytes(String ipString) {
        byte[] ipBytes = new byte[4];
        StringTokenizer st = new StringTokenizer(ipString, ".");
        try {
            ipBytes[0] = (byte)(Integer.parseInt(st.nextToken()) & 0xFF);
            ipBytes[1] = (byte)(Integer.parseInt(st.nextToken()) & 0xFF);
            ipBytes[2] = (byte)(Integer.parseInt(st.nextToken()) & 0xFF);
            ipBytes[3] = (byte)(Integer.parseInt(st.nextToken()) & 0xFF);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ipBytes;
    }

    private String readString(long offset) {
        try {
            this.ipFile.seek(offset);
            int i = 0;
            this.buffer[i] = this.ipFile.readByte();
            while (this.buffer[i] != 0) {
                this.buffer[++i] = this.ipFile.readByte();
            }
            if (i != 0) {
                return this.getString(this.buffer, 0, i, "GBK");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "";
    }

    private String readString(int offset) {
        try {
            this.ipByteBuffer.position(offset);
            int i = 0;
            this.buffer[i] = this.ipByteBuffer.get();
            while (this.buffer[i] != 0) {
                this.buffer[++i] = this.ipByteBuffer.get();
            }
            if (i != 0) {
                return this.getString(this.buffer, 0, i, "GBK");
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        return "";
    }

    private String getString(byte[] ipBytes) {
        this.ipStringBuffer.delete(0, this.ipStringBuffer.length());
        this.ipStringBuffer.append(ipBytes[0] & 0xFF);
        this.ipStringBuffer.append('.');
        this.ipStringBuffer.append(ipBytes[1] & 0xFF);
        this.ipStringBuffer.append('.');
        this.ipStringBuffer.append(ipBytes[2] & 0xFF);
        this.ipStringBuffer.append('.');
        this.ipStringBuffer.append(ipBytes[3] & 0xFF);
        return this.ipStringBuffer.toString();
    }

    private String getString(byte[] ipBytes, int offset, int length, String encoding) {
        try {
            return new String(ipBytes, offset, length, encoding);
        }
        catch (UnsupportedEncodingException e) {
            return new String(ipBytes, offset, length);
        }
    }
}

