/*
 * Decompiled with CFR 0.152.
 */
package y.layout.planar;

import y.algo.GraphConnectivity;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.EdgeMap;
import y.base.Graph;
import y.base.NodeCursor;
import y.base.YCursor;
import y.base.YList;
import y.layout.planar.DualPlanarInformation;
import y.layout.planar.Face;
import y.layout.planar.FaceCursor;
import y.layout.planar.FaceMap;
import y.layout.planar.do;
import y.layout.planar.int;
import y.util.D;

public class SimplePlanarInformation {
    protected Graph graph;
    protected YList faceList;
    protected Face outerFace;
    private EdgeMap a;

    public SimplePlanarInformation(Graph graph) {
        this.graph = graph;
        this.a = graph.createEdgeMap();
        this.faceList = new YList();
    }

    public Graph getGraph() {
        return this.graph;
    }

    public Edge createReverse(Edge edge) {
        Edge edge2 = this.graph.createEdge(edge.target(), edge.source());
        this.setReverse(edge, edge2);
        this.getSimpleEdgeInfo(edge2).a(true);
        return edge2;
    }

    public void setReverse(Edge edge, Edge edge2) {
        this.getSimpleEdgeInfo(edge).a(edge2);
        this.getSimpleEdgeInfo(edge2).a(edge);
    }

    public Edge getReverse(Edge edge) {
        return this.getSimpleEdgeInfo(edge).a();
    }

    public FaceCursor faces() {
        return new do(this.faceList);
    }

    public void setOuterFace(Face face) {
        this.outerFace = face;
    }

    public Face getOuterFace() {
        return this.outerFace;
    }

    public int faceCount() {
        return this.faceList.size();
    }

    public Face faceOf(Edge edge) {
        return this.getSimpleEdgeInfo(edge).b();
    }

    protected void setFaceOf(Edge edge, Face face) {
        this.getSimpleEdgeInfo(edge).a(face);
    }

    public void calcOrdering() {
        DualPlanarInformation dualPlanarInformation = new DualPlanarInformation(this);
        dualPlanarInformation.createCircularEdgeOrder();
        dualPlanarInformation.dispose();
    }

    public void calcFaces() {
        this.faceList = new YList();
        if (this.graph.edgeCount() == 0) {
            return;
        }
        boolean[] blArray = new boolean[this.graph.edgeCount()];
        EdgeCursor edgeCursor = this.graph.edges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            if (!blArray[edge.index()]) {
                this.createFace(edge, blArray);
            }
            edgeCursor.next();
        }
        this.setOuterFace(null);
    }

    protected Face createFace(Edge edge, boolean[] blArray) {
        Face face = new Face();
        Edge edge2 = edge;
        boolean bl = true;
        while (bl) {
            face.a(edge);
            this.getSimpleEdgeInfo(edge).a(face);
            blArray[edge.index()] = true;
            Edge edge3 = this.followingEdge(edge);
            if (blArray[edge3.index()]) {
                if (edge3 == edge2) {
                    bl = false;
                } else {
                    throw new RuntimeException("Graph is not Planar !");
                }
            }
            edge = edge3;
        }
        this.faceList.add(face);
        return face;
    }

    public FaceMap createFaceMap() {
        return new int();
    }

    public void disposeFaceMap(FaceMap faceMap) {
        ((int)faceMap).a();
    }

    public Edge cyclicNextEdge(Edge edge) {
        Edge edge2 = edge.nextOutEdge();
        return edge2 == null ? edge.source().firstOutEdge() : edge2;
    }

    public Edge cyclicPrevEdge(Edge edge) {
        Edge edge2 = edge.prevOutEdge();
        return edge2 == null ? edge.source().lastOutEdge() : edge2;
    }

    protected Edge followingEdge(Edge edge) {
        return this.cyclicNextEdge(this.getReverse(edge));
    }

    public boolean isPlanar() {
        Object object;
        Object object2;
        Object object3;
        YCursor yCursor;
        Object object4;
        D.bug(this, 0, "Planarity Check....");
        Graph graph = this.getGraph();
        boolean[] blArray = new boolean[graph.edgeCount()];
        int n = 0;
        while (n < graph.edgeCount()) {
            blArray[n] = false;
            ++n;
        }
        FaceCursor faceCursor = this.faces();
        while (faceCursor.ok()) {
            object4 = faceCursor.face();
            yCursor = ((Face)object4).edges();
            while (yCursor.ok()) {
                object3 = yCursor.edge();
                if (blArray[object3.index()]) {
                    D.bug(this, 0, "Edge " + object3 + " is in two faces !");
                    return false;
                }
                blArray[object3.index()] = true;
                yCursor.next();
            }
            faceCursor.next();
        }
        object4 = this.graph.edges();
        while (object4.ok()) {
            if (!blArray[object4.edge().index()]) {
                D.bug(this, 0, "Edge " + object4.edge() + " is in no face !");
                return false;
            }
            object4.next();
        }
        yCursor = this.faces();
        while (yCursor.ok()) {
            object3 = new Edge[2];
            object2 = yCursor.face().pairs();
            while (object2.ok()) {
                object2.pair((Edge[])object3);
                if (object3[0].target() != object3[1].source()) {
                    D.bug(this, 0, "Face is not a cycle: " + yCursor.face());
                    return false;
                }
                object2.next();
            }
            yCursor.next();
        }
        object3 = this.faces();
        while (object3.ok()) {
            object2 = object3.face();
            object = ((Face)object2).edges();
            while (object.ok()) {
                if (this.faceOf(object.edge()) != object2) {
                    D.bug(this, 0, "Edge " + object.edge() + " belongs to wrong face!");
                    return false;
                }
                object.next();
            }
            object3.next();
        }
        object2 = this.faces();
        while (object2.ok()) {
            object = object2.face();
            EdgeCursor edgeCursor = ((Face)object).edges();
            while (edgeCursor.ok()) {
                Edge edge = edgeCursor.edge();
                edgeCursor.cyclicPrev();
                Edge edge2 = edgeCursor.edge();
                edgeCursor.cyclicNext();
                Edge edge3 = this.getReverse(edge2);
                if (this.cyclicNextEdge(edge3) != edge) {
                    D.bug(this, 0, "Edge " + edge + " in wrong order !");
                    return false;
                }
                edgeCursor.next();
            }
            object2.next();
        }
        int n2 = graph.nodeCount();
        int n3 = graph.edgeCount();
        int n4 = this.faces().size();
        int n5 = GraphConnectivity.connectedComponents(graph).length;
        int n6 = 0;
        NodeCursor nodeCursor = graph.nodes();
        while (nodeCursor.ok()) {
            if (nodeCursor.node().degree() == 0) {
                ++n6;
            }
            nodeCursor.next();
        }
        int n7 = (n3 / 2 + 2 * n5 - n2 - n6 - n4) / 2;
        if (n7 == 0) {
            return true;
        }
        D.bug(this, 0, "genus ==  " + n7);
        return false;
    }

    public void dispose() {
        EdgeCursor edgeCursor = this.graph.edges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            if (this.isInsertedEdge(edge)) {
                this.graph.removeEdge(edge);
            }
            edgeCursor.next();
        }
        this.graph.disposeEdgeMap(this.a);
    }

    public boolean isOuterFaceSetCorrectly() {
        if (this.getOuterFace() == null) {
            return false;
        }
        Face face = this.getOuterFace();
        boolean bl = false;
        FaceCursor faceCursor = this.faces();
        while (faceCursor.ok()) {
            Face face2 = faceCursor.face();
            if (face == face2) {
                bl = true;
            }
            faceCursor.next();
        }
        return bl;
    }

    public String toString() {
        String string = new String("Facelist:\n");
        FaceCursor faceCursor = this.faces();
        while (faceCursor.ok()) {
            Face face = faceCursor.face();
            string = string + "Face :";
            if (face == this.outerFace) {
                string = string + "  --> Outer-Face <---";
            }
            string = string + "\n";
            string = string + face;
            string = string + "\n";
            faceCursor.next();
        }
        return string;
    }

    public void markAsInsertedEdge(Edge edge) {
        this.setIsInsertedEdge(edge, true);
    }

    public void setIsInsertedEdge(Edge edge, boolean bl) {
        this.getSimpleEdgeInfo(edge).a(bl);
    }

    public boolean isInsertedEdge(Edge edge) {
        return this.getSimpleEdgeInfo(edge).c();
    }

    public void showCircularEdgeOrder() {
        D.bug(0, "CIRCULAR OUTEDGE ORDER");
        NodeCursor nodeCursor = this.graph.nodes();
        while (nodeCursor.ok()) {
            D.bug(0, "Node: " + nodeCursor.node());
            EdgeCursor edgeCursor = nodeCursor.node().edges();
            while (edgeCursor.ok()) {
                D.bug(0, "  edge: " + edgeCursor.edge());
                edgeCursor.next();
            }
            nodeCursor.next();
        }
    }

    public void showFaces() {
        D.bug(0, "SHOWING FACES");
        FaceCursor faceCursor = this.faces();
        while (faceCursor.ok()) {
            D.bug(0, "Face: " + faceCursor.face());
            faceCursor.next();
        }
    }

    protected SimpleEdgeInfo getSimpleEdgeInfo(Edge edge) {
        SimpleEdgeInfo simpleEdgeInfo = (SimpleEdgeInfo)this.a.get(edge);
        if (simpleEdgeInfo == null) {
            simpleEdgeInfo = this.createSimpleEdgeInfo();
            this.a.set(edge, simpleEdgeInfo);
        }
        return simpleEdgeInfo;
    }

    protected SimpleEdgeInfo createSimpleEdgeInfo() {
        return new SimpleEdgeInfo();
    }

    public static class SimpleEdgeInfo {
        private Edge a;
        private boolean b;
        private Face c;

        void a(Edge edge) {
            this.a = edge;
        }

        Edge a() {
            return this.a;
        }

        boolean c() {
            return this.b;
        }

        void a(boolean bl) {
            this.b = bl;
        }

        Face b() {
            return this.c;
        }

        void a(Face face) {
            this.c = face;
        }
    }
}

