/*
 * Decompiled with CFR 0.152.
 */
package twaver.table;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import twaver.AlarmSeverity;
import twaver.AlarmSeverityChangeListener;
import twaver.AlarmStateStatistics;
import twaver.TDataBox;
import twaver.TView;
import twaver.TWaverUtil;
import twaver.table.ResizableTable;
import twaver.table.renderer.AlarmSeverityRenderer;

public class TAlarmStatTable
extends ResizableTable
implements TView {
    private AlarmStateStatistics \u0266 = null;
    private DefaultTableModel \u0263 = new DefaultTableModel(){

        public boolean isCellEditable(int row, int column) {
            return false;
        }
    };
    private AlarmSeverityChangeListener \u0265 = new AlarmSeverityChangeListener(){

        public boolean alarmSeverityChange() {
            TAlarmStatTable.this.repaint();
            return false;
        }
    };
    private PropertyChangeListener \u0264 = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            TAlarmStatTable.this.updateTViewUI();
        }
    };

    public TAlarmStatTable() {
        this(new TDataBox());
    }

    public TAlarmStatTable(TDataBox box) {
        this(box, null);
    }

    public TAlarmStatTable(TDataBox box, List alarmSeverities) {
        this.\u0266 = new AlarmStateStatistics(box, alarmSeverities);
        this.\u0266.getPropertyChangeSupport().addPropertyChangeListener("alarmstate", this.\u0264);
        AlarmSeverity.addAlarmSeverityChangeListener(this.\u0265);
        this.setModel(this.\u0263);
        this.X();
        this.W();
        this.updateTViewUI();
    }

    public AlarmStateStatistics getAlarmStateStatistics() {
        return this.\u0266;
    }

    public TDataBox getDataBox() {
        return this.\u0266.getDataBox();
    }

    public void setDataBox(TDataBox box) {
        if (box == null) {
            throw new NullPointerException("Cannot set a null TDataBox");
        }
        this.\u0266.setDataBox(box);
    }

    private void X() {
        this.\u0263.setColumnCount(0);
        String severityName = TWaverUtil.getString("Alarm.Severity");
        this.\u0263.addColumn(severityName);
        this.\u0263.addColumn(TWaverUtil.getString("Alarm.New"));
        this.\u0263.addColumn(TWaverUtil.getString("Alarm.Acked"));
        this.\u0263.addColumn(TWaverUtil.getString("Alarm.Total"));
        this.getColumn(severityName).setCellRenderer(new AlarmSeverityRenderer());
        this.setAutoResizeMode(4);
    }

    private void W() {
        Iterator it = this.\u0266.getSeverityList().iterator();
        while (it.hasNext()) {
            AlarmSeverity severity = (AlarmSeverity)it.next();
            this.\u0263.addRow(new Object[]{severity, "0", "0", "0"});
        }
        this.\u0263.addRow(new Object[]{TWaverUtil.getString("Alarm.Total"), "0", "0", "0"});
    }

    public void updateTViewUI() {
        List severityList = this.\u0266.getSeverityList();
        int count = severityList.size();
        for (int i2 = 0; i2 < count; ++i2) {
            AlarmSeverity severity = (AlarmSeverity)severityList.get(i2);
            int iNew = this.\u0266.getNewAlarmCount(severity);
            int iAck = this.\u0266.getAcknowledgedAlarmCount(severity);
            int iTotal = this.\u0266.getTotalAlarmCount(severity);
            this.\u0263.setValueAt(iNew + "", i2, 1);
            this.\u0263.setValueAt(iAck + "", i2, 2);
            this.\u0263.setValueAt(iTotal + "", i2, 3);
        }
        this.\u0263.setValueAt(this.\u0266.getNewAlarmCount() + "", count, 1);
        this.\u0263.setValueAt(this.\u0266.getAcknowledgedAlarmCount() + "", count, 2);
        this.\u0263.setValueAt(this.\u0266.getTotalAlarmCount() + "", count, 3);
    }
}

