/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.chart;

import com.nepxion.swing.chart.ChartContext;
import com.nepxion.swing.chart.ChartPDFWriter;
import com.nepxion.swing.icon.IconFactory;
import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.popupmenu.JBasicPopupMenu;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;

public class JChartPanel
extends ChartPanel {
    private ChartPDFWriter chartPDFWriter;

    public JChartPanel(JFreeChart chart) {
        super(chart);
        this.initComponents();
    }

    public JChartPanel(JFreeChart chart, boolean useBuffer) {
        super(chart, useBuffer);
        this.initComponents();
    }

    public JChartPanel(JFreeChart chart, boolean properties, boolean save, boolean print, boolean zoom, boolean tooltips) {
        super(chart, properties, save, print, zoom, tooltips);
        this.initComponents();
    }

    public JChartPanel(JFreeChart chart, int width, int height, int minimumDrawWidth, int minimumDrawHeight, int maximumDrawWidth, int maximumDrawHeight, boolean useBuffer, boolean properties, boolean save, boolean print, boolean zoom, boolean tooltips) {
        super(chart, width, height, minimumDrawWidth, minimumDrawHeight, maximumDrawWidth, maximumDrawHeight, useBuffer, properties, save, print, zoom, tooltips);
        this.initComponents();
    }

    public JChartPanel(JFreeChart chart, int width, int height, int minimumDrawWidth, int minimumDrawHeight, int maximumDrawWidth, int maximumDrawHeight, boolean useBuffer, boolean properties, boolean copy, boolean save, boolean print, boolean zoom, boolean tooltips) {
        super(chart, width, height, minimumDrawWidth, minimumDrawHeight, maximumDrawWidth, maximumDrawHeight, useBuffer, properties, copy, save, print, zoom, tooltips);
        this.initComponents();
    }

    private void initComponents() {
        this.setMouseWheelEnabled(true);
    }

    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        JPopupMenu popupMenu = this.getPopupMenu();
        if (popupMenu != null && popupMenu.isShowing()) {
            super.mouseClicked(e);
        }
    }

    protected JPopupMenu createPopupMenu(boolean properties, boolean copy, boolean save, boolean print, boolean zoom) {
        JPopupMenu popupMenu = super.createPopupMenu(properties, copy, save, print, zoom);
        JMenuItem propertiesMenuItem = null;
        if (properties) {
            propertiesMenuItem = this.getMenuItem(popupMenu, localizationResources.getString("Properties..."));
            propertiesMenuItem.setText(SwingLocale.getString("setting") + "    ");
            propertiesMenuItem.setIcon(IconFactory.getSwingIcon("edit.png"));
        }
        JMenuItem copyMenuItem = null;
        if (copy) {
            copyMenuItem = this.getMenuItem(popupMenu, localizationResources.getString("Copy"));
            copyMenuItem.setIcon(IconFactory.getSwingIcon("copy.png"));
        }
        JMenu exportMenu = null;
        if (save) {
            JMenuItem exportPNGMenuItem = this.getMenuItem(popupMenu, localizationResources.getString("Save_as..."));
            exportPNGMenuItem.setText("PNG " + SwingLocale.getString("image"));
            exportPNGMenuItem.setIcon(IconFactory.getSwingIcon("image.png"));
            JMenuItem exportPDFMenuItem = new JMenuItem();
            exportPDFMenuItem.setText("PDF " + SwingLocale.getString("file"));
            exportPDFMenuItem.setIcon(IconFactory.getSwingIcon("pdf.png"));
            exportPDFMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JChartPanel.this.exportPDF();
                }
            });
            exportMenu = new JMenu();
            exportMenu.setText(SwingLocale.getString("export"));
            exportMenu.setIcon(IconFactory.getSwingIcon("export.png"));
            exportMenu.add(exportPDFMenuItem);
            exportMenu.add(exportPNGMenuItem);
        }
        JMenu zoomInMenu = null;
        JMenu zoomOutMenu = null;
        JMenu zoomResetMenu = null;
        if (zoom) {
            zoomInMenu = (JMenu)this.getMenuItem(popupMenu, localizationResources.getString("Zoom_In"));
            zoomInMenu.setIcon(IconFactory.getSwingIcon("zoom_in.png"));
            zoomOutMenu = (JMenu)this.getMenuItem(popupMenu, localizationResources.getString("Zoom_Out"));
            zoomOutMenu.setIcon(IconFactory.getSwingIcon("zoom_out.png"));
            zoomResetMenu = (JMenu)this.getMenuItem(popupMenu, localizationResources.getString("Auto_Range"));
            zoomResetMenu.setText(SwingLocale.getString("zoom_restore"));
            zoomResetMenu.setIcon(IconFactory.getSwingIcon("zoom.png"));
        }
        JMenuItem printMenuItem = null;
        if (print) {
            printMenuItem = this.getMenuItem(popupMenu, localizationResources.getString("Print..."));
            printMenuItem.setText(SwingLocale.getString("print"));
            printMenuItem.setIcon(IconFactory.getSwingIcon("print.png"));
        }
        popupMenu.removeAll();
        JBasicPopupMenu basicPopupMenu = new JBasicPopupMenu();
        if (properties) {
            basicPopupMenu.add(propertiesMenuItem);
        }
        if (copy) {
            basicPopupMenu.add(copyMenuItem);
        }
        if (save) {
            basicPopupMenu.add(exportMenu);
        }
        if (zoom) {
            basicPopupMenu.addSeparator();
            basicPopupMenu.add(zoomInMenu);
            basicPopupMenu.add(zoomOutMenu);
            basicPopupMenu.add(zoomResetMenu);
        }
        if (print) {
            basicPopupMenu.addSeparator();
            basicPopupMenu.add(printMenuItem);
        }
        return basicPopupMenu;
    }

    public void exportPDF() {
        if (this.chartPDFWriter == null) {
            this.chartPDFWriter = new ChartPDFWriter(this);
        }
        this.chartPDFWriter.write(ChartContext.getChartPDFAuthor(), ChartContext.getChartPDFSubject());
    }

    public void exportPNG() {
        try {
            this.doSaveAs();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private JMenuItem getMenuItem(JPopupMenu popupMenu, String text) {
        for (int i = 0; i < popupMenu.getComponentCount(); ++i) {
            JMenuItem menuItem;
            Component component = popupMenu.getComponent(i);
            if (!(component instanceof JMenuItem) || !(menuItem = (JMenuItem)component).getText().equals(text)) continue;
            return menuItem;
        }
        return null;
    }
}

