/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.style.framework;

import com.nepxion.swing.lookandfeel.LookAndFeelTheme;
import com.nepxion.swing.style.framework.IStyle;
import com.nepxion.swing.style.framework.JLiteStyle;
import java.awt.Color;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class StyleManager {
    private static IStyle style;

    public static void setStyle(String styleClass) {
        try {
            style = (IStyle)Class.forName(styleClass).newInstance();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
    }

    public static void setThemeDecorated() {
        Color tabbedPaneBorderLineColor;
        Color tabbedPaneForeground;
        Color tabbedPaneSelectionForeground;
        Color background;
        Color tabbedPaneBackground;
        LookAndFeelTheme.setTheme(5);
        UIDefaults uiDefaults = UIManager.getLookAndFeelDefaults();
        Color tabbedPaneGradientColor = style.getTabbedPaneGradientColor();
        if (tabbedPaneGradientColor != null) {
            uiDefaults.put("DockableFrame.activeTitleBackground", tabbedPaneGradientColor);
        }
        if ((tabbedPaneBackground = style.getTabbedPaneBackground()) != null) {
            uiDefaults.put("DockableFrame.activeTitleBackground2", tabbedPaneBackground);
        }
        if ((background = UIManager.getColor("Panel.background")) != null) {
            uiDefaults.put("JideTabbedPane.background", background);
        }
        if ((tabbedPaneSelectionForeground = style.getTabbedPaneSelectionForeground()) != null) {
            uiDefaults.put("JideTabbedPane.selectedTabTextForeground", tabbedPaneSelectionForeground);
        }
        if ((tabbedPaneForeground = style.getTabbedPaneForeground()) != null) {
            uiDefaults.put("JideTabbedPane.unselectedTabTextForeground", tabbedPaneForeground);
        }
        if ((tabbedPaneBorderLineColor = style.getTabbedPaneBorderLineColor()) != null) {
            uiDefaults.put("JideTabbedPane.shadow", tabbedPaneBorderLineColor);
        }
    }

    public static void setFrameDecorated(boolean isFrameDecorated) {
        JFrame.setDefaultLookAndFeelDecorated(isFrameDecorated);
    }

    public static void setDialogDecorated(boolean isDialogDecorated) {
        JDialog.setDefaultLookAndFeelDecorated(isDialogDecorated);
    }

    public static IStyle getStyle() {
        if (style == null) {
            style = new JLiteStyle();
        }
        return style;
    }
}

