/*
 * Decompiled with CFR 0.152.
 */
package twaver.tree;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import twaver.AlarmSeverity;
import twaver.AlarmSeverityChangeListener;
import twaver.CheckableFilter;
import twaver.ChildrenSortableFilter;
import twaver.DataBoxEvent;
import twaver.DataBoxListener;
import twaver.DataBoxSelectionEvent;
import twaver.DataBoxSelectionListener;
import twaver.DataBoxSelectionModel;
import twaver.DataBoxSequenceAdapter;
import twaver.DataBoxSequenceListener;
import twaver.EditableFilter;
import twaver.Element;
import twaver.ElementLabelEditor;
import twaver.Generator;
import twaver.MouseActionEvent;
import twaver.PaintSelectionStateFilter;
import twaver.PopupMenuFactory;
import twaver.PopupMenuGenerator;
import twaver.PropertyChangeFilter;
import twaver.TDataBox;
import twaver.TUIManager;
import twaver.VisibleFilter;
import twaver.base.A.D.B.E;
import twaver.base.A.D.B.F;
import twaver.base.A.D.B.G;
import twaver.base.A.E.P;
import twaver.base.A.E.h;
import twaver.base.A.F.D;
import twaver.base.A.I.C;
import twaver.base.A.K.A;
import twaver.base.A.K.B;
import twaver.tree.AbstractTTreeNode;
import twaver.tree.DataBoxNode;
import twaver.tree.DefaultDnDHandler;
import twaver.tree.DnDHandler;
import twaver.tree.ElementNode;
import twaver.tree.LazyLoader;
import twaver.tree.LazyLoaderListener;
import twaver.tree.TTreeCellIcon;

public class TTree
extends JTree
implements C,
Autoscroll {
    public static final int DEFAULT_SELECTION = 0;
    public static final int CHECK_SELECTION = 1;
    public static final int CHECK_CHILDREN_SELECTION = 2;
    public static final int CHECK_DESCENDANT_SELECTION = 3;
    public static final int CHECK_DESCENDANT_ANCESTOR_SELECTION = 4;
    private PopupMenuFactory \u02bf = null;
    private PopupMenuGenerator \u02b4 = null;
    protected TDataBox box = null;
    private boolean \u038c = false;
    private AbstractTTreeNode \u02b7 = null;
    private Map \u02a7 = new HashMap();
    private DefaultTreeModel \u029a = null;
    private Comparator \u02c0 = null;
    private ChildrenSortableFilter \u02b2 = null;
    private List \u02b1 = new ArrayList();
    private List \u02e3 = new ArrayList();
    private CheckableFilter \u0396 = null;
    private LazyLoader \u02bb = null;
    private _A \u0298 = new _A(this);
    private Generator \u02a0 = TUIManager.getElementToolTipTextGenerator();
    private EditableFilter \u029c = null;
    private ElementLabelEditor \u029f = ElementLabelEditor.TREEEDITOR;
    private PaintSelectionStateFilter \u02a3 = null;
    private Object \u0393 = null;
    private DnDHandler \u0394 = new DefaultDnDHandler();
    private Generator \u0392 = TUIManager.getElementTreeLabelGenerator();
    private Generator \u02be = TUIManager.getElementStateOutlineColorGenerator();
    private Generator \u0395 = TUIManager.getElementBodyColorGenerator();
    private Generator \u02a8 = new Generator(){

        public Object generate(Object object) {
            return new TTreeCellIcon((Element)object, TTree.this);
        }
    };
    private twaver.base.A.A.D \u0389 = new twaver.base.A.A.D(this, new Insets(10, 10, 10, 10));
    private List \u029b = new ArrayList();
    private PropertyChangeListener \u02b0 = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("name")) {
                ((DefaultTreeModel)TTree.this.getModel()).nodeChanged(TTree.this.\u02b7);
            }
        }
    };
    private DataBoxSelectionListener \u02b6 = new DataBoxSelectionListener(){

        public void selectionChanged(DataBoxSelectionEvent e2) {
            TTree.this.c();
        }
    };
    private DataBoxSequenceListener \u02e4 = new DataBoxSequenceAdapter(){

        public void hiberarchyChanged(Element element) {
            ElementNode elementNode = TTree.this.getLoadedTreeNodeByElement(element);
            if (elementNode != null && elementNode != TTree.this.getRootNode()) {
                TTree.this.A(elementNode);
                TTree.this.E(element);
            }
        }
    };
    private AlarmSeverityChangeListener \u02c1 = new AlarmSeverityChangeListener(){

        public boolean alarmSeverityChange() {
            TTree.this.repaint();
            return false;
        }
    };
    private G \u0390 = null;
    private boolean \u029e = TUIManager.getBoolean("tree.enable.right.click.event");
    private int \u02a6 = TUIManager.getInt("tree.icon.width");
    private int \u02b5 = TUIManager.getInt("tree.icon.height");
    private Icon \u02a1 = TUIManager.getIcon("tree.expanded.icon");
    private Icon \u0299 = TUIManager.getIcon("tree.collapsed.icon");
    private String \u037a = TUIManager.getString("tree.databox.node.icon");
    private boolean \u02bd = TUIManager.getBoolean("tree.databox.label.editable");
    private int \u038f = TUIManager.getInt("tree.selection.mode");
    private int \u02d1 = TUIManager.getInt("tree.uncheckable.style");
    private boolean \u02a4 = TUIManager.getBoolean("tree.icon.visible");
    private boolean \u038e = TUIManager.getBoolean("tree.selectable.on.right.click");
    private boolean \u029d = TUIManager.getBoolean("tree.clear.selection.on.margin.clicked");
    private boolean \u02e2 = TUIManager.getBoolean("tree.show.plain.icon");
    private boolean \u0388 = TUIManager.getBoolean("tree.element.draggable");
    private boolean \u02b3 = TUIManager.getBoolean("tree.ensure.visible.on.selected");
    private boolean \u02bc = TUIManager.getBoolean("tree.element.tooltip.displayable");
    private boolean \u02e0 = TUIManager.getBoolean("tree.enable.tristate.checkbox");
    private boolean \u02a2 = TUIManager.getBoolean("tree.paint.selected.state.when.checked");
    private boolean \u038a = TUIManager.getBoolean("tree.checked.when.not.specified");
    private boolean \u02d0 = TUIManager.getBoolean("tree.update.sort.on.property.changed");
    private boolean \u02a5 = true;
    private boolean \u0386 = true;
    private List \u02b8 = new ArrayList();
    private boolean \u0391 = true;
    private PropertyChangeFilter \u02e1 = new PropertyChangeFilter(){

        public boolean isInterested(PropertyChangeEvent event) {
            return !"selected".equals(event.getPropertyName());
        }
    };

    protected void updateSort(Element element, PropertyChangeEvent evt, ElementNode elementNode) {
        AbstractTTreeNode parentNode = (AbstractTTreeNode)elementNode.getParent();
        if (parentNode != null && parentNode.getChildCount() > 1) {
            Object[] children = new Element[parentNode.getChildCount() - 1];
            Enumeration<TreeNode> e2 = parentNode.children();
            int i2 = 0;
            int oldIndex = -1;
            while (e2.hasMoreElements()) {
                Element child = ((ElementNode)e2.nextElement()).getElement();
                if (child != element) {
                    children[i2] = child;
                    ++i2;
                    continue;
                }
                oldIndex = i2;
            }
            int newIndex = twaver.base.A.E.D.A(children, element, this.getSortComparator());
            if (oldIndex != newIndex) {
                LinkedList<Element> list = new LinkedList<Element>();
                int count = this.getRowCount();
                for (i2 = 0; i2 < count; ++i2) {
                    Object comp;
                    TreePath path = this.getPathForRow(i2);
                    if (!this.isExpanded(path) || !((comp = path.getLastPathComponent()) instanceof ElementNode)) continue;
                    list.add(((ElementNode)comp).getElement());
                }
                this.\u038c = true;
                DefaultTreeModel model = (DefaultTreeModel)this.getModel();
                model.removeNodeFromParent(elementNode);
                model.insertNodeInto(elementNode, parentNode, newIndex);
                this.\u038c = false;
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    Element ele = (Element)it.next();
                    this.expand(ele);
                }
                this.c();
            }
        }
    }

    public boolean isFireTreeNodeChangedWhenSelectionChanged() {
        return this.\u0391;
    }

    public void setFireTreeNodeChangedWhenSelectionChanged(boolean fireTreeNodeChangedWithSelectionChanged) {
        this.\u0391 = fireTreeNodeChangedWithSelectionChanged;
    }

    public PropertyChangeFilter getSortPropertyChangeFilter() {
        return this.\u02e1;
    }

    public void setSortPropertyChangeFilter(PropertyChangeFilter sortPropertyChangeFilter) {
        this.\u02e1 = sortPropertyChangeFilter;
    }

    public void addLazyLoaderListener(LazyLoaderListener l2) {
        if (l2 != null && !this.\u02b8.contains(l2)) {
            this.\u02b8.add(l2);
        }
    }

    public void removelazyLoaderListener(LazyLoaderListener l2) {
        this.\u02b8.remove(l2);
    }

    public TTree() {
        this(new TDataBox());
    }

    public TTree(TDataBox box) {
        this.setDataBox(box);
        this.init();
    }

    public TTree(TDataBox box, Element treeRoot) {
        this.setDataBox(box, treeRoot);
        this.init();
    }

    public TTree(TDataBox box, Comparator sortComparator) {
        this.\u02c0 = sortComparator;
        this.setDataBox(box);
        this.init();
    }

    public TTree(TDataBox box, Element treeRoot, Comparator sortComparator) {
        this.\u02c0 = sortComparator;
        this.setDataBox(box, treeRoot);
        this.init();
    }

    public Generator getElementBodyColorGenerator() {
        return this.\u0395;
    }

    public void setElementBodyColorGenerator(Generator elementBodyColorGenerator) {
        this.\u0395 = elementBodyColorGenerator;
    }

    public Generator getElementStateOutlineColorGenerator() {
        return this.\u02be;
    }

    public void setElementStateOutlineColorGenerator(Generator elementOutlineColorGenerator) {
        this.\u02be = elementOutlineColorGenerator;
    }

    public PaintSelectionStateFilter getPaintSelectionStateFilter() {
        return this.\u02a3;
    }

    public void setPaintSelectionStateFilter(PaintSelectionStateFilter paintSelectionStateFilter) {
        this.\u02a3 = paintSelectionStateFilter;
        this.repaint();
    }

    public Insets getAutoscrollInsets() {
        return this.\u0389.getAutoscrollInsets();
    }

    public void autoscroll(Point cursorLocation) {
        this.\u0389.autoscroll(cursorLocation);
    }

    public List getElementNodeDoubleClickedActionListeners() {
        return this.\u02b1;
    }

    public List treeNodeClickedActionListeners() {
        return this.\u02e3;
    }

    public void addElementNodeDoubleClickedActionListener(ActionListener l2) {
        if (!this.\u02b1.contains(l2)) {
            this.\u02b1.add(l2);
        }
    }

    public void removeElementNodeDoubleClickedActionListener(ActionListener l2) {
        this.\u02b1.remove(l2);
    }

    private void A(MouseActionEvent event) {
        for (int i2 = 0; i2 < this.\u02b1.size(); ++i2) {
            ActionListener l2 = (ActionListener)this.\u02b1.get(i2);
            l2.actionPerformed(event);
        }
    }

    public void addTreeNodeClickedActionListener(ActionListener l2) {
        if (!this.\u02e3.contains(l2)) {
            this.\u02e3.add(l2);
        }
    }

    public void removeTreeNodeClickedActionListener(ActionListener l2) {
        this.\u02e3.remove(l2);
    }

    private void B(MouseActionEvent event) {
        for (int i2 = 0; i2 < this.\u02e3.size(); ++i2) {
            ActionListener l2 = (ActionListener)this.\u02e3.get(i2);
            l2.actionPerformed(event);
        }
    }

    public boolean isElementToolTipDisplayable() {
        return this.\u02bc;
    }

    public void setElementToolTipDisplayable(boolean isElementToolTipDisplayable) {
        this.\u02bc = isElementToolTipDisplayable;
    }

    public int getTTreeSelectionMode() {
        return this.\u038f;
    }

    public void setTTreeSelectionMode(int selectionMode) {
        if (selectionMode == 0 || selectionMode == 1 || selectionMode == 2 || selectionMode == 3 || selectionMode == 4) {
            this.\u038f = selectionMode;
            if (this.\u038f == 0) {
                if (!(this.getCellRenderer() instanceof B)) {
                    this.setCellRenderer(new B(this));
                }
            } else if (!(this.getCellRenderer() instanceof twaver.base.A.K.D)) {
                this.setCellRenderer(new twaver.base.A.K.D(this));
            }
            this.updateTViewUI();
        }
    }

    public AbstractTTreeNode getRootNode() {
        return this.\u02b7;
    }

    public boolean isElementDraggable() {
        return this.\u0388;
    }

    public void setElementDraggable(boolean isElementDraggable) {
        this.\u0388 = isElementDraggable;
    }

    public boolean isLoaded(Element element) {
        if (element == null) {
            return false;
        }
        return this.\u02a7.containsKey(element.getID());
    }

    public Comparator getSortComparator() {
        return this.\u02c0;
    }

    public void setSortComparator(Comparator sortComparator) {
        Comparator oldValue = this.\u02c0;
        this.\u02c0 = sortComparator;
        this.updateTViewUI();
        this.firePropertyChange("sortComparator", oldValue, this.\u02c0);
    }

    protected void init() {
        this.setToolTipText("");
        this.setShowsRootHandles(true);
        this.Y();
        this.setShowsRootHandles(true);
        this.setExpandsSelectedPaths(false);
        this.setSelectionModel(new twaver.base.A.K.C(this));
        AlarmSeverity.addAlarmSeverityChangeListener(this.\u02c1);
        new _B(this);
        this.setCellEditor(new A(this));
        this.setTTreeSelectionMode(0);
        if (TUIManager.getBoolean("tree.enable.dnd")) {
            this.initDnD();
        }
        this.putClientProperty("Tree.paintLines", Boolean.FALSE);
    }

    public boolean isDnDTarget(Object target) {
        return this.\u0393 != null && this.\u0393 == target;
    }

    private void A(Object target) {
        if (this.\u0393 != target) {
            this.\u0393 = target;
            this.repaint();
        }
    }

    protected void initDnD() {
        DropTargetAdapter dropTargetListener = new DropTargetAdapter(){

            public void dragExit(DropTargetEvent dropTargetEvent) {
                TTree.this.A(null);
            }

            public void dragOver(DropTargetDragEvent e2) {
                if (TTree.this.\u0388 && TTree.this.\u0394 != null) {
                    Point location = e2.getLocation();
                    TreePath path = TTree.this.getPathForLocation(location.x, location.y);
                    if (path == null) {
                        TTree.this.A(null);
                    } else {
                        TTree.this.A(path.getLastPathComponent());
                    }
                }
            }

            public void drop(DropTargetDropEvent e2) {
                if (TTree.this.\u0388 && TTree.this.\u0394 != null) {
                    TTree.this.\u0394.drop(TTree.this, e2, TTree.this.\u0393);
                    TTree.this.A(null);
                }
            }
        };
        DragGestureListener dragGestureListener = new DragGestureListener(){

            public void dragGestureRecognized(DragGestureEvent e2) {
                if (TTree.this.\u0388 && TTree.this.\u0394 != null) {
                    Point point = e2.getDragOrigin();
                    int row = TTree.this.getRowForLocation(point.x, point.y);
                    TreePath path = TTree.this.getPathForRow(row);
                    if (path != null && TTree.this.getSelectionModel().isPathSelected(path)) {
                        TTree.this.\u0394.drag(TTree.this, e2);
                    }
                }
            }
        };
        DragSource dragSource = new DragSource();
        dragSource.createDefaultDragGestureRecognizer(this, 3, dragGestureListener);
        DropTarget dropTarget = new DropTarget(this, 3, dropTargetListener);
        this.setDropTarget(dropTarget);
    }

    private void Z() {
        this.box.addDataBoxListener(this.\u0298);
        this.box.addPropertyChangeListener(this.\u02b0);
        this.box.getSelectionModel().addDataBoxSelectionListener(this.\u02b6);
        this.box.addElementPropertyChangeListener(this.\u0298);
        this.box.addDataBoxSequenceListener(this.\u02e4);
    }

    private void a() {
        this.box.removeDataBoxListener(this.\u0298);
        this.box.removePropertyChangeListener(this.\u02b0);
        this.box.getSelectionModel().removeDataBoxSelectionListener(this.\u02b6);
        this.box.removeElementPropertyChangeListener(this.\u0298);
        this.box.removeDataBoxSequenceListener(this.\u02e4);
    }

    public TDataBox getDataBox() {
        return this.box;
    }

    public void setDataBox(TDataBox box) {
        this.A(box, new DataBoxNode(this, box));
    }

    public void setDataBox(TDataBox box, Element rootElement) {
        if (box == null) {
            throw new IllegalArgumentException("Cannot set a null TDataBox");
        }
        if (rootElement == null) {
            throw new IllegalArgumentException("Cannot set a null rootElement");
        }
        if (!box.containsByID(rootElement.getID())) {
            throw new IllegalArgumentException("DataBox doesn't contain the element");
        }
        this.A(box, new ElementNode(this, rootElement));
    }

    private void A(TDataBox box, AbstractTTreeNode root) {
        if (box == null) {
            throw new IllegalArgumentException("DataBox must be non null");
        }
        TDataBox oldBox = this.box;
        if (oldBox != null) {
            this.a();
            this.\u02a7.clear();
            this.\u038c = true;
            this.clearSelection();
            this.\u038c = false;
        }
        this.box = box;
        this.\u02b7 = root;
        if (oldBox == null) {
            this.\u029a = new DefaultTreeModel(root){

                public void valueForPathChanged(TreePath path, Object newValue) {
                    MutableTreeNode node = (MutableTreeNode)path.getLastPathComponent();
                    if (node instanceof ElementNode) {
                        Element element = ((ElementNode)node).getElement();
                        TTree.this.\u029f.setLabel(element, newValue.toString());
                    } else if (node instanceof DataBoxNode) {
                        TTree.this.getDataBox().setName(newValue.toString());
                    }
                }
            };
            this.setModel(this.\u029a);
        } else {
            this.\u029a.setRoot(root);
        }
        this.Z();
        this.updateTViewUI();
        this.firePropertyChange("databox", oldBox, this.box);
    }

    private void _() {
        if (this.\u038c || !this.isAutoSyncSelectionFromViewToDataBox()) {
            return;
        }
        this.\u038c = true;
        DataBoxSelectionModel boxSelectionModel = this.box.getSelectionModel();
        TreeSelectionModel treeSelectionModel = this.getSelectionModel();
        boxSelectionModel.clearSelection();
        TreePath[] paths = treeSelectionModel.getSelectionPaths();
        if (paths != null) {
            ArrayList<Element> elements = new ArrayList<Element>();
            for (int i2 = 0; i2 < paths.length; ++i2) {
                TreePath path = paths[i2];
                Object object = path.getLastPathComponent();
                if (!(object instanceof ElementNode)) continue;
                ElementNode nodeElement = (ElementNode)object;
                Element element = nodeElement.getElement();
                elements.add(element);
            }
            if (elements.size() > 0) {
                boxSelectionModel.setSelection(elements);
                elements.clear();
            }
        }
        this.\u038c = false;
    }

    void C(ElementNode node) {
        if (node == null) {
            return;
        }
        Element element = node.getElement();
        this.\u02a7.put(element.getID(), node);
        Enumeration<TreeNode> e2 = node.children();
        while (e2.hasMoreElements()) {
            ElementNode childNode = (ElementNode)e2.nextElement();
            this.C(childNode);
        }
    }

    void B(ElementNode node) {
        if (node == null) {
            return;
        }
        Enumeration<TreeNode> e2 = node.children();
        while (e2.hasMoreElements()) {
            ElementNode childNode = (ElementNode)e2.nextElement();
            this.B(childNode);
        }
        Element element = node.getElement();
        this.\u02a7.remove(element.getID());
    }

    void b() {
        this.\u02a7.clear();
        if (this.\u02b7 instanceof ElementNode) {
            this.C((ElementNode)this.\u02b7);
        } else {
            Enumeration<TreeNode> e2 = this.\u02b7.children();
            while (e2.hasMoreElements()) {
                ElementNode childNode = (ElementNode)e2.nextElement();
                this.C(childNode);
            }
        }
    }

    public PopupMenuFactory getPopupMenuFactory() {
        return this.\u02bf;
    }

    public void setPopupMenuFactory(PopupMenuFactory popupMenuFactory) {
        this.\u02bf = popupMenuFactory;
    }

    private void c() {
        if (this.\u038c || !this.isAutoSyncSelectionFromDataBoxToView()) {
            return;
        }
        if (this.getDataBox().getSelectionModel().isAdjusting()) {
            return;
        }
        if (this.isEditing()) {
            this.stopEditing();
        }
        this.\u038c = true;
        ArrayList<TreePath> pathList = new ArrayList<TreePath>();
        Iterator it = this.box.selection();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            if (!this.makeNodeLoaded(element) || !h.F(this, element)) continue;
            pathList.add(this.getTreePathByElement(element));
        }
        if (pathList.size() > 0) {
            TreePath[] paths = (TreePath[])Array.newInstance(TreePath.class, pathList.size());
            pathList.toArray(paths);
            this.setSelectionPaths(paths);
            if (this.\u02b3 && this.\u038f == 0) {
                for (int i2 = 0; i2 < paths.length; ++i2) {
                    this.makeVisible(paths[i2]);
                }
                this.scrollPathToVisible(paths[0]);
            }
        } else {
            this.clearSelection();
        }
        this.\u038c = false;
    }

    public void ensureVisible(Collection elements) {
        if (elements == null) {
            return;
        }
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            this.ensureVisible((Element)it.next());
        }
    }

    public void ensureVisible(Element element) {
        if (this.makeNodeLoaded(element)) {
            ElementNode elementNode = this.getLoadedTreeNodeByElement(element);
            Object[] objects = this.\u029a.getPathToRoot(elementNode);
            TreePath path = new TreePath(objects);
            this.scrollPathToVisible(path);
        }
    }

    public boolean isEnsureVisibleOnSelected() {
        return this.\u02b3;
    }

    public void setEnsureVisibleOnSelected(boolean isEnsureVisibleOnSelected) {
        this.\u02b3 = isEnsureVisibleOnSelected;
    }

    public void setRootElement(Element element) {
        if (element != null) {
            this.setDataBox(this.box, element);
        } else {
            this.setDataBox(this.box);
        }
    }

    public ElementNode getLoadedTreeNodeByElement(Element element) {
        if (element == null) {
            return null;
        }
        return (ElementNode)this.\u02a7.get(element.getID());
    }

    public ElementNode getTreeNodeByElement(Element element) {
        if (element == null) {
            return null;
        }
        if (this.makeNodeLoaded(element)) {
            return (ElementNode)this.\u02a7.get(element.getID());
        }
        return null;
    }

    public boolean isVisible(Element element) {
        if (element == null || !this.box.containsByID(element.getID())) {
            return false;
        }
        Iterator it = this.\u029b.iterator();
        while (it.hasNext()) {
            VisibleFilter filter = (VisibleFilter)it.next();
            if (filter.isVisible(element)) continue;
            return false;
        }
        return true;
    }

    public List getVisibleFilters() {
        return new ArrayList(this.\u029b);
    }

    public void addVisibleFilter(VisibleFilter filter) {
        if (filter != null) {
            if (this.\u029b.contains(filter)) {
                this.\u029b.remove(filter);
            }
            this.\u029b.add(filter);
            this.updateTViewUI();
        }
    }

    public void removeVisibleFilter(VisibleFilter filter) {
        if (filter != null) {
            this.\u029b.remove(filter);
            this.updateTViewUI();
        }
    }

    private void Y() {
        this.\u029b.add(D.C);
    }

    private void E(Element element) {
        if (element == null) {
            return;
        }
        Element parent = element.getParent();
        if (parent == null) {
            if (this.\u02b7 instanceof DataBoxNode) {
                if (!this.isRootVisible()) {
                    this.makeNodeLoaded(element);
                    this.expandRoot();
                } else if (this.\u02b7.isExplored()) {
                    this.makeNodeLoaded(element);
                }
            }
        } else {
            ElementNode parentNode = this.getLoadedTreeNodeByElement(parent);
            if (this.\u02b7 == parentNode && !this.isRootVisible()) {
                this.makeNodeLoaded(element);
            } else if (parentNode != null && parentNode.isExplored()) {
                this.makeNodeLoaded(element);
            }
        }
    }

    public boolean makeNodeLoaded(Element element) {
        if (this.isLoaded(element)) {
            return true;
        }
        if (!this.box.contains(element)) {
            return false;
        }
        if (!this.isVisible(element)) {
            return false;
        }
        Element parent = element.getParent();
        if (parent == null) {
            if (this.\u02b7 instanceof DataBoxNode) {
                this.A(this.\u02b7, element);
                return true;
            }
        } else if (this.makeNodeLoaded(parent)) {
            ElementNode parentNode = this.getLoadedTreeNodeByElement(parent);
            parentNode.explore();
            if (this.getLoadedTreeNodeByElement(element) == null) {
                this.A(parentNode, element);
            }
            return true;
        }
        return false;
    }

    private void A(AbstractTTreeNode parentNode, Element element) {
        ElementNode elementNode = new ElementNode(this, element);
        int index = h.A(this, parentNode, elementNode);
        this.\u038c = true;
        if (index > parentNode.getChildCount()) {
            index = parentNode.getChildCount();
        }
        if (index < 0) {
            index = 0;
        }
        this.\u029a.insertNodeInto(elementNode, parentNode, index);
        this.\u038c = false;
    }

    private void A(ElementNode elementNode) {
        this.\u038c = true;
        this.B(elementNode);
        if (elementNode.getParent() != null) {
            ((DefaultTreeModel)this.getModel()).removeNodeFromParent(elementNode);
        }
        this.\u038c = false;
    }

    public void setSelectionPaths(TreePath[] paths) {
        TreeSelectionModel selectionModel = this.getSelectionModel();
        if (selectionModel instanceof twaver.base.A.K.C) {
            ((twaver.base.A.K.C)selectionModel).A(paths);
        } else {
            selectionModel.setSelectionPaths(paths);
        }
    }

    private void D(Element element) {
        ElementNode elementNode = this.getLoadedTreeNodeByElement(element);
        if (elementNode != null) {
            if (elementNode == this.getRootNode()) {
                this.setDataBox(this.box);
            } else {
                this.A(elementNode);
            }
        }
    }

    public Element getElementByRowIndex(int rowIndex) {
        Object comp;
        TreePath path = this.getPathForRow(rowIndex);
        if (path != null && (comp = path.getLastPathComponent()) instanceof ElementNode) {
            return ((ElementNode)comp).getElement();
        }
        return null;
    }

    public void updateTViewUI() {
        LinkedList<Element> list = new LinkedList<Element>();
        int count = this.getRowCount();
        for (int i2 = 0; i2 < count; ++i2) {
            Object comp;
            TreePath path = this.getPathForRow(i2);
            if (!this.isExpanded(path) || !((comp = path.getLastPathComponent()) instanceof ElementNode)) continue;
            list.add(((ElementNode)comp).getElement());
        }
        this.\u038c = true;
        if (this.\u02b7 != null) {
            this.\u02b7.reloadChildren();
        }
        this.updateUI();
        this.\u038c = false;
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            this.expand(element);
        }
        this.c();
    }

    public Generator getElementLabelGenerator() {
        return this.\u0392;
    }

    public void setElementLabelGenerator(Generator elementLabelGenerator) {
        if (elementLabelGenerator == null) {
            elementLabelGenerator = TUIManager.getElementTreeLabelGenerator();
        }
        this.\u0392 = elementLabelGenerator;
        this.updateTViewUI();
    }

    public Generator getElementIconGenerator() {
        return this.\u02a8;
    }

    public void setElementIconGenerator(Generator elementIconGenerator) {
        this.\u02a8 = elementIconGenerator;
        this.updateTViewUI();
    }

    public String getDataBoxIconURL() {
        return this.\u037a;
    }

    public void setDataBoxIconURL(String boxIconURL) {
        this.\u037a = boxIconURL;
        this.repaint();
    }

    public boolean isDataBoxLabelEditable() {
        return this.\u02bd;
    }

    public void setDataBoxLabelEditable(boolean dataBoxLabelEditable) {
        this.\u02bd = dataBoxLabelEditable;
    }

    public CheckableFilter getCheckableFilter() {
        return this.\u0396;
    }

    public void setCheckableFilter(CheckableFilter checkableFilter) {
        this.\u0396 = checkableFilter;
        this.updateTViewUI();
    }

    public boolean isCheckable(Element element) {
        if (this.\u0396 == null) {
            return true;
        }
        return this.\u0396.isCheckable(element);
    }

    public boolean isEnableTristateCheckBox() {
        return this.\u02e0;
    }

    public void setEnableTristateCheckBox(boolean enableTristateCheckBox) {
        if (this.\u02e0 != enableTristateCheckBox) {
            this.\u02e0 = enableTristateCheckBox;
            this.updateTViewUI();
        }
    }

    public LazyLoader getLazyLoader() {
        return this.\u02bb;
    }

    public void setLazyLoader(LazyLoader lazyLoader) {
        this.\u02bb = lazyLoader;
    }

    protected Component getCursorComponent() {
        return this;
    }

    public void expandAll() {
        h.B(this);
    }

    public void expandAll(Element element) {
        h.E(this, element);
    }

    public void expand(int level) {
        h.A(this, level);
    }

    public void expand(Element element, int level) {
        h.A(this, element, level);
    }

    public void expand(Element element) {
        h.D(this, element);
    }

    public void expandRoot() {
        h.A(this);
    }

    public void collapseAll() {
        h.C(this);
    }

    public void collapseAll(Element element) {
        h.A(this, element);
    }

    public void collapse(Element element) {
        h.B(this, element);
    }

    public void collapseAll(TreePath parent) {
        h.A(this, parent);
    }

    public void setRootVisible(boolean rootVisible) {
        super.setRootVisible(rootVisible);
        if (!rootVisible) {
            this.expandRoot();
        }
    }

    public void moveTo(int index, Element element) {
        this.box.moveTo(index, element);
    }

    public void moveToUp(Element element) {
        this.box.moveToUp(element);
    }

    public void moveToDown(Element element) {
        this.box.moveToDown(element);
    }

    public void moveToTop(Element element) {
        this.box.moveToTop(element);
    }

    public void moveToBottom(Element element) {
        this.box.moveToBottom(element);
    }

    public EditableFilter getElementLabelEditableFilter() {
        return this.\u029c;
    }

    public void setElementLabelEditableFilter(EditableFilter elementLabelEditableFilter) {
        this.\u029c = elementLabelEditableFilter;
        this.setEditable(this.\u029c != null);
    }

    public ElementLabelEditor getElementLabelEditor() {
        return this.\u029f;
    }

    public void setElementLabelEditor(ElementLabelEditor elementLabelEditor) {
        this.\u029f = elementLabelEditor == null ? ElementLabelEditor.TREEEDITOR : elementLabelEditor;
    }

    public Generator getElementToolTipTextGenerator() {
        return this.\u02a0;
    }

    public void setElementToolTipTextGenerator(Generator elementToolTipTextGenerator) {
        this.\u02a0 = elementToolTipTextGenerator;
    }

    public boolean isSelectableOnRightClick() {
        return this.\u038e;
    }

    public void setSelectableOnRightClick(boolean isSelectableOnRightClick) {
        this.\u038e = isSelectableOnRightClick;
    }

    public boolean isClearSelectionOnMarginClicked() {
        return this.\u029d;
    }

    public void setClearSelectionOnMarginClicked(boolean isClearSelectionOnMarginClicked) {
        this.\u029d = isClearSelectionOnMarginClicked;
    }

    public TreePath getTreePathByElement(Element element) {
        ElementNode elementNode;
        if (this.makeNodeLoaded(element) && (elementNode = this.getLoadedTreeNodeByElement(element)) != null) {
            Object[] objects = ((DefaultTreeModel)this.getModel()).getPathToRoot(elementNode);
            TreePath path = new TreePath(objects);
            return path;
        }
        return null;
    }

    public void startEditingAtElement(Element element) {
        TreePath treePath = this.getTreePathByElement(element);
        if (treePath != null) {
            this.startEditingAtPath(treePath);
        }
    }

    public int getTristate(Element element) {
        if (this.isEnableTristateCheckBox()) {
            if (element.isSelected()) {
                if (h.C(this, element)) {
                    return 1;
                }
                return 3;
            }
            return 2;
        }
        if (element.isSelected()) {
            return 1;
        }
        return 2;
    }

    public boolean isIconVisible() {
        return this.\u02a4;
    }

    public void setIconVisible(boolean isIconVisible) {
        this.\u02a4 = isIconVisible;
        this.updateUI();
    }

    public boolean isExpanded(Element element) {
        TreePath treePath = this.getTreePathByElement(element);
        if (treePath != null) {
            return this.isExpanded(treePath);
        }
        return false;
    }

    public boolean isExpanded(ElementNode elementNode) {
        if (elementNode == null) {
            return false;
        }
        return this.isExpanded(elementNode.getElement());
    }

    public void updateUI() {
        TreeCellEditor editor;
        super.updateUI();
        TreeCellRenderer render = this.getCellRenderer();
        if (render instanceof JComponent) {
            ((JComponent)((Object)render)).updateUI();
        }
        if ((editor = this.getCellEditor()) instanceof JComponent) {
            ((JComponent)((Object)editor)).updateUI();
        }
        if (this.ui instanceof BasicTreeUI) {
            if (this.\u0299 != null) {
                ((BasicTreeUI)this.ui).setCollapsedIcon(this.\u0299);
            }
            if (this.\u02a1 != null) {
                ((BasicTreeUI)this.ui).setExpandedIcon(this.\u02a1);
            }
        }
    }

    public PopupMenuGenerator getPopupMenuGenerator() {
        return this.\u02b4;
    }

    public void setPopupMenuGenerator(PopupMenuGenerator popupMenuGenerator) {
        this.\u02b4 = popupMenuGenerator;
    }

    public DnDHandler getDnDHandler() {
        return this.\u0394;
    }

    public void setDnDHandler(DnDHandler dndHandler) {
        this.\u0394 = dndHandler;
    }

    public boolean isShowPlainIcon() {
        return this.\u02e2;
    }

    public void setShowPlainIcon(boolean showPlainIcon) {
        this.\u02e2 = showPlainIcon;
        this.repaint();
    }

    public ChildrenSortableFilter getChildrenSortableFilter() {
        return this.\u02b2;
    }

    public void setChildrenSortableFilter(ChildrenSortableFilter sortableFilter) {
        this.\u02b2 = sortableFilter;
        this.updateTViewUI();
    }

    public boolean isChildrenSortable(Element parentElement) {
        if (this.\u02b2 == null) {
            return true;
        }
        return this.\u02b2.isChildrenSortable(parentElement);
    }

    public int getUncheckableStyle(Element element) {
        return this.\u02d1;
    }

    public int getUncheckableStyle() {
        return this.\u02d1;
    }

    public void setUncheckableStyle(int uncheckableStyle) {
        this.\u02d1 = uncheckableStyle;
        this.updateUI();
    }

    public Icon getCollapsedIcon() {
        return this.\u0299;
    }

    public void setCollapsedIcon(Icon collapsedIcon) {
        this.\u0299 = collapsedIcon;
        if (this.ui instanceof BasicTreeUI && this.\u0299 != null) {
            ((BasicTreeUI)this.ui).setCollapsedIcon(this.\u0299);
        }
        this.repaint();
    }

    public Icon getExpandedIcon() {
        return this.\u02a1;
    }

    public void setExpandedIcon(Icon expandedIcon) {
        this.\u02a1 = expandedIcon;
        if (this.ui instanceof BasicTreeUI && this.\u02a1 != null) {
            ((BasicTreeUI)this.ui).setExpandedIcon(this.\u02a1);
        }
        this.repaint();
    }

    public boolean isAutoSyncSelectionFromDataBoxToView() {
        return this.\u02a5;
    }

    public void setAutoSyncSelectionFromDataBoxToView(boolean autoSyncSelectionFromDataBoxToTree) {
        this.\u02a5 = autoSyncSelectionFromDataBoxToTree;
    }

    public boolean isAutoSyncSelectionFromViewToDataBox() {
        return this.\u0386;
    }

    public void setAutoSyncSelectionFromViewToDataBox(boolean autoSyncSelectionFromTreeToDataBox) {
        this.\u0386 = autoSyncSelectionFromTreeToDataBox;
    }

    public int getIconWidth() {
        return this.\u02a6;
    }

    public void setIconWidth(int iconWidth) {
        this.\u02a6 = iconWidth;
        this.updateTViewUI();
    }

    public int getIconHeight() {
        return this.\u02b5;
    }

    public void setIconHeight(int iconHeight) {
        this.\u02b5 = iconHeight;
        this.updateTViewUI();
    }

    public boolean isPaintSelectedStateWhenChecked() {
        return this.\u02a2;
    }

    public void setPaintSelectedStateWhenChecked(boolean paintSelectedStateWhenChecked) {
        this.\u02a2 = paintSelectedStateWhenChecked;
        this.repaint();
    }

    public boolean isCheckedWhenNotSpecified() {
        return this.\u038a;
    }

    public void setCheckedWhenNotSpecified(boolean checkedWhenNotSpecified) {
        this.\u038a = checkedWhenNotSpecified;
        this.repaint();
    }

    public boolean isEnableAnimation() {
        return this.\u0390 != null;
    }

    public void prepareRenderer(JLabel renderer, Element element) {
    }

    public boolean isEnableRightClickEvent() {
        return this.\u029e;
    }

    public void setEnableRightClickEvent(boolean isEnableRightClickEvent) {
        this.\u029e = isEnableRightClickEvent;
    }

    public boolean isUpdateSortOnPropertyChanged() {
        return this.\u02d0;
    }

    public void setUpdateSortOnPropertyChanged(boolean updateSortOnPropertyChanged) {
        this.\u02d0 = updateSortOnPropertyChanged;
    }

    public void setEnableAnimation(boolean enableAnimation) {
        if (this.isEnableAnimation() == enableAnimation) {
            return;
        }
        if (enableAnimation) {
            this.\u0390 = new G(){

                public boolean A(F event) {
                    if (TTree.this.isEnableAnimation() && TTree.this.isShowing()) {
                        twaver.base.A.D.B.C gifTask = event.A();
                        String url = gifTask.D();
                        List list = TTree.this.box.getGifIconFinder().A(url);
                        if (list != null) {
                            for (int i2 = 0; i2 < list.size(); ++i2) {
                                Rectangle rect;
                                Element element = (Element)list.get(i2);
                                TreePath path = TTree.this.getTreePathByElement(element);
                                if (path == null || (rect = TTree.this.getPathBounds(path)) == null) continue;
                                TTree.this.repaint(rect);
                            }
                        }
                    }
                    return false;
                }
            };
            E.B().A(this.\u0390);
        } else {
            this.\u0390 = null;
        }
    }

    class _B
    extends MouseAdapter
    implements TreeSelectionListener,
    TreeWillExpandListener {
        private TTree A = null;
        private Element B = null;

        _B(TTree tree) {
            this.A = tree;
            this.A.addTreeSelectionListener(this);
            this.A.addTreeWillExpandListener(this);
            this.A.addMouseListener(this);
        }

        public void valueChanged(TreeSelectionEvent e2) {
            if (this.A.getTTreeSelectionMode() == 0) {
                this.A._();
            }
        }

        public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
        }

        public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
            ElementNode node;
            Element element;
            Object comp;
            TreePath path;
            LazyLoader lazyLoader = this.A.getLazyLoader();
            if (lazyLoader != null && (path = event.getPath()) != null && (comp = path.getLastPathComponent()) instanceof ElementNode && this.B != (element = (node = (ElementNode)comp).getElement()) && !lazyLoader.isLoaded(element)) {
                LazyLoaderListener l2;
                int i2;
                this.B = element;
                node.explore();
                Cursor cursor = this.A.getCursorComponent().getCursor();
                this.A.getCursorComponent().setCursor(Cursor.getPredefinedCursor(3));
                for (i2 = 0; i2 < TTree.this.\u02b8.size(); ++i2) {
                    l2 = (LazyLoaderListener)TTree.this.\u02b8.get(i2);
                    l2.beforeLoad(element);
                }
                lazyLoader.load(element);
                for (i2 = 0; i2 < TTree.this.\u02b8.size(); ++i2) {
                    l2 = (LazyLoaderListener)TTree.this.\u02b8.get(i2);
                    l2.afterLoad(element);
                }
                this.A.getCursorComponent().setCursor(cursor);
                this.B = null;
            }
        }

        public void mouseReleased(MouseEvent evt) {
            JPopupMenu popMenu;
            JPopupMenu popMenu2;
            PopupMenuGenerator generator;
            Object comp;
            if (!this.A.isEnabled()) {
                return;
            }
            TDataBox box = this.A.getDataBox();
            TreePath path = this.A.getPathForLocation(evt.getX(), evt.getY());
            if (path == null && this.A.isClearSelectionOnMarginClicked()) {
                this.A.getSelectionModel().clearSelection();
            }
            if (!SwingUtilities.isRightMouseButton(evt)) {
                return;
            }
            if (path != null && this.A.isSelectableOnRightClick() && P.A(evt) && (!((comp = path.getLastPathComponent()) instanceof ElementNode) || !((ElementNode)comp).getElement().isSelected())) {
                this.A.getSelectionModel().setSelectionPath(path);
            }
            if ((generator = this.A.getPopupMenuGenerator()) != null && (popMenu2 = generator.generate(this.A, evt)) != null) {
                popMenu2.show(this.A, evt.getPoint().x, evt.getPoint().y);
                return;
            }
            PopupMenuFactory factory = this.A.getPopupMenuFactory();
            if (factory != null && (popMenu = factory.getPopupMenu(box.getSelectionModel(), evt.getPoint())) != null) {
                popMenu.show(this.A, evt.getPoint().x, evt.getPoint().y);
            }
        }

        public void mouseClicked(MouseEvent evt) {
            TreePath path;
            if (!this.A.isEnabled()) {
                return;
            }
            if ((SwingUtilities.isLeftMouseButton(evt) || TTree.this.isEnableRightClickEvent()) && (path = this.A.getPathForLocation(evt.getX(), evt.getY())) != null) {
                Object comp = path.getLastPathComponent();
                if (comp instanceof ElementNode) {
                    ElementNode node = (ElementNode)comp;
                    MouseActionEvent event = new MouseActionEvent((Object)node, evt, TTree.this);
                    if (evt.getClickCount() == 2) {
                        this.A.A(event);
                    }
                    this.A.B(event);
                } else if (comp instanceof DataBoxNode) {
                    DataBoxNode node = (DataBoxNode)comp;
                    MouseActionEvent event = new MouseActionEvent((Object)node, evt, TTree.this);
                    this.A.B(event);
                }
            }
        }
    }

    class _A
    implements DataBoxListener,
    PropertyChangeListener {
        private TTree A = null;

        _A(TTree tree) {
            this.A = tree;
        }

        public void elementAdded(DataBoxEvent e2) {
            Element element = e2.getElement();
            this.A.E(element);
        }

        public void elementRemoved(DataBoxEvent e2) {
            Element element = e2.getElement();
            this.A.D(element);
        }

        public void elementsCleared(DataBoxEvent e2) {
            AbstractTTreeNode root = this.A.getRootNode();
            if (root == null) {
                return;
            }
            if (root instanceof DataBoxNode) {
                root.reloadChildren();
            } else {
                this.A.setDataBox(this.A.getDataBox());
            }
            this.A.updateUI();
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            Element element = (Element)evt.getSource();
            ElementNode elementNode = this.A.getLoadedTreeNodeByElement(element);
            if (elementNode != null) {
                if (!TTree.this.isFireTreeNodeChangedWhenSelectionChanged() && propName.equals("selected")) {
                    this.A.repaint();
                } else {
                    ((DefaultTreeModel)this.A.getModel()).nodeChanged(elementNode);
                }
                if (elementNode != this.A.getRootNode()) {
                    if (propName.equals("parent")) {
                        this.A.A(elementNode);
                    } else if (TTree.this.isUpdateSortOnPropertyChanged() && TTree.this.getSortComparator() != null && TTree.this.isChildrenSortable(element.getParent()) && (TTree.this.\u02e1 == null || TTree.this.\u02e1.isInterested(evt))) {
                        TTree.this.updateSort(element, evt, elementNode);
                    }
                }
            }
            if (this.A.isVisible(element)) {
                this.A.E(element);
            } else {
                this.A.D(element);
            }
        }
    }
}

