/*
 * Decompiled with CFR 0.152.
 */
package twaver.network.ui;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.List;
import twaver.ShapeNode;
import twaver.base.A.E.d;
import twaver.network.ui.DefaultBorderUI;
import twaver.network.ui.ShapeNodeUI;

public class ShapeNodeBorderUI
extends DefaultBorderUI {
    private ShapeNodeUI J;

    public ShapeNodeBorderUI(ShapeNodeUI shapeNodeUI) {
        super(shapeNodeUI);
        this.J = shapeNodeUI;
    }

    public void paintBorder(Graphics2D g2d) {
        if (!this.isVisible()) {
            return;
        }
        ShapeNode node = this.J.getShapeNode();
        if (node.getShapeNodeType() == 0) {
            d.B(g2d, (Shape)this.A());
            return;
        }
        int type = this.getType();
        boolean resizable = this.network.isResizable(this.element);
        if (!resizable && type == 1) {
            return;
        }
        if (!resizable && type != 2) {
            super.paintBorder(g2d);
            return;
        }
        if (this.J.isShowDashLine()) {
            GeneralPath path = new GeneralPath();
            List segments = ((ShapeNode)this.element).getSegments();
            List points = ((ShapeNode)this.element).getPoints();
            if (points.size() > 0) {
                if (segments == null || segments.size() == 0) {
                    Point2D point = (Point2D)points.get(0);
                    path.moveTo((int)point.getX(), (int)point.getY());
                    for (int i2 = 1; i2 < points.size(); ++i2) {
                        point = (Point2D)points.get(i2);
                        path.lineTo((int)point.getX(), (int)point.getY());
                    }
                    path.closePath();
                } else {
                    Point2D point = (Point2D)points.get(0);
                    path.moveTo((int)point.getX(), (int)point.getY());
                    for (int i3 = 1; i3 < points.size(); ++i3) {
                        point = (Point2D)points.get(i3);
                        int segment = 1;
                        if (i3 < segments.size()) {
                            segment = (Integer)segments.get(i3);
                        }
                        switch (segment) {
                            case 0: {
                                path.moveTo((int)point.getX(), (int)point.getY());
                                break;
                            }
                            case 1: {
                                path.lineTo((int)point.getX(), (int)point.getY());
                                break;
                            }
                            case 4: {
                                path.closePath();
                            }
                        }
                        path.lineTo((int)point.getX(), (int)point.getY());
                    }
                }
                d.A(g2d, (Shape)path);
            }
        }
        if (resizable) {
            d.B(g2d, (Shape)this.A());
        } else {
            super.paintBorder(g2d);
        }
    }

    protected Shape getShape() {
        if (this.getType() == 2) {
            return this.A();
        }
        return super.getShape();
    }

    private Area A() {
        if (!this.isVisible()) {
            return null;
        }
        Area area = new Area();
        ShapeNode node = (ShapeNode)this.getElement();
        List points = node.getPoints();
        for (int i2 = 0; i2 < points.size(); ++i2) {
            Point2D point = (Point2D)points.get(i2);
            Rectangle rect = new Rectangle((int)point.getX() - 3, (int)point.getY() - 3, 6, 6);
            area.add(new Area(rect));
        }
        return area;
    }

    public Rectangle getBounds() {
        if (!this.isVisible()) {
            return null;
        }
        Rectangle bounds = super.getBounds();
        if (bounds == null) {
            return this.A().getBounds();
        }
        bounds.add(this.A().getBounds());
        return bounds;
    }

    public int getPointIndex(Point2D p2) {
        if (p2 == null || !this.isVisible()) {
            return -1;
        }
        ShapeNode node = (ShapeNode)this.getElement();
        List points = node.getPoints();
        for (int i2 = 0; i2 < points.size(); ++i2) {
            Point2D point = (Point2D)points.get(i2);
            Rectangle rect = new Rectangle((int)point.getX() - 3, (int)point.getY() - 3, 6, 6);
            if (!rect.contains(p2)) continue;
            return i2;
        }
        return -1;
    }
}

