/*
 * Decompiled with CFR 0.152.
 */
package twaver.network.ui;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Area;
import java.beans.PropertyChangeEvent;
import twaver.ShapeNode;
import twaver.TWaverConst;
import twaver.base.A.E.S;
import twaver.base.A.E.d;
import twaver.network.TNetwork;
import twaver.network.ui.BorderUI;
import twaver.network.ui.NodeUI;
import twaver.network.ui.ShapeNodeBorderUI;

public class ShapeNodeUI
extends NodeUI {
    private ShapeNode l = null;
    private boolean k;
    private Shape m = null;

    public ShapeNodeUI(TNetwork network, ShapeNode node) {
        super(network, node);
        this.l = node;
        this.k = this.l.isShapeNodeShowDashLine();
    }

    public void elementPropertyChange(PropertyChangeEvent evt) {
        super.elementPropertyChange(evt);
        this.m = null;
    }

    public void updateClientProperty(String propertyName) {
        if ("shapenode.show.dash.line".equals(propertyName)) {
            this.k = this.l.isShapeNodeShowDashLine();
        } else {
            super.updateClientProperty(propertyName);
        }
    }

    public boolean isShowDashLine() {
        return this.k;
    }

    public BorderUI getBorder() {
        if (this.defaultBorder == null) {
            this.defaultBorder = new ShapeNodeBorderUI(this);
        }
        return this.defaultBorder;
    }

    public boolean contains(int x, int y) {
        Shape s;
        if (this.l.getShapeNodeType() == 0) {
            return super.contains(x, y);
        }
        Shape shape = this.l.getShape();
        if (this.customDrawFill && shape.contains(x, y)) {
            return true;
        }
        if (this.customDrawOutline && (s = this.customDrawOutlineStroke.createStrokedShape(shape)).intersects(x - 2, y - 2, 4.0, 4.0)) {
            return true;
        }
        shape = this.F();
        if (shape != null && shape.contains(x, y)) {
            return true;
        }
        shape = this.G();
        if (shape != null && shape.contains(x, y)) {
            return true;
        }
        return this.containInAttachments(x, y);
    }

    public Rectangle getUIBounds() {
        Rectangle rect = super.getUIBounds();
        Shape shape = this.F();
        if (shape != null) {
            rect.add(shape.getBounds());
        }
        if ((shape = this.G()) != null) {
            rect.add(shape.getBounds());
        }
        return rect;
    }

    public void paint(Graphics2D g2d) {
        super.paint(g2d);
        this.paintArrows(g2d);
    }

    protected void paintArrows(Graphics2D g2d) {
        Color color;
        Shape shape = this.F();
        if (shape != null) {
            color = this.l.getShapeNodeFromArrowColor();
            g2d.setColor(color);
            g2d.fill(shape);
            if (this.l.isShapeNodeFromArrowOutline()) {
                g2d.setStroke(TWaverConst.BASIC_STROKE);
                g2d.setColor(this.l.getShapeNodeFromArrowOutlineColor());
                g2d.draw(shape);
            }
        }
        if ((shape = this.G()) != null) {
            color = this.l.getShapeNodeToArrowColor();
            g2d.setColor(color);
            g2d.fill(shape);
            if (this.l.isShapeNodeToArrowOutline()) {
                g2d.setStroke(TWaverConst.BASIC_STROKE);
                g2d.setColor(this.l.getShapeNodeToArrowOutlineColor());
                g2d.draw(shape);
            }
        }
    }

    private Shape F() {
        if (!this.l.isShapeNodeFromArrow()) {
            return null;
        }
        return S.A(this.l.isShapeNodeFromArrowCenter(), this.l.getPath(), null, null, this.l.getShapeNodeFromArrowStyle(), this.l.getShapeNodeFromArrowXOffset(), this.l.getShapeNodeFromArrowYOffset());
    }

    private Shape G() {
        if (!this.l.isShapeNodeToArrow()) {
            return null;
        }
        return S.B(this.l.isShapeNodeToArrowCenter(), this.l.getPath(), null, null, this.l.getShapeNodeToArrowStyle(), this.l.getShapeNodeToArrowXOffset(), this.l.getShapeNodeToArrowYOffset());
    }

    protected void paintCustomDraw(Graphics2D g2d) {
        if (this.l.getShapeNodeType() == 0) {
            super.paintCustomDraw(g2d);
            return;
        }
        Object oldHinds = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        if (this.customDrawAntialias) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        Shape bodyShape = this.l.getShape();
        Color stateOutlineColor = this.getStateOutlineColor();
        Area shape = null;
        int offset = this.customDrawOutline && this.customDrawOutline3D ? 1 : 0;
        BorderUI border = this.getBorder();
        if (border instanceof ShapeNodeBorderUI) {
            ShapeNodeBorderUI sb = (ShapeNodeBorderUI)border;
            if (this.l.isSelected() && sb.isVisible() && sb.getType() == 1 && !this.network.isResizable(this.element) && this.network.isSelectedStatePaintable(this.element)) {
                if (sb.isXormode()) {
                    g2d.setXORMode(Color.WHITE);
                }
                Color selectedColor = this.network.getElementSelectColor(this.element);
                g2d.setColor(selectedColor);
                if (this.customDrawOutline) {
                    int strokeWidth = stateOutlineColor == null ? 3 + offset : 6 + offset;
                    g2d.setStroke(d.B(strokeWidth));
                    if (this.m == null) {
                        this.m = new Area(this.customDrawOutlineStroke.createStrokedShape(bodyShape));
                    }
                    g2d.draw(this.m);
                } else {
                    int strokeWidth = stateOutlineColor == null ? 2 : 4;
                    g2d.setStroke(d.B(strokeWidth));
                    g2d.draw(bodyShape);
                }
                if (sb.isXormode()) {
                    g2d.setPaintMode();
                }
            }
        }
        if (stateOutlineColor != null) {
            g2d.setColor(stateOutlineColor);
            if (this.customDrawOutline) {
                g2d.setStroke(d.B(3 + offset));
                if (shape == null) {
                    shape = new Area(this.customDrawOutlineStroke.createStrokedShape(bodyShape));
                }
                g2d.draw(shape);
            } else {
                g2d.setStroke(d.B(2));
                g2d.draw(bodyShape);
            }
        }
        this.paintCustomDrawBody(g2d, bodyShape);
        this.paintCustomDrawOutline(g2d, bodyShape);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHinds);
    }

    public ShapeNode getShapeNode() {
        return this.l;
    }
}

