/*
 * Decompiled with CFR 0.152.
 */
package twaver.table.editor;

import twaver.TUIManager;
import twaver.TWaverUtil;
import twaver.table.editor.AbstractCellEditor;

public class LongEditor
extends AbstractCellEditor {
    public LongEditor() {
        this(TUIManager.getString("table.alignment.number"));
    }

    public LongEditor(String alignment) {
        TWaverUtil.setHorizontalAlignment(this.getComponent(), alignment);
    }

    public Object getCellEditorValue() {
        Object value = super.getCellEditorValue();
        if (value == null || "".equals(value)) {
            return null;
        }
        if (value instanceof Long) {
            return value;
        }
        if (value instanceof Number) {
            return new Long(((Number)value).longValue());
        }
        try {
            return new Long(Long.parseLong(value.toString()));
        }
        catch (Exception ex) {
            return value;
        }
    }

    public boolean validInputValue(Object inputValue) {
        return inputValue instanceof Long;
    }
}

