/*
 * Decompiled with CFR 0.152.
 */
package twaver.network.ui;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import twaver.Chassis;
import twaver.Element;
import twaver.Node;
import twaver.TSubNetwork;
import twaver.TWaverUtil;
import twaver.base.A.E.O;
import twaver.base.A.E.b;
import twaver.network.TNetwork;
import twaver.network.ui.A;
import twaver.network.ui.BaseElementUI;
import twaver.network.ui.ElementUI;

public class NodeUI
extends BaseElementUI {
    protected boolean drawImageShape;

    public NodeUI(TNetwork network, Node node) {
        super(network, node);
        this.drawImageShape = b.K(this.element, "draw.image.shape");
    }

    public Node getNode() {
        return (Node)this.element;
    }

    public void paintBody(Graphics2D g2d) {
        if (this.element.getImage() == null) {
            super.paintBody(g2d);
        } else {
            Color bodyColor = this.getPaintBodyColor(null);
            ImageIcon image = O.A(this.element.getImageURL(), bodyColor);
            Rectangle bounds = this.element.getBounds();
            g2d.drawImage(image.getImage(), bounds.x, bounds.y, bounds.width, bounds.height, null);
            if (this.textureFactory != null) {
                if (bodyColor == null) {
                    this.setBodyPaint(g2d, this.color);
                } else {
                    this.setBodyPaint(g2d, bodyColor);
                }
                g2d.fill(bounds);
            }
        }
    }

    public void paintStateOutline(Graphics2D g2d) {
        if (this.drawImageShape) {
            Color stateOutlineColor;
            Shape imageShape = this.getImageShape();
            if (imageShape != null && (stateOutlineColor = this.getStateOutlineColor()) != null) {
                this.setStateOutline(g2d, stateOutlineColor);
                g2d.draw(imageShape);
            }
        } else {
            super.paintStateOutline(g2d);
        }
    }

    public Shape getImageShape() {
        Shape imageShape = O.C(this.element.getImageURL());
        if (imageShape != null) {
            Point location = this.getNode().getLocation();
            AffineTransform at = AffineTransform.getTranslateInstance(location.x, location.y);
            imageShape = at.createTransformedShape(imageShape);
        }
        return imageShape;
    }

    public void updateClientProperty(String propertyName) {
        if (propertyName.equals("draw.image.shape")) {
            this.drawImageShape = b.K(this.element, "draw.image.shape");
        } else {
            super.updateClientProperty(propertyName);
        }
    }

    public void performAction(int gesture, MouseEvent e2) {
        if (gesture == 2) {
            Chassis chassis = this.getDrillDownChassis();
            if (chassis != null) {
                ElementUI chassisUI = this.network.getRenderer().getElementUI(chassis);
                chassisUI.performAction(gesture, e2);
            }
            if (this.element instanceof TSubNetwork) {
                this.network.loadAndEnterSubNetwork((TSubNetwork)this.element);
            }
        }
    }

    protected Chassis getDrillDownChassis() {
        ArrayList<A> items = null;
        Iterator it = this.getNode().children();
        while (it.hasNext()) {
            Element child = (Element)it.next();
            if (!(child instanceof Chassis)) continue;
            if (items == null) {
                items = new ArrayList<A>();
            }
            items.add(new A((Chassis)child));
        }
        if (items == null) {
            return null;
        }
        if (items.size() == 1) {
            A chassisItem = (A)items.get(0);
            return chassisItem.A();
        }
        if (items.size() > 1) {
            Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, this.network);
            String message = TWaverUtil.getString("SELECT_CHASSIS");
            String title = TWaverUtil.getString("CONFIRM");
            A chassisItem = window instanceof Dialog ? (A)JOptionPane.showInputDialog((Dialog)window, message, title, -1, null, items.toArray(), items.get(0)) : (A)JOptionPane.showInputDialog((Frame)window, message, title, -1, null, items.toArray(), items.get(0));
            if (chassisItem != null) {
                return chassisItem.A();
            }
        }
        return null;
    }

    public boolean contains(int x, int y) {
        if (this.network.isElementTransparentAreaSelectable() || this.element.getImage() == null || this.isCustomDraw()) {
            return super.contains(x, y);
        }
        if (this.containInAttachments(x, y)) {
            return true;
        }
        Rectangle bounds = this.getNode().getBounds();
        return O.A(this.getNode().getImageURL(), x - bounds.x, y - bounds.y, bounds.width, bounds.height);
    }

    public boolean isDrawImageShape() {
        return this.drawImageShape;
    }
}

