/*
 * Decompiled with CFR 0.152.
 */
package twaver.network.inputhandler;

import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import twaver.Element;
import twaver.MouseActionEvent;
import twaver.base.A.E.P;
import twaver.network.TNetwork;
import twaver.network.inputhandler.InputAdapter;
import twaver.network.ui.Attachment;
import twaver.network.ui.ElementUI;

public class InteractionInputHandler
extends InputAdapter {
    private TNetwork x = null;

    public InteractionInputHandler(TNetwork network) {
        this.x = network;
    }

    public void mouseClicked(MouseEvent e2) {
        Element element = this.x.getElementPhysicalAt(e2.getPoint());
        if (element != null) {
            ElementUI ui = this.x.getElementUI(element);
            Point point = this.x.getLogicalPoint(e2.getPoint());
            Attachment attachment = ui.getAttachmentAt(point);
            if (e2.getClickCount() != 2 || this.x.isDoubleClickable(element)) {
                int gesture = P.B(e2);
                if (attachment != null) {
                    attachment.performAction(gesture, e2);
                } else {
                    ui.performAction(gesture, e2);
                }
            }
            ui.mouseClicked(e2);
            if (attachment != null) {
                this.x.fireInteractionPerformed(attachment, 16, e2);
            } else {
                this.x.fireInteractionPerformed(element, 15, e2);
            }
        }
        if (SwingUtilities.isLeftMouseButton(e2) || this.x.isEnableRightClickEvent()) {
            MouseActionEvent event;
            if (element == null) {
                event = new MouseActionEvent((Object)this.x, e2, this.x);
                if (e2.getClickCount() == 2) {
                    this.x.fireBackgroundDoubleClicked(event);
                }
            } else {
                event = new MouseActionEvent((Object)element, e2, this.x);
                if (e2.getClickCount() == 2) {
                    this.x.fireElementDoubleClicked(event);
                }
                this.x.fireElementClicked(event);
            }
        }
    }

    public TNetwork getNetwork() {
        return this.x;
    }
}

