/*
 * Decompiled with CFR 0.152.
 */
package y.io.gml;

import java.io.IOException;
import y.io.GMLIOHandler;
import y.io.gml.GMLEncoder;
import y.io.gml.ObjectEncoder;
import y.view.ImageNodeRealizer;
import y.view.NodeRealizer;
import y.view.ShapeNodeRealizer;

public class NodeRealizerObjectEncoder
implements ObjectEncoder {
    public void encode(Object object, GMLEncoder gMLEncoder) throws IOException {
        ImageNodeRealizer imageNodeRealizer;
        NodeRealizer nodeRealizer = (NodeRealizer)object;
        gMLEncoder.addAttribute("x", (float)nodeRealizer.getCenterX());
        gMLEncoder.addAttribute("y", (float)nodeRealizer.getCenterY());
        gMLEncoder.addAttribute("w", (float)nodeRealizer.getWidth());
        gMLEncoder.addAttribute("h", (float)nodeRealizer.getHeight());
        String string = "oval";
        if (nodeRealizer instanceof ShapeNodeRealizer) {
            byte by = ((ShapeNodeRealizer)nodeRealizer).getShapeType();
            switch (by) {
                case 0: {
                    string = "rectangle";
                    break;
                }
                case 1: {
                    string = "roundrectangle";
                    break;
                }
                case 2: {
                    string = "ellipse";
                    break;
                }
                case 3: {
                    string = "parallelogram";
                    break;
                }
                case 4: {
                    string = "hexagon";
                    break;
                }
                case 7: {
                    string = "octagon";
                    break;
                }
                case 8: {
                    string = "diamond";
                    break;
                }
                case 5: {
                    string = "triangle";
                    break;
                }
                case 6: {
                    string = "rectangle3d";
                    break;
                }
                default: {
                    string = "rectangle";
                }
            }
            gMLEncoder.addAttribute("type", string);
        } else if (nodeRealizer instanceof ImageNodeRealizer && (imageNodeRealizer = (ImageNodeRealizer)nodeRealizer).getImageURL() != null) {
            gMLEncoder.addAttribute("image", imageNodeRealizer.getImageURL().toString());
        }
        gMLEncoder.addAttribute("width", nodeRealizer.getLineType().getLineWidth());
        gMLEncoder.addAttribute("fill", GMLIOHandler.convertColor(nodeRealizer.getFillColor()));
        gMLEncoder.addAttribute("outline", GMLIOHandler.convertColor(nodeRealizer.getLineColor()));
    }
}

