/*
 * Decompiled with CFR 0.152.
 */
package twaver.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import twaver.TWaverConst;
import twaver.TWaverUtil;
import twaver.base.A.E.C;
import twaver.base.A.E.D;
import twaver.swing.TComboBox;
import twaver.table.PageListener;
import twaver.table.TTable;
import twaver.table.TablePaging;

public class TPageNavigator
extends JPanel
implements ActionListener {
    protected boolean isAdjusting = false;
    protected TablePaging pageable;
    protected String summaryContext;
    protected JLabel summary;
    protected Object[] items = null;
    private long A;
    protected JComboBox pageRowSizeSelection;
    protected JTextField currentPage;
    protected JButton firstPage;
    protected JButton prePage;
    protected JButton nextPage;
    protected JButton lastPage;
    protected JPanel rightPanel = new JPanel(new FlowLayout(2, 0, 0));

    public TPageNavigator(TablePaging page) {
        this(page, null);
    }

    public TPageNavigator(final TablePaging pageable, int[] pageSizes) {
        this.pageable = pageable;
        this.summaryContext = TWaverUtil.getString("table.summary");
        this.summary = new JLabel(" ");
        this.summary.setAlignmentX(2.0f);
        if (pageSizes == null || pageSizes.length == 0) {
            this.items = new String[]{TTable.\u01db};
        } else {
            this.items = new String[pageSizes.length];
            for (int i2 = 0; i2 < this.items.length; ++i2) {
                this.items[i2] = pageSizes[i2] <= 0 ? TTable.\u01db : pageSizes[i2] + "";
            }
        }
        this.pageRowSizeSelection = new TComboBox(this.items);
        this.pageRowSizeSelection.setEditable(true);
        this.currentPage = new JTextField();
        this.currentPage.setHorizontalAlignment(0);
        this.firstPage = this.A("/resource/image/table/first.png", "table.first");
        this.prePage = this.A("/resource/image/table/previous.png", "table.prev");
        this.nextPage = this.A("/resource/image/table/next.png", "table.next");
        this.lastPage = this.A("/resource/image/table/last.png", "table.last");
        int height = this.currentPage.getPreferredSize().height;
        this.currentPage.setPreferredSize(new Dimension(32, height));
        this.pageRowSizeSelection.setPreferredSize(new Dimension(52, height));
        if (this.items.length != 1 || this.items[0] != TTable.\u01db) {
            this.rightPanel.add(this.A("table.pageRowSize"));
            this.rightPanel.add(this.pageRowSizeSelection);
            this.rightPanel.add(this.A("table.currentPage"));
            this.rightPanel.add(this.currentPage);
            this.rightPanel.add(this.firstPage);
            this.rightPanel.add(this.prePage);
            this.rightPanel.add(this.nextPage);
            this.rightPanel.add(this.lastPage);
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.summary, "Center");
        this.add((Component)this.rightPanel, "East");
        this.pageRowSizeSelection.addActionListener(this);
        this.currentPage.addActionListener(this);
        this.firstPage.addActionListener(this);
        this.prePage.addActionListener(this);
        this.nextPage.addActionListener(this);
        this.lastPage.addActionListener(this);
        this.currentPage.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e2) {
                TPageNavigator.this.currentPage.setText(pageable.getCurrentPageIndex() + "");
            }

            public void focusLost(FocusEvent e2) {
                TPageNavigator.this.currentPage.setText(pageable.getCurrentPageIndex() + "");
            }
        });
        pageable.addPageListener(new PageListener(){

            public void pageChanged() {
                TPageNavigator.this.updateUIState();
            }
        });
        this.updateUIState();
    }

    private JLabel A(String i18nKey) {
        JLabel label = new JLabel(" " + TWaverUtil.getString(i18nKey), 4);
        return label;
    }

    private JButton A(String iconURL, String i18nKey) {
        JButton button = new JButton(C.E(iconURL));
        button.setToolTipText(TWaverUtil.getString(i18nKey));
        button.setVerticalAlignment(0);
        button.setHorizontalAlignment(0);
        button.setMargin(TWaverConst.NONE_INSETS);
        return button;
    }

    public void updateUIState() {
        this.isAdjusting = true;
        String context = this.summaryContext.replaceFirst("%p", this.pageable.getCurrentPageIndex() + "").replaceFirst("%ps", this.pageable.getPageTotalCount() + "").replaceFirst("%first", this.C() + 1 + "").replaceFirst("%last", this.A() + 1 + "").replaceFirst("%sum", this.pageable.getTotalRowCount() + "");
        this.summary.setText(" " + context);
        String rowSize = this.pageable.getPageRowSize() == Integer.MAX_VALUE ? TTable.\u01db : this.pageable.getPageRowSize() + "";
        if (D.A(this.items, rowSize) >= 0) {
            this.pageRowSizeSelection.setSelectedItem(rowSize);
        } else {
            this.pageRowSizeSelection.getEditor().setItem(rowSize);
        }
        if (!this.currentPage.hasFocus()) {
            this.currentPage.setText(this.pageable.getCurrentPageIndex() + "");
        }
        this.firstPage.setEnabled(this.E());
        this.prePage.setEnabled(this.B());
        this.nextPage.setEnabled(this.F());
        this.lastPage.setEnabled(this.D());
        this.isAdjusting = false;
    }

    private int C() {
        return Math.min((this.pageable.getCurrentPageIndex() - 1) * this.pageable.getPageRowSize(), this.pageable.getTotalRowCount() - 1);
    }

    private int A() {
        return Math.min(this.C() + this.pageable.getPageRowSize() - 1, this.pageable.getTotalRowCount() - 1);
    }

    private boolean E() {
        return this.pageable.getPageTotalCount() > 0 && this.pageable.getCurrentPageIndex() != 1;
    }

    private boolean B() {
        return this.pageable.getPageTotalCount() > 0 && this.pageable.getCurrentPageIndex() > 1;
    }

    private boolean F() {
        return this.pageable.getPageTotalCount() > 0 && this.pageable.getCurrentPageIndex() < this.pageable.getPageTotalCount();
    }

    private boolean D() {
        return this.pageable.getPageTotalCount() > 0 && this.pageable.getCurrentPageIndex() != this.pageable.getPageTotalCount();
    }

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(ActionEvent e2) {
        if (this.isAdjusting) {
            return;
        }
        Object source = e2.getSource();
        if (source == this.pageRowSizeSelection) {
            void var5_7;
            int pageRowSize;
            long now = System.currentTimeMillis();
            if (now - this.A < 1000L) {
                return;
            }
            this.A = now;
            String value = (String)this.pageRowSizeSelection.getSelectedItem();
            if (TTable.\u01db.equals(value)) {
                pageRowSize = Integer.MAX_VALUE;
            } else {
                try {
                    pageRowSize = Integer.parseInt(value);
                }
                catch (Exception ex) {
                    return;
                }
            }
            this.pageable.setPageRowSize((int)var5_7);
        } else if (source == this.currentPage) {
            try {
                String valueText = this.currentPage.getText();
                int value = Integer.parseInt(valueText.trim());
                this.pageable.setCurrentPageIndex(value);
            }
            catch (Exception exception) {}
        } else if (source == this.firstPage) {
            this.pageable.firstPage();
        } else if (source == this.prePage) {
            this.pageable.previousPage();
        } else if (source == this.nextPage) {
            this.pageable.nextPage();
        } else if (source == this.lastPage) {
            this.pageable.lastPage();
        }
    }
}

