/*
 * Decompiled with CFR 0.152.
 */
package twaver.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import twaver.Element;
import twaver.Node;
import twaver.TDataBox;
import twaver.TUIManager;
import twaver.TWaverConst;
import twaver.base.A.D.O;
import twaver.base.A.E.D;
import twaver.base.A.E.a;
import twaver.base.A.E.d;
import twaver.chart.AbstractChart;
import twaver.chart.C;
import twaver.chart.RadarAxis;
import twaver.web.svg.chart.AbstractSVGChart;
import twaver.web.svg.chart.SVGRadarChart;
import twaver.web.svg.network.SVGContext;

public class RadarChart
extends AbstractChart {
    private Font \u0431 = TUIManager.getFont("tchart.radar.axis.text.font");
    private Color \u0442 = TUIManager.getColor("tchart.radar.axis.text.color");
    private Color \u0443 = TUIManager.getColor("tchart.radar.axis.color");
    private String \u044d = TUIManager.getString("tchart.radar.axis.stroke");
    private double \u0430 = TUIManager.getDouble("tchart.radar.axis.start.angle");
    private boolean \u0446 = TUIManager.getBoolean("tchart.radar.axis.text.visible");
    private boolean \u043a = TUIManager.getBoolean("tchart.radar.axis.visible");
    private boolean \u0441 = TUIManager.getBoolean("tchart.radar.axis.inflexion.visible");
    private int \u044a = TUIManager.getInt("tchart.radar.axis.inflexion.style");
    private boolean \u0447 = TUIManager.getBoolean("tchart.radar.axis.text.tooltip.visible");
    private boolean \u0452 = TUIManager.getBoolean("tchart.radar.ring.visible");
    private int \u044c = TUIManager.getInt("tchart.radar.ring.style");
    private Color \u0427 = TUIManager.getColor("tchart.radar.ring.major.color");
    private String \u044f = TUIManager.getString("tchart.radar.ring.major.stroke");
    private boolean \u0448 = TUIManager.getBoolean("tchart.radar.ring.min.visible");
    private Color \u0438 = TUIManager.getColor("tchart.radar.ring.min.color");
    private String \u0433 = TUIManager.getString("tchart.radar.ring.min.stroke");
    private boolean \u043f = TUIManager.getBoolean("tchart.radar.fill");
    private Color \u043d = TUIManager.getColor("tchart.radar.fill.color");
    private boolean \u0449 = TUIManager.getBoolean("tchart.radar.fill.gradient");
    private Color \u044e = TUIManager.getColor("tchart.radar.fill.gradient.color");
    private int \u043b = TUIManager.getInt("tchart.radar.fill.gradient.factory");
    private double \u0440 = TUIManager.getDouble("tchart.radar.scale.max.value");
    private double \u0439 = TUIManager.getDouble("tchart.radar.scale.min.value");
    private boolean \u0434 = TUIManager.getBoolean("tchart.radar.scale.major.text.visible");
    private Font \u0435 = TUIManager.getFont("tchart.radar.scale.major.text.font");
    private Color \u0436 = TUIManager.getColor("tchart.radar.scale.major.text.color");
    private int \u042b = TUIManager.getInt("tchart.radar.scale.major.count");
    private int \u043c = TUIManager.getInt("tchart.radar.scale.min.count");
    private boolean \u0432 = TUIManager.getBoolean("tchart.radar.shape.fill.gradient");
    private Color \u042a = TUIManager.getColor("tchart.radar.shape.fill.gradient.color");
    private int \u044b = TUIManager.getInt("tchart.inflexion.style");
    private boolean \u042d = TUIManager.getBoolean("tchart.radar.inflexion.visible");
    private boolean \u042c = TUIManager.getBoolean("tchart.radar.line.visible");
    private boolean \u0445 = TUIManager.getBoolean("tchart.radar.area.fill");
    private List \u0451 = new ArrayList();
    private Rectangle \u042f;
    private double \u0429;
    private double \u0428;
    private double \u0444 = 0.0;
    private double \u043e = 0.0;
    private int \u0453 = 50;
    private int \u0437 = 128;
    private static double \u042e = Math.PI / 180;

    public RadarChart() {
        this(new TDataBox());
    }

    public RadarChart(TDataBox box) {
        this(box, null, null);
    }

    public RadarChart(TDataBox box, String title, Color backgroundColor) {
        this(box, title, backgroundColor, null);
    }

    public RadarChart(TDataBox box, String title, Color backgroundColor, Color foregroundColor) {
        super(box, title, backgroundColor, foregroundColor);
    }

    public RadarChart(List items) {
        this(items, null);
    }

    public RadarChart(List items, String title) {
        this(items, title, null);
    }

    public RadarChart(List items, String title, Color backgroundColor) {
        super(items, title, backgroundColor);
    }

    protected void calculate() {
    }

    public void paintChart(Graphics2D g2d, int width, int height) {
        g2d.setStroke(TWaverConst.BASIC_STROKE);
        this.backgroundBounds.x = this.xGap;
        this.backgroundBounds.y = this.yGap;
        this.backgroundBounds.width = width - 2 * this.xGap;
        this.backgroundBounds.height = height - 2 * this.yGap;
        this.paintBackground(g2d);
        double widthR = (double)(width - 2 * this.xGap) / 2.0;
        double heightR = (double)(height - 2 * this.yGap) / 2.0;
        double widthMaxR = 0.0;
        double heightMaxR = 0.0;
        if (this.\u0446) {
            int listSize = this.\u0451.size();
            for (int i2 = 0; i2 < listSize; ++i2) {
                Object obj = this.\u0451.get(i2);
                String text = "";
                if (obj instanceof RadarAxis) {
                    RadarAxis axis = (RadarAxis)obj;
                    if (!axis.isAxisTextVisible()) continue;
                    text = axis.getText();
                } else {
                    text = obj.toString();
                }
                Dimension dim = this.B(text, this.\u0431);
                if (dim.getWidth() > widthMaxR) {
                    widthMaxR = dim.getWidth();
                }
                if (!(dim.getHeight() > heightMaxR)) continue;
                heightMaxR = dim.getHeight();
            }
        }
        double r = heightR - heightMaxR > widthR - widthMaxR ? widthR - widthMaxR : heightR - heightMaxR;
        this.\u042f = D.A((double)this.xGap + widthR - r, (double)this.yGap + heightR - r, (double)this.xGap + widthR + r, (double)this.yGap + heightR + r);
        this.\u0429 = this.\u042f.getCenterX();
        this.\u0428 = this.\u042f.getCenterY();
        this.\u0444 = this.\u0440 - this.\u0439;
        if (this.\u0451.size() < 1) {
            return;
        }
        this.A(g2d);
        this.D(g2d);
        this.C(g2d);
        this.B(g2d);
    }

    private void D(Graphics2D g2d) {
        double r = this.\u042f.getWidth() / 2.0;
        int size = this.\u0451.size();
        for (int i2 = 0; i2 < size; ++i2) {
            Rectangle2D.Double labelRectangle;
            Stroke strokeOfAxis = TUIManager.getStrokeByType(this.\u044d);
            g2d.setStroke(strokeOfAxis);
            g2d.setColor(this.\u0443);
            double angle = ((double)i2 * this.\u043e + this.\u0430) * \u042e;
            Point2D.Double point = new Point2D.Double(this.\u0429 + r * Math.cos(angle), this.\u0428 + r * Math.sin(angle));
            String item = "";
            Object obj = this.\u0451.get(i2);
            item = obj instanceof RadarAxis ? ((RadarAxis)obj).getText() : obj.toString();
            if (this.\u043a) {
                Line2D.Double line = new Line2D.Double(new Point2D.Double(this.\u0429, this.\u0428), point);
                g2d.draw(line);
                this.paintAxisInflexion(g2d, strokeOfAxis, this.\u0443, point, i2, item);
            }
            if (!this.\u0446) continue;
            double labelPointX = this.\u0429 + (r + 2.0) * Math.cos(angle);
            double labelPointY = this.\u0428 + (r + 2.0) * Math.sin(angle);
            if (this.\u0447 && (labelRectangle = this.A(1, item, this.\u0442, this.\u0431, labelPointX, labelPointY, this.getAxisTextPosition((double)i2 * this.\u043e + this.\u0430))) != null) {
                this.shapeStructs.add(0, new C(labelRectangle, new Node(), this.getAxisToopTip(i2, item), i2));
            }
            this.A(g2d, item, this.\u0442, this.\u0431, (int)labelPointX, (int)labelPointY, this.getAxisTextPosition((double)i2 * this.\u043e + this.\u0430));
        }
    }

    protected void paintAxisInflexion(Graphics2D g2d, Stroke stroke, Color color, Point2D.Double point, int index, String item) {
        Shape shape;
        if (!this.\u0441) {
            return;
        }
        int w = 2;
        if (stroke instanceof BasicStroke) {
            w = (int)((BasicStroke)stroke).getLineWidth() + 1;
        }
        Rectangle bounds = new Rectangle((int)(point.x - (double)w), (int)(point.y - (double)w), w * 2 + 1, w * 2 + 1);
        if (this.\u044a == 2) {
            if (bounds.width % 2 == 1) {
                ++bounds.width;
            }
            if (bounds.height % 2 == 1) {
                ++bounds.height;
            }
        }
        if ((shape = this.getInflexionShape(this.\u044a, bounds)) != null) {
            this.shapeStructs.add(0, new C(shape, new Node(), this.getAxisToopTip(index, item), index));
            g2d.setColor(color);
            g2d.fill(shape);
        }
    }

    protected int getAxisTextPosition(double angle) {
        angle = (angle % 360.0 + 360.0) % 360.0;
        int position = 1;
        if (angle == 0.0) {
            position = 5;
        }
        if (angle == 180.0) {
            position = 4;
        }
        if (angle == 90.0) {
            position = 3;
        }
        if (angle == 270.0) {
            position = 2;
        }
        if (angle > 270.0 && angle < 360.0) {
            position = 7;
        }
        if (angle > 180.0 && angle < 270.0) {
            position = 6;
        }
        if (angle > 90.0 && angle < 180.0) {
            position = 8;
        }
        if (angle > 0.0 && angle < 90.0) {
            position = 9;
        }
        return position;
    }

    protected int getAxisScaleTextPosition(double angle) {
        angle = (angle % 360.0 + 360.0) % 360.0;
        int position = 1;
        if (angle == 0.0) {
            position = 3;
        }
        if (angle == 180.0) {
            position = 8;
        }
        if (angle == 90.0) {
            position = 5;
        }
        if (angle == 270.0) {
            position = 5;
        }
        if (angle > 270.0 && angle < 360.0) {
            position = 9;
        }
        if (angle > 180.0 && angle < 270.0) {
            position = 8;
        }
        if (angle > 90.0 && angle < 180.0) {
            position = 6;
        }
        if (angle > 0.0 && angle < 90.0) {
            position = 7;
        }
        return position;
    }

    protected String getAxisToopTip(int index, String axisLabel) {
        return axisLabel;
    }

    private void A(Graphics2D g2d) {
        double r = this.\u042f.getWidth() / 2.0;
        double minr = r / (double)this.\u042b;
        if (this.\u043f) {
            Shape shape = null;
            if (this.\u044c == 2) {
                Ellipse2D.Double ellip;
                shape = ellip = new Ellipse2D.Double(this.\u042f.getX(), this.\u042f.getY(), this.\u042f.getWidth(), this.\u042f.getHeight());
            } else if (this.\u044c == 1) {
                GeneralPath path = new GeneralPath();
                int size = this.\u0451.size();
                for (int j2 = 0; j2 < size; ++j2) {
                    double ang = (this.\u043e * (double)j2 + this.\u0430) * \u042e;
                    float pointX = (int)(this.\u0429 + r * Math.cos(ang));
                    float pointY = (int)(this.\u0428 + r * Math.sin(ang));
                    if (j2 == 0) {
                        path.moveTo(pointX, pointY);
                        continue;
                    }
                    path.lineTo(pointX, pointY);
                }
                path.closePath();
                shape = path;
            }
            if (shape != null) {
                g2d.setColor(this.\u043d);
                if (this.\u0449) {
                    O factory = d.E(this.\u043b);
                    Rectangle rec = new Rectangle(this.\u042f.x, this.\u042f.y, this.\u042f.width, this.\u042f.height);
                    Paint paint = factory.A(rec, this.\u044e, this.\u043d);
                    g2d.setPaint(paint);
                }
                g2d.fill(shape);
            }
        }
        if (this.\u042b < 1 || !this.\u0452) {
            return;
        }
        for (int i2 = 0; i2 <= this.\u042b; ++i2) {
            g2d.setStroke(TUIManager.getStrokeByType(this.\u044f));
            g2d.setColor(this.\u0427);
            double length = minr * (double)i2;
            double minLength = minr / (double)(this.\u043c + 1);
            if (this.\u044c == 2) {
                Ellipse2D.Double ring = new Ellipse2D.Double(this.\u0429 - length, this.\u0428 - length, length * 2.0, length * 2.0);
                g2d.draw(ring);
                if (i2 == this.\u042b || !this.\u0448) continue;
                for (int j3 = 1; j3 <= this.\u043c; ++j3) {
                    g2d.setStroke(TUIManager.getStrokeByType(this.\u0433));
                    g2d.setColor(this.\u0438);
                    double dx = this.\u0429 - (length + minLength * (double)j3);
                    double dy = this.\u0428 - (length + minLength * (double)j3);
                    ring = new Ellipse2D.Double(dx, dy, (length + minLength * (double)j3) * 2.0, (length + minLength * (double)j3) * 2.0);
                    g2d.draw(ring);
                }
                continue;
            }
            if (this.\u044c != 1) continue;
            GeneralPath path = new GeneralPath();
            int size = this.\u0451.size();
            for (int j4 = 0; j4 < size; ++j4) {
                double angle = (this.\u043e * (double)j4 + this.\u0430) * \u042e;
                float pointX = (int)(this.\u0429 + length * Math.cos(angle));
                float pointY = (int)(this.\u0428 + length * Math.sin(angle));
                if (j4 == 0) {
                    path.moveTo(pointX, pointY);
                    continue;
                }
                path.lineTo(pointX, pointY);
            }
            path.closePath();
            g2d.draw(path);
            if (i2 == this.\u042b || !this.\u0448) continue;
            g2d.setStroke(TUIManager.getStrokeByType(this.\u0433));
            g2d.setColor(this.\u0438);
            for (int m2 = 1; m2 <= this.\u043c; ++m2) {
                path = new GeneralPath();
                for (int j5 = 0; j5 < size; ++j5) {
                    double ang = (this.\u043e * (double)j5 + this.\u0430) * \u042e;
                    float pointX = (float)(this.\u0429 + (length + (double)m2 * minLength) * Math.cos(ang));
                    float pointY = (float)(this.\u0428 + (length + (double)m2 * minLength) * Math.sin(ang));
                    if (j5 == 0) {
                        path.moveTo(pointX, pointY);
                        continue;
                    }
                    path.lineTo(pointX, pointY);
                }
                path.closePath();
                g2d.draw(path);
            }
        }
    }

    private void C(Graphics2D g2d) {
        if (this.\u042b < 1 || !this.\u0434) {
            return;
        }
        double r = this.\u042f.getWidth() / 2.0;
        int size = this.\u0451.size();
        double minr = r / (double)this.\u042b;
        for (int i2 = 0; i2 < size; ++i2) {
            if (!this.isScaleVisible(i2)) continue;
            Stroke strokeOfAxis = TUIManager.getStrokeByType(this.\u044d);
            g2d.setStroke(strokeOfAxis);
            g2d.setColor(this.\u0443);
            double angle = ((double)i2 * this.\u043e + this.\u0430) * \u042e;
            Object obj = this.\u0451.get(i2);
            int scaleTextposition = this.getAxisScaleTextPosition((double)i2 * this.\u043e + this.\u0430);
            for (int j2 = 1; j2 <= this.\u042b; ++j2) {
                String val = this.getScaleValueText(obj, j2);
                if (val == null) continue;
                int x = (int)(this.\u0429 + minr * (double)j2 * Math.cos(angle));
                int y = (int)(this.\u0428 + minr * (double)j2 * Math.sin(angle));
                this.A(g2d, val, this.\u0436, this.\u0435, x, y, scaleTextposition);
            }
        }
    }

    protected boolean isScaleVisible(int index) {
        return true;
    }

    protected String getScaleValueText(Object obj, int index) {
        RadarAxis raxis;
        double axisMin = 0.0;
        double axisMax = 0.0;
        if (obj instanceof RadarAxis) {
            raxis = (RadarAxis)obj;
            if (!raxis.isAxisTextVisible()) {
                return null;
            }
        } else {
            double avgValue = this.\u0444 / (double)this.\u042b;
            String value = this.getFormat().format(avgValue * (double)index + this.\u0439);
            return value;
        }
        axisMin = raxis.getMinValue();
        axisMax = raxis.getMaxValue();
        double avgValue = axisMax == axisMin ? axisMax : (axisMax - axisMin) / (double)this.\u042b;
        String value = this.getFormat().format(avgValue * (double)index + axisMin);
        return value;
    }

    private void B(Graphics2D g2d) {
        Element element;
        if (this.publishedElements.size() < 1) {
            return;
        }
        Iterator it = this.publishedElements.iterator();
        while (it.hasNext()) {
            element = (Element)it.next();
            if (element.isSelected()) continue;
            this.A(g2d, element);
        }
        it = this.publishedElements.iterator();
        while (it.hasNext()) {
            element = (Element)it.next();
            if (!element.isSelected()) continue;
            this.A(g2d, element);
        }
    }

    private void A(Graphics2D g2d, Element element) {
        List list = this.getValues(element);
        double r = this.\u042f.getWidth() / 2.0;
        GeneralPath path = new GeneralPath();
        int size = this.\u0451.size();
        double fillminr = 0.0;
        Element lastSelectedElement = this.box.getLastSelectedElement();
        int alpha = this.\u0437;
        if (lastSelectedElement != null && !element.isSelected()) {
            alpha = this.\u0453;
        }
        for (int i2 = 0; i2 < size; ++i2) {
            Object axis = this.\u0451.get(i2);
            double axisMinValue = this.\u0439;
            double axisMaxValue = this.\u0440;
            double axisRange = this.\u0444;
            if (axis instanceof RadarAxis) {
                RadarAxis radarAxis = (RadarAxis)axis;
                axisMinValue = radarAxis.getMinValue();
                axisMaxValue = radarAxis.getMaxValue();
                axisRange = Math.abs(axisMaxValue - axisMinValue);
            }
            Point2D.Double point = null;
            Double value = null;
            if (i2 >= list.size()) {
                point = new Point2D.Double(this.\u0429, this.\u0428);
            } else {
                value = (Double)list.get(i2);
                double ang = ((double)i2 * this.\u043e + this.\u0430) * \u042e;
                if (value != null) {
                    double val = value;
                    if (val < axisMinValue) {
                        point = new Point2D.Double(this.\u0429, this.\u0428);
                    } else if (val > axisMaxValue) {
                        point = new Point2D.Double(this.\u0429 + r * Math.cos(ang), this.\u0428 + r * Math.sin(ang));
                    } else {
                        double len = r * (val - axisMinValue) / axisRange;
                        point = new Point2D.Double(this.\u0429 + len * Math.cos(ang), this.\u0428 + len * Math.sin(ang));
                    }
                } else {
                    point = new Point2D.Double(this.\u0429, this.\u0428);
                }
            }
            if (fillminr < Math.abs(point.x - this.\u0429)) {
                fillminr = Math.abs(point.x - this.\u0429);
            }
            if (fillminr < Math.abs(point.y - this.\u0428)) {
                fillminr = Math.abs(point.y - this.\u0428);
            }
            if (this.isInflexionVisible(element)) {
                this.paintInflexion(g2d, element, new Point((int)point.x, (int)point.y), value, i2);
            }
            if (i2 == 0) {
                path.moveTo((float)point.x, (float)point.y);
                continue;
            }
            path.lineTo((float)point.x, (float)point.y);
        }
        path.closePath();
        Shape shape = this.getStroke(element).createStrokedShape(path);
        this.shapeStructs.add(new C(shape, element, null));
        if (element.isSelected()) {
            g2d.setStroke(this.getSelectedStroke(element));
            g2d.setColor(this.getSelectedColor(element));
        } else {
            g2d.setStroke(this.getStroke(element));
            g2d.setColor(this.getColor(element));
        }
        Color color = g2d.getColor();
        Color alphaColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
        if (this.isLineVisible(element)) {
            g2d.draw(shape);
        }
        g2d.setColor(alphaColor);
        if (this.isAreaFill(element)) {
            try {
                Area ar = new Area(path);
                if (this.\u0432) {
                    O factory = d.E(10);
                    int startx = (int)(this.\u0429 - fillminr);
                    int starty = (int)(this.\u0428 - fillminr);
                    Rectangle rec = new Rectangle(startx, starty, (int)(fillminr * 2.0), (int)(fillminr * 2.0));
                    Color alcolor = new Color(this.\u042a.getRed(), this.\u042a.getGreen(), this.\u042a.getBlue(), alpha);
                    Paint paint = factory.A(rec, alcolor, alphaColor);
                    g2d.setPaint(paint);
                }
                g2d.fill(ar);
                g2d.setColor(color);
                this.shapeStructs.add(0, new C(ar, element, null));
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        if (this.isLineVisible(element)) {
            g2d.setColor(this.getColor(element));
            g2d.setStroke(this.getStroke(element));
            g2d.fill(shape);
        }
    }

    protected boolean isInflexionVisible(Element element) {
        return this.\u042d;
    }

    protected boolean isLineVisible(Element element) {
        return this.\u042c;
    }

    protected boolean isAreaFill(Element element) {
        return this.\u0445;
    }

    public String getToolTipText(Element element, Double value, int index) {
        if (!this.isEnableToolTipText()) {
            return null;
        }
        if (index >= this.\u0451.size() || index >= this.getValues(element).size()) {
            return null;
        }
        String text = this.getToolTipText(element);
        Object scaleText = this.\u0451.get(index);
        if (scaleText != null) {
            text = text == null ? scaleText.toString() : (scaleText instanceof RadarAxis ? text + "<br>" + ((RadarAxis)scaleText).getText() : text + "<br>" + scaleText);
        }
        String valueText = "null";
        if (value != null) {
            valueText = this.getFormatedText(element, value, index);
        }
        if ((text = text == null ? valueText : text + "<br>" + valueText) != null) {
            if (text.indexOf("<html>") >= 0) {
                text = text.replaceAll("<html>", "");
                text = text.replaceAll("</html>", "");
            }
            text = "<html>" + text + "</html>";
        }
        return text;
    }

    protected void paintInflexion(Graphics2D g2d, Element element, Point point, Double value, int i2) {
        Rectangle bounds;
        int inflexionStyle = this.getInflexionStyle(element);
        Shape shape = this.getInflexionShape(inflexionStyle, bounds = this.getInflexionBounds(element, point));
        if (shape != null) {
            this.shapeStructs.add(0, new C(bounds, element, this.getToolTipText(element, value, i2), i2));
            Color color = this.getColor(element);
            if (element.isSelected()) {
                color = this.getSelectedColor(element);
            }
            g2d.setColor(color);
            g2d.fill(shape);
        }
    }

    protected Shape getInflexionShape(int inflexionStyle, Rectangle bounds) {
        Shape shape = null;
        if (inflexionStyle == 1) {
            int x = bounds.x;
            int y = bounds.y;
            int width = bounds.width;
            int height = bounds.height;
            shape = new Area(new Ellipse2D.Float(x, y, width, height));
        } else if (inflexionStyle == 2) {
            --bounds.x;
            --bounds.y;
            GeneralPath path = new GeneralPath();
            path.moveTo(bounds.x + bounds.width / 2, bounds.y);
            path.lineTo(bounds.x, bounds.y + bounds.height / 2);
            path.lineTo(bounds.x + bounds.width / 2, bounds.y + bounds.height);
            path.lineTo(bounds.x + bounds.width, bounds.y + bounds.height / 2);
            path.closePath();
            shape = new Area(path);
        } else if (inflexionStyle == 3) {
            shape = bounds;
        } else if (inflexionStyle == 4) {
            --bounds.x;
            --bounds.y;
            GeneralPath path = new GeneralPath();
            path.moveTo(bounds.x + bounds.width / 2, bounds.y);
            path.lineTo(bounds.x, bounds.y + bounds.height);
            path.lineTo(bounds.x + bounds.width, bounds.y + bounds.height);
            path.closePath();
            shape = new Area(path);
        }
        return shape;
    }

    public int getInflexionStyle(Element element) {
        Object value = element.getClientProperty("chart.inflexion.style");
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return this.\u044b;
    }

    protected Rectangle getInflexionBounds(Element element, Point point) {
        Dimension inflexionSize = this.getInflexionSize(element, point);
        int w = inflexionSize.width;
        int h2 = inflexionSize.height;
        Rectangle bounds = new Rectangle(point.x - w, point.y - h2, w * 2 + 1, h2 * 2 + 1);
        if (this.getInflexionStyle(element) == 2) {
            if (bounds.width % 2 == 1) {
                ++bounds.width;
            }
            if (bounds.height % 2 == 1) {
                ++bounds.height;
            }
        }
        return bounds;
    }

    protected Dimension getInflexionSize(Element element, Point point) {
        Stroke stroke = this.getStroke(element);
        int w = 3;
        if (stroke instanceof BasicStroke) {
            w = (int)((BasicStroke)stroke).getLineWidth() + 2;
        }
        return new Dimension(w, w);
    }

    public void addAxisText(Object itemText) {
        if (this.\u0451.contains(itemText)) {
            return;
        }
        this.\u0451.add(itemText);
        this.\u043e = this.\u0451.size() > 0 ? 360.0 / (double)this.\u0451.size() : 360.0;
        this.chartPane.repaint();
    }

    public void addAxis(Object radarAxis) {
        if (this.\u0451.contains(radarAxis)) {
            return;
        }
        this.\u0451.add(radarAxis);
        this.\u043e = this.\u0451.size() > 0 ? 360.0 / (double)this.\u0451.size() : 360.0;
        this.chartPane.repaint();
    }

    public void removeAxisText(Object itemText) {
        if (!this.\u0451.contains(itemText)) {
            return;
        }
        this.\u0451.remove(itemText);
        this.\u043e = this.\u0451.size() > 0 ? 360.0 / (double)this.\u0451.size() : 360.0;
        this.chartPane.repaint();
    }

    public void removeAxisText(int itemIndex) {
        if (itemIndex < 0 || itemIndex >= this.\u0451.size()) {
            return;
        }
        this.\u0451.remove(itemIndex);
        this.\u043e = this.\u0451.size() > 0 ? 360.0 / (double)this.\u0451.size() : 360.0;
        this.chartPane.repaint();
    }

    public Font getAxisTextFont() {
        return this.\u0431;
    }

    public void setAxisTextFont(Font axisTextFont) {
        this.\u0431 = axisTextFont;
        this.chartPane.repaint();
    }

    public Color getAxisTextColor() {
        return this.\u0442;
    }

    public void setAxisTextColor(Color axisTextColor) {
        this.\u0442 = axisTextColor;
        this.chartPane.repaint();
    }

    public Color getAxisColor() {
        return this.\u0443;
    }

    public void setAxisColor(Color axisColor) {
        this.\u0443 = axisColor;
        this.chartPane.repaint();
    }

    public String getAxisStroke() {
        return this.\u044d;
    }

    public void setAxisStroke(String axisStroke) {
        this.\u044d = axisStroke;
        this.chartPane.repaint();
    }

    public double getAxisStartAngle() {
        return this.\u0430;
    }

    public void setAxisStartAngle(double axisStartAngle) {
        this.\u0430 = axisStartAngle;
        this.chartPane.repaint();
    }

    public int getRingStyle() {
        return this.\u044c;
    }

    public void setRingStyle(int ringStyle) {
        this.\u044c = ringStyle;
        this.chartPane.repaint();
    }

    public Color getRingMajorColor() {
        return this.\u0427;
    }

    public void setRingMajorColor(Color ringMajorColor) {
        this.\u0427 = ringMajorColor;
        this.chartPane.repaint();
    }

    public String getRingMajorStroke() {
        return this.\u044f;
    }

    public void setRingMajorStroke(String ringMajorStroke) {
        this.\u044f = ringMajorStroke;
        this.chartPane.repaint();
    }

    public boolean isRingMinVisible() {
        return this.\u0448;
    }

    public void setRingMinVisible(boolean ringMinVisible) {
        this.\u0448 = ringMinVisible;
        this.chartPane.repaint();
    }

    public Color getRingMinColor() {
        return this.\u0438;
    }

    public void setRingMinColor(Color ringMinColor) {
        this.\u0438 = ringMinColor;
        this.chartPane.repaint();
    }

    public String getRingMinStroke() {
        return this.\u0433;
    }

    public void setRingMinStroke(String ringMinStroke) {
        this.\u0433 = ringMinStroke;
        this.chartPane.repaint();
    }

    public double getScaleMaxValue() {
        return this.\u0440;
    }

    public void setScaleMaxValue(double scaleMaxValue) {
        this.\u0440 = scaleMaxValue;
        this.chartPane.repaint();
    }

    public double getScaleMinValue() {
        return this.\u0439;
    }

    public void setScaleMinValue(double scaleMinValue) {
        this.\u0439 = scaleMinValue;
        this.chartPane.repaint();
    }

    public boolean isScaleMajorTextVisible() {
        return this.\u0434;
    }

    public void setScaleMajorTextVisible(boolean scaleMajorTextVisible) {
        this.\u0434 = scaleMajorTextVisible;
        this.chartPane.repaint();
    }

    public Font getScaleMajorTextFont() {
        return this.\u0435;
    }

    public void setScaleMajorTextFont(Font scaleMajorTextFont) {
        this.\u0435 = scaleMajorTextFont;
        this.chartPane.repaint();
    }

    public Color getScaleMajorTextColor() {
        return this.\u0436;
    }

    public void setScaleMajorTextColor(Color scaleMajorTextColor) {
        this.\u0436 = scaleMajorTextColor;
        this.chartPane.repaint();
    }

    public int getScaleMajorCount() {
        return this.\u042b;
    }

    public void setScaleMajorCount(int scaleMajorCount) {
        this.\u042b = scaleMajorCount < 0 ? 0 : scaleMajorCount;
        this.chartPane.repaint();
    }

    public int getScaleMinCount() {
        return this.\u043c;
    }

    public void setScaleMinCount(int scaleMinCount) {
        this.\u043c = scaleMinCount < 0 ? 0 : scaleMinCount;
        this.chartPane.repaint();
    }

    public boolean isShapeFill() {
        return this.\u0445;
    }

    public void setShapeFill(boolean shapeFill) {
        this.\u0445 = shapeFill;
        this.chartPane.repaint();
    }

    public List getAxisList() {
        return this.\u0451;
    }

    public Rectangle getDrawBound() {
        return this.\u042f;
    }

    public boolean isRingVisible() {
        return this.\u0452;
    }

    public void setRingVisible(boolean ringVisible) {
        this.\u0452 = ringVisible;
        this.chartPane.repaint();
    }

    public boolean isAxisTextVisible() {
        return this.\u0446;
    }

    public void setAxisTextVisible(boolean axisTextVisible) {
        this.\u0446 = axisTextVisible;
        this.chartPane.repaint();
    }

    public boolean isAxisVisible() {
        return this.\u043a;
    }

    public void setAxisVisible(boolean axisVisible) {
        this.\u043a = axisVisible;
        this.chartPane.repaint();
    }

    public boolean isRadarFill() {
        return this.\u043f;
    }

    public void setRadarFill(boolean radarFill) {
        this.\u043f = radarFill;
        this.chartPane.repaint();
    }

    public Color getRadarFillColor() {
        return this.\u043d;
    }

    public void setRadarFillColor(Color radarFillColor) {
        this.\u043d = radarFillColor;
        this.chartPane.repaint();
    }

    public boolean isRadarFillGradient() {
        return this.\u0449;
    }

    public void setRadarFillGradient(boolean radarFillGradient) {
        this.\u0449 = radarFillGradient;
        this.chartPane.repaint();
    }

    public Color getRadarFillGradientColor() {
        return this.\u044e;
    }

    public void setRadarFillGradientColor(Color radarFillGradientColor) {
        this.\u044e = radarFillGradientColor;
        this.chartPane.repaint();
    }

    public int getRadarFillGradientFactory() {
        return this.\u043b;
    }

    public void setRadarFillGradientFactory(int radarFillGradientFactory) {
        this.\u043b = radarFillGradientFactory;
        this.chartPane.repaint();
    }

    public boolean isShapeFillGradient() {
        return this.\u0432;
    }

    public void setShapeFillGradient(boolean shapeFillGradient) {
        this.\u0432 = shapeFillGradient;
        this.chartPane.repaint();
    }

    public Color getShapeFillGradientColor() {
        return this.\u042a;
    }

    public void setShapeFillGradientColor(Color shapeFillGradientColor) {
        this.\u042a = shapeFillGradientColor;
        this.chartPane.repaint();
    }

    public int getAxisInflexionStyle() {
        return this.\u044a;
    }

    public void setAxisInflexionStyle(int axisInflexionStyle) {
        this.\u044a = axisInflexionStyle;
        this.chartPane.repaint();
    }

    public boolean isAxisInflexionVisible() {
        return this.\u0441;
    }

    public void setAxisInflexionVisible(boolean axisInflexionVisible) {
        this.\u0441 = axisInflexionVisible;
        this.chartPane.repaint();
    }

    public boolean isAxisTextTooltipVisible() {
        return this.\u0447;
    }

    public void setAxisTextTooltipVisible(boolean axisTextTooltipVisible) {
        this.\u0447 = axisTextTooltipVisible;
        this.chartPane.repaint();
    }

    public boolean isInflexionVisible() {
        return this.\u042d;
    }

    public void setInflexionVisible(boolean inflexionVisible) {
        this.\u042d = inflexionVisible;
        this.chartPane.repaint();
    }

    public boolean isLineVisible() {
        return this.\u042c;
    }

    public void setLineVisible(boolean lineVisible) {
        this.\u042c = lineVisible;
        this.chartPane.repaint();
    }

    public boolean isAreaFill() {
        return this.\u0445;
    }

    public void setAreaFill(boolean areaFill) {
        this.\u0445 = areaFill;
        this.chartPane.repaint();
    }

    public int getInflexionStyle() {
        return this.\u044b;
    }

    public void setInflexionStyle(int inflexionStyle) {
        this.\u044b = inflexionStyle;
        this.chartPane.repaint();
    }

    protected void setChartSVGAttribute(AbstractSVGChart absChart) {
        super.setChartSVGAttribute(absChart);
        SVGRadarChart chart = (SVGRadarChart)absChart;
        chart.setAreaFill(this.isAreaFill());
        chart.setAxisColor(this.getAxisColor());
        chart.setAxisInflexionStyle(this.getAxisInflexionStyle());
        chart.setAxisInflexionVisible(this.isAxisInflexionVisible());
        chart.setAxisStartAngle(this.getAxisStartAngle());
        chart.setAxisTextColor(this.getAxisTextColor());
        chart.setAxisTextFont(this.getAxisTextFont());
        chart.setAxisTextVisible(this.isAxisTextVisible());
        chart.setAxisVisible(this.isAxisVisible());
        chart.setInflexionVisible(this.isInflexionVisible());
        chart.setInflexionStyle(this.getInflexionStyle());
        chart.setLineVisible(this.isLineVisible());
        chart.setRadarFill(this.isRadarFill());
        chart.setRadarFillColor(this.getRadarFillColor());
        chart.setRadarFillGradient(this.isRadarFillGradient());
        chart.setRadarFillGradientColor(this.getRadarFillGradientColor());
        chart.setRadarFillGradientFactory(this.getRadarFillGradientFactory());
        chart.setRingMajorColor(this.getRingMajorColor());
        chart.setRingMajorStroke(this.getRingMajorStroke());
        chart.setRingMinColor(this.getRingMinColor());
        chart.setRingMinStroke(this.getRingMinStroke());
        chart.setRingMinVisible(this.isRingMinVisible());
        chart.setRingStyle(this.getRingStyle());
        chart.setRingVisible(this.isRingVisible());
        chart.setScaleMajorCount(this.getScaleMajorCount());
        chart.setScaleMajorTextColor(this.getScaleMajorTextColor());
        chart.setScaleMajorTextFont(this.getScaleMajorTextFont());
        chart.setScaleMajorTextVisible(this.isScaleMajorTextVisible());
        chart.setScaleMaxValue(this.getScaleMaxValue());
        chart.setScaleMinCount(this.getScaleMinCount());
        chart.setScaleMinValue(this.getScaleMinValue());
        chart.setShapeFillGradient(this.isShapeFillGradient());
        chart.setShapeFillGradientColor(this.getShapeFillGradientColor());
        int size = this.\u0451.size();
        for (int i2 = 0; i2 < size; ++i2) {
            chart.addAxis(this.\u0451.get(i2));
        }
        super.setChartSVGAttribute(chart);
    }

    public void exportSVG(String fileName, int width, int height) {
        if (fileName == null) {
            return;
        }
        if (!fileName.toLowerCase().endsWith(".svg")) {
            fileName = fileName + ".svg";
        }
        SVGRadarChart chart = new SVGRadarChart();
        this.setChartSVGAttribute(chart);
        SVGContext context = new SVGContext();
        a.A(fileName, chart.toSVG(context, width, height));
    }
}

