/*
 * Decompiled with CFR 0.152.
 */
package twaver;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import twaver.Node;
import twaver.base.A.E.W;

public class RotatableNode
extends Node {
    private double Z = 0.0;
    private int W = 0;
    private int V = 0;
    private double Y = 1.0;
    private Shape X = null;

    public RotatableNode() {
        this.M();
    }

    public RotatableNode(Object id) {
        super(id);
        this.M();
    }

    private void M() {
        this.W = twaver.base.A.E.W.H(this);
        this.V = twaver.base.A.E.W.A(this);
        this.L();
    }

    public String getUIClassID() {
        return "RotatableNodeUI";
    }

    public double getAngle() {
        return this.Z;
    }

    public void setAngle(double angle) {
        if (this.Z == angle) {
            return;
        }
        Double oldValue = new Double(this.Z);
        this.Z = angle;
        this.firePropertyChange("angle", oldValue, new Double(this.Z));
        this.L();
    }

    public double getZoom() {
        return this.Y;
    }

    public void setZoom(double zoom) {
        if (this.Y == zoom) {
            return;
        }
        Double oldValue = new Double(this.Y);
        this.Y = zoom;
        this.firePropertyChange("zoom", oldValue, new Double(this.Y));
        this.L();
    }

    public int getWidth() {
        return this.W;
    }

    public int getHeight() {
        return this.V;
    }

    public void setImage(String url) {
        if (url == null || url.trim().equals("")) {
            url = null;
        }
        String oldUrl = this.imageUrl;
        this.imageUrl = url;
        this.firePropertyChange("image", oldUrl, this.imageUrl);
        this.L();
    }

    private void L() {
        int oldWidth = this.W;
        int oldHeight = this.V;
        Point centerLocation = this.getCenterLocation();
        int w = twaver.base.A.E.W.H(this);
        int h2 = twaver.base.A.E.W.A(this);
        AffineTransform at = new AffineTransform();
        at.setTransform(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
        at.rotate(Math.toRadians(this.Z));
        this.X = at.createTransformedShape(new Rectangle2D.Double((double)(-w / 2) * this.Y, (double)(-h2 / 2) * this.Y, (double)w * this.Y, (double)h2 * this.Y));
        Rectangle rect = this.X.getBounds();
        this.V = rect.height;
        this.W = rect.width;
        this.firePropertyChange("width", oldWidth, this.W);
        this.firePropertyChange("height", oldHeight, this.V);
        this.setCenterLocation(centerLocation);
    }

    public Shape getRotatableShape() {
        Point centerLocation = this.getCenterLocation();
        AffineTransform at = new AffineTransform();
        at.translate(centerLocation.getX(), centerLocation.getY());
        return at.createTransformedShape(this.X);
    }
}

