/*
 * Decompiled with CFR 0.152.
 */
package twaver;

import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import twaver.BaseEquipment;
import twaver.FloatInsets;
import twaver.Node;
import twaver.Slot;
import twaver.TWaverUtil;
import twaver.base.A.E.E;
import twaver.base.A.E.b;
import twaver.base.Direction;

public class Card
extends BaseEquipment {
    private int x = 0;
    private int w = 0;

    public Card() {
        this.S();
    }

    public Card(Object id) {
        super(id);
        this.S();
    }

    public String getUIClassID() {
        return "CardUI";
    }

    public String getSVGUIClassID() {
        return "CardSVGUI";
    }

    public boolean isAdjustToBottom() {
        return E.A(this);
    }

    protected void hostPropertyChange(PropertyChangeEvent evt) {
        if (b.C(evt.getPropertyName())) {
            this.adjustBounds();
        }
    }

    private void S() {
        this.setSize(30, 100);
        this.getClientProperties().put("border.insets", TWaverUtil.valueOf(-2));
        this.getClientProperties().put("label.highlightable", Boolean.FALSE);
        this.getClientProperties().put("label.position", TWaverUtil.valueOf(1));
        this.getClientProperties().put("label.orientation", TWaverUtil.valueOf(3));
    }

    public void adjustBounds() {
        Node host = this.getHost();
        if (host instanceof Slot) {
            Rectangle bounds;
            Slot slot = (Slot)host;
            Rectangle b1 = slot.getEquipBoundsByIndex(this.x);
            Rectangle b2 = slot.getEquipBoundsByIndex(this.x + this.w);
            if (b1 != null && b2 != null) {
                b1.add(b2);
                bounds = b1;
            } else {
                bounds = slot.getEquipBoundsByIndex(0);
            }
            if (bounds != null) {
                Insets insets;
                FloatInsets floatInsets = this.getCardExtendPercent();
                if (floatInsets != null) {
                    float extend;
                    Rectangle b0 = slot.getEquipBoundsByIndex(0);
                    if (floatInsets.top != 0.0f) {
                        extend = (float)b0.height * floatInsets.top;
                        bounds.y = (int)((float)bounds.y - extend);
                        bounds.height = (int)((float)bounds.height + extend);
                    }
                    if (floatInsets.bottom != 0.0f) {
                        extend = (float)b0.height * floatInsets.bottom;
                        bounds.height = (int)((float)bounds.height + extend);
                    }
                    if (floatInsets.left != 0.0f) {
                        extend = (float)b0.width * floatInsets.left;
                        bounds.x = (int)((float)bounds.x - extend);
                        bounds.width = (int)((float)bounds.width + extend);
                    }
                    if (floatInsets.right != 0.0f) {
                        extend = (float)b0.width * floatInsets.right;
                        bounds.width = (int)((float)bounds.width + extend);
                    }
                }
                if ((insets = this.getCardExtendPixel()) != null) {
                    if (insets.top != 0) {
                        bounds.y -= insets.top;
                        bounds.height += insets.top;
                    }
                    if (insets.bottom != 0) {
                        bounds.height += insets.bottom;
                    }
                    if (insets.left != 0) {
                        bounds.x -= insets.left;
                        bounds.width += insets.left;
                    }
                    if (insets.right != 0) {
                        bounds.width += insets.right;
                    }
                }
                this.setLocation(bounds.x, bounds.y);
                this.setSize(bounds.width, bounds.height);
            }
        }
    }

    public void putClientProperty(Object key, Object value) {
        if ("label.direction".equals(key)) {
            this.putLabelPosition(1);
            if (Direction.VERTICAL.equals(value)) {
                this.putLabelOrientation(3);
            } else {
                this.putLabelOrientation(1);
            }
        }
        super.putClientProperty(key, value);
        if (key.toString().startsWith("card.extend.")) {
            this.adjustBounds();
        }
    }

    public void putLabelDirection(Direction direction) {
        this.putClientProperty((Object)"label.direction", direction);
    }

    public void putCardBoltTop(boolean cardBoltTop) {
        this.putClientProperty((Object)"card.bolt.top", cardBoltTop);
    }

    public void putCardBoltBottom(boolean cardBoltBottom) {
        this.putClientProperty((Object)"card.bolt.bottom", cardBoltBottom);
    }

    public void putCardBoltLeft(boolean cardBoltLeft) {
        this.putClientProperty((Object)"card.bolt.left", cardBoltLeft);
    }

    public void putCardBoltRight(boolean cardBoltRight) {
        this.putClientProperty((Object)"card.bolt.right", cardBoltRight);
    }

    public void putCardExtendPixel(Insets cardExtendPixel) {
        this.putClientProperty((Object)"card.extend.pixel", cardExtendPixel);
    }

    public void putCardExtendPercent(FloatInsets cardExtendPercent) {
        this.putClientProperty((Object)"card.extend.percent", cardExtendPercent);
    }

    public boolean isCardBoltTop() {
        return b.K(this, "card.bolt.top");
    }

    public boolean isCardBoltBottom() {
        return b.K(this, "card.bolt.bottom");
    }

    public boolean isCardBoltLeft() {
        return b.K(this, "card.bolt.left");
    }

    public boolean isCardBoltRight() {
        return b.K(this, "card.bolt.right");
    }

    public Insets getCardExtendPixel() {
        return b.B(this, "card.extend.pixel");
    }

    public FloatInsets getCardExtendPercent() {
        return b.N(this, "card.extend.percent");
    }

    public int getSpanCount() {
        return this.w;
    }

    public void setSpanCount(int spanCount) {
        if (this.w != spanCount) {
            int oldValue = this.w;
            this.w = spanCount;
            this.firePropertyChange("spanCount", oldValue, this.w);
            this.adjustBounds();
        }
    }

    public int getStartIndex() {
        return this.x;
    }

    public void setStartIndex(int startIndex) {
        if (this.x != startIndex) {
            int oldValue = this.x;
            this.x = startIndex;
            this.firePropertyChange("startIndex", oldValue, this.x);
            this.adjustBounds();
        }
    }
}

