/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.splitpane;

import com.jidesoft.swing.JideSplitPane;
import com.nepxion.swing.listener.DisplayAbilityListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.HierarchyEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class JBasicSplitPane
extends JideSplitPane {
    public static final String FIX = "fix";
    public static final String FLEXIBLE = "flexible";
    public static final String VARY = "vary";
    private Map dividerLocations;

    public JBasicSplitPane() {
        this.initComponents();
    }

    public JBasicSplitPane(int newOrientation) {
        super(newOrientation);
        this.initComponents();
    }

    private void initComponents() {
        this.dividerLocations = new HashMap();
        this.setDividerSize(5);
        this.addHierarchyListener(new DisplayAbilityListener(){

            @Override
            public void displayAbilityChanged(HierarchyEvent e) {
                JBasicSplitPane.this.adaptDividerLocation();
                JBasicSplitPane.this.removeHierarchyListener(this);
            }
        });
    }

    private void adaptDividerLocation() {
        if (this.dividerLocations != null) {
            for (Object key : this.dividerLocations.keySet()) {
                int index = (Integer)key;
                int location = (Integer)this.dividerLocations.get(key);
                JBasicSplitPane.super.setDividerLocation(index, location);
                this.setPaneSize(index, location);
            }
            this.dividerLocations = null;
        }
    }

    public void setDividerLocation(int index, int location) {
        if (this.dividerLocations == null) {
            super.setDividerLocation(index, location);
        } else {
            this.dividerLocations.put(new Integer(index), new Integer(location));
        }
    }

    private void setPaneSize(int index, int size) {
        Component pane = this.getPaneAt(index);
        if (pane != null && pane instanceof JComponent) {
            int width = 0;
            int height = 0;
            if (this.getOrientation() == 0) {
                width = this.getPreferredSize().width;
                height = size;
            } else if (this.getOrientation() == 1) {
                width = size;
                height = this.getPreferredSize().height;
            }
            JComponent component = (JComponent)pane;
            Dimension dimension = new Dimension(width, height);
            component.setPreferredSize(dimension);
        }
    }

    public void updateUI() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JBasicSplitPane.super.updateUI();
            }
        });
    }
}

