/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.panel.decoration;

import com.nepxion.swing.panel.JGradientPanel;
import com.nepxion.swing.style.framework.IStyle;
import com.nepxion.swing.style.framework.StyleManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.SwingConstants;

public class JDecorationHeader
extends JGradientPanel
implements SwingConstants {
    private JLabel label;
    private boolean selected;
    private IStyle style;

    public JDecorationHeader() {
        this((String)null, null);
    }

    public JDecorationHeader(String title, String toolTipText) {
        this(title, null, toolTipText, true, StyleManager.getStyle());
    }

    public JDecorationHeader(String title, String toolTipText, boolean selected) {
        this(title, null, toolTipText, selected, StyleManager.getStyle());
    }

    public JDecorationHeader(String title, String toolTipText, IStyle style) {
        this(title, null, toolTipText, true, style);
    }

    public JDecorationHeader(String title, String toolTipText, boolean selected, IStyle style) {
        this(title, null, toolTipText, selected, style);
    }

    public JDecorationHeader(Icon icon, String toolTipText) {
        this(null, icon, toolTipText, true, StyleManager.getStyle());
    }

    public JDecorationHeader(Icon icon, String toolTipText, boolean selected) {
        this(null, icon, toolTipText, selected, StyleManager.getStyle());
    }

    public JDecorationHeader(Icon icon, String toolTipText, IStyle style) {
        this(null, icon, toolTipText, true, style);
    }

    public JDecorationHeader(Icon icon, String toolTipText, boolean selected, IStyle style) {
        this(null, icon, toolTipText, selected, style);
    }

    public JDecorationHeader(String title, Icon icon, String toolTipText) {
        this(title, icon, toolTipText, true, StyleManager.getStyle());
    }

    public JDecorationHeader(String title, Icon icon, String toolTipText, boolean selected) {
        this(title, icon, toolTipText, selected, StyleManager.getStyle());
    }

    public JDecorationHeader(String title, Icon icon, String toolTipText, IStyle style) {
        this(title, icon, toolTipText, true, style);
    }

    public JDecorationHeader(String title, Icon icon, String toolTipText, boolean selected, IStyle style) {
        super(new BorderLayout(), null, null);
        this.style = style;
        this.selected = selected;
        this.label = new JLabel(title, icon, 10);
        this.label.setToolTipText(toolTipText);
        if (style.getTitleBorder() != null) {
            this.setBorder(style.getTitleBorder());
        }
        this.add((Component)this.label, "West");
        this.updateHeader();
    }

    private void updateHeader() {
        this.label.setForeground(this.getTextForeground(this.selected));
        this.setGradientColor(this.getHeaderGradientColor(this.selected));
        this.setBackground(this.getHeaderBackground(this.selected));
    }

    public JLabel getLabel() {
        return this.label;
    }

    public String getTitle() {
        return this.label.getText();
    }

    public void setTitle(String newText) {
        String oldText = this.getTitle();
        this.label.setText(newText);
        this.firePropertyChange("title", oldText, newText);
    }

    public Icon getIcon() {
        return this.label.getIcon();
    }

    public void setIcon(Icon newIcon) {
        Icon oldIcon = this.getIcon();
        this.label.setIcon(newIcon);
        this.firePropertyChange("icon", oldIcon, newIcon);
    }

    @Override
    public String getToolTipText() {
        return this.label.getToolTipText();
    }

    @Override
    public void setToolTipText(String newToolTipText) {
        String oldToolTipText = this.getToolTipText();
        this.label.setToolTipText(newToolTipText);
        this.firePropertyChange("toolTipText", oldToolTipText, newToolTipText);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean newValue) {
        boolean oldValue = this.isSelected();
        this.selected = newValue;
        this.updateHeader();
        this.firePropertyChange("selected", oldValue, newValue);
    }

    public Color getTextForeground(boolean selected) {
        if (selected) {
            return this.style.getSelectionForeground();
        }
        return this.style.getForeground();
    }

    public Color getHeaderBackground(boolean selected) {
        if (selected) {
            return this.style.getSelectionBackground();
        }
        return this.style.getBackground();
    }

    public Color getHeaderGradientColor(boolean selected) {
        if (selected) {
            return this.style.getSelectionGradientColor();
        }
        return this.style.getGradientColor();
    }
}

