/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.chart.bar;

import com.nepxion.swing.chart.bar.CylinderBarRenderer3D;
import com.nepxion.swing.chart.bar.RectangleBarChartFactory;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryAxis3D;
import org.jfree.chart.axis.NumberAxis3D;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.chart.urls.StandardCategoryURLGenerator;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.GradientPaintTransformType;
import org.jfree.ui.GradientPaintTransformer;
import org.jfree.ui.StandardGradientPaintTransformer;
import org.jfree.ui.TextAnchor;

public class CylinderBarChartFactory
extends RectangleBarChartFactory {
    public static CategoryPlot createCategoryPlot3D(CategoryDataset categoryDataset, PlotOrientation orientation, String categoryAxisLabel, String valueAxisLabel, String toolTipText, String legendToolTipText, boolean isCategoryLabelRotated) {
        CategoryPlot categoryPlot = CylinderBarChartFactory.createCategoryPlot3D(categoryDataset, orientation, categoryAxisLabel, valueAxisLabel, true, true, false);
        CylinderBarChartFactory.setCategoryPlotPreference(categoryPlot, orientation, toolTipText, legendToolTipText, isCategoryLabelRotated, 0.75f);
        return categoryPlot;
    }

    public static CategoryPlot createCategoryPlot3D(CategoryDataset categoryDataset, PlotOrientation orientation, String categoryAxisLabel, String valueAxisLabel, boolean labels, boolean tooltips, boolean urls) {
        if (orientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        CategoryAxis3D categoryAxis = new CategoryAxis3D(categoryAxisLabel);
        NumberAxis3D valueAxis = new NumberAxis3D(valueAxisLabel);
        CylinderBarRenderer3D cylinderBarRenderer3D = new CylinderBarRenderer3D();
        if (orientation == PlotOrientation.HORIZONTAL) {
            cylinderBarRenderer3D.setBasePositiveItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.OUTSIDE3, TextAnchor.CENTER));
            cylinderBarRenderer3D.setBaseNegativeItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.OUTSIDE9, TextAnchor.CENTER_LEFT));
            cylinderBarRenderer3D.setItemLabelAnchorOffset(20.0);
        } else if (orientation == PlotOrientation.VERTICAL) {
            cylinderBarRenderer3D.setBasePositiveItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BOTTOM_CENTER));
            cylinderBarRenderer3D.setBaseNegativeItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.OUTSIDE6, TextAnchor.TOP_CENTER));
            cylinderBarRenderer3D.setItemLabelAnchorOffset(5.0);
        }
        if (labels) {
            cylinderBarRenderer3D.setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator());
        }
        if (tooltips) {
            cylinderBarRenderer3D.setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        }
        if (urls) {
            cylinderBarRenderer3D.setBaseItemURLGenerator((CategoryURLGenerator)new StandardCategoryURLGenerator());
        }
        cylinderBarRenderer3D.setGradientPaintTransformer((GradientPaintTransformer)new StandardGradientPaintTransformer(orientation == PlotOrientation.VERTICAL ? GradientPaintTransformType.CENTER_HORIZONTAL : GradientPaintTransformType.CENTER_VERTICAL));
        CategoryPlot categoryPlot = new CategoryPlot(categoryDataset, (CategoryAxis)categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)cylinderBarRenderer3D);
        categoryPlot.setOrientation(orientation);
        return categoryPlot;
    }
}

