/*
 * Decompiled with CFR 0.152.
 */
package twaver.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import twaver.AlarmSeverity;
import twaver.AlarmSeverityChangeListener;
import twaver.TDataBox;
import twaver.TView;
import twaver.TWaverConst;
import twaver.VisibleFilter;
import twaver.base.A.E.C;
import twaver.chart.BarChart;
import twaver.chart.Item;
import twaver.chart.PieChart;
import twaver.table.TAlarmStatTable;

public class TAlarmOverview
extends JPanel
implements TView {
    public static final int TABLE_PANEL = 0;
    public static final int BAR_PANEL = 1;
    public static final int PIE_PANEL = 2;
    private JToolBar \u056c = new JToolBar();
    private ButtonGroup \u056e = new ButtonGroup();
    private JToggleButton \u056d;
    private JToggleButton \u0569;
    private JToggleButton \u0571;
    private JPanel \u0570;
    private TAlarmStatTable \u056f;
    private BarChart \u056a;
    private PieChart \u0566;
    private JComponent \u0567;
    private List \u056b = new ArrayList();
    private ActionListener \u0565 = new ActionListener(){

        public void actionPerformed(ActionEvent e2) {
            TAlarmOverview.this.E(e2);
        }
    };
    private AlarmSeverityChangeListener \u0568 = new AlarmSeverityChangeListener(){

        public boolean alarmSeverityChange() {
            for (int i2 = 0; i2 < TAlarmOverview.this.\u056b.size(); ++i2) {
                Item item = (Item)TAlarmOverview.this.\u056b.get(i2);
                AlarmSeverity severity = (AlarmSeverity)item.getUserObject();
                item.setColor(severity.getColor());
                item.setName(severity.getNickName());
            }
            return false;
        }
    };

    public TAlarmOverview(TDataBox box) {
        this(box, null);
    }

    public TAlarmOverview(TDataBox box, List alarmSeverities) {
        this.setLayout(new BorderLayout());
        this.\u056c.setRollover(true);
        this.\u056c.setFloatable(false);
        this.\u056d = this.A("/resource/image/chart/legend.png");
        this.\u0569 = this.A("/resource/image/chart/bar.png");
        this.\u0571 = this.A("/resource/image/chart/pie.png");
        this.\u056d.setSelected(true);
        this.add((Component)this.\u056c, "North");
        this.\u056f = new TAlarmStatTable(box, alarmSeverities);
        this.\u056f.setAutoResizeMode(3);
        PropertyChangeSupport support = this.\u056f.getAlarmStateStatistics().getPropertyChangeSupport();
        support.addPropertyChangeListener("alarmstate", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                TAlarmOverview.this.updateTViewUI();
            }
        });
        Iterator it = this.\u056f.getAlarmStateStatistics().getSeverityList().iterator();
        while (it.hasNext()) {
            AlarmSeverity severity = (AlarmSeverity)it.next();
            Item item = new Item(severity.getNickName(), 0.0, severity.getColor(), null, TWaverConst.DEFAULT_INT_FORMATER);
            item.setUserObject(severity);
            this.\u056b.add(item);
        }
        this.\u0570 = new JPanel(new BorderLayout());
        this.\u0570.add((Component)this.\u056f.getTableHeader(), "North");
        this.\u0570.add((Component)this.\u056f, "Center");
        this.add((Component)this.\u0570, "Center");
        this.\u0567 = this.\u0570;
        this.\u056a = new BarChart(this.\u056b);
        this.\u0566 = new PieChart(this.\u056b);
        this.updateTViewUI();
        AlarmSeverity.addAlarmSeverityChangeListener(this.\u0568);
    }

    private JToggleButton A(String icon) {
        JToggleButton button = new JToggleButton(C.E(icon));
        button.setMargin(TWaverConst.NONE_INSETS);
        button.addActionListener(this.\u0565);
        this.\u056e.add(button);
        this.\u056c.add(button);
        return button;
    }

    private void E(ActionEvent e2) {
        Object source = e2.getSource();
        if (source == this.\u056d) {
            this.A(this.\u0570);
        }
        if (source == this.\u0569) {
            this.A(this.\u056a);
        }
        if (source == this.\u0571) {
            this.A(this.\u0566);
        }
        this.validate();
        this.repaint();
    }

    public void setSelectedPanelIndex(int panelIndex) {
        if (panelIndex == 0) {
            this.A(this.\u0570);
            this.\u056d.setSelected(true);
        } else if (panelIndex == 1) {
            this.A(this.\u056a);
            this.\u0569.setSelected(true);
        } else if (panelIndex == 2) {
            this.A(this.\u0566);
            this.\u0571.setSelected(true);
        }
    }

    private void A(JComponent newComponent) {
        if (this.\u0567 != newComponent) {
            this.remove(this.\u0567);
            this.add((Component)newComponent, "Center");
            this.\u0567 = newComponent;
        }
    }

    public void updateTViewUI() {
        for (int i2 = 0; i2 < this.\u056b.size(); ++i2) {
            Item item = (Item)this.\u056b.get(i2);
            AlarmSeverity severity = (AlarmSeverity)item.getUserObject();
            int totalCount = this.\u056f.getAlarmStateStatistics().getTotalAlarmCount(severity);
            item.setValue(totalCount);
            item.setToolTipText(severity.getDisplayName() + ":" + totalCount);
        }
    }

    public TAlarmStatTable getAlarmStatTable() {
        return this.\u056f;
    }

    public TDataBox getDataBox() {
        return this.\u056f.getDataBox();
    }

    public void setDataBox(TDataBox box) {
        this.\u056f.setDataBox(box);
    }

    public VisibleFilter getVisibleFilter() {
        return this.\u056f.getAlarmStateStatistics().getVisibleFilter();
    }

    public void setVisibleFilter(VisibleFilter visibleFilter) {
        this.\u056f.getAlarmStateStatistics().setVisibleFilter(visibleFilter);
    }

    public void reset() {
        this.\u056f.getAlarmStateStatistics().reset();
    }

    public JToggleButton getBarButton() {
        return this.\u0569;
    }

    public BarChart getBarChart() {
        return this.\u056a;
    }

    public JComponent getCurrentComponent() {
        return this.\u0567;
    }

    public ButtonGroup getGroup() {
        return this.\u056e;
    }

    public JToggleButton getPieButton() {
        return this.\u0571;
    }

    public PieChart getPieChart() {
        return this.\u0566;
    }

    public TAlarmStatTable getTable() {
        return this.\u056f;
    }

    public JToggleButton getTableButton() {
        return this.\u056d;
    }

    public JPanel getTablePane() {
        return this.\u0570;
    }

    public JToolBar getToolbar() {
        return this.\u056c;
    }
}

