/*
 * Decompiled with CFR 0.152.
 */
package twaver.table;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import twaver.TWaverConst;
import twaver.TWaverUtil;
import twaver.table.TPageNavigator;
import twaver.table.TTableAdapter;
import twaver.table.TTableModel;

public class TTableNavigator
extends TPageNavigator {
    private TTableModel C;
    private JCheckBox B;

    public TTableNavigator(TTableModel tableModel) {
        this(tableModel, null);
    }

    public TTableNavigator(TTableModel tableModel, int[] pageSizes) {
        this(tableModel, pageSizes, true);
    }

    public TTableNavigator(final TTableModel tableModel, int[] pageSizes, boolean lockable) {
        super(tableModel, pageSizes);
        this.C = tableModel;
        this.setMinimumSize(TWaverConst.EMPTY_DIMENSION);
        if (lockable) {
            this.B = new JCheckBox(TWaverUtil.getString("table.lock"), tableModel.isLocked());
            this.rightPanel.add(this.B);
            this.C.addTableListener(new TTableAdapter(){

                public void lockedChanged() {
                    if (TTableNavigator.this.B.isSelected() != tableModel.isLocked()) {
                        TTableNavigator.this.B.setSelected(tableModel.isLocked());
                    }
                }
            });
            this.B.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e2) {
                    if (TTableNavigator.this.B.isSelected()) {
                        tableModel.lock();
                    } else {
                        tableModel.unlockAndPublish();
                    }
                }
            });
        }
    }
}

