/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.splitpane;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JSplitPane;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class DividerActionListener
implements ActionListener {
    private JSplitPane splitPane;
    private boolean minimum;

    public DividerActionListener(JSplitPane splitPane, boolean minimum) {
        this.splitPane = splitPane;
        this.minimum = minimum;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int newLocation;
        if (this.splitPane == null) {
            throw new IllegalArgumentException("SplitPane can't be null");
        }
        BasicSplitPaneUI splitPaneUI = (BasicSplitPaneUI)this.splitPane.getUI();
        BasicSplitPaneDivider splitPaneDivider = splitPaneUI.getDivider();
        int orientation = this.splitPane.getOrientation();
        Insets insets = this.splitPane.getInsets();
        int lastLocation = this.splitPane.getLastDividerLocation();
        int currentLocation = splitPaneUI.getDividerLocation(this.splitPane);
        if (this.minimum) {
            if (orientation == 0) {
                if (currentLocation >= this.splitPane.getHeight() - insets.bottom - splitPaneDivider.getHeight()) {
                    int maxLocation = this.splitPane.getMaximumDividerLocation();
                    newLocation = Math.min(lastLocation, maxLocation);
                } else {
                    newLocation = insets.top;
                }
            } else if (currentLocation >= this.splitPane.getWidth() - insets.right - splitPaneDivider.getWidth()) {
                int maxLocation = this.splitPane.getMaximumDividerLocation();
                newLocation = Math.min(lastLocation, maxLocation);
            } else {
                newLocation = insets.left;
            }
        } else if (orientation == 0) {
            if (currentLocation == insets.top) {
                int maxLoc = this.splitPane.getMaximumDividerLocation();
                newLocation = Math.min(lastLocation, maxLoc);
            } else {
                newLocation = this.splitPane.getHeight() - splitPaneDivider.getHeight() - insets.top;
            }
        } else if (currentLocation == insets.left) {
            int maxLoc = this.splitPane.getMaximumDividerLocation();
            newLocation = Math.min(lastLocation, maxLoc);
        } else {
            newLocation = this.splitPane.getWidth() - splitPaneDivider.getWidth() - insets.left;
        }
        if (currentLocation != newLocation) {
            this.splitPane.setDividerLocation(newLocation);
            this.splitPane.setLastDividerLocation(currentLocation);
        }
    }
}

