/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.shrinkbar;

import com.nepxion.swing.shrinkbar.JShrinkHeader;
import com.nepxion.swing.shrinkbar.ShrinkContants;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.event.MouseInputAdapter;

public class SplitListener
extends MouseInputAdapter
implements ShrinkContants {
    protected Point lastPoint;
    protected JShrinkHeader shrinkHeader;

    public SplitListener(JShrinkHeader shrinkHeader) {
        this.shrinkHeader = shrinkHeader;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.shrinkHeader.isShrinked()) {
            return;
        }
        this.lastPoint = e.getPoint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.lastPoint = null;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.shrinkHeader.isShrinked()) {
            return;
        }
        if (this.lastPoint == null) {
            return;
        }
        Point point = e.getPoint();
        int x = point.x - this.lastPoint.x;
        JComponent parent = (JComponent)this.shrinkHeader.getParent();
        int placement = this.shrinkHeader.getPlacement();
        int shrinkedWidth = this.shrinkHeader.getShrinkedWidth();
        Dimension size = parent.getPreferredSize();
        if (placement == 0) {
            size.width -= x;
        } else if (placement == 1) {
            size.width += x;
        }
        size.width = Math.max(size.width, shrinkedWidth);
        parent.setPreferredSize(size);
        this.shrinkHeader.revalidateParent();
    }
}

