/*
 * Decompiled with CFR 0.152.
 */
package twaver;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import twaver.AbstractElement;
import twaver.base.A.E.W;
import twaver.base.A.E.b;

public class BaseElement
extends AbstractElement
implements Cloneable {
    protected double xLocation = 0.0;
    protected double yLocation = 0.0;

    public BaseElement() {
    }

    public BaseElement(Object id) {
        super(id);
    }

    public Rectangle getBounds() {
        return new Rectangle((int)this.xLocation, (int)this.yLocation, this.getWidth(), this.getHeight());
    }

    public Point getCenterLocation() {
        Rectangle rect = this.getBounds();
        return new Point((int)rect.getCenterX(), (int)rect.getCenterY());
    }

    public void setCenterLocation(double x, double y) {
        Rectangle rect = this.getBounds();
        this.setLocation(x - (double)(rect.width / 2), y - (double)(rect.height / 2));
    }

    public void setCenterLocation(Point2D location) {
        this.setCenterLocation(location.getX(), location.getY());
    }

    public Point getLocation() {
        return new Point((int)this.xLocation, (int)this.yLocation);
    }

    public void setLocation(Point location) {
        if (location != null) {
            this.setLocation(new Point2D.Double(location.x, location.y));
        }
    }

    public void setLocation(int x, int y) {
        this.setLocation(new Point2D.Double(x, y));
    }

    public void setLocation(double x, double y) {
        this.setLocation(new Point2D.Double(x, y));
    }

    public void setLocation(Point2D.Double location) {
        if (location != null) {
            Point2D.Double oldValue = new Point2D.Double(this.xLocation, this.yLocation);
            this.xLocation = location.getX();
            this.yLocation = location.getY();
            this.firePropertyChange("location", oldValue, location);
        }
    }

    public double getX() {
        return this.xLocation;
    }

    public double getY() {
        return this.yLocation;
    }

    public int getWidth() {
        return W.H(this);
    }

    public int getHeight() {
        return W.A(this);
    }

    public String getUIClassID() {
        return "BaseElementUI";
    }

    public String getSVGUIClassID() {
        return "BaseElementSVGUI";
    }

    public void putBodyColor(Color color) {
        this.putClientProperty((Object)"body.color", color);
    }

    public void putBodyRaised(boolean bodyRaised) {
        this.putClientProperty((Object)"body.raised", (Object)bodyRaised);
    }

    public void putBodyFill(boolean bodyFill) {
        this.putClientProperty((Object)"body.fill", bodyFill);
    }

    public void putCustomDraw(boolean customDraw) {
        this.putClientProperty((Object)"custom.draw", customDraw);
    }

    public void putCustomDrawShapeFactory(int customDrawShapeFactory) {
        this.putClientProperty((Object)"custom.draw.shape.factory", customDrawShapeFactory);
    }

    public void putCustomDrawDefaultBorder(boolean customDrawDefaultBorder) {
        this.putClientProperty((Object)"custom.draw.default.border", customDrawDefaultBorder);
    }

    public void putCustomDrawAntialias(boolean customDrawAntialias) {
        this.putClientProperty((Object)"custom.draw.antialias", customDrawAntialias);
    }

    public void putCustomDrawFill(boolean customDrawFill) {
        this.putClientProperty((Object)"custom.draw.fill", customDrawFill);
    }

    public void putCustomDrawFill3D(boolean customDrawFill3D) {
        this.putClientProperty((Object)"custom.draw.fill.3d", customDrawFill3D);
    }

    public void putCustomDrawFillColor(Color customDrawFillColor) {
        this.putClientProperty((Object)"custom.draw.fill.color", customDrawFillColor);
    }

    public void putCustomDrawOutline(boolean customDrawOutline) {
        this.putClientProperty((Object)"custom.draw.outline", customDrawOutline);
    }

    public void putCustomDrawOutline3D(boolean customDrawOutline3D) {
        this.putClientProperty((Object)"custom.draw.outline.3d", customDrawOutline3D);
    }

    public void putCustomDrawOutlineColor(Color customDrawOutlineColor) {
        this.putClientProperty((Object)"custom.draw.outline.color", customDrawOutlineColor);
    }

    public void putCustomDrawOutlineStroke(String customDrawOutlineStroke) {
        this.putClientProperty((Object)"custom.draw.outline.stroke", customDrawOutlineStroke);
    }

    public void putCustomDrawGradient(boolean customDrawGradient) {
        this.putClientProperty((Object)"custom.draw.gradient", customDrawGradient);
    }

    public void putCustomDrawGradientFactory(int customDrawGradientFactory) {
        this.putClientProperty((Object)"custom.draw.gradient.factory", customDrawGradientFactory);
    }

    public void putCustomDrawGradientColor(Color customDrawGradientColor) {
        this.putClientProperty((Object)"custom.draw.gradient.color", customDrawGradientColor);
    }

    public Color getBodyColor() {
        return b.P(this, "body.color");
    }

    public boolean isBodyFill() {
        return b.K(this, "body.fill");
    }

    public boolean isCustomDraw() {
        return b.K(this, "custom.draw");
    }

    public int getCustomDrawShapeFactory() {
        return b.J(this, "custom.draw.shape.factory");
    }

    public boolean isCustomDrawDefaultBorder() {
        return b.K(this, "custom.draw.default.border");
    }

    public boolean isCustomDrawAntialias() {
        return b.K(this, "custom.draw.antialias");
    }

    public boolean isCustomDrawFill() {
        return b.K(this, "custom.draw.fill");
    }

    public boolean isCustomDrawFill3D() {
        return b.K(this, "custom.draw.fill.3d");
    }

    public Color getCustomDrawFillColor() {
        return b.P(this, "custom.draw.fill.color");
    }

    public boolean isCustomDrawOutline() {
        return b.K(this, "custom.draw.outline");
    }

    public boolean isCustomDrawOutline3D() {
        return b.K(this, "custom.draw.outline.3d");
    }

    public Color getCustomDrawOutlineColor() {
        return b.P(this, "custom.draw.outline.color");
    }

    public Stroke getCustomDrawOutlineStroke() {
        return b.F(this, "custom.draw.outline.stroke");
    }

    public boolean isCustomDrawGradient() {
        return b.K(this, "custom.draw.gradient");
    }

    public int getCustomDrawGradientFactory() {
        return b.J(this, "custom.draw.gradient.factory");
    }

    public Color getCustomDrawGradientColor() {
        return b.P(this, "custom.draw.gradient.color");
    }

    public boolean isBodyRaised() {
        return b.K(this, "body.raised");
    }
}

