/*
 * Decompiled with CFR 0.152.
 */
package twaver;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import twaver.Alarm;
import twaver.AlarmElementMapping;
import twaver.AlarmModelEvent;
import twaver.AlarmModelListener;
import twaver.AlarmModelQuickFinder;
import twaver.BatchEvent;
import twaver.BatchListener;
import twaver.Batchable;
import twaver.DataBoxEvent;
import twaver.DataBoxListener;
import twaver.DefaultAlarmElementMapping;
import twaver.Element;
import twaver.TDataBox;
import twaver.base.A.E.R;

public class AlarmModel
implements Serializable,
PropertyChangeListener,
DataBoxListener,
Batchable {
    private final TDataBox h;
    private int f = -1;
    private Map o = new LinkedHashMap();
    private transient List j = null;
    private transient List k = new ArrayList();
    private transient List e = null;
    private transient List g = new ArrayList();
    private transient AlarmElementMapping d = new DefaultAlarmElementMapping();
    private boolean i = false;
    private boolean n = true;
    private transient int l = 0;
    private transient List m = new ArrayList();

    public boolean isBatching() {
        return this.l > 0;
    }

    public void startBatch() {
        ++this.l;
        int count = this.m.size();
        if (this.l == 1 && count > 0) {
            BatchEvent event = new BatchEvent(this);
            for (int i2 = 0; i2 < count; ++i2) {
                BatchListener l2 = (BatchListener)this.m.get(i2);
                l2.batchStarted(event);
            }
        }
    }

    public void endBatch() {
        if (this.l == 0) {
            throw new IllegalStateException("batch hasn't started yet.");
        }
        --this.l;
        int count = this.m.size();
        if (this.l == 0 && count > 0) {
            BatchEvent event = new BatchEvent(this);
            for (int i2 = 0; i2 < count; ++i2) {
                BatchListener l2 = (BatchListener)this.m.get(i2);
                l2.batchEnded(event);
            }
        }
    }

    public void addBatchListener(BatchListener l2) {
        if (!this.m.contains(l2)) {
            this.m.add(l2);
        }
    }

    public void removeBatchListener(BatchListener l2) {
        this.m.remove(l2);
    }

    AlarmModel(TDataBox box) {
        if (box == null) {
            throw new NullPointerException("the data box of alarm model can't be null");
        }
        this.h = box;
        box.addDataBoxListener(this);
    }

    public TDataBox getDataBox() {
        return this.h;
    }

    public Iterator iterator() {
        return this.o.values().iterator();
    }

    public List getAllAlarms() {
        ArrayList list = new ArrayList(this.o.size());
        Iterator it = this.o.values().iterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    public boolean isEmpty() {
        return this.o.size() == 0;
    }

    public void removeFirstAlarm(int count) {
        while (count > 0 && this.o.size() > 0) {
            Alarm alarm = (Alarm)this.o.values().iterator().next();
            this.removeAlarm(alarm);
            --count;
        }
    }

    public int getLimit() {
        return this.f;
    }

    public void setLimit(int limit) {
        this.f = limit;
        this.B();
    }

    private void B() {
        if (this.f > 0 && this.o.size() > this.f) {
            this.removeFirstAlarm(this.o.size() - this.f);
        }
    }

    public int size() {
        return this.o.size();
    }

    void A(AlarmModelListener l2) {
        if (l2 == null) {
            return;
        }
        if (this.j == null) {
            this.j = new ArrayList();
        }
        if (!this.j.contains(l2)) {
            this.j.add(l2);
        }
    }

    void B(AlarmModelListener l2) {
        if (this.j != null) {
            this.j.remove(l2);
        }
    }

    void C(PropertyChangeListener l2) {
        if (this.e == null) {
            this.e = new ArrayList();
        }
        if (!this.e.contains(l2)) {
            this.e.add(l2);
        }
    }

    void D(PropertyChangeListener l2) {
        if (this.e != null) {
            this.e.remove(l2);
        }
    }

    public void addAlarmModelListener(AlarmModelListener l2) {
        if (l2 != null) {
            if (this.k.contains(l2)) {
                throw new IllegalArgumentException("listener already exists.");
            }
            this.k.add(l2);
        }
    }

    public void removeAlarmModelListener(AlarmModelListener l2) {
        this.k.remove(l2);
    }

    public void addAlarmPropertyChangeListener(PropertyChangeListener l2) {
        if (l2 != null) {
            if (this.g.contains(l2)) {
                throw new IllegalArgumentException("listener already exists.");
            }
            this.g.add(l2);
        }
    }

    public void removeAlarmPropertyChangeListener(PropertyChangeListener l2) {
        this.g.remove(l2);
    }

    private void A(Alarm alarm, int type) {
        AlarmModelListener l2;
        Iterator it;
        AlarmModelEvent e2 = new AlarmModelEvent(this, alarm, type);
        if (this.j != null) {
            it = this.j.iterator();
            while (it.hasNext()) {
                l2 = (AlarmModelListener)it.next();
                switch (e2.getType()) {
                    case 1: {
                        l2.alarmAdded(e2);
                        break;
                    }
                    case 2: {
                        l2.alarmRemoved(e2);
                        break;
                    }
                    case 3: {
                        l2.alarmCleared(e2);
                    }
                }
            }
        }
        it = this.k.iterator();
        while (it.hasNext()) {
            l2 = (AlarmModelListener)it.next();
            switch (e2.getType()) {
                case 1: {
                    l2.alarmAdded(e2);
                    break;
                }
                case 2: {
                    l2.alarmRemoved(e2);
                    break;
                }
                case 3: {
                    l2.alarmCleared(e2);
                }
            }
        }
    }

    public void addAlarms(List alarms) {
        if (alarms != null) {
            Iterator it = alarms.iterator();
            while (it.hasNext()) {
                Alarm alarm = (Alarm)it.next();
                this.addAlarm(alarm);
            }
        }
    }

    public void addAlarm(Alarm alarm) {
        if (alarm == null) {
            throw new NullPointerException("alarm can not null");
        }
        if (this.isAlarmExists(alarm.getAlarmID())) {
            throw new IllegalArgumentException("alarm with id '" + alarm.getAlarmID() + "' already exist");
        }
        if (this.isAutoRemoveAlarmWhenCleared() && alarm.isCleared()) {
            return;
        }
        this.o.put(alarm.getAlarmID(), alarm);
        this.A(alarm, 1);
        this.C(alarm);
        alarm.getPropertyChangeSupport().addPropertyChangeListener(this);
        this.B();
    }

    private void A(Alarm alarm) {
        R.A(this, alarm, true);
    }

    private void B(Alarm alarm) {
        R.A(this, alarm, false);
    }

    private void C(Alarm alarm) {
        if (!alarm.isCleared()) {
            R.A(this, alarm, true);
        }
    }

    private void D(Alarm alarm) {
        if (!alarm.isCleared()) {
            R.A(this, alarm, false);
        }
    }

    public Alarm getAlarmByID(Object id) {
        return (Alarm)this.o.get(id);
    }

    public void clearAlarmByID(Object alarmID) {
        this.clearAlarmByID(alarmID, null);
    }

    public void clearAlarmByID(Object alarmID, Date clearTime) {
        if (alarmID == null) {
            throw new NullPointerException("alarm id can not null.");
        }
        if (!this.isAlarmExists(alarmID)) {
            throw new NullPointerException("alarm with alarmID '" + alarmID + "' not exists.");
        }
        if (clearTime == null) {
            clearTime = new Date();
        }
        Alarm alarm = this.getAlarmByID(alarmID);
        alarm.setClearedTime(clearTime);
        alarm.setCleared(true);
    }

    public void confirmAlarmByID(Object alarmID) {
        this.acknowledgeAlarmByID(alarmID);
    }

    public void acknowledgeAlarmByID(Object alarmID) {
        this.acknowledgeAlarmByID(alarmID, null, null);
    }

    public void acknowledgeAlarm(Alarm alarm) {
        this.acknowledgeAlarmByID(alarm.getAlarmID(), null, null);
    }

    public void confirmAlarmByID(Object alarmID, Date ackTime, String ackUserID) {
        this.acknowledgeAlarmByID(alarmID, ackTime, ackUserID);
    }

    public void acknowledgeAlarmByID(Object alarmID, Date ackTime, String ackUserID) {
        if (alarmID == null) {
            throw new NullPointerException("alarm id can not null.");
        }
        if (!this.isAlarmExists(alarmID)) {
            throw new NullPointerException("alarm with alarmID '" + alarmID + "' not exists.");
        }
        Alarm alarm = this.getAlarmByID(alarmID);
        if (alarm.isAcked()) {
            throw new IllegalStateException("alarm '" + alarm.getAlarmID() + "' already acknowledged.");
        }
        if (ackTime == null) {
            ackTime = new Date();
        }
        alarm.setAckTime(ackTime);
        alarm.setAckUserID(ackUserID);
        alarm.setAcked(true);
    }

    public boolean isAlarmExists(Object alarmID) {
        return this.o.containsKey(alarmID);
    }

    public void removeAllAlarms() {
        this.clear();
    }

    public void clear() {
        Iterator it = this.o.values().iterator();
        while (it.hasNext()) {
            Alarm alarm = (Alarm)it.next();
            alarm.getPropertyChangeSupport().removePropertyChangeListener(this);
            this.D(alarm);
        }
        this.o.clear();
        this.A(null, 3);
    }

    public void removeAlarmByID(Object alarmID) {
        Alarm alarm = this.getAlarmByID(alarmID);
        if (alarm != null) {
            this.o.remove(alarm.getAlarmID());
            alarm.getPropertyChangeSupport().removePropertyChangeListener(this);
            this.D(alarm);
            this.A(alarm, 2);
        }
    }

    public void removeAlarm(Alarm alarm) {
        if (alarm != null) {
            this.removeAlarmByID(alarm.getAlarmID());
        }
    }

    public Collection getAlarmsByElement(Element element) {
        Object object = this.d.getCorrespondingAlarms(this.h, element);
        if (object instanceof Alarm) {
            LinkedList<Object> result = new LinkedList<Object>();
            result.add(object);
            return result;
        }
        if (object instanceof Collection) {
            return (Collection)object;
        }
        return new LinkedList();
    }

    public Collection getElementsByAlarm(Alarm alarm) {
        Object object = this.d.getCorrespondingElements(this.h, alarm);
        if (object instanceof Element) {
            LinkedList<Object> result = new LinkedList<Object>();
            result.add(object);
            return result;
        }
        if (object instanceof Collection) {
            return (Collection)object;
        }
        return new LinkedList();
    }

    public void removeAlarmsByElement(Element element) {
        if (element != null) {
            Object object = this.d.getCorrespondingAlarms(this.h, element);
            if (object instanceof Alarm) {
                this.removeAlarm((Alarm)object);
            } else if (object instanceof Collection) {
                Collection c2 = (Collection)object;
                Iterator alarms = c2.iterator();
                while (alarms.hasNext()) {
                    Alarm alarm = (Alarm)alarms.next();
                    this.removeAlarm(alarm);
                }
            }
        }
    }

    private void B(Alarm alarm, PropertyChangeEvent e2) {
        Object object = this.d.getCorrespondingElements(this.h, alarm);
        if (object instanceof Element) {
            Element element = (Element)object;
            R.A(element, e2, this);
        } else if (object instanceof Collection) {
            Collection c2 = (Collection)object;
            Iterator elements = c2.iterator();
            while (elements.hasNext()) {
                Element element = (Element)elements.next();
                R.A(element, e2, this);
            }
        }
    }

    private void A(Alarm alarm, PropertyChangeEvent e2) {
        Object object = this.d.getCorrespondingElements(this.h, alarm);
        if (object instanceof Element) {
            Element element = (Element)object;
            R.A(element, e2);
        } else if (object instanceof Collection) {
            Collection c2 = (Collection)object;
            Iterator elements = c2.iterator();
            while (elements.hasNext()) {
                Element element = (Element)elements.next();
                R.A(element, e2);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent e2) {
        if (this.e != null) {
            Iterator it = this.e.iterator();
            while (it.hasNext()) {
                PropertyChangeListener l2 = (PropertyChangeListener)it.next();
                l2.propertyChange(e2);
            }
        }
        Alarm alarm = (Alarm)e2.getSource();
        String propertyName = e2.getPropertyName();
        if (!alarm.isCleared()) {
            if (propertyName.equals("alarmSeverity")) {
                this.B(alarm, e2);
            } else if (propertyName.equals("acked")) {
                this.A(alarm, e2);
            }
        }
        if (propertyName.equals("cleared")) {
            if (alarm.isCleared()) {
                this.B(alarm);
                if (this.isAutoRemoveAlarmWhenCleared()) {
                    this.removeAlarm(alarm);
                }
            } else {
                this.A(alarm);
            }
        }
        this.A(e2);
    }

    private void A(PropertyChangeEvent e2) {
        Iterator it = this.g.iterator();
        while (it.hasNext()) {
            PropertyChangeListener l2 = (PropertyChangeListener)it.next();
            l2.propertyChange(e2);
        }
    }

    public void elementRemoved(DataBoxEvent e2) {
        if (!this.n) {
            return;
        }
        if (e2.getElement() != null) {
            this.removeAlarmsByElement(e2.getElement());
        }
    }

    public void elementsCleared(DataBoxEvent e2) {
        if (!this.n) {
            return;
        }
        this.removeAllAlarms();
    }

    public void elementAdded(DataBoxEvent e2) {
        if (this.o.size() == 0) {
            return;
        }
        Element element = e2.getElement();
        Object object = this.d.getCorrespondingAlarms(this.h, element);
        if (object instanceof Alarm) {
            Alarm alarm = (Alarm)object;
            if (!alarm.isCleared()) {
                R.A(element, alarm, true);
            }
        } else if (object instanceof Collection) {
            Collection c2 = (Collection)object;
            Iterator alarms = c2.iterator();
            while (alarms.hasNext()) {
                Alarm alarm = (Alarm)alarms.next();
                if (alarm.isCleared()) continue;
                R.A(element, alarm, true);
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.k = new ArrayList();
        this.g = new ArrayList();
        this.d = new DefaultAlarmElementMapping();
        this.m = new ArrayList();
    }

    public AlarmElementMapping getAlarmElementMapping() {
        return this.d;
    }

    public void setAlarmElementMapping(AlarmElementMapping alarmElementMapping) {
        this.d = alarmElementMapping;
    }

    public boolean isAutoRemoveAlarmWhenCleared() {
        return this.i;
    }

    public void setAutoRemoveAlarmWhenCleared(boolean autoRemoveAlarmWhenCleared) {
        this.i = autoRemoveAlarmWhenCleared;
    }

    public AlarmModelQuickFinder createAlarmFinder(String propertyName) {
        return new AlarmModelQuickFinder(this, propertyName);
    }

    public boolean isAutoRemoveAlarmWhenElementIsRemoved() {
        return this.n;
    }

    public void setAutoRemoveAlarmWhenElementIsRemoved(boolean autoRemoveAlarmWhenElementIsRemoved) {
        this.n = autoRemoveAlarmWhenElementIsRemoved;
    }
}

