/*
 * Decompiled with CFR 0.152.
 */
package twaver.table.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import twaver.AlarmSeverity;
import twaver.AlarmState;

public class AlarmStateRenderer
extends DefaultTableCellRenderer {
    private Rectangle2D C = new Rectangle2D.Double();
    private AlarmState B;
    private int A;
    public static final int ALARMNUM_ALAINTYPE_LEFT = 0;
    public static final int ALARMNUM_ALAINTYPE_CENTER = 1;
    public static final int ALARMNUM_ALAINTYPE_RIGHT = 2;

    public AlarmStateRenderer() {
        this("center");
    }

    public AlarmStateRenderer(String alignment) {
        this.A = "left".equalsIgnoreCase(alignment) ? 0 : ("right".equalsIgnoreCase(alignment) ? 2 : 1);
    }

    private int A(Iterator iterator) {
        int nums = 0;
        if (this.B != null) {
            while (iterator.hasNext()) {
                AlarmSeverity severity = (AlarmSeverity)iterator.next();
                if (this.B.getNewAlarmCount(severity) == 0 && this.B.getAcknowledgedAlarmCount(severity) == 0) continue;
                ++nums;
            }
        }
        return nums;
    }

    private float[] A() {
        float[] offsetx = new float[]{0.0f, 0.0f};
        switch (this.A) {
            case 2: {
                offsetx[0] = 1.0f;
                offsetx[1] = -1.0f;
                break;
            }
            case 1: {
                offsetx[0] = 0.5f;
                offsetx[1] = -0.5f;
                break;
            }
        }
        return offsetx;
    }

    public void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        if (this.B == null) {
            return;
        }
        Graphics2D g22 = (Graphics2D)g2;
        float width = this.getSize().width;
        float height = this.getSize().height;
        int typesNum = this.A(AlarmSeverity.iterator());
        if (typesNum == 0) {
            return;
        }
        width /= (float)typesNum;
        int i2 = 0;
        int newAlarms = 0;
        int ackAlarms = 0;
        double contentsWidth = 0.0;
        Iterator iterator = AlarmSeverity.iterator();
        while (iterator.hasNext()) {
            AlarmSeverity severity = (AlarmSeverity)iterator.next();
            newAlarms = this.B.getNewAlarmCount(severity);
            ackAlarms = this.B.getAcknowledgedAlarmCount(severity);
            if (newAlarms == 0 && ackAlarms == 0) continue;
            Color color = severity.getColor();
            g22.setColor(color);
            this.C.setRect((float)i2 * width, 0.0, width, height);
            g22.fill(this.C);
            g22.setColor(Color.BLACK);
            String contents = newAlarms + "/" + ackAlarms;
            contentsWidth = g2.getFont().getStringBounds(contents, g22.getFontRenderContext()).getWidth();
            float[] offsetx = this.A();
            g22.drawString(contents, (float)((double)(((float)i2 + offsetx[0]) * width) + (double)offsetx[1] * contentsWidth), height - 3.0f);
            ++i2;
        }
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, null, isSelected, hasFocus, row, column);
        this.B = value instanceof AlarmState ? (AlarmState)value : null;
        return this;
    }
}

