/*
 * Decompiled with CFR 0.152.
 */
package y.layout.labeling;

import java.util.Hashtable;
import y.base.DataProvider;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.NodeCursor;
import y.base.YCursor;
import y.base.YList;
import y.geom.IntersectionAlgorithm;
import y.geom.LineSegment;
import y.geom.YLineSegmentCursor;
import y.geom.YPointPath;
import y.layout.AbstractLayoutStage;
import y.layout.EdgeLabelLayout;
import y.layout.LabelCandidate;
import y.layout.LayoutGraph;
import y.layout.LayoutTool;
import y.layout.NodeLabelCandidate;
import y.layout.NodeLabelLayout;
import y.layout.ProfitModel;
import y.layout.SliderEdgeLabelModel;
import y.layout.labeling.a;
import y.layout.labeling.do;
import y.layout.labeling.if;
import y.util.D;
import y.util.DataProviderAdapter;
import y.util.Timer;

public abstract class AbstractLabelingAlgorithm
extends AbstractLayoutStage {
    private ProfitModel bf = null;
    private boolean be = false;
    private boolean bj = false;
    private boolean bi = true;
    private boolean bh = true;
    private Object bc = null;
    YList bd;
    boolean bg = false;

    public void setRemoveNodeOverlaps(boolean bl) {
        this.bj = bl;
    }

    public void setRemoveEdgeOverlaps(boolean bl) {
        this.be = bl;
    }

    public boolean getRemoveNodeOverlaps() {
        return this.bj;
    }

    public boolean getRemoveEdgeOverlaps() {
        return this.be;
    }

    public void setPlaceNodeLabels(boolean bl) {
        this.bi = bl;
    }

    public void setPlaceEdgeLabels(boolean bl) {
        this.bh = bl;
    }

    public boolean getPlaceNodeLabels() {
        return this.bi;
    }

    public boolean getPlaceEdgeLabels() {
        return this.bh;
    }

    public void setSelection(Object object) {
        this.bc = object;
    }

    public Object getSelectionKey() {
        return this.bc;
    }

    public boolean canLayout(LayoutGraph layoutGraph) {
        if (this.getCoreLayouter() != null) {
            return this.getCoreLayouter().canLayout(layoutGraph);
        }
        return true;
    }

    public void doLayout(LayoutGraph layoutGraph) {
        if (this.getCoreLayouter() != null) {
            this.getCoreLayouter().doLayout(layoutGraph);
        }
        this.label(layoutGraph);
    }

    public void label(LayoutGraph layoutGraph) {
        D.bug(this, (Object)"Start labeling");
        Timer timer = new Timer();
        DataProvider dataProvider = this.bc != null ? layoutGraph.getDataProvider(this.bc) : null;
        if[] ifArray = this.a(layoutGraph, dataProvider);
        D.bug(this, (Object)("Label Number: " + ifArray.length));
        this.label(layoutGraph, ifArray);
        this.a(ifArray);
        D.bug(this, (Object)("Time: " + timer));
    }

    public void label(LayoutGraph layoutGraph, Object object) {
        Timer timer = new Timer();
        DataProvider dataProvider = layoutGraph.getDataProvider(object);
        if[] ifArray = this.a(layoutGraph, dataProvider);
        D.bug(this, (Object)("Label Number: " + ifArray.length));
        this.label(layoutGraph, ifArray);
        this.a(ifArray);
        D.bug(this, (Object)("Time: " + timer));
    }

    public void label(LayoutGraph layoutGraph, YList yList, YList yList2) {
        Object object;
        Object object2;
        Timer timer = new Timer();
        final Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        Object object3 = new Object();
        YCursor yCursor = yList.cursor();
        while (yCursor.ok()) {
            object2 = (NodeLabelLayout)yCursor.current();
            hashtable.put(object2, object3);
            yCursor.next();
        }
        object2 = yList2.cursor();
        while (object2.ok()) {
            object = (EdgeLabelLayout)object2.current();
            hashtable.put(object, object3);
            object2.next();
        }
        object = new DataProviderAdapter(){

            public boolean getBool(Object object) {
                return hashtable.get(object) != null;
            }
        };
        if[] ifArray = this.a(layoutGraph, (DataProvider)object);
        hashtable.clear();
        this.label(layoutGraph, ifArray);
        this.a(ifArray);
        D.bug(this, (Object)("Time: " + timer));
    }

    private if[] a(LayoutGraph layoutGraph, DataProvider dataProvider) {
        NodeLabelLayout[] nodeLabelLayoutArray;
        if[] ifArray = new if[AbstractLabelingAlgorithm.d(layoutGraph)];
        int n = 0;
        NodeCursor nodeCursor = layoutGraph.nodes();
        while (nodeCursor.ok()) {
            nodeLabelLayoutArray = layoutGraph.getLabelLayout(nodeCursor.node());
            int n2 = 0;
            while (n2 < nodeLabelLayoutArray.length) {
                ifArray[n] = new do(n, nodeLabelLayoutArray[n2]);
                if (dataProvider != null && !dataProvider.getBool(nodeLabelLayoutArray[n2])) {
                    ifArray[n].a(true);
                }
                if (!this.bi) {
                    ifArray[n].a(true);
                }
                ifArray[n].a(layoutGraph);
                ++n2;
                ++n;
            }
            nodeCursor.next();
        }
        nodeLabelLayoutArray = new YList();
        EdgeCursor edgeCursor = layoutGraph.edges();
        while (edgeCursor.ok()) {
            EdgeLabelLayout[] edgeLabelLayoutArray = layoutGraph.getLabelLayout(edgeCursor.edge());
            int n3 = 0;
            while (n3 < edgeLabelLayoutArray.length) {
                ifArray[n] = new a(n, edgeLabelLayoutArray[n3]);
                if (dataProvider != null && !dataProvider.getBool(edgeLabelLayoutArray[n3])) {
                    ifArray[n].a(true);
                }
                if (!this.bh) {
                    ifArray[n].a(true);
                }
                ifArray[n].a(layoutGraph);
                ++n3;
                ++n;
            }
            edgeCursor.next();
        }
        this.removeNodesOverlaps(layoutGraph, ifArray);
        this.removeEdgesOverlaps(layoutGraph, ifArray);
        return ifArray;
    }

    protected void removeNodesOverlaps(LayoutGraph layoutGraph, if[] ifArray) {
        Object object;
        Timer timer = new Timer();
        D.bug(this, (Object)"Handle Node Overlaps !");
        YList yList = new YList();
        NodeCursor nodeCursor = layoutGraph.nodes();
        while (nodeCursor.ok()) {
            yList.add(layoutGraph.getRectangle(nodeCursor.node()));
            nodeCursor.next();
        }
        int n = 0;
        while (n < ifArray.length) {
            object = ifArray[n].b();
            YCursor yCursor = ((YList)object).cursor();
            while (yCursor.ok()) {
                yList.add(yCursor.current());
                yCursor.next();
            }
            ++n;
        }
        object = new IntersectionAlgorithm();
        IntersectionAlgorithm.intersect(yList, new _if());
        if (this.bj) {
            int n2 = 0;
            while (n2 < ifArray.length) {
                YList yList2 = ifArray[n2].b();
                YCursor yCursor = yList2.cursor();
                while (yCursor.ok()) {
                    LabelCandidate labelCandidate = (LabelCandidate)yCursor.current();
                    if (labelCandidate.getNodeOverlapPenalty() > 0.0) {
                        yList2.remove(labelCandidate);
                    }
                    yCursor.next();
                }
                ++n2;
            }
        }
        D.bug(this, (Object)("Time: " + timer));
    }

    protected void removeEdgesOverlaps(LayoutGraph layoutGraph, if[] ifArray) {
        Object object;
        Object object2;
        Object object3;
        Timer timer = new Timer();
        D.bug(this, (Object)"Handle Edge Overlaps !");
        YList yList = new YList();
        int n = 0;
        while (n < ifArray.length) {
            object3 = ifArray[n].b();
            object2 = ((YList)object3).cursor();
            while (object2.ok()) {
                yList.add(object2.current());
                object2.next();
            }
            ++n;
        }
        object3 = layoutGraph.edges();
        while (object3.ok()) {
            object2 = LayoutTool.getEdgeClippedOnBB(layoutGraph, object3.edge());
            YLineSegmentCursor yLineSegmentCursor = ((YPointPath)object2).lineSegments();
            while (yLineSegmentCursor.ok()) {
                object = yLineSegmentCursor.lineSegment();
                yList.add(new _do((LineSegment)object, object3.edge()));
                yLineSegmentCursor.next();
            }
            object3.next();
        }
        object2 = new IntersectionAlgorithm();
        IntersectionAlgorithm.intersect(yList, new _a(layoutGraph));
        if (this.be) {
            int n2 = 0;
            while (n2 < ifArray.length) {
                object = ifArray[n2].b();
                YCursor yCursor = ((YList)object).cursor();
                while (yCursor.ok()) {
                    LabelCandidate labelCandidate = (LabelCandidate)yCursor.current();
                    if (labelCandidate.getEdgeOverlapPenalty() > 0.0) {
                        ((YList)object).remove(labelCandidate);
                    }
                    yCursor.next();
                }
                ++n2;
            }
        }
        D.bug(this, (Object)("Time: " + timer));
    }

    private static int d(LayoutGraph layoutGraph) {
        int n = 0;
        NodeCursor nodeCursor = layoutGraph.nodes();
        while (nodeCursor.ok()) {
            n += layoutGraph.getLabelLayout(nodeCursor.node()).length;
            nodeCursor.next();
        }
        EdgeCursor edgeCursor = layoutGraph.edges();
        while (edgeCursor.ok()) {
            n += layoutGraph.getLabelLayout(edgeCursor.edge()).length;
            edgeCursor.next();
        }
        return n;
    }

    public void setProfitModel(ProfitModel profitModel) {
        this.bf = profitModel;
    }

    public double getProfit(LabelCandidate labelCandidate) {
        double d2 = 0.0;
        if (this.bf != null) {
            return this.bf.getProfit(labelCandidate);
        }
        Object object = labelCandidate.getParameter();
        if (object instanceof SliderEdgeLabelModel) {
            SliderEdgeLabelModel.ModelParameter modelParameter = (SliderEdgeLabelModel.ModelParameter)object;
            d2 = 1.0 - Math.abs((0.5 - modelParameter.getAbsRatio()) * 2.0);
        } else {
            d2 = 1.0;
        }
        return d2;
    }

    protected abstract void label(LayoutGraph var1, if[] var2);

    public YList getRects() {
        return this.bd;
    }

    public void setStoreRects(boolean bl) {
        this.bg = bl;
    }

    public boolean isStoreRects() {
        return this.bg;
    }

    private void a(if[] ifArray) {
        if (!this.bg) {
            return;
        }
        if (this.bd == null) {
            this.bd = new YList();
        } else {
            this.bd.clear();
        }
        int n = 0;
        while (n < ifArray.length) {
            YList yList = ifArray[n].b();
            YCursor yCursor = yList.cursor();
            while (yCursor.ok()) {
                this.bd.add(yCursor.current());
                yCursor.next();
            }
            ++n;
        }
    }

    class _do
    extends LineSegment {
        private Edge p;

        _do(LineSegment lineSegment, Edge edge) {
            super(lineSegment.getFirstEndPoint(), lineSegment.getSecondEndPoint());
            this.p = edge;
        }

        Edge b() {
            return this.p;
        }
    }

    class _a
    implements IntersectionAlgorithm.IntersectionHandler {
        LayoutGraph a;

        _a(LayoutGraph layoutGraph) {
            this.a = layoutGraph;
        }

        public void checkIntersection(Object object, Object object2) {
            LabelCandidate labelCandidate = null;
            _do _do2 = null;
            if (object instanceof LabelCandidate) {
                labelCandidate = (LabelCandidate)object;
            }
            if (object instanceof _do) {
                _do2 = (_do)object;
            }
            if (object2 instanceof LabelCandidate) {
                if (labelCandidate == null) {
                    labelCandidate = (LabelCandidate)object2;
                } else {
                    return;
                }
            }
            if (labelCandidate == null) {
                return;
            }
            if (object2 instanceof _do) {
                _do2 = (_do)object2;
            }
            if (labelCandidate.isInternal() && labelCandidate.getOwner() instanceof EdgeLabelLayout && this.a.getFeature((EdgeLabelLayout)labelCandidate.getOwner()) == _do2.b()) {
                return;
            }
            if (_do2.intersects(labelCandidate.getBoundingBox())) {
                labelCandidate.setEdgeOverlapPenalty(1.0);
            }
        }
    }

    class _if
    implements IntersectionAlgorithm.IntersectionHandler {
        _if() {
        }

        public void checkIntersection(Object object, Object object2) {
            NodeLabelCandidate nodeLabelCandidate;
            LabelCandidate labelCandidate = null;
            if (object instanceof LabelCandidate) {
                labelCandidate = (LabelCandidate)object;
            }
            if (object2 instanceof LabelCandidate) {
                if (labelCandidate == null) {
                    labelCandidate = (LabelCandidate)object2;
                } else {
                    return;
                }
            }
            if (labelCandidate == null) {
                return;
            }
            if (labelCandidate instanceof NodeLabelCandidate && (nodeLabelCandidate = (NodeLabelCandidate)labelCandidate).isInternal()) {
                return;
            }
            labelCandidate.setNodeOverlapPenalty(1.0);
        }
    }
}

