/*
 * Decompiled with CFR 0.152.
 */
package twaver.table.renderer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import twaver.EnumType;
import twaver.EnumTypeManager;
import twaver.TUIManager;
import twaver.TWaverUtil;
import twaver.base.A.E.d;

public class EnumTypeRenderer
extends JPanel
implements TableCellRenderer {
    private String A = null;
    private boolean D = false;
    private DefaultTableCellRenderer C = new DefaultTableCellRenderer();
    private DefaultTableCellRenderer B = new DefaultTableCellRenderer();

    public EnumTypeRenderer(String enumTypeName) {
        this(enumTypeName, TUIManager.getString("table.alignment.enumtype"));
    }

    public EnumTypeRenderer(String enumTypeName, String alignment) {
        this(enumTypeName, alignment, "false");
    }

    public EnumTypeRenderer(String enumTypeName, String alignment, String considerDropDownIcon) {
        this.D = TWaverUtil.stringToBoolean(considerDropDownIcon);
        this.A = enumTypeName;
        TWaverUtil.setHorizontalAlignment(this.C, alignment);
        TWaverUtil.setHorizontalAlignment(this.B, alignment);
        JLabel label = new JLabel();
        label.setIcon(d.A());
        this.setLayout(new BorderLayout());
        this.add((Component)this.C, "Center");
        this.add((Component)label, "East");
        this.setOpaque(true);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String text = null;
        Icon icon = null;
        Color background = null;
        Color foreground = null;
        EnumType enumType = EnumTypeManager.getInstance().getEnumType(this.A, value);
        if (enumType != null) {
            text = enumType.toString();
            icon = enumType.getIcon();
            background = enumType.getBackground();
            foreground = enumType.getForeground();
            if (background != null && isSelected) {
                background = background.darker();
            }
        } else {
            String string = text = value == null ? null : value.toString();
        }
        if (this.D && table.isCellEditable(row, column)) {
            this.C.getTableCellRendererComponent(table, text, isSelected, hasFocus, row, column);
            this.C.setIcon(icon);
            this.setToolTipText(text);
            this.setBackground(this.C.getBackground());
            if (foreground != null) {
                this.C.setForeground(foreground);
            }
            if (background != null) {
                this.C.setBackground(background);
                this.setBackground(background);
            }
            return this;
        }
        this.B.getTableCellRendererComponent(table, text, isSelected, hasFocus, row, column);
        this.B.setIcon(icon);
        this.B.setToolTipText(text);
        if (foreground != null) {
            this.B.setForeground(foreground);
        }
        if (background != null) {
            this.B.setBackground(background);
        }
        return this.B;
    }

    public String getEnumTypeName() {
        return this.A;
    }

    public void setEnumTypeName(String enumTypeName) {
        this.A = enumTypeName;
    }

    public boolean isConsiderDropDownIcon() {
        return this.D;
    }

    public void setConsiderDropDownIcon(boolean considerDropDownIcon) {
        this.D = considerDropDownIcon;
    }
}

