/*
 * Decompiled with CFR 0.152.
 */
package y.layout.planar;

import java.util.ArrayList;
import java.util.Vector;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.EdgeList;
import y.base.EdgeMap;
import y.base.Graph;
import y.base.ListCell;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeList;
import y.base.NodeMap;
import y.geom.YPoint;
import y.geom.YPointCursor;
import y.geom.YPointPath;
import y.layout.LayoutGraph;
import y.layout.planar.Face;
import y.layout.planar.SimplePlanarInformation;
import y.layout.planar.SubdivisionHandler;
import y.util.D;

public class PlanarInformation
extends SimplePlanarInformation {
    public static final int UNIFY = 1;
    public static final int SPLIT = 0;
    private EdgeMap e;
    private EdgeMap h;
    private EdgeList b;
    private NodeMap g;
    private ArrayList i;
    private static final int f = 0;
    private static final int c = 1;
    private static final int d = 2;

    public PlanarInformation(Graph graph) {
        super(graph);
        this.g = graph.createNodeMap();
        this.e = graph.createEdgeMap();
        this.h = graph.createEdgeMap();
        this.i = new ArrayList();
        this.b = new EdgeList();
        EdgeCursor edgeCursor = graph.edges();
        while (edgeCursor.ok()) {
            this.getEdgeInfo(edgeCursor.edge()).b(true);
            edgeCursor.next();
        }
    }

    public void dispose() {
        super.dispose();
        this.graph.disposeEdgeMap(this.e);
        this.graph.disposeEdgeMap(this.h);
        this.graph.disposeNodeMap(this.g);
        this.b.clear();
    }

    public void setType(Node node, int n) {
        this.getNodeInfo(node).a(n);
    }

    public int getType(Node node) {
        return this.getNodeInfo(node).a();
    }

    public boolean isCrossing(Node node) {
        return this.getType(node) == 1;
    }

    public void markAsCrossing(Node node) {
        this.setType(node, 1);
    }

    public void markAsBend(Node node) {
        this.setType(node, 2);
    }

    public boolean isBend(Node node) {
        return this.getType(node) == 2;
    }

    public boolean isVertex(Node node) {
        return this.getType(node) == 0;
    }

    public void markAsVertex(Node node) {
        this.setType(node, 0);
    }

    public int countCrossings() {
        int n = 0;
        NodeCursor nodeCursor = this.graph.nodes();
        while (nodeCursor.ok()) {
            if (this.isCrossing(nodeCursor.node())) {
                ++n;
            }
            nodeCursor.next();
        }
        return n;
    }

    public Face[] splitFace(Face face, Edge edge) {
        Face[] faceArray = this.splitFace(face, edge, null, null);
        return faceArray;
    }

    public Face[] splitFace(Face face, Edge edge, Edge edge2, Edge edge3) {
        ListCell listCell;
        Edge edge4;
        Edge edge5;
        if (edge2 != null && this.faceOf(edge2) != face) {
            throw new RuntimeException("Fatal Error in edge to face assignment!");
        }
        if (edge3 != null && this.faceOf(edge3) != face) {
            throw new RuntimeException("Fatal Error in edge to face assignment!");
        }
        if (this.isBend(edge.source())) {
            this.markAsCrossing(edge.source());
        }
        if (this.isBend(edge.target())) {
            this.markAsCrossing(edge.target());
        }
        this.faceList.remove(face);
        EdgeCursor edgeCursor = face.edges();
        if (edge2 == null) {
            while (edgeCursor.ok() && edgeCursor.edge().target() != edge.source()) {
                edgeCursor.cyclicNext();
            }
            edge2 = edgeCursor.edge();
        }
        if (edge3 == null) {
            while (edgeCursor.ok() && edgeCursor.edge().target() != edge.target()) {
                edgeCursor.cyclicNext();
            }
            edge3 = edgeCursor.edge();
        }
        Edge edge6 = this.createReverse(edge);
        Face[] faceArray = new Face[2];
        Face face2 = new Face();
        Face face3 = new Face();
        if (edge2.target() == edge.target()) {
            edge5 = edge;
            edge4 = edge6;
        } else {
            edge5 = edge6;
            edge4 = edge;
        }
        this.getEdgeInfo(edge5).a(face2);
        this.getEdgeInfo(edge4).a(face3);
        edgeCursor.toFirst();
        while (edgeCursor.ok() && edgeCursor.edge() != edge2) {
            edgeCursor.cyclicNext();
        }
        edgeCursor.cyclicNext();
        while (edgeCursor.ok() && edgeCursor.edge() != edge3) {
            this.getEdgeInfo(edgeCursor.edge()).a(face2);
            face2.a(edgeCursor.edge());
            edgeCursor.cyclicNext();
        }
        this.getEdgeInfo(edge3).a(face2);
        face2.a(edge3);
        face2.a(edge5);
        this.faceList.add(face2);
        faceArray[0] = face2;
        edgeCursor.cyclicNext();
        while (edgeCursor.ok() && edgeCursor.edge() != edge2) {
            this.getEdgeInfo(edgeCursor.edge()).a(face3);
            face3.a(edgeCursor.edge());
            edgeCursor.cyclicNext();
        }
        this.getEdgeInfo(edge2).a(face3);
        face3.a(edge2);
        face3.a(edge4);
        this.faceList.add(face3);
        faceArray[1] = face3;
        if (this.getOuterFace() == face) {
            this.setOuterFace(PlanarInformation.a(face2, face3));
        }
        Face[] faceArray2 = new Face[]{face};
        Face[] faceArray3 = new Face[]{face2, face3};
        if (this.getEdgeInfo(edge).d() && (listCell = this.b.findCell(edge)) != null) {
            this.b.removeCell(listCell);
        }
        this.fireSplitFaceEvent(edge, faceArray2, faceArray3);
        return faceArray;
    }

    private static Face a(Face face, Face face2) {
        Face face3 = face.edges().size() > face2.edges().size() ? face : face2;
        return face3;
    }

    public void splitFaceWithSelfLoop(Edge edge, Edge edge2) {
        if (edge == null && edge2.source().degree() > 2) {
            Edge edge3 = null;
            EdgeCursor edgeCursor = edge2.source().outEdges();
            while (edgeCursor.ok()) {
                Edge edge4 = edgeCursor.edge();
                if (edge2 != edge4) {
                    if (edge3 == null) {
                        edge3 = edge4;
                    }
                    if (this.faceOf(edge4).edges().size() == 1) {
                        edge3 = edge4;
                    }
                }
                edgeCursor.next();
            }
            this.splitFaceWithSelfLoop(edge3, edge2);
            return;
        }
        Face face = new Face();
        Edge edge5 = this.createReverse(edge2);
        face.a(edge5);
        this.faceList.add(face);
        this.getEdgeInfo(edge5).a(face);
        if (edge != null) {
            Face face2 = this.faceOf(edge);
            face2.replaceEdge(edge, edge2, edge);
            this.getEdgeInfo(edge2).a(face2);
            Face[] faceArray = new Face[]{face2};
            Face[] faceArray2 = new Face[]{face, face2};
            this.fireSplitFaceEvent(edge2, faceArray, faceArray2);
        } else {
            Face face3 = new Face();
            this.faceList.add(face3);
            this.getEdgeInfo(edge2).a(face3);
            face3.a(edge2);
            Face[] faceArray = new Face[]{};
            Face[] faceArray3 = new Face[]{face, face3};
            this.fireSplitFaceEvent(edge2, faceArray, faceArray3);
        }
    }

    public Face bridgeFace(Edge edge, Edge edge2, Edge edge3) {
        ListCell listCell;
        Face[] faceArray;
        Edge edge4;
        Edge edge5;
        Face face = new Face();
        Face face2 = null;
        Face face3 = null;
        EdgeCursor edgeCursor = null;
        EdgeCursor edgeCursor2 = null;
        Node node = edge.source();
        Node node2 = edge.target();
        Edge edge6 = this.createReverse(edge);
        if (edge2 == null) {
            if (node.degree() == 2) {
                face.a(edge6);
                this.getEdgeInfo(edge6).a(face);
                face.a(edge);
                this.getEdgeInfo(edge).a(face);
            } else {
                face.a(edge6);
                this.getEdgeInfo(edge6).a(face);
                edge5 = node.firstOutEdge();
                if (edge5 == edge) {
                    throw new RuntimeException("Bridge Face failed !");
                }
                face2 = this.faceOf(edge5);
                this.faceList.remove(face2);
                edgeCursor = face2.edges();
                while (edgeCursor.ok() && edgeCursor.edge().source() != node) {
                    edgeCursor.cyclicNext();
                }
                edge4 = edgeCursor.edge();
                face.a(edge4);
                this.getEdgeInfo(edge4).a(face);
                edgeCursor.cyclicNext();
                while (edgeCursor.ok() && edgeCursor.edge() != edge4) {
                    face.a(edgeCursor.edge());
                    this.getEdgeInfo(edgeCursor.edge()).a(face);
                    edgeCursor.cyclicNext();
                }
                face.a(edge);
                this.getEdgeInfo(edge).a(face);
                if (this.getOuterFace() == face2) {
                    this.setOuterFace(face);
                }
            }
        } else {
            face.a(edge6);
            this.getEdgeInfo(edge6).a(face);
            face2 = this.faceOf(edge2);
            this.faceList.remove(face2);
            edgeCursor = face2.edges();
            while (edgeCursor.ok() && edgeCursor.edge() != edge2) {
                edgeCursor.cyclicNext();
            }
            edgeCursor.cyclicNext();
            while (edgeCursor.ok() && edgeCursor.edge() != edge2) {
                faceArray = edgeCursor.edge();
                face.a((Edge)faceArray);
                this.getEdgeInfo((Edge)faceArray).a(face);
                edgeCursor.cyclicNext();
            }
            face.a(edge2);
            this.getEdgeInfo(edge2).a(face);
            face.a(edge);
            this.getEdgeInfo(edge).a(face);
            if (this.getOuterFace() == face2) {
                this.setOuterFace(face);
            }
        }
        if (edge3 == null) {
            if (node2.degree() != 2) {
                edge5 = node2.firstOutEdge();
                if (edge5 == edge6) {
                    throw new RuntimeException("Error in bridge Face !");
                }
                face3 = this.faceOf(edge5);
                this.faceList.remove(face3);
                edgeCursor2 = face3.edges();
                while (edgeCursor2.ok() && edgeCursor2.edge().source() != node2) {
                    edgeCursor2.cyclicNext();
                }
                edge4 = edgeCursor2.edge();
                face.a(edge4);
                this.getEdgeInfo(edge4).a(face);
                edgeCursor2.cyclicNext();
                while (edgeCursor2.ok() && edgeCursor2.edge() != edge4) {
                    face.a(edgeCursor2.edge());
                    this.getEdgeInfo(edgeCursor2.edge()).a(face);
                    edgeCursor2.cyclicNext();
                }
                if (this.getOuterFace() == face3) {
                    this.setOuterFace(face);
                }
            }
        } else {
            face3 = this.faceOf(edge3);
            this.faceList.remove(face3);
            edgeCursor2 = face3.edges();
            while (edgeCursor2.ok() && edgeCursor2.edge() != edge3) {
                edgeCursor2.cyclicNext();
            }
            edgeCursor2.cyclicNext();
            while (edgeCursor2.ok() && edgeCursor2.edge() != edge3) {
                faceArray = edgeCursor2.edge();
                face.a((Edge)faceArray);
                this.getEdgeInfo((Edge)faceArray).a(face);
                edgeCursor2.cyclicNext();
            }
            face.a(edge3);
            this.getEdgeInfo(edge3).a(face);
        }
        this.faceList.add(face);
        if (this.getOuterFace() == face3) {
            this.setOuterFace(face);
        }
        faceArray = new Face[]{face};
        ArrayList<Face> arrayList = new ArrayList<Face>(2);
        if (face2 != null) {
            arrayList.add(face2);
        }
        if (face3 != null) {
            arrayList.add(face3);
        }
        Face[] faceArray2 = new Face[arrayList.size()];
        arrayList.toArray(faceArray2);
        if (this.getEdgeInfo(edge).d() && (listCell = this.b.findCell(edge)) != null) {
            this.b.removeCell(listCell);
        }
        this.fireSplitFaceEvent(edge, faceArray2, faceArray);
        return face;
    }

    public Face bridgeFace(Edge edge) {
        Face face = this.bridgeFace(edge, null, null);
        return face;
    }

    /*
     * Unable to fully structure code
     */
    public void unsplitFace(Edge var1_1) {
        block14: {
            block12: {
                var2_2 = this.getReverse(var1_1);
                if (this.faceOf(var1_1) == this.faceOf(var2_2)) break block12;
                var5_3 = this.faceOf(var1_1);
                var6_5 = this.faceOf(var2_2);
                var7_7 = new Face();
                var3_9 = new Face[2];
                var4_10 = new Face[1];
                var3_9[0] = var5_3;
                var3_9[1] = var6_5;
                var4_10[0] = var7_7;
                var8_11 = var5_3.edges();
                var9_13 = var6_5.edges();
                this.faceList.remove(var5_3);
                this.faceList.remove(var6_5);
                while (var8_11.ok()) {
                    block13: {
                        var10_14 = var8_11.edge();
                        if (var10_14 == var1_1) ** GOTO lbl24
                        var7_7.a(var10_14);
                        this.getEdgeInfo(var10_14).a(var7_7);
                        break block13;
lbl-1000:
                        // 1 sources

                        {
                            var9_13.cyclicNext();
lbl24:
                            // 2 sources

                            ** while (var9_13.edge() != var2_2)
                        }
lbl25:
                        // 1 sources

                        var9_13.cyclicNext();
                        while (var9_13.edge() != var2_2) {
                            var7_7.a(var9_13.edge());
                            this.getEdgeInfo(var9_13.edge()).a(var7_7);
                            var9_13.cyclicNext();
                        }
                    }
                    var8_11.next();
                }
                this.a(var1_1);
                this.a(var2_2);
                this.faceList.add(var7_7);
                if (var5_3 == this.getOuterFace() || var6_5 == this.getOuterFace()) {
                    this.setOuterFace(var7_7);
                }
                break block14;
            }
            var5_4 = this.faceOf(var1_1);
            var6_6 = new Face();
            var7_8 = new Face();
            var3_9 = new Face[1];
            var4_10 = new Face[]{var6_6, var7_8};
            var3_9[0] = var5_4;
            this.faceList.remove(var5_4);
            var8_12 = var5_4.edges();
            while (var8_12.edge() != var1_1) {
                var8_12.cyclicNext();
            }
            var8_12.cyclicNext();
            while (var8_12.edge() != var2_2) {
                var6_6.a(var8_12.edge());
                this.getEdgeInfo(var8_12.edge()).a(var6_6);
                var8_12.cyclicNext();
            }
            var8_12.cyclicNext();
            while (var8_12.edge() != var1_1) {
                var7_8.a(var8_12.edge());
                this.getEdgeInfo(var8_12.edge()).a(var7_8);
                var8_12.cyclicNext();
            }
            if (var6_6.edges().size() > 0) {
                if (var5_4 == this.getOuterFace()) {
                    this.setOuterFace(var6_6);
                }
                this.faceList.add(var6_6);
            }
            if (var7_8.edges().size() > 0) {
                if (var5_4 == this.getOuterFace()) {
                    this.setOuterFace(var7_8);
                }
                this.faceList.add(var7_8);
            }
            if (var6_6.edges().size() == 0 && var7_8.edges().size() == 0) {
                this.setOuterFace(this.faces().face());
            }
            this.a(var1_1);
            this.a(var2_2);
        }
        this.fireUnsplitFaceEvent(var1_1, var3_9, var4_10);
    }

    public void insertNodeWithEdge(Edge edge, Node node, Face face) {
        Edge edge2 = this.createReverse(edge);
        if (edge.target().equals(node)) {
            face.insertEdges(edge, edge2);
        } else {
            face.insertEdges(edge2, edge);
        }
        this.getEdgeInfo(edge).a(face);
        this.getEdgeInfo(edge2).a(face);
    }

    public Node subdivideEdge(Edge edge) {
        Edge edge2 = this.getReverse(edge);
        Node node = edge.source();
        Node node2 = edge.target();
        Node node3 = this.graph.createNode();
        this.markAsBend(node3);
        Edge edge3 = this.graph.createEdge(node, edge, node3, null, 1, 0);
        this.getEdgeInfo(edge3).a(false);
        Edge edge4 = this.graph.createEdge(node3, null, node2, edge, 0, 1);
        this.getEdgeInfo(edge4).a(false);
        Edge edge5 = this.graph.createEdge(node2, edge2, node3, null, 1, 0);
        this.getEdgeInfo(edge5).a(true);
        Edge edge6 = this.graph.createEdge(node3, null, node, edge2, 0, 1);
        this.getEdgeInfo(edge6).a(true);
        EdgeList edgeList = new EdgeList();
        edgeList.add(edge3);
        edgeList.add(edge4);
        this.updateEdgeRecoveryInfo(edge, edgeList, 0);
        Face face = this.faceOf(edge);
        Face face2 = this.faceOf(edge2);
        this.getEdgeInfo(edge3).a(face);
        this.getEdgeInfo(edge4).a(face);
        this.getEdgeInfo(edge5).a(face2);
        this.getEdgeInfo(edge6).a(face2);
        face.replaceEdge(edge, edge3, edge4);
        face2.replaceEdge(edge2, edge5, edge6);
        this.setReverse(edge3, edge6);
        this.setReverse(edge4, edge5);
        this.fireSubdivisionEvent(edge, edgeList.toEdgeArray());
        this.a(edge);
        this.a(edge2);
        return node3;
    }

    public EdgeList subdivideEdge(Edge edge, int n) {
        Object object;
        Edge edge2;
        Edge edge3;
        Edge edge4 = this.getReverse(edge);
        Node node = edge.source();
        Node node2 = edge.target();
        Face face = this.faceOf(edge);
        Face face2 = this.faceOf(edge4);
        Node[] nodeArray = new Node[n];
        Node[] nodeArray2 = new Node[n + 2];
        boolean bl = this.isInsertedEdge(edge);
        nodeArray2[0] = node;
        nodeArray2[n + 1] = node2;
        int n2 = 0;
        while (n2 < n) {
            nodeArray[n2] = this.graph.createNode();
            nodeArray2[n2 + 1] = nodeArray[n2];
            this.markAsBend(nodeArray[n2]);
            ++n2;
        }
        EdgeList edgeList = new EdgeList();
        EdgeList edgeList2 = new EdgeList();
        Edge edge5 = this.graph.createEdge(node, edge, nodeArray[0], null, 1, 0);
        edgeList.addLast(edge5);
        Edge edge6 = this.graph.createEdge(nodeArray[0], null, node, edge4, 0, 1);
        edgeList2.addFirst(edge6);
        this.setReverse(edge5, edge6);
        int n3 = 1;
        while (n3 < n) {
            edge3 = this.graph.createEdge(nodeArray2[n3], nodeArray2[n3 + 1]);
            edge2 = this.graph.createEdge(nodeArray2[n3 + 1], nodeArray2[n3]);
            edgeList.addLast(edge3);
            edgeList2.addFirst(edge2);
            this.setReverse(edge3, edge2);
            ++n3;
        }
        edge3 = this.graph.createEdge(nodeArray[n - 1], null, node2, edge, 0, 1);
        edgeList.addLast(edge3);
        edge2 = this.graph.createEdge(node2, edge4, nodeArray[n - 1], null, 1, 0);
        edgeList2.addFirst(edge2);
        this.setReverse(edge3, edge2);
        if (bl) {
            this.updateEdgeRecoveryInfo(edge4, edgeList2, 0);
        } else {
            this.updateEdgeRecoveryInfo(edge, edgeList, 0);
        }
        this.fireSubdivisionEvent(edge, edgeList.toEdgeArray());
        this.a(edge);
        this.a(edge4);
        EdgeCursor edgeCursor = edgeList.edges();
        while (edgeCursor.ok()) {
            object = edgeCursor.edge();
            this.getEdgeInfo((Edge)object).a(face);
            this.getEdgeInfo((Edge)object).a(bl);
            edgeCursor.next();
        }
        object = edgeList2.edges();
        while (object.ok()) {
            Edge edge7 = object.edge();
            this.getEdgeInfo(edge7).a(face2);
            this.getEdgeInfo(edge7).a(!bl);
            object.next();
        }
        face.a(edge, edgeList);
        face2.a(edge4, edgeList2);
        return edgeList;
    }

    public Edge unsubdivideEdge(Node node) {
        Edge edge;
        Edge edge2;
        Edge edge3;
        Edge edge4;
        Edge edge5;
        EdgeList edgeList = new EdgeList();
        if (node.inDegree() != 2 || node.outDegree() != 2) {
            throw new RuntimeException("Node is not a crossing");
        }
        EdgeCursor edgeCursor = node.inEdges();
        Edge edge6 = edgeCursor.edge();
        edgeCursor.next();
        Edge edge7 = edgeCursor.edge();
        edgeCursor = node.outEdges();
        Edge edge8 = edgeCursor.edge();
        edgeCursor.next();
        Edge edge9 = edgeCursor.edge();
        if (this.isInsertedEdge(edge6)) {
            edge5 = edge7;
            edge4 = edge6;
        } else {
            edge5 = edge6;
            edge4 = edge7;
        }
        if (edge8 == this.getReverse(edge5)) {
            edge3 = edge9;
            edge2 = edge8;
        } else {
            edge3 = edge8;
            edge2 = edge9;
        }
        Edge edge10 = (Edge)this.h.get(edge5);
        if (edge5.source() == edge10.source() && edge3.target() == edge10.target()) {
            this.b(edge10);
            edge = edge10;
        } else {
            edge = this.graph.createEdge(edge5.source(), edge3.target());
        }
        Edge edge11 = this.createReverse(edge);
        if (edge4.source() != edge11.source() || edge2.target() != edge11.target()) {
            throw new RuntimeException("Reverse Edge Restauration failed!");
        }
        Face face = this.faceOf(edge5);
        face.a(edge5, edge3, edge);
        this.getEdgeInfo(edge).a(face);
        Face face2 = this.faceOf(edge4);
        face2.a(edge4, edge2, edge11);
        this.getEdgeInfo(edge11).a(face2);
        this.a(node);
        edgeList.addFirst(edge3);
        edgeList.addFirst(edge5);
        this.updateEdgeRecoveryInfo(edge, edgeList, 1);
        this.fireUnsubdivideEvent(edgeList.toEdgeArray(), edge);
        return edge;
    }

    public void addSubdivisionHandler(SubdivisionHandler subdivisionHandler) {
        this.i.add(subdivisionHandler);
    }

    public void removeSubdivisionHandler(SubdivisionHandler subdivisionHandler) {
        this.i.remove(subdivisionHandler);
    }

    protected void fireSubdivisionEvent(Edge edge, Edge[] edgeArray) {
        int n = 0;
        while (n < this.i.size()) {
            SubdivisionHandler subdivisionHandler = (SubdivisionHandler)this.i.get(n);
            subdivisionHandler.subdivide(edge, edgeArray);
            ++n;
        }
    }

    protected void fireUnsubdivideEvent(Edge[] edgeArray, Edge edge) {
        int n = 0;
        while (n < this.i.size()) {
            SubdivisionHandler subdivisionHandler = (SubdivisionHandler)this.i.get(n);
            subdivisionHandler.unsubdivide(edgeArray, edge);
            ++n;
        }
    }

    protected void fireSplitFaceEvent(Edge edge, Face[] faceArray, Face[] faceArray2) {
        int n = 0;
        while (n < this.i.size()) {
            SubdivisionHandler subdivisionHandler = (SubdivisionHandler)this.i.get(n);
            subdivisionHandler.splitFace(edge, faceArray, faceArray2);
            ++n;
        }
    }

    protected void fireUnsplitFaceEvent(Edge edge, Face[] faceArray, Face[] faceArray2) {
        int n = 0;
        while (n < this.i.size()) {
            SubdivisionHandler subdivisionHandler = (SubdivisionHandler)this.i.get(n);
            subdivisionHandler.unsplitFace(edge, faceArray, faceArray2);
            ++n;
        }
    }

    public EdgeCursor getCurrentPath(Edge edge) {
        ListCell listCell = this.b.findCell(edge);
        if (listCell == null) {
            EdgeList edgeList = new EdgeList();
            edgeList.add(edge);
            return edgeList.edges();
        }
        EdgeList edgeList = (EdgeList)this.e.get(edge);
        return edgeList.edges();
    }

    public Edge getUnsplitEdge(Edge edge) {
        Edge edge2 = (Edge)this.h.get(edge);
        if (edge2 == null) {
            edge2 = edge;
        }
        return edge2;
    }

    public void updateEdgeRecoveryInfo(Edge edge, EdgeList edgeList, int n) {
        if (n == 0) {
            if (this.getEdgeInfo(edge).d()) {
                ListCell listCell = this.b.findCell(edge);
                if (listCell == null) {
                    this.b.add(edge);
                }
                this.e.set(edge, edgeList);
                EdgeCursor edgeCursor = edgeList.edges();
                while (edgeCursor.ok()) {
                    Edge edge2 = edgeCursor.edge();
                    this.h.set(edge2, edge);
                    this.e.set(edge2, edgeList);
                    edgeCursor.next();
                }
            } else {
                Object object;
                EdgeList edgeList2 = (EdgeList)this.e.get(edge);
                ListCell listCell = edgeList2.findCell(edge);
                Edge edge3 = (Edge)this.h.get(listCell.getInfo());
                ListCell listCell2 = listCell;
                EdgeCursor edgeCursor = edgeList.edges();
                while (edgeCursor.ok()) {
                    object = edgeCursor.edge();
                    this.h.set(object, edge3);
                    edgeList2.insertAfter(object, listCell2);
                    listCell2 = edgeList2.succCell(listCell2);
                    edgeCursor.next();
                }
                edgeList2.removeCell(listCell);
                object = edgeList2.edges();
                while (object.ok()) {
                    this.e.set(object.edge(), edgeList2);
                    object.next();
                }
            }
        } else if (n == 1) {
            EdgeCursor edgeCursor = edgeList.edges();
            this.e.set(edge, this.e.get(edgeCursor.edge()));
            this.h.set(edge, this.h.get(edgeCursor.edge()));
            EdgeList edgeList3 = (EdgeList)this.e.get(edge);
            ListCell listCell = edgeList3.findCell(edgeCursor.edge());
            edgeList3.insertBefore(edge, listCell);
            while (edgeCursor.ok()) {
                if (edgeCursor.edge() != edgeList3.getInfo(listCell)) {
                    throw new RuntimeException("WRONG SEGMENTS IN EDGE RECOVERY");
                }
                ListCell listCell3 = edgeList3.succCell(listCell);
                edgeList3.removeCell(listCell);
                listCell = listCell3;
                edgeCursor.next();
            }
            if (edgeList3.size() == 1) {
                this.b.remove(edge);
                this.markAsOriginalEdge(edge);
            }
        } else {
            throw new RuntimeException("UNSPECIFIED EDGE RECOVERY");
        }
    }

    public void doEdgeRecovery() {
        Object object;
        LayoutGraph layoutGraph = (LayoutGraph)this.graph;
        Vector<YPoint> vector = new Vector<YPoint>();
        EdgeCursor edgeCursor = this.b.edges();
        while (edgeCursor.ok()) {
            vector.clear();
            object = edgeCursor.edge();
            this.b((Edge)object);
            EdgeCursor edgeCursor2 = ((EdgeList)this.e.get(object)).edges();
            while (edgeCursor2.ok()) {
                YPointPath yPointPath = layoutGraph.getPoints(edgeCursor2.edge());
                YPointCursor yPointCursor = yPointPath.points();
                while (yPointCursor.ok()) {
                    vector.add(yPointCursor.point());
                    yPointCursor.next();
                }
                if (this.isBend(edgeCursor2.edge().target())) {
                    vector.add(layoutGraph.getCenter(edgeCursor2.edge().target()));
                }
                edgeCursor2.next();
            }
            layoutGraph.setPoints((Edge)object, new YPointPath(vector));
            edgeCursor2.toFirst();
            layoutGraph.setSourcePointRel((Edge)object, layoutGraph.getSourcePointRel(edgeCursor2.edge()));
            edgeCursor2.toLast();
            layoutGraph.setTargetPointRel((Edge)object, layoutGraph.getTargetPointRel(edgeCursor2.edge()));
            this.e.set(edgeCursor.edge(), null);
            edgeCursor.next();
        }
        this.b.clear();
        object = this.graph.nodes();
        while (object.ok()) {
            if (this.isCrossing(object.node()) || this.isBend(object.node())) {
                this.a(object.node());
            }
            object.next();
        }
    }

    public void doRemoveOriginalEdges(EdgeList edgeList) {
        EdgeCursor edgeCursor = edgeList.edges();
        while (edgeCursor.ok()) {
            ListCell listCell = this.b.findCell(edgeCursor.edge());
            if (listCell == null) {
                this.unsplitFace(edgeCursor.edge());
            } else {
                Object object;
                NodeList nodeList = new NodeList();
                EdgeList edgeList2 = (EdgeList)this.e.get(edgeCursor.edge());
                this.b.removeCell(listCell);
                EdgeCursor edgeCursor2 = edgeList2.edges();
                while (edgeCursor2.ok()) {
                    object = edgeCursor2.edge();
                    this.unsplitFace((Edge)object);
                    if (((Edge)object).target() != edgeCursor.edge().target()) {
                        nodeList.add(edgeCursor2.edge().target());
                    }
                    edgeCursor2.next();
                }
                object = nodeList.nodes();
                while (object.ok()) {
                    this.unsubdivideEdge(object.node());
                    object.next();
                }
            }
            edgeCursor.next();
        }
    }

    public void markAsOriginalEdge(Edge edge) {
        this.getEdgeInfo(edge).b(true);
    }

    protected NodeInfo getNodeInfo(Node node) {
        NodeInfo nodeInfo = (NodeInfo)this.g.get(node);
        if (nodeInfo == null) {
            nodeInfo = this.createNodeInfo();
            this.g.set(node, nodeInfo);
        }
        return nodeInfo;
    }

    protected NodeInfo createNodeInfo() {
        return new NodeInfo();
    }

    protected EdgeInfo getEdgeInfo(Edge edge) {
        return (EdgeInfo)this.getSimpleEdgeInfo(edge);
    }

    protected EdgeInfo createEdgeInfo() {
        return new EdgeInfo();
    }

    protected SimplePlanarInformation.SimpleEdgeInfo createSimpleEdgeInfo() {
        return this.createEdgeInfo();
    }

    private void a(Edge edge) {
        if (this.getEdgeInfo(edge).d()) {
            this.graph.hide(edge);
        } else {
            this.graph.removeEdge(edge);
        }
    }

    private void b(Edge edge) {
        if (!this.getEdgeInfo(edge).d()) {
            throw new RuntimeException("Tried to reinsert non-original edge !");
        }
        this.graph.unhide(edge);
    }

    private void a(Node node) {
        EdgeCursor edgeCursor = node.edges();
        while (edgeCursor.ok()) {
            this.a(edgeCursor.edge());
            edgeCursor.next();
        }
        this.graph.removeNode(node);
    }

    public void checkEdgeRecovery() {
        Object object;
        Object object2;
        boolean[] blArray = new boolean[this.graph.edgeCount()];
        EdgeCursor edgeCursor = this.b.edges();
        while (edgeCursor.ok()) {
            object2 = edgeCursor.edge();
            object = (EdgeList)this.e.get(object2);
            if (((EdgeList)object).firstEdge().source() != ((Edge)object2).source()) {
                throw new RuntimeException("Path has wrong source !!");
            }
            if (((EdgeList)object).lastEdge().target() != ((Edge)object2).target()) {
                throw new RuntimeException("Path has wrong target !!");
            }
            Edge edge = null;
            EdgeCursor edgeCursor2 = ((EdgeList)object).edges();
            while (edgeCursor2.ok()) {
                Edge edge2 = edgeCursor2.edge();
                if (this.h.get(edge2) != object2) {
                    throw new RuntimeException("Wrong backlink in segmentsToEdge : " + object2);
                }
                if (edge != null && edge.target() != edge2.source()) {
                    throw new RuntimeException("Recovery info is no path :" + object2);
                }
                edge = edge2;
                blArray[edge2.index()] = true;
                edgeCursor2.next();
            }
            edgeCursor.next();
        }
        object2 = this.graph.edges();
        while (object2.ok()) {
            object = object2.edge();
            if (!(this.isInsertedEdge((Edge)object) || this.getEdgeInfo((Edge)object).d() || blArray[((Edge)object).index()])) {
                throw new RuntimeException("Edge " + object + " is contained in no path");
            }
            object2.next();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void showEdgeRecoveryInfo(boolean var1_1) {
        block3: {
            var5_2 = this.b.edges();
            D.bug(0, "Edge recovery info:");
            if (!var1_1) ** GOTO lbl18
            while (var5_2.ok()) {
                var2_3 = var5_2.edge();
                var4_5 = ((EdgeList)this.e.get(var2_3)).edges();
                while (var4_5.ok()) {
                    D.bug(0, "    segment: " + var4_5.edge() + " org. Edge: " + (Edge)this.h.get(var4_5.edge()));
                    var4_5.next();
                }
                var5_2.next();
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                var2_4 = var5_2.edge();
                var3_6 = (EdgeList)this.e.get(var2_4);
                D.bug(0, "edge: " + var2_4 + " segments: " + var3_6);
                var5_2.next();
lbl18:
                // 2 sources

                ** while (var5_2.ok())
            }
        }
    }

    public static class EdgeInfo
    extends SimplePlanarInformation.SimpleEdgeInfo {
        private boolean d;

        boolean d() {
            return this.d;
        }

        void b(boolean bl) {
            this.d = bl;
        }
    }

    public static class NodeInfo {
        private int a = 0;

        int a() {
            return this.a;
        }

        void a(int n) {
            this.a = n;
        }
    }
}

