/*
 * Decompiled with CFR 0.152.
 */
package y.geom;

import y.geom.AffineLine;
import y.geom.PlaneObject;
import y.geom.YPoint;
import y.geom.YRectangle;
import y.geom.YVector;
import y.util.D;

public class LineSegment
implements PlaneObject {
    private YPoint o;
    private YPoint m;
    private double l;
    private double k;
    private static double n = 1.0E-8;

    public LineSegment(YPoint yPoint, YPoint yPoint2) {
        this.o = yPoint;
        this.m = yPoint2;
        if (yPoint2.getX() == yPoint.getX()) {
            if (yPoint.getY() < yPoint2.getY()) {
                this.l = Double.MAX_VALUE;
                this.k = Double.NaN;
            } else {
                this.l = Double.MIN_VALUE;
                this.k = Double.NaN;
            }
        } else {
            this.l = (yPoint2.getY() - yPoint.getY()) / (yPoint2.getX() - yPoint.getX());
            this.k = yPoint.getY() - yPoint.getX() * this.l;
        }
    }

    public YPoint getFirstEndPoint() {
        return this.o;
    }

    public YPoint getSecondEndPoint() {
        return this.m;
    }

    public boolean isInYIntervall(double d2) {
        if (this.o.getY() < this.m.getY()) {
            return d2 > this.o.getY() + n && d2 < this.m.getY() - n;
        }
        return d2 > this.m.getY() + n && d2 < this.o.getY() - n;
    }

    public boolean isInXIntervall(double d2) {
        if (this.o.getX() < this.m.getX()) {
            return d2 > this.o.getX() + n && d2 < this.m.getX() - n;
        }
        return d2 > this.m.getX() + n && d2 < this.o.getX() - n;
    }

    public double getXOffset() {
        return this.k;
    }

    public double getScope() {
        return this.l;
    }

    public double length() {
        return this.toYVector().length();
    }

    public YRectangle getBoundingBox() {
        double d2 = this.o.getX() < this.m.getX() ? this.o.getX() : this.m.getX();
        double d3 = this.o.getX() > this.m.getX() ? this.o.getX() : this.m.getX();
        double d4 = this.o.getY() < this.m.getY() ? this.o.getY() : this.m.getY();
        double d5 = this.o.getY() > this.m.getY() ? this.o.getY() : this.m.getY();
        return new YRectangle(d2, d4, d3 - d2, d5 - d4);
    }

    public boolean intersects(YRectangle yRectangle) {
        return LineSegment.boxIntersectsSegment(yRectangle, this.o.getX(), this.o.getY(), this.m.getX(), this.m.getY());
    }

    public boolean contains(YPoint yPoint) {
        YRectangle yRectangle = new YRectangle(yPoint.getX() - n, yPoint.getY() - n, 2.0 * n, 2.0 * n);
        return LineSegment.boxIntersectsSegment(yRectangle, this.o.getX(), this.o.getY(), this.m.getX(), this.m.getY());
    }

    public boolean intersects(YPoint yPoint) {
        YRectangle yRectangle = new YRectangle(yPoint.getX() - 0.01, yPoint.getY() - 0.01, 0.02, 0.02);
        return LineSegment.boxIntersectsSegment(yRectangle, this.o.getX(), this.o.getY(), this.m.getX(), this.m.getY());
    }

    public static final boolean boxIntersectsSegment(YRectangle yRectangle, YPoint yPoint, YPoint yPoint2) {
        return LineSegment.boxIntersectsSegment(yRectangle, yPoint.getX(), yPoint.getY(), yPoint2.getX(), yPoint2.getY());
    }

    public static final boolean boxIntersectsSegment(YRectangle yRectangle, double d2, double d3, double d4, double d5) {
        double d6 = yRectangle.getX();
        double d7 = yRectangle.getX() + yRectangle.getWidth();
        double d8 = yRectangle.getY();
        double d9 = yRectangle.getY() + yRectangle.getHeight();
        int n = 0;
        int n2 = 0;
        if (d2 <= d6) {
            n |= 1;
        }
        if (d2 >= d7) {
            n |= 2;
        }
        if (d3 <= d8) {
            n |= 4;
        }
        if (d3 >= d9) {
            n |= 8;
        }
        if (d4 <= d6) {
            n2 |= 1;
        }
        if (d4 >= d7) {
            n2 |= 2;
        }
        if (d5 <= d8) {
            n2 |= 4;
        }
        if (d5 >= d9) {
            n2 |= 8;
        }
        if ((n & n2) != 0) {
            return false;
        }
        if ((n | n2) == 0) {
            return true;
        }
        double d10 = (d5 - d3) / (d4 - d2);
        double d11 = d2 + (d9 - d3) / d10;
        if (d11 > d6 && d11 < d7) {
            return true;
        }
        double d12 = d2 + (d8 - d3) / d10;
        if (d12 > d6 && d12 < d7) {
            return true;
        }
        double d13 = d3 + (d6 - d2) * d10;
        if (d13 > d8 && d13 < d9) {
            return true;
        }
        double d14 = d3 + (d7 - d2) * d10;
        return d14 > d8 && d14 < d9;
    }

    public static YPoint getIntersection(LineSegment lineSegment, LineSegment lineSegment2) {
        double d2;
        Object object;
        D.bug(14, "Segment 1: " + lineSegment);
        D.bug(14, "Segment 2: " + lineSegment2);
        if (Math.abs(lineSegment2.getFirstEndPoint().getX() - lineSegment2.getSecondEndPoint().getX()) < n) {
            object = lineSegment;
            lineSegment = lineSegment2;
            lineSegment2 = object;
        }
        if (Math.abs(lineSegment.getFirstEndPoint().getX() - lineSegment.getSecondEndPoint().getX()) < n) {
            if (!lineSegment2.isInXIntervall(lineSegment.getFirstEndPoint().getX())) {
                return null;
            }
            object = new Double(lineSegment2.getScope());
            if (((Double)object).isInfinite() || ((Double)object).isNaN()) {
                return null;
            }
            Double d3 = new Double(lineSegment2.getXOffset());
            if (d3.isInfinite() || d3.isNaN()) {
                return null;
            }
            double d4 = lineSegment2.getXOffset() + lineSegment2.getScope() * lineSegment.getFirstEndPoint().getX();
            if (!lineSegment.isInYIntervall(d4)) {
                return null;
            }
            return new YPoint(lineSegment.getFirstEndPoint().getX(), d4);
        }
        double d5 = lineSegment.getScope();
        if (d5 == (d2 = lineSegment2.getScope())) {
            return null;
        }
        double d6 = (lineSegment2.getXOffset() - lineSegment.getXOffset()) / (d5 - d2);
        D.bug(14, "m1: " + d5 + " x1: " + lineSegment.getXOffset());
        D.bug(14, "m2: " + d2 + " x2: " + lineSegment2.getXOffset());
        D.bug(14, "XI: " + d6);
        if (lineSegment.isInXIntervall(d6) && lineSegment2.isInXIntervall(d6)) {
            return new YPoint(d6, d6 * d5 + lineSegment.getXOffset());
        }
        return null;
    }

    public YVector toYVector() {
        return new YVector(this.m, this.o);
    }

    public AffineLine toAffineLine() {
        return new AffineLine(this.m, this.o);
    }

    public String toString() {
        return "SP: " + this.o.toString() + " TP: " + this.m.toString();
    }
}

