/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf;

import com.jidesoft.icons.IconsFactory;
import com.jidesoft.icons.JideIconsFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.XPUtils;
import com.jidesoft.plaf.basic.BasicPainter;
import com.jidesoft.plaf.basic.Painter;
import com.jidesoft.plaf.eclipse.Eclipse3xWindowsUtils;
import com.jidesoft.plaf.eclipse.EclipseMetalUtils;
import com.jidesoft.plaf.eclipse.EclipseWindowsUtils;
import com.jidesoft.plaf.office2003.Office2003Painter;
import com.jidesoft.plaf.office2003.Office2003WindowsUtils;
import com.jidesoft.plaf.office2007.Office2007WindowsUtils;
import com.jidesoft.plaf.vsnet.VsnetMetalUtils;
import com.jidesoft.plaf.vsnet.VsnetWindowsUtils;
import com.jidesoft.plaf.xerto.XertoMetalUtils;
import com.jidesoft.plaf.xerto.XertoWindowsUtils;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.ProductNames;
import com.jidesoft.utils.SecurityUtils;
import com.jidesoft.utils.SystemInfo;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import sun.swing.SwingLazyValue;

public class LookAndFeelFactory
implements ProductNames {
    public static final String WINDOWS_LNF = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    public static final String METAL_LNF = "javax.swing.plaf.metal.MetalLookAndFeel";
    public static final String AQUA_LNF = "apple.laf.AquaLookAndFeel";
    public static final String AQUA_LNF_6 = "com.apple.laf.AquaLookAndFeel";
    public static final String QUAQUA_LNF = "ch.randelshofer.quaqua.QuaquaLookAndFeel";
    public static final String ALLOY_LNF = "com.incors.plaf.alloy.AlloyLookAndFeel";
    public static final String SYNTHETICA_LNF = "de.javasoft.plaf.synthetica.SyntheticaLookAndFeel";
    public static final String SYNTHETICA_LNF_PREFIX = "de.javasoft.plaf.synthetica.Synthetica";
    public static final String PLASTIC3D_LNF = "com.jgoodies.plaf.plastic.Plastic3DLookAndFeel";
    public static final String PLASTIC3D_LNF_1_3 = "com.jgoodies.looks.plastic.Plastic3DLookAndFeel";
    public static final String PLASTICXP_LNF = "com.jgoodies.looks.plastic.PlasticXPLookAndFeel";
    public static final String TONIC_LNF = "com.digitprop.tonic.TonicLookAndFeel";
    public static final String A03_LNF = "a03.swing.plaf.A03LookAndFeel";
    public static final String PGS_LNF = "com.pagosoft.plaf.PgsLookAndFeel";
    public static final String GTK_LNF = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
    public static final String NIMBUS_LNF_NAME = "NimbusLookAndFeel";
    public static final int VSNET_STYLE_WITHOUT_MENU = 0;
    public static final int VSNET_STYLE = 1;
    public static final int ECLIPSE_STYLE = 2;
    public static final int OFFICE2003_STYLE = 3;
    public static final int XERTO_STYLE = 4;
    public static final int XERTO_STYLE_WITHOUT_MENU = 6;
    public static final int ECLIPSE3X_STYLE = 5;
    public static final int OFFICE2007_STYLE = 7;
    private static int _style = -1;
    private static int _defaultStyle = -1;
    private static LookAndFeel _lookAndFeel;
    public static final String JIDE_EXTENSION_INSTALLLED = "jidesoft.extendsionInstalled";
    public static final String JIDE_STYLE_INSTALLED = "jidesoft.extendsionStyle";
    private static List<UIDefaultsCustomizer> _uiDefaultsCustomizers;
    private static List<UIDefaultsInitializer> _uiDefaultsInitializers;
    private static Map<String, String> _installedLookAndFeels;
    public static final String LAF_INSTALLED = "installed";
    public static final String LAF_NOT_INSTALLED = "not installed";
    private static int _productsUsed;

    static {
        _uiDefaultsCustomizers = new Vector<UIDefaultsCustomizer>();
        _uiDefaultsInitializers = new Vector<UIDefaultsInitializer>();
        _installedLookAndFeels = new HashMap<String, String>();
        _productsUsed = -1;
    }

    protected LookAndFeelFactory() {
    }

    public static int getDefaultStyle() {
        if (_defaultStyle == -1) {
            String defaultStyle = SecurityUtils.getProperty("jide.defaultStyle", "-1");
            try {
                _defaultStyle = Integer.parseInt(defaultStyle);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (_defaultStyle == -1) {
                int suggestedStyle;
                try {
                    suggestedStyle = SystemInfo.isWindowsVistaAbove() && UIManager.getLookAndFeel() instanceof WindowsLookAndFeel && SystemInfo.isJdk6Above() ? 7 : (XPUtils.isXPStyleOn() && UIManager.getLookAndFeel() instanceof WindowsLookAndFeel ? 3 : ((LookAndFeelFactory.getProductsUsed() & 0x10) == 0 ? 0 : 1));
                }
                catch (UnsupportedOperationException e) {
                    suggestedStyle = (LookAndFeelFactory.getProductsUsed() & 0x10) == 0 ? 0 : 1;
                }
                return suggestedStyle;
            }
        }
        return _defaultStyle;
    }

    public static void setDefaultStyle(int defaultStyle) {
        _defaultStyle = defaultStyle;
    }

    public static void installJideExtension() {
        LookAndFeelFactory.installJideExtension(LookAndFeelFactory.getDefaultStyle());
    }

    public static void installJideExtension(int style) {
        LookAndFeelFactory.installJideExtension(UIManager.getLookAndFeelDefaults(), UIManager.getLookAndFeel(), style);
    }

    public static boolean isJideExtensionInstalled() {
        return UIDefaultsLookup.getBoolean(JIDE_EXTENSION_INSTALLLED);
    }

    public static void installJideExtension(UIDefaults uiDefaults, LookAndFeel lnf, int style) {
        UIDefaultsCustomizer[] customizers;
        UIDefaultsInitializer[] initializers;
        if (LookAndFeelFactory.isJideExtensionInstalled() && _style == style && _lookAndFeel == lnf) {
            return;
        }
        _style = style;
        uiDefaults.put(JIDE_STYLE_INSTALLED, (Object)_style);
        _lookAndFeel = lnf;
        UIDefaultsInitializer[] uIDefaultsInitializerArray = initializers = LookAndFeelFactory.getUIDefaultsInitializers();
        int n = initializers.length;
        int n2 = 0;
        while (n2 < n) {
            UIDefaultsInitializer initializer = uIDefaultsInitializerArray[n2];
            if (initializer != null) {
                initializer.initialize(uiDefaults);
            }
            ++n2;
        }
        if (lnf.getClass().getName().equals(ALLOY_LNF) && LookAndFeelFactory.isAlloyLnfInstalled() || lnf.getClass().getName().equals(PLASTIC3D_LNF) && LookAndFeelFactory.isPlastic3DLnfInstalled() || lnf.getClass().getName().equals(PLASTIC3D_LNF_1_3) && LookAndFeelFactory.isPlastic3D13LnfInstalled() || lnf.getClass().getName().equals(PLASTICXP_LNF) && LookAndFeelFactory.isPlasticXPLnfInstalled() || lnf.getClass().getName().equals(PGS_LNF) && LookAndFeelFactory.isPgsLnfInstalled() || lnf.getClass().getName().equals(TONIC_LNF) && LookAndFeelFactory.isTonicLnfInstalled()) {
            switch (style) {
                case 7: {
                    VsnetWindowsUtils.initComponentDefaults(uiDefaults);
                    Office2003WindowsUtils.initComponentDefaults(uiDefaults);
                    Office2007WindowsUtils.initComponentDefaults(uiDefaults);
                    Office2007WindowsUtils.initClassDefaults(uiDefaults, false);
                    break;
                }
                case 3: {
                    VsnetWindowsUtils.initComponentDefaults(uiDefaults);
                    Office2003WindowsUtils.initComponentDefaults(uiDefaults);
                    Office2003WindowsUtils.initClassDefaults(uiDefaults, false);
                    break;
                }
                case 0: 
                case 1: {
                    VsnetMetalUtils.initComponentDefaults(uiDefaults);
                    VsnetMetalUtils.initClassDefaults(uiDefaults);
                    Painter gripperPainter = new Painter(){

                        public void paint(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
                            Office2003Painter.getInstance().paintGripper(c, g, rect, orientation, state);
                        }
                    };
                    uiDefaults.put("Gripper.painter", gripperPainter);
                    uiDefaults.put("JideTabbedPane.gripperPainter", gripperPainter);
                    uiDefaults.put("JideTabbedPane.defaultTabShape", (Object)4);
                    uiDefaults.put("JideTabbedPane.selectedTabTextForeground", UIDefaultsLookup.getColor("controlText"));
                    uiDefaults.put("JideTabbedPane.unselectedTabTextForeground", UIDefaultsLookup.getColor("controlText"));
                    uiDefaults.put("JideTabbedPane.foreground", UIDefaultsLookup.getColor("controlText"));
                    uiDefaults.put("JideTabbedPane.light", UIDefaultsLookup.getColor("control"));
                    uiDefaults.put("JideSplitPaneDivider.gripperPainter", gripperPainter);
                    int products = LookAndFeelFactory.getProductsUsed();
                    if ((products & 1) == 0) break;
                    ImageIcon titleButtonImage = IconsFactory.getImageIcon(VsnetWindowsUtils.class, "icons/title_buttons_windows.gif");
                    int titleButtonSize = 10;
                    uiDefaults.put("DockableFrameUI", "com.jidesoft.plaf.vsnet.VsnetDockableFrameUI");
                    uiDefaults.put("DockableFrameTitlePane.hideIcon", IconsFactory.getIcon(null, titleButtonImage, 0, 0, 10, 10));
                    uiDefaults.put("DockableFrameTitlePane.unfloatIcon", IconsFactory.getIcon(null, titleButtonImage, 0, 10, 10, 10));
                    uiDefaults.put("DockableFrameTitlePane.floatIcon", IconsFactory.getIcon(null, titleButtonImage, 0, 20, 10, 10));
                    uiDefaults.put("DockableFrameTitlePane.autohideIcon", IconsFactory.getIcon(null, titleButtonImage, 0, 30, 10, 10));
                    uiDefaults.put("DockableFrameTitlePane.stopAutohideIcon", IconsFactory.getIcon(null, titleButtonImage, 0, 40, 10, 10));
                    uiDefaults.put("DockableFrameTitlePane.hideAutohideIcon", IconsFactory.getIcon(null, titleButtonImage, 0, 50, 10, 10));
                    uiDefaults.put("DockableFrameTitlePane.maximizeIcon", IconsFactory.getIcon(null, titleButtonImage, 0, 60, 10, 10));
                    uiDefaults.put("DockableFrameTitlePane.restoreIcon", IconsFactory.getIcon(null, titleButtonImage, 0, 70, 10, 10));
                    uiDefaults.put("DockableFrameTitlePane.buttonGap", (Object)4);
                    uiDefaults.put("DockableFrame.titleBorder", new BorderUIResource(BorderFactory.createEmptyBorder(1, 0, 2, 0)));
                    uiDefaults.put("DockableFrame.border", new BorderUIResource(BorderFactory.createEmptyBorder(2, 0, 0, 0)));
                    uiDefaults.put("DockableFrameTitlePane.gripperPainter", gripperPainter);
                    break;
                }
                case 2: {
                    EclipseMetalUtils.initComponentDefaults(uiDefaults);
                    EclipseMetalUtils.initClassDefaults(uiDefaults);
                    break;
                }
                case 5: {
                    Eclipse3xWindowsUtils.initComponentDefaults(uiDefaults);
                    Eclipse3xWindowsUtils.initClassDefaults(uiDefaults);
                    break;
                }
                case 4: 
                case 6: {
                    XertoMetalUtils.initComponentDefaults(uiDefaults);
                    XertoMetalUtils.initClassDefaults(uiDefaults);
                }
            }
            uiDefaults.put("Theme.painter", BasicPainter.getInstance());
        } else if (lnf.getClass().getName().equals(MetalLookAndFeel.class.getName())) {
            switch (style) {
                case 1: 
                case 3: 
                case 7: {
                    VsnetMetalUtils.initComponentDefaults(uiDefaults);
                    VsnetMetalUtils.initClassDefaultsWithMenu(uiDefaults);
                    break;
                }
                case 2: {
                    EclipseMetalUtils.initComponentDefaults(uiDefaults);
                    EclipseMetalUtils.initClassDefaults(uiDefaults);
                    break;
                }
                case 5: {
                    Eclipse3xWindowsUtils.initComponentDefaults(uiDefaults);
                    Eclipse3xWindowsUtils.initClassDefaults(uiDefaults);
                    break;
                }
                case 0: {
                    VsnetMetalUtils.initComponentDefaults(uiDefaults);
                    VsnetMetalUtils.initClassDefaults(uiDefaults);
                    break;
                }
                case 4: 
                case 6: {
                    XertoMetalUtils.initComponentDefaults(uiDefaults);
                    XertoMetalUtils.initClassDefaults(uiDefaults);
                }
            }
        } else if (lnf instanceof MetalLookAndFeel) {
            switch (style) {
                case 0: 
                case 1: 
                case 3: 
                case 7: {
                    VsnetMetalUtils.initComponentDefaults(uiDefaults);
                    VsnetMetalUtils.initClassDefaults(uiDefaults);
                    break;
                }
                case 2: {
                    EclipseMetalUtils.initClassDefaults(uiDefaults);
                    EclipseMetalUtils.initComponentDefaults(uiDefaults);
                    break;
                }
                case 5: {
                    Eclipse3xWindowsUtils.initComponentDefaults(uiDefaults);
                    Eclipse3xWindowsUtils.initClassDefaults(uiDefaults);
                    break;
                }
                case 4: 
                case 6: {
                    XertoMetalUtils.initComponentDefaults(uiDefaults);
                    XertoMetalUtils.initClassDefaults(uiDefaults);
                }
            }
        } else if (lnf instanceof WindowsLookAndFeel) {
            switch (style) {
                case 7: {
                    VsnetWindowsUtils.initComponentDefaultsWithMenu(uiDefaults);
                    VsnetWindowsUtils.initClassDefaultsWithMenu(uiDefaults);
                    Office2003WindowsUtils.initComponentDefaults(uiDefaults);
                    Office2007WindowsUtils.initComponentDefaults(uiDefaults);
                    Office2007WindowsUtils.initClassDefaults(uiDefaults);
                    break;
                }
                case 3: {
                    VsnetWindowsUtils.initComponentDefaultsWithMenu(uiDefaults);
                    VsnetWindowsUtils.initClassDefaultsWithMenu(uiDefaults);
                    Office2003WindowsUtils.initClassDefaults(uiDefaults);
                    Office2003WindowsUtils.initComponentDefaults(uiDefaults);
                    break;
                }
                case 2: {
                    EclipseWindowsUtils.initClassDefaultsWithMenu(uiDefaults);
                    EclipseWindowsUtils.initComponentDefaultsWithMenu(uiDefaults);
                    break;
                }
                case 5: {
                    Eclipse3xWindowsUtils.initComponentDefaults(uiDefaults);
                    Eclipse3xWindowsUtils.initClassDefaults(uiDefaults);
                    break;
                }
                case 1: {
                    VsnetWindowsUtils.initComponentDefaultsWithMenu(uiDefaults);
                    VsnetWindowsUtils.initClassDefaultsWithMenu(uiDefaults);
                    break;
                }
                case 0: {
                    VsnetWindowsUtils.initComponentDefaults(uiDefaults);
                    VsnetWindowsUtils.initClassDefaults(uiDefaults);
                    break;
                }
                case 4: {
                    XertoWindowsUtils.initComponentDefaultsWithMenu(uiDefaults);
                    XertoWindowsUtils.initClassDefaultsWithMenu(uiDefaults);
                    break;
                }
                case 6: {
                    XertoWindowsUtils.initComponentDefaults(uiDefaults);
                    XertoWindowsUtils.initClassDefaults(uiDefaults);
                }
            }
        } else if (LookAndFeelFactory.isAquaLnfInstalled() && (LookAndFeelFactory.isLnfInUse(AQUA_LNF_6) || LookAndFeelFactory.isLnfInUse(AQUA_LNF)) || LookAndFeelFactory.isQuaquaLnfInstalled() && LookAndFeelFactory.isLnfInUse(QUAQUA_LNF)) {
            try {
                Class<?> aquaJideUtils = LookAndFeelFactory.getUIManagerClassLoader().loadClass("com.jidesoft.plaf.aqua.AquaJideUtils");
                aquaJideUtils.getMethod("initComponentDefaults", UIDefaults.class).invoke(null, uiDefaults);
                aquaJideUtils.getMethod("initClassDefaults", UIDefaults.class).invoke(null, uiDefaults);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                JideSwingUtilities.throwInvocationTargetException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
        } else {
            if (LookAndFeelFactory.isGTKLnfInstalled() && LookAndFeelFactory.isLnfInUse(GTK_LNF)) {
                new GTKInitializer().initialize(uiDefaults);
            } else if (LookAndFeelFactory.isSyntheticaLnfInstalled() && (lnf.getClass().getName().startsWith(SYNTHETICA_LNF_PREFIX) || LookAndFeelFactory.isLnfInUse(SYNTHETICA_LNF))) {
                new SyntheticaInitializer().initialize(uiDefaults);
            } else if (LookAndFeelFactory.isNimbusLnfInstalled() && lnf.getClass().getName().indexOf(NIMBUS_LNF_NAME) != -1) {
                new NimbusInitializer().initialize(uiDefaults);
            }
            switch (style) {
                case 7: {
                    if (SystemInfo.isWindows()) {
                        VsnetWindowsUtils.initComponentDefaultsWithMenu(uiDefaults);
                        Office2003WindowsUtils.initComponentDefaults(uiDefaults);
                        Office2007WindowsUtils.initComponentDefaults(uiDefaults);
                        Office2007WindowsUtils.initClassDefaults(uiDefaults);
                        break;
                    }
                    VsnetMetalUtils.initComponentDefaults(uiDefaults);
                    VsnetMetalUtils.initClassDefaults(uiDefaults);
                    break;
                }
                case 3: {
                    if (SystemInfo.isWindows()) {
                        VsnetWindowsUtils.initComponentDefaultsWithMenu(uiDefaults);
                        Office2003WindowsUtils.initComponentDefaults(uiDefaults);
                        Office2003WindowsUtils.initClassDefaults(uiDefaults);
                        break;
                    }
                    VsnetMetalUtils.initComponentDefaults(uiDefaults);
                    VsnetMetalUtils.initClassDefaults(uiDefaults);
                    break;
                }
                case 2: {
                    if (SystemInfo.isWindows()) {
                        EclipseWindowsUtils.initClassDefaultsWithMenu(uiDefaults);
                        EclipseWindowsUtils.initComponentDefaultsWithMenu(uiDefaults);
                        break;
                    }
                    EclipseMetalUtils.initClassDefaults(uiDefaults);
                    EclipseMetalUtils.initComponentDefaults(uiDefaults);
                    break;
                }
                case 5: {
                    Eclipse3xWindowsUtils.initClassDefaults(uiDefaults);
                    Eclipse3xWindowsUtils.initComponentDefaults(uiDefaults);
                    break;
                }
                case 1: {
                    if (SystemInfo.isWindows()) {
                        VsnetWindowsUtils.initClassDefaultsWithMenu(uiDefaults);
                        VsnetWindowsUtils.initComponentDefaultsWithMenu(uiDefaults);
                        break;
                    }
                    VsnetMetalUtils.initComponentDefaults(uiDefaults);
                    VsnetMetalUtils.initClassDefaults(uiDefaults);
                    break;
                }
                case 0: {
                    if (SystemInfo.isWindows()) {
                        VsnetWindowsUtils.initClassDefaults(uiDefaults);
                        VsnetWindowsUtils.initComponentDefaults(uiDefaults);
                        break;
                    }
                    VsnetMetalUtils.initComponentDefaults(uiDefaults);
                    VsnetMetalUtils.initClassDefaults(uiDefaults);
                    break;
                }
                case 4: {
                    if (SystemInfo.isWindows()) {
                        XertoWindowsUtils.initClassDefaultsWithMenu(uiDefaults);
                        XertoWindowsUtils.initComponentDefaultsWithMenu(uiDefaults);
                        break;
                    }
                    XertoMetalUtils.initComponentDefaults(uiDefaults);
                    XertoMetalUtils.initClassDefaults(uiDefaults);
                    break;
                }
                case 6: {
                    if (SystemInfo.isWindows()) {
                        XertoWindowsUtils.initClassDefaults(uiDefaults);
                        XertoWindowsUtils.initComponentDefaults(uiDefaults);
                        break;
                    }
                    XertoMetalUtils.initComponentDefaults(uiDefaults);
                    XertoMetalUtils.initClassDefaults(uiDefaults);
                }
            }
            if (lnf.getClass().getName().startsWith(SYNTHETICA_LNF_PREFIX) || LookAndFeelFactory.isLnfInstalled(SYNTHETICA_LNF) && LookAndFeelFactory.isLnfInUse(SYNTHETICA_LNF)) {
                new SyntheticaCustomizer().customize(uiDefaults);
            }
        }
        uiDefaults.put(JIDE_EXTENSION_INSTALLLED, Boolean.TRUE);
        UIDefaultsCustomizer[] uIDefaultsCustomizerArray = customizers = LookAndFeelFactory.getUIDefaultsCustomizers();
        int n3 = customizers.length;
        n = 0;
        while (n < n3) {
            UIDefaultsCustomizer customizer = uIDefaultsCustomizerArray[n];
            if (customizer != null) {
                customizer.customize(uiDefaults);
            }
            ++n;
        }
    }

    public static boolean isLnfInstalled(String lnfName) {
        String installed = _installedLookAndFeels.get(lnfName);
        if (installed != null) {
            return LAF_INSTALLED.equals(installed);
        }
        return LookAndFeelFactory.loadLnfClass(lnfName) != null;
    }

    public static ClassLoader getUIManagerClassLoader() {
        Object cl = UIManager.get("ClassLoader");
        if (cl instanceof ClassLoader) {
            return (ClassLoader)cl;
        }
        ClassLoader classLoader = LookAndFeelFactory.class.getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    public static boolean isLnfInUse(String lnfName) {
        return (!_installedLookAndFeels.containsKey(lnfName) || _installedLookAndFeels.get(lnfName) != null && !_installedLookAndFeels.get(lnfName).equals(LAF_NOT_INSTALLED)) && LookAndFeelFactory.isAssignableFrom(lnfName, UIManager.getLookAndFeel().getClass());
    }

    public static void setLnfInstalled(String lnfName, boolean installed) {
        _installedLookAndFeels.put(lnfName, installed ? LAF_INSTALLED : LAF_NOT_INSTALLED);
    }

    private static Class loadLnfClass(String lnfName) {
        try {
            Class<?> clazz = LookAndFeelFactory.getUIManagerClassLoader().loadClass(lnfName);
            HashMap<String, String> map = new HashMap<String, String>(_installedLookAndFeels);
            map.put(lnfName, LAF_INSTALLED);
            _installedLookAndFeels = map;
            return clazz;
        }
        catch (ClassNotFoundException e) {
            HashMap<String, String> map = new HashMap<String, String>(_installedLookAndFeels);
            map.put(lnfName, LAF_NOT_INSTALLED);
            _installedLookAndFeels = map;
            return null;
        }
    }

    private static boolean isAssignableFrom(String lnfName, Class cls) {
        if (lnfName.equals(cls.getName())) {
            return true;
        }
        Class cl = LookAndFeelFactory.loadLnfClass(lnfName);
        return cl != null && cl.isAssignableFrom(cls);
    }

    public static boolean isAquaLnfInstalled() {
        return LookAndFeelFactory.isLnfInstalled(AQUA_LNF_6) || LookAndFeelFactory.isLnfInstalled(AQUA_LNF);
    }

    public static boolean isQuaquaLnfInstalled() {
        return LookAndFeelFactory.isLnfInstalled(QUAQUA_LNF);
    }

    public static boolean isAlloyLnfInstalled() {
        return LookAndFeelFactory.isLnfInstalled(ALLOY_LNF);
    }

    public static boolean isGTKLnfInstalled() {
        return LookAndFeelFactory.isLnfInstalled(GTK_LNF);
    }

    public static boolean isPlastic3DLnfInstalled() {
        return LookAndFeelFactory.isLnfInstalled(PLASTIC3D_LNF);
    }

    public static boolean isPlastic3D13LnfInstalled() {
        return LookAndFeelFactory.isLnfInstalled(PLASTIC3D_LNF_1_3);
    }

    public static boolean isPlasticXPLnfInstalled() {
        return LookAndFeelFactory.isLnfInstalled(PLASTICXP_LNF);
    }

    public static boolean isTonicLnfInstalled() {
        return LookAndFeelFactory.isLnfInstalled(TONIC_LNF);
    }

    public static boolean isA03LnfInstalled() {
        return LookAndFeelFactory.isLnfInstalled(A03_LNF);
    }

    public static boolean isPgsLnfInstalled() {
        return LookAndFeelFactory.isLnfInstalled(PGS_LNF);
    }

    public static boolean isSyntheticaLnfInstalled() {
        return LookAndFeelFactory.isLnfInstalled(SYNTHETICA_LNF);
    }

    public static boolean isNimbusLnfInstalled() {
        UIManager.LookAndFeelInfo[] infos;
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = infos = UIManager.getInstalledLookAndFeels();
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
            if (info.getClassName().indexOf(NIMBUS_LNF_NAME) != -1) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void installDefaultLookAndFeelAndExtension() {
        LookAndFeelFactory.installDefaultLookAndFeel();
        LookAndFeelFactory.installJideExtension();
    }

    public static void installDefaultLookAndFeel() {
        try {
            String lnfName = SecurityUtils.getProperty("swing.defaultlaf", null);
            if (lnfName == null) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else {
                UIManager.setLookAndFeel(lnfName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static LookAndFeel getLookAndFeel() {
        return _lookAndFeel;
    }

    public static int getStyle() {
        return _style;
    }

    public static UIDefaultsCustomizer[] getUIDefaultsCustomizers() {
        return _uiDefaultsCustomizers.toArray(new UIDefaultsCustomizer[_uiDefaultsCustomizers.size()]);
    }

    public static void addUIDefaultsCustomizer(UIDefaultsCustomizer uiDefaultsCustomizer) {
        if (!_uiDefaultsCustomizers.contains(uiDefaultsCustomizer)) {
            _uiDefaultsCustomizers.add(uiDefaultsCustomizer);
        }
    }

    public static void removeUIDefaultsCustomizer(UIDefaultsCustomizer uiDefaultsCustomizer) {
        _uiDefaultsCustomizers.remove(uiDefaultsCustomizer);
    }

    public static UIDefaultsInitializer[] getUIDefaultsInitializers() {
        return _uiDefaultsInitializers.toArray(new UIDefaultsInitializer[_uiDefaultsInitializers.size()]);
    }

    public static void addUIDefaultsInitializer(UIDefaultsInitializer uiDefaultsInitializer) {
        if (!_uiDefaultsInitializers.contains(uiDefaultsInitializer)) {
            _uiDefaultsInitializers.add(uiDefaultsInitializer);
        }
    }

    public static void removeUIDefaultsInitializer(UIDefaultsInitializer uiDefaultsInitializer) {
        _uiDefaultsInitializers.remove(uiDefaultsInitializer);
    }

    private static Icon loadSyntheticaIcon(Class syntheticaClass, String key) {
        try {
            Method method = syntheticaClass.getMethod("loadIcon", String.class);
            return (Icon)method.invoke(null, key);
        }
        catch (Exception e) {
            return IconsFactory.getImageIcon(syntheticaClass, UIDefaultsLookup.getString(key));
        }
    }

    public static void verifyDefaults(UIDefaults table, Object[] keyValueList) {
        int i = 0;
        int max = keyValueList.length;
        while (i < max) {
            Object value = keyValueList[i + 1];
            if (value == null) {
                System.out.println("The value for " + keyValueList[i] + " is null");
            } else {
                Object oldValue = table.get(keyValueList[i]);
                if (oldValue != null) {
                    System.out.println("The value for " + keyValueList[i] + " exists which is " + oldValue);
                }
            }
            i += 2;
        }
    }

    public static void putDefaults(UIDefaults table, Object[] keyValueArray) {
        int i = 0;
        int max = keyValueArray.length;
        while (i < max) {
            Object value = keyValueArray[i + 1];
            if (value == null) {
                table.remove(keyValueArray[i]);
            } else if (table.get(keyValueArray[i]) == null) {
                table.put(keyValueArray[i], value);
            }
            i += 2;
        }
    }

    public static void overwriteDefaults(UIDefaults table, Object[] keyValueArray) {
        int i = 0;
        int max = keyValueArray.length;
        while (i < max) {
            Object value = keyValueArray[i + 1];
            if (value == null) {
                table.remove(keyValueArray[i]);
            } else {
                table.put(keyValueArray[i], value);
            }
            i += 2;
        }
    }

    public static int getProductsUsed() {
        if (_productsUsed == -1) {
            _productsUsed = 0;
            try {
                Class.forName("com.jidesoft.docking.Product");
                _productsUsed |= 1;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Class.forName("com.jidesoft.action.Product");
                _productsUsed |= 0x10;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Class.forName("com.jidesoft.document.Product");
                _productsUsed |= 2;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Class.forName("com.jidesoft.grid.Product");
                _productsUsed |= 4;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Class.forName("com.jidesoft.wizard.Product");
                _productsUsed |= 8;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Class.forName("com.jidesoft.pivot.Product");
                _productsUsed |= 0x20;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Class.forName("com.jidesoft.shortcut.Product");
                _productsUsed |= 0x40;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Class.forName("com.jidesoft.editor.Product");
                _productsUsed |= 0x80;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Class.forName("com.jidesoft.rss.Product");
                _productsUsed |= 0x100;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Class.forName("com.jidesoft.diff.Product");
                _productsUsed |= 0x4000;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return _productsUsed;
    }

    public static void setProductsUsed(int productsUsed) {
        _productsUsed = productsUsed;
    }

    public static boolean isCurrentLnfDecorated() {
        return !LookAndFeelFactory.isLnfInstalled(SYNTHETICA_LNF) || !LookAndFeelFactory.isLnfInUse(SYNTHETICA_LNF);
    }

    public static void main(String[] args) {
    }

    public static class GTKInitializer
    implements UIDefaultsInitializer {
        public void initialize(UIDefaults defaults) {
            ImageIcon rightImageIcon = IconsFactory.createMaskImage(new JLabel(), JideIconsFactory.getImageIcon("jide/direction_right.gif"), Color.BLACK, Color.GRAY);
            ImageIcon downImageIcon = IconsFactory.createMaskImage(new JLabel(), JideIconsFactory.getImageIcon("jide/direction_down.gif"), Color.BLACK, Color.GRAY);
            Object[] uiDefaults = new Object[]{"activeCaption", defaults.getColor("textHighlight"), "activeCaptionText", defaults.getColor("textHighlightText"), "inactiveCaptionBorder", defaults.getColor("controlShadowtextHighlightText"), "CategorizedTable.categoryCollapsedIcon", rightImageIcon, "CategorizedTable.categoryExpandedIcon", downImageIcon, "CategorizedTable.collapsedIcon", rightImageIcon, "CategorizedTable.expandedIcon", downImageIcon};
            LookAndFeelFactory.putDefaults(defaults, uiDefaults);
        }
    }

    public static class NimbusInitializer
    implements UIDefaultsInitializer {
        public void initialize(UIDefaults defaults) {
            SwingLazyValue marginBorder = new SwingLazyValue("javax.swing.plaf.basic.BasicBorders$MarginBorder");
            Object[] uiDefaults = new Object[]{"textHighlight", new ColorUIResource(197, 218, 233), "controlText", new ColorUIResource(Color.BLACK), "activeCaptionText", new ColorUIResource(Color.BLACK), "MenuItem.acceleratorFont", new FontUIResource("Arial", 0, 12), "ComboBox.background", new ColorUIResource(Color.WHITE), "ComboBox.disabledForeground", new ColorUIResource(Color.DARK_GRAY), "ComboBox.disabledBackground", new ColorUIResource(Color.GRAY), "activeCaption", new ColorUIResource(197, 218, 233), "inactiveCaption", new ColorUIResource(Color.DARK_GRAY), "control", new ColorUIResource(220, 223, 228), "controlLtHighlight", new ColorUIResource(Color.WHITE), "controlHighlight", new ColorUIResource(Color.LIGHT_GRAY), "controlShadow", new ColorUIResource(133, 137, 144), "controlDkShadow", new ColorUIResource(Color.BLACK), "MenuItem.background", new ColorUIResource(237, 239, 242), "SplitPane.background", new ColorUIResource(220, 223, 228), "Tree.hash", new ColorUIResource(Color.GRAY), "TextField.foreground", new ColorUIResource(Color.BLACK), "TextField.inactiveForeground", new ColorUIResource(Color.BLACK), "TextField.selectionForeground", new ColorUIResource(Color.WHITE), "TextField.selectionBackground", new ColorUIResource(197, 218, 233), "Table.gridColor", new ColorUIResource(Color.BLACK), "TextField.background", new ColorUIResource(Color.WHITE), "Table.selectionBackground", defaults.getColor("Tree.selectionBackground"), "Table.selectionForeground", defaults.getColor("Tree.selectionForeground"), "Menu.border", marginBorder, "MenuItem.border", marginBorder, "CheckBoxMenuItem.border", marginBorder, "RadioButtonMenuItem.border", marginBorder};
            LookAndFeelFactory.putDefaults(defaults, uiDefaults);
        }
    }

    public static class SyntheticaCustomizer
    implements UIDefaultsCustomizer {
        public void customize(UIDefaults defaults) {
            try {
                Class<?> syntheticaClass = Class.forName(LookAndFeelFactory.SYNTHETICA_LNF);
                Class<?> syntheticaFrameBorder = Class.forName("com.jidesoft.plaf.synthetica.SyntheticaFrameBorder");
                Class<?> syntheticaPopupBorder = Class.forName("com.jidesoft.plaf.synthetica.SyntheticaPopupBorder");
                Color toolbarBackground = new JToolBar().getBackground();
                int products = LookAndFeelFactory.getProductsUsed();
                Object[] uiDefaults = new Object[]{"JideTabbedPaneUI", "com.jidesoft.plaf.synthetica.SyntheticaJideTabbedPaneUI", "JideSplitPane.dividerSize", 6, "JideTabbedPane.tabAreaBackground", UIManager.getColor("control"), "JideTabbedPane.background", UIManager.getColor("control"), "JideTabbedPane.defaultTabShape", 9, "JideTabbedPane.defaultTabShape", 9, "JideTabbedPane.contentBorderInsets", new InsetsUIResource(2, 2, 2, 2), "JideButton.foreground", UIDefaultsLookup.getColor("Button.foreground"), "JideSplitButton.foreground", UIDefaultsLookup.getColor("Button.foreground"), "Icon.floating", Boolean.FALSE, "ContentContainer.background", toolbarBackground, "PopupMenu.border", syntheticaPopupBorder.newInstance()};
                LookAndFeelFactory.overwriteDefaults(defaults, uiDefaults);
                if ((products & 2) != 0) {
                    uiDefaults = new Object[]{"CollapsiblePane.background", UIDefaultsLookup.getColor("TaskPane.borderColor"), "CollapsiblePane.emphasizedBackground", UIDefaultsLookup.getColor("TaskPane.borderColor"), "CollapsiblePane.foreground", UIDefaultsLookup.getColor("TaskPane.titleForeground"), "CollapsiblePane.emphasizedForeground", UIDefaultsLookup.getColor("TaskPane.specialTitleForeground"), "CollapsiblePane.font", UIDefaultsLookup.getFont("TaskPane.font") != null ? UIDefaultsLookup.getFont("TaskPane.font") : UIDefaultsLookup.getFont("Label.font"), "StatusBarItem.border", new BorderUIResource(BorderFactory.createEmptyBorder(2, 2, 2, 2)), "StatusBar.childrenOpaque", false, "StatusBar.paintResizableIcon", false, "OutlookTabbedPane.buttonStyle", 0, "FloorTabbedPane.buttonStyle", 0};
                    LookAndFeelFactory.overwriteDefaults(defaults, uiDefaults);
                }
                if ((products & 4) != 0) {
                    uiDefaults = new Object[]{"NestedTableHeaderUI", "com.jidesoft.plaf.synthetica.SyntheticaNestedTableHeaderUI", "EditableTableHeaderUI", "com.jidesoft.plaf.synthetica.SyntheticaEditableTableHeaderUI"};
                    LookAndFeelFactory.overwriteDefaults(defaults, uiDefaults);
                }
                if ((products & 0x10) != 0) {
                    uiDefaults = new Object[]{"CommandBar.background", toolbarBackground, "CommandBar.border", new BorderUIResource(BorderFactory.createEmptyBorder()), "CommandBar.borderVert", new BorderUIResource(BorderFactory.createEmptyBorder()), "CommandBar.borderFloating", syntheticaFrameBorder.newInstance(), "CommandBar.titleBarBackground", UIDefaultsLookup.getColor("InternalFrame.activeTitleBackground"), "CommandBar.titleBarForeground", UIDefaultsLookup.getColor("InternalFrame.activeTitleForeground"), "CommandBarContainer.verticalGap", 0};
                    LookAndFeelFactory.overwriteDefaults(defaults, uiDefaults);
                }
                if ((products & 1) != 0) {
                    uiDefaults = new Object[]{"Workspace.background", UIManager.getColor("control"), "DockableFrame.inactiveTitleForeground", UIDefaultsLookup.getColor("Synthetica.docking.titlebar.color"), "DockableFrame.activeTitleForeground", UIDefaultsLookup.getColor("Synthetica.docking.titlebar.color.selected"), "DockableFrame.titleBorder", UIDefaultsLookup.getColor("Synthetica.docking.border.color"), "FrameContainer.contentBorderInsets", new InsetsUIResource(2, 2, 2, 2), "DockableFrameTitlePane.hideIcon", LookAndFeelFactory.loadSyntheticaIcon(syntheticaClass, "Synthetica.docking.titlebar.close"), "DockableFrameTitlePane.hideRolloverIcon", LookAndFeelFactory.loadSyntheticaIcon(syntheticaClass, "Synthetica.docking.titlebar.close.hover"), "DockableFrameTitlePane.hideActiveIcon", LookAndFeelFactory.loadSyntheticaIcon(syntheticaClass, "Synthetica.docking.titlebar.active.close"), "DockableFrameTitlePane.hideRolloverActiveIcon", LookAndFeelFactory.loadSyntheticaIcon(syntheticaClass, "Synthetica.docking.titlebar.active.close.hover"), "DockableFrameTitlePane.floatIcon", LookAndFeelFactory.loadSyntheticaIcon(syntheticaClass, "Synthetica.docking.titlebar.undock"), "DockableFrameTitlePane.floatRolloverIcon", LookAndFeelFactory.loadSyntheticaIcon(syntheticaClass, "Synthetica.docking.titlebar.undock.hover"), "DockableFrameTitlePane.floatActiveIcon", LookAndFeelFactory.loadSyntheticaIcon(syntheticaClass, "Synthetica.docking.titlebar.active.undock"), "DockableFrameTitlePane.floatRolloverActiveIcon", LookAndFeelFactory.loadSyntheticaIcon(syntheticaClass, "Synthetica.docking.titlebar.active.undock.hover"), "DockableFrameTitlePane.unfloatIcon", LookAndFeelFactory.loadSyntheticaIcon(syntheticaClass, "Synthetica.docking.titlebar.dock"), "DockableFrameTitlePane.unfloatRolloverIcon", LookAndFeelFactory.loadSyntheticaIcon(syntheticaClass, "Synthetica.docking.titlebar.dock.hover"), "DockableFrameTitlePane.unfloatActiveIcon", LookAndFeelFactory.loadSyntheticaIcon(syntheticaClass, "Synthetica.docking.titlebar.active.dock"), "DockableFrameTitlePane.unfloatRolloverActiveIcon", LookAndFeelFactory.loadSyntheticaIcon(syntheticaClass, "Synthetica.docking.titlebar.active.dock.hover"), "DockableFrameTitlePane.autohideIcon", LookAndFeelFactory.loadSyntheticaIcon(syntheticaClass, "Synthetica.docking.titlebar.iconify"), "DockableFrameTitlePane.autohideRolloverIcon", LookAndFeelFactory.loadSyntheticaIcon(syntheticaClass, "Synthetica.docking.titlebar.iconify.hover"), "DockableFrameTitlePane.autohideActiveIcon", LookAndFeelFactory.loadSyntheticaIcon(syntheticaClass, "Synthetica.docking.titlebar.active.iconify"), "DockableFrameTitlePane.autohideRolloverActiveIcon", LookAndFeelFactory.loadSyntheticaIcon(syntheticaClass, "Synthetica.docking.titlebar.active.iconify.hover"), "DockableFrameTitlePane.stopAutohideIcon", LookAndFeelFactory.loadSyntheticaIcon(syntheticaClass, "Synthetica.docking.titlebar.restore"), "DockableFrameTitlePane.stopAutohideRolloverIcon", LookAndFeelFactory.loadSyntheticaIcon(syntheticaClass, "Synthetica.docking.titlebar.restore.hover"), "DockableFrameTitlePane.stopAutohideActiveIcon", LookAndFeelFactory.loadSyntheticaIcon(syntheticaClass, "Synthetica.docking.titlebar.active.restore"), "DockableFrameTitlePane.stopAutohideRolloverActiveIcon", LookAndFeelFactory.loadSyntheticaIcon(syntheticaClass, "Synthetica.docking.titlebar.active.restore.hover"), "DockableFrameTitlePane.hideAutohideIcon", LookAndFeelFactory.loadSyntheticaIcon(syntheticaClass, "Synthetica.docking.titlebar.iconify"), "DockableFrameTitlePane.hideAutohideRolloverIcon", LookAndFeelFactory.loadSyntheticaIcon(syntheticaClass, "Synthetica.docking.titlebar.iconify.hover"), "DockableFrameTitlePane.hideAutohideActiveIcon", LookAndFeelFactory.loadSyntheticaIcon(syntheticaClass, "Synthetica.docking.titlebar.active.iconify"), "DockableFrameTitlePane.hideAutohideRolloverActiveIcon", LookAndFeelFactory.loadSyntheticaIcon(syntheticaClass, "Synthetica.docking.titlebar.active.iconify.hover"), "DockableFrameTitlePane.maximizeIcon", LookAndFeelFactory.loadSyntheticaIcon(syntheticaClass, "Synthetica.docking.titlebar.maximize"), "DockableFrameTitlePane.maximizeRolloverIcon", LookAndFeelFactory.loadSyntheticaIcon(syntheticaClass, "Synthetica.docking.titlebar.maximize.hover"), "DockableFrameTitlePane.maximizeActiveIcon", LookAndFeelFactory.loadSyntheticaIcon(syntheticaClass, "Synthetica.docking.titlebar.active.maximize"), "DockableFrameTitlePane.maximizeRolloverActiveIcon", LookAndFeelFactory.loadSyntheticaIcon(syntheticaClass, "Synthetica.docking.titlebar.active.maximize.hover"), "DockableFrameTitlePane.restoreIcon", LookAndFeelFactory.loadSyntheticaIcon(syntheticaClass, "Synthetica.docking.titlebar.restore"), "DockableFrameTitlePane.restoreRolloverIcon", LookAndFeelFactory.loadSyntheticaIcon(syntheticaClass, "Synthetica.docking.titlebar.restore.hover"), "DockableFrameTitlePane.restoreActiveIcon", LookAndFeelFactory.loadSyntheticaIcon(syntheticaClass, "Synthetica.docking.titlebar.active.restore"), "DockableFrameTitlePane.restoreRolloverActiveIcon", LookAndFeelFactory.loadSyntheticaIcon(syntheticaClass, "Synthetica.docking.titlebar.active.restore.hover"), "DockableFrameTitlePane.use3dButtons", Boolean.FALSE, "DockableFrameTitlePane.contentFilledButtons", Boolean.FALSE, "DockableFrameTitlePane.buttonGap", 0};
                    LookAndFeelFactory.overwriteDefaults(defaults, uiDefaults);
                }
                Class<?> painterClass = Class.forName("com.jidesoft.plaf.synthetica.SyntheticaJidePainter");
                Method getInstanceMethod = painterClass.getMethod("getInstance", new Class[0]);
                Object painter = getInstanceMethod.invoke(null, new Object[0]);
                UIDefaultsLookup.put(UIManager.getDefaults(), "Theme.painter", painter);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static class SyntheticaInitializer
    implements UIDefaultsInitializer {
        public void initialize(UIDefaults defaults) {
            try {
                Class<?> syntheticaPopupBorder = Class.forName("com.jidesoft.plaf.synthetica.SyntheticaPopupBorder");
                Object[] uiDefaults = new Object[]{"Label.font", UIDefaultsLookup.getFont("Button.font"), "ToolBar.font", UIDefaultsLookup.getFont("Button.font"), "MenuItem.acceleratorFont", UIDefaultsLookup.getFont("Button.font"), "ComboBox.disabledForeground", defaults.get("Synthetica.comboBox.disabled.textColor"), "ComboBox.disabledBackground", defaults.get("Synthetica.comboBox.disabled.backgroundColor"), "Slider.focusInsets", new InsetsUIResource(0, 0, 0, 0), "PopupMenu.border", syntheticaPopupBorder.newInstance()};
                LookAndFeelFactory.putDefaults(defaults, uiDefaults);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static interface UIDefaultsCustomizer {
        public void customize(UIDefaults var1);
    }

    public static interface UIDefaultsInitializer {
        public void initialize(UIDefaults var1);
    }
}

