/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.renderer.list;

import com.nepxion.swing.element.IElementNode;
import com.nepxion.swing.renderer.list.CellRendererLabel;
import com.nepxion.swing.renderer.list.CheckBoxCellRendererPanel;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CheckBoxListCellRenderer
extends CheckBoxCellRendererPanel
implements ListCellRenderer {
    private JList list;
    private int cellHeight = -1;
    private JCheckBox checkBox;
    private CellRendererLabel cellLabel;

    public CheckBoxListCellRenderer(JList list) {
        this(list, -1);
    }

    public CheckBoxListCellRenderer(JList list, int cellHeight) {
        this.list = list;
        this.checkBox = this.getCheckBox();
        this.cellLabel = this.getLabel();
        list.addListSelectionListener(new CheckBoxListSelectionListener());
        list.addMouseListener(new CheckBoxListMouseListener());
        this.setCellHeight(cellHeight);
    }

    public JList getList() {
        return this.list;
    }

    public void setList(JList list) {
        this.list = list;
    }

    public int getCellHeight() {
        return this.cellHeight;
    }

    public void setCellHeight(int cellHeight) {
        this.cellHeight = cellHeight;
        if (this.list != null && cellHeight > 0) {
            this.list.setFixedCellHeight(cellHeight);
        }
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
        IElementNode elementNode = (IElementNode)value;
        this.checkBox.setSelected(elementNode.isSelected());
        this.cellLabel.setText(elementNode.getText());
        this.cellLabel.setIcon(elementNode.getIcon());
        this.cellLabel.setToolTipText(elementNode.getToolTipText());
        this.cellLabel.setSelected(isSelected);
        this.cellLabel.setFont(list.getFont());
        this.cellLabel.setFocus(hasFocus);
        this.cellLabel.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
        this.cellLabel.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
        this.setToolTipText(elementNode.getToolTipText());
        return this;
    }

    private void adaptSelection() {
        int[] indexes = this.list.getSelectedIndices();
        if (indexes.length > 1) {
            boolean selected = false;
            for (int i = 0; i < indexes.length; ++i) {
                int index = indexes[i];
                IElementNode elementNode = (IElementNode)this.list.getModel().getElementAt(index);
                if (i == 0) {
                    selected = elementNode.isSelected();
                }
                elementNode.setSelected(selected);
                Rectangle rectangle = this.list.getCellBounds(index, index);
                this.list.repaint(rectangle);
            }
        } else {
            int index = this.list.getSelectedIndex();
            if (index > -1) {
                IElementNode elementNode;
                elementNode.setSelected(!(elementNode = (IElementNode)this.list.getModel().getElementAt(index)).isSelected());
                Rectangle rectangle = this.list.getCellBounds(index, index);
                this.list.repaint(rectangle);
            }
        }
    }

    public class CheckBoxListMouseListener
    extends MouseAdapter {
        @Override
        public void mousePressed(MouseEvent e) {
            CheckBoxListCellRenderer.this.adaptSelection();
        }
    }

    public class CheckBoxListSelectionListener
    implements ListSelectionListener {
        @Override
        public void valueChanged(ListSelectionEvent e) {
            CheckBoxListCellRenderer.this.adaptSelection();
        }
    }
}

