/*
 * Decompiled with CFR 0.152.
 */
package y.layout;

import y.base.Edge;
import y.base.EdgeCursor;
import y.base.EdgeList;
import y.base.Node;
import y.base.NodeCursor;
import y.geom.YPoint;
import y.layout.AbstractLayoutStage;
import y.layout.EdgeLayout;
import y.layout.LayoutGraph;
import y.layout.Layouter;
import y.layout.NodeLayout;

public class SelfLoopLayouter
extends AbstractLayoutStage {
    private EdgeList cd = new EdgeList();

    public SelfLoopLayouter() {
    }

    public SelfLoopLayouter(Layouter layouter) {
        this();
        this.setCoreLayouter(layouter);
    }

    public void doLayout(LayoutGraph layoutGraph) {
        if (this.getCoreLayouter() != null) {
            this.o(layoutGraph);
            this.doLayoutCore(layoutGraph);
            this.n(layoutGraph);
            this.layoutSelfLoops(layoutGraph);
        } else {
            this.layoutSelfLoops(layoutGraph);
        }
    }

    public boolean canLayout(LayoutGraph layoutGraph) {
        if (this.getCoreLayouter() == null) {
            return true;
        }
        this.o(layoutGraph);
        boolean bl = this.canLayoutCore(layoutGraph);
        this.n(layoutGraph);
        return bl;
    }

    protected void layoutSelfLoops(LayoutGraph layoutGraph) {
        int[][] nArray = new int[2][2];
        int[] nArray2 = new int[2];
        NodeCursor nodeCursor = layoutGraph.nodes();
        while (nodeCursor.ok()) {
            Node node = nodeCursor.node();
            this.a(layoutGraph, node, nArray);
            int n = Integer.MAX_VALUE;
            nArray2[1] = 0;
            nArray2[0] = 0;
            int n2 = 0;
            while (n2 < 2) {
                int n3 = 0;
                while (n3 < 2) {
                    if (nArray[n2][n3] < n) {
                        nArray2[0] = n2 == 0 ? -1 : 1;
                        nArray2[1] = n3 == 0 ? -1 : 1;
                        n = nArray[n2][n3];
                    }
                    ++n3;
                }
                ++n2;
            }
            EdgeCursor edgeCursor = node.outEdges();
            while (edgeCursor.ok()) {
                Edge edge = edgeCursor.edge();
                if (edge.isSelfLoop()) {
                    EdgeLayout edgeLayout = layoutGraph.getLayout(edge);
                    NodeLayout nodeLayout = layoutGraph.getLayout(edge.source());
                    double d2 = nodeLayout.getX();
                    double d3 = nodeLayout.getY();
                    double d4 = nodeLayout.getWidth();
                    double d5 = nodeLayout.getHeight();
                    YPoint yPoint = null;
                    edgeLayout.clearPoints();
                    if (nArray2[0] == -1 && nArray2[1] == -1) {
                        yPoint = new YPoint(-d4 / 4.0, -d5 / 4.0);
                        edgeLayout.addPoint(d2 + d4 / 4.0, d3 - 20.0);
                        edgeLayout.addPoint(d2 - 20.0, d3 - 20.0);
                        edgeLayout.addPoint(d2 - 20.0, d3 + d5 / 4.0);
                    } else if (nArray2[0] == -1 && nArray2[1] == 1) {
                        yPoint = new YPoint(-d4 / 4.0, d5 / 4.0);
                        edgeLayout.addPoint(d2 + d4 / 4.0, d3 + d5 + 20.0);
                        edgeLayout.addPoint(d2 - 20.0, d3 + d5 + 20.0);
                        edgeLayout.addPoint(d2 - 20.0, d3 + d5 - d5 / 4.0);
                    } else if (nArray2[0] == 1 && nArray2[1] == -1) {
                        yPoint = new YPoint(d4 / 4.0, -d5 / 4.0);
                        edgeLayout.addPoint(d2 + d4 - d4 / 4.0, d3 - 20.0);
                        edgeLayout.addPoint(d2 + d4 + 20.0, d3 - 20.0);
                        edgeLayout.addPoint(d2 + d4 + 20.0, d3 + d5 / 4.0);
                    } else if (nArray2[0] == 1 && nArray2[1] == 1) {
                        yPoint = new YPoint(d4 / 4.0, d5 / 4.0);
                        edgeLayout.addPoint(d2 + d4 - d4 / 4.0, d3 + d5 + 20.0);
                        edgeLayout.addPoint(d2 + d4 + 20.0, d3 + d5 + 20.0);
                        edgeLayout.addPoint(d2 + d4 + 20.0, d3 + d5 - d5 / 4.0);
                    }
                    edgeLayout.setSourcePoint(yPoint);
                    edgeLayout.setTargetPoint(yPoint);
                }
                edgeCursor.next();
            }
            nodeCursor.next();
        }
    }

    private void a(LayoutGraph layoutGraph, Node node, int[][] nArray) {
        int n = nArray[1][1];
        nArray[1][0] = n;
        nArray[0][1] = n;
        nArray[0][0] = n;
        EdgeCursor edgeCursor = node.edges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            if (!edge.isSelfLoop()) {
                YPoint yPoint = layoutGraph.getCenter(node);
                EdgeLayout edgeLayout = layoutGraph.getLayout(edge);
                YPoint yPoint2 = edgeLayout.pointCount() == 0 ? (edge.source() == node ? layoutGraph.getTargetPointAbs(edge) : layoutGraph.getSourcePointAbs(edge)) : (edge.source() == node ? edgeLayout.getPoint(0) : edgeLayout.getPoint(edgeLayout.pointCount() - 1));
                int[] nArray2 = nArray[yPoint2.getX() - yPoint.getX() < 0.0 ? 0 : 1];
                int n2 = yPoint2.getY() - yPoint.getY() < 0.0 ? 0 : 1;
                nArray2[n2] = nArray2[n2] + 1;
            }
            edgeCursor.next();
        }
    }

    private void o(LayoutGraph layoutGraph) {
        EdgeCursor edgeCursor = layoutGraph.edges();
        while (edgeCursor.ok()) {
            if (edgeCursor.edge().isSelfLoop()) {
                this.cd.push(edgeCursor.edge());
                layoutGraph.hide(edgeCursor.edge());
            }
            edgeCursor.next();
        }
    }

    private void n(LayoutGraph layoutGraph) {
        while (!this.cd.isEmpty()) {
            layoutGraph.unhide(this.cd.popEdge());
        }
    }
}

