/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.chart.bar;

import com.nepxion.swing.chart.bar.IBarRenderer;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.data.category.CategoryDataset;

public class BarSelectionAdapter
implements ChartMouseListener {
    private IBarRenderer chartRenderer;

    public void chartMouseMoved(ChartMouseEvent e) {
        this.adaptSelection(e, true);
    }

    public void chartMouseClicked(ChartMouseEvent e) {
        this.adaptSelection(e, false);
    }

    private void adaptSelection(ChartMouseEvent e, boolean isMouseOver) {
        JFreeChart chart = e.getChart();
        ChartEntity chartEntity = e.getEntity();
        if (chartEntity instanceof CategoryItemEntity) {
            CategoryItemEntity categoryItemEntity = (CategoryItemEntity)chartEntity;
            CategoryDataset categoryDataset = categoryItemEntity.getDataset();
            CategoryPlot categoryPlot = chart.getCategoryPlot();
            Comparable rowKey = categoryItemEntity.getRowKey();
            Comparable columnKey = categoryItemEntity.getColumnKey();
            int rowIndex = categoryDataset.getRowIndex(rowKey);
            int columnIndex = categoryDataset.getColumnIndex(columnKey);
            this.chartRenderer = (IBarRenderer)categoryPlot.getRenderer();
            if (isMouseOver) {
                this.chartRenderer.dispatchMouseOver(rowIndex, columnIndex);
            } else {
                this.chartRenderer.dispatchMouseDown(rowIndex, columnIndex);
            }
        } else if (this.chartRenderer != null) {
            if (isMouseOver) {
                this.chartRenderer.dispatchMouseOver(-1, -1);
            } else {
                this.chartRenderer.dispatchMouseDown(-1, -1);
            }
        }
    }
}

