/*
 * Decompiled with CFR 0.152.
 */
package twaver.gis.ogc;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import twaver.A.A.C.H.E;
import twaver.A.A.C.I.A;
import twaver.GeoCoordinate;
import twaver.gis.GeographyFeature;
import twaver.gis.gadget.GridBbox;
import twaver.gis.gadget.WMSLayerInfo;
import twaver.gis.tiles.ComparisonOperateCondition;
import twaver.gis.tiles.SpatialOperateCondition;
import twaver.gis.utils.XMLUtils;

public class WFSUtils {
    private static final String \u00c8 = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" outputFormat=\"JSON\" xmlns:topp=\"http://www.openplans.org/topp\"  xmlns:wfs=\"http://www.opengis.net/wfs\"  xmlns:ogc=\"http://www.opengis.net/ogc\"  xmlns:gml=\"http://www.opengis.net/gml\"  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"  xsi:schemaLocation=\"http://www.opengis.net/wfs http://schemas.opengis.net/wfs/1.1.0/wfs.xsd\">";
    private static final String \u00cf = "</wfs:GetFeature>";
    private static final String d = "<wfs:Query typeName=";
    private static final String q = "</wfs:Query>";
    private static final String V = "<wfs:PropertyName>";
    private static final String g = "</wfs:PropertyName>";
    private static final String j = "<ogc:Filter>";
    private static final String v = "</ogc:Filter>";
    private static final String a = "<ogc:FeatureId>";
    private static final String o = "</ogc:FeatureId>";
    private static final String G = "<ogc:PropertyName>";
    private static final String L = "</ogc:PropertyName>";
    private static final String \u00d2 = "<ogc:LowerBoundary>";
    private static final String \u00db = "</ogc:LowerBoundary>";
    private static final String R = "<ogc:UpperBoundary>";
    private static final String Z = "</ogc:UpperBoundary>";
    private static final String A = "<ogc:Literal>";
    private static final String K = "</ogc:Literal>";
    private static final String J = "<PropertyName>";
    private static final String P = "</PropertyName>";
    private static final String \u00d8 = "<Filter>";
    private static final String D = "</Filter>";
    private static final String \u00d9 = "<Disjoint>";
    private static final String E = "</Disjoint>";
    private static final String \u00c5 = "<Equals>";
    private static final String \u00cc = "</Equals>";
    private static final String \u00d5 = "<DWithin>";
    private static final String B = "</DWithin>";
    private static final String U = "<Intersects>";
    private static final String c = "</Intersects>";
    private static final String \u00a4 = "<Touches>";
    private static final String \u00c4 = "</Touches>";
    private static final String \u00d3 = "<Crosses>";
    private static final String \u00dc = "</Crosses>";
    private static final String H = "<Within>";
    private static final String M = "</Within>";
    private static final String \u00dd = "<Contains>";
    private static final String F = "</Contains>";
    private static final String \u00ce = "<Overlaps>";
    private static final String \u00d4 = "</Overlaps>";
    private static final String z = "<Distance>";
    private static final String \u00c1 = "</Distance>";
    private static final String \u00a2 = "<units>";
    private static final String \u00c2 = "</units>";
    private static final String[] e = new String[]{"<Disjoint>", "<Equals>", "<DWithin>", "<Intersects>", "<Touches>", "<Crosses>", "<Within>", "<Contains>", "<Overlaps>"};
    private static final String[] r = new String[]{"</Disjoint>", "</Equals>", "</DWithin>", "</Intersects>", "</Touches>", "</Crosses>", "</Within>", "</Contains>", "</Overlaps>"};
    private static final String i = "<ogc:BBOX>";
    private static final String w = "</ogc:BBOX>";
    private static final String I = "<ogc:PropertyName>";
    private static final String N = "</ogc:PropertyName>";
    private static final String S = "<gml:Envelope srsName=\"http://www.opengis.net/gml/srs/epsg.xml#4326\">";
    private static final String _ = "</gml:Envelope>";
    private static final String O = "<gml:lowerCorner>";
    private static final String W = "</gml:lowerCorner>";
    private static final String s = "<gml:upperCorner>";
    private static final String \u00b5 = "</gml:upperCorner>";
    private static final String \u00c0 = "<gml:Box srsName=\"http://www.opengis.net/gml/srs/epsg.xml#4326\">";
    private static final String \u00cb = "</gml:Box>";
    private static final String \u00c6 = "<gml:outerBoundaryIs>";
    private static final String \u00cd = "</gml:outerBoundaryIs>";
    private static final String \u00aa = "<gml:LineString srsName=\"http://www.opengis.net/gml/srs/epsg.xml#4326\">";
    private static final String \u00c7 = "</gml:LineString>";
    private static final String f = "<gml:Polygon>";
    private static final String t = "</gml:Polygon>";
    private static final String n = "<gml:LinearRing>";
    private static final String \u00a3 = "</gml:LinearRing>";
    private static final String Q = "<gml:Point srsName=\"http://www.opengis.net/gml/srs/epsg.xml#4326\">";
    private static final String Y = "</gml:Point>";
    private static final String T = "<gml:coordinates>";
    private static final String b = "</gml:coordinates>";
    private static final String h = "<ogc:PropertyIsEqualTo>";
    private static final String u = "</ogc:PropertyIsEqualTo>";
    private static final String p = "<ogc:PropertyIsNotEqualTo>";
    private static final String \u00a5 = "</ogc:PropertyIsNotEqualTo>";
    private static final String m = "<ogc:PropertyIsLessThan>";
    private static final String y = "</ogc:PropertyIsLessThan>";
    private static final String \u00ba = "<ogc:PropertyIsGreaterThan>";
    private static final String \u00c9 = "</ogc:PropertyIsGreaterThan>";
    private static final String X = "<ogc:PropertyIsLike wildCard=\"*\" singleChar=\"#\" escapeChar=\"!\">";
    private static final String l = "</ogc:PropertyIsLike>";
    private static final String \u00d6 = "<ogc:PropertyIsBetween>";
    private static final String C = "</ogc:PropertyIsBetween>";
    private static final String k = "<ogc:PropertyIsLessThanOrEqualTo>";
    private static final String x = "</ogc:PropertyIsLessThanOrEqualTo>";
    private static final String \u00d1 = "<ogc:PropertyIsGreaterThanOrEqualTo>";
    private static final String \u00da = "</ogc:PropertyIsGreaterThanOrEqualTo>";
    private static final String \u00ca = "<ogc:Literal>";
    private static final String \u00d0 = "</ogc:Literal>";
    private static final String \u00c3 = "the_geom";

    public static String buildNormalQuery(String typeName, String[] resultPropertyNames) {
        StringBuffer sb = new StringBuffer();
        WFSUtils.A(sb, resultPropertyNames, typeName);
        WFSUtils.C(sb);
        return sb.toString();
    }

    public static String buildComparisonOperation(String typeName, String[] resultPropertyNames, ComparisonOperateCondition condition) {
        StringBuffer sb = new StringBuffer();
        WFSUtils.A(sb, condition);
        WFSUtils.A(sb, false);
        WFSUtils.A(sb, resultPropertyNames, typeName);
        WFSUtils.C(sb);
        return sb.toString();
    }

    private static void A(StringBuffer sb, ComparisonOperateCondition condition) {
        int type = condition.getQueryType();
        int[] operateTypes = condition.getOperateOperators();
        String[] referenceValues = condition.getReferenceValues();
        String[] referenceProperties = condition.getReferenceProperties();
        if (type == 0) {
            sb.insert(0, WFSUtils.B(referenceValues[0]));
        } else if (3 == type) {
            sb.insert(0, WFSUtils.A(referenceProperties[0], referenceValues[0]));
            WFSUtils.A(sb, operateTypes[0]);
        }
    }

    private static String A(String referencePropertyName, String value) {
        StringBuffer sb = new StringBuffer();
        sb.append("<ogc:PropertyName>");
        sb.append(referencePropertyName);
        sb.append("</ogc:PropertyName>");
        sb.append("<ogc:Literal>");
        sb.append(value);
        sb.append("</ogc:Literal>");
        return sb.toString();
    }

    private static void A(StringBuffer sb, int operateType) {
        String head = "";
        String tail = "";
        if (4 == operateType) {
            head = h;
            tail = u;
        } else if (2 == operateType) {
            head = \u00ba;
            tail = \u00c9;
        } else if (3 == operateType) {
            head = \u00d1;
            tail = \u00da;
        } else if (5 == operateType) {
            head = X;
            tail = l;
        }
        sb.insert(0, head);
        sb.insert(sb.length(), tail);
    }

    private static String B(String fid) {
        return "<ogc:FeatureId fid=\"" + fid + "\"/>";
    }

    public static String buildSpatialOperation(String typeName, String[] resultPropertyName, SpatialOperateCondition conditionInfo) {
        StringBuffer sb = new StringBuffer();
        WFSUtils.A(sb, \u00c3, true);
        WFSUtils.A(sb, conditionInfo);
        int operatorType = conditionInfo.getOperatorType();
        WFSUtils.A(operatorType, sb);
        WFSUtils.A(sb, true);
        WFSUtils.A(sb, resultPropertyName, typeName);
        WFSUtils.C(sb);
        return sb.toString();
    }

    public static String buildBBoxOperation(String typeName, String[] resultPropertyNames, GridBbox bbox) {
        StringBuffer sb = new StringBuffer();
        WFSUtils.A(sb, bbox);
        WFSUtils.A(sb);
        WFSUtils.A(sb, false);
        WFSUtils.A(sb, resultPropertyNames, typeName);
        WFSUtils.C(sb);
        return sb.toString();
    }

    private static String D(GeoCoordinate[] coordinates) {
        StringBuffer sb = new StringBuffer();
        sb.append(\u00c0);
        sb.append(T);
        int t = coordinates.length - 1;
        int i = 0;
        while (i < coordinates.length) {
            sb.append(String.valueOf(coordinates[i].getLongitude()) + "," + coordinates[i].getLatitude());
            if (i < t) {
                sb.append(" ");
            }
            ++i;
        }
        sb.append(b);
        sb.append(\u00cb);
        return sb.toString();
    }

    private static void A(StringBuffer sb) {
        sb.insert(0, i);
        sb.insert(sb.length(), w);
    }

    private static void A(StringBuffer sb, GridBbox bbox) {
        sb.append("<ogc:PropertyName>");
        sb.append(\u00c3);
        sb.append("</ogc:PropertyName>");
        sb.append(S);
        sb.append(O);
        sb.append(bbox.getMinx()).append(" ").append(bbox.getMiny());
        sb.append(W);
        sb.append(s);
        sb.append(bbox.getMaxx()).append(" ").append(bbox.getMaxy());
        sb.append(\u00b5);
        sb.append(_);
    }

    private static String B(GeoCoordinate[] coordinates) {
        StringBuffer sb = new StringBuffer();
        sb.append(Q);
        sb.append(T);
        int i = 0;
        while (i < coordinates.length) {
            sb.append(String.valueOf(coordinates[i].getLongitude()) + "," + coordinates[i].getLatitude()).append(" ");
            ++i;
        }
        sb.append(b);
        sb.append(Y);
        return sb.toString();
    }

    private static String C(GeoCoordinate[] coordinates) {
        StringBuffer sb = new StringBuffer();
        sb.append(f);
        sb.append(\u00c6);
        sb.append(\u00aa);
        sb.append(T);
        int i = 0;
        while (i < coordinates.length) {
            sb.append(String.valueOf(coordinates[i].getLongitude()) + "," + coordinates[i].getLatitude()).append(" ");
            ++i;
        }
        sb.append(b);
        sb.append(\u00c7);
        sb.append(\u00cd);
        sb.append(t);
        return sb.toString();
    }

    private static String A(GeoCoordinate[] coordinates) {
        StringBuffer sb = new StringBuffer();
        sb.append(\u00aa);
        sb.append(T);
        int i = 0;
        while (i < coordinates.length) {
            sb.append(String.valueOf(coordinates[i].getLongitude()) + "," + coordinates[i].getLatitude()).append(" ");
            ++i;
        }
        sb.append(b);
        sb.append(\u00c7);
        return sb.toString();
    }

    private static void A(StringBuffer sb, SpatialOperateCondition conditionInfo) {
        if (conditionInfo != null) {
            int type = conditionInfo.getGMLType();
            GeoCoordinate[] ca = conditionInfo.getCoordinates();
            if (type == 0) {
                sb.append(WFSUtils.B(ca));
            } else if (2 == type) {
                sb.append(WFSUtils.A(ca));
            } else if (3 == type) {
                sb.append(WFSUtils.D(ca));
            }
        }
    }

    private static String A(String unit, double distance) {
        StringBuffer sb = new StringBuffer();
        sb.append(z);
        sb.append(\u00a2).append(unit);
        sb.append(\u00c2);
        sb.append(distance);
        sb.append(\u00c1);
        return sb.toString();
    }

    private static void A(int operatorType, StringBuffer sb) {
        if (WFSUtils.A(operatorType)) {
            sb.insert(0, e[operatorType]);
            if (2 == operatorType) {
                sb.insert(sb.length(), WFSUtils.A("cm", 0.0));
            }
            sb.insert(sb.length(), r[operatorType]);
        }
    }

    private static boolean A(int operatorType) {
        return operatorType >= 0 && operatorType <= 8;
    }

    private static void A(StringBuffer sb, boolean spatial) {
        if (spatial) {
            sb.insert(0, \u00d8);
            sb.insert(sb.length(), D);
        } else {
            sb.insert(0, j);
            sb.insert(sb.length(), v);
        }
    }

    private static void A(StringBuffer contents, String[] resultPropertyNames, String typeName) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < resultPropertyNames.length) {
            WFSUtils.B(sb, resultPropertyNames[i]);
            ++i;
        }
        contents.insert(0, (Object)sb);
        contents.insert(0, "<wfs:Query typeName=\"" + typeName + "\">");
        contents.insert(contents.length(), q);
    }

    private static void B(StringBuffer sb, String propertyName) {
        sb.append(V);
        sb.append(propertyName);
        sb.append(g);
    }

    private static void A(StringBuffer sb, String propertyName, boolean spatial) {
        if (spatial) {
            sb.append(J);
            sb.append(propertyName);
            sb.append(P);
        } else {
            sb.append(V);
            sb.append(propertyName);
            sb.append(g);
        }
    }

    private static void C(StringBuffer sb) {
        sb.insert(0, \u00c8);
        sb.insert(sb.length(), \u00cf);
    }

    private static void A(StringBuffer contents, String layerName) {
        contents.append(d).append("\"");
        contents.append(layerName).append("\"");
    }

    private static void B(StringBuffer contents) {
        contents.append(q);
    }

    public static List getWFSLayers(int executorType, String urlString) {
        return WFSUtils.getWFSLayers(executorType, urlString, "UTF-8");
    }

    public static List getWFSLayers(int executorType, String urlString, String charset) {
        ArrayList<WMSLayerInfo> result = null;
        if (urlString != null) {
            List layers;
            block9: {
                URL url = new URL(String.valueOf(urlString) + "?VERSION=1.1.0&service=WFS&request=GetCapabilities");
                String contents = XMLUtils.getRequestResult(url, charset);
                Document doc = XMLUtils.createDocument(contents, charset);
                Node root = XMLUtils.getChild(doc, "wfs:WFS_Capabilities");
                if (root == null) {
                    root = XMLUtils.getChild(doc, "WFS_Capabilities");
                }
                Node featureTypeList = XMLUtils.getChild(root, "FeatureTypeList");
                Node operation = XMLUtils.getChild(featureTypeList, "Operations");
                layers = XMLUtils.getChildren(featureTypeList, "FeatureType");
                if (layers != null) break block9;
                return null;
            }
            try {
                result = new ArrayList<WMSLayerInfo>();
                int length = layers.size();
                int i = 0;
                while (i < length) {
                    Node layer = (Node)layers.get(i);
                    String layerName = XMLUtils.getSonValue(layer, "Name");
                    String srs = XMLUtils.getSonValue(layer, "DefaultSRS");
                    if (srs == null) {
                        srs = XMLUtils.getSonValue(layer, "SRS");
                    }
                    WMSLayerInfo layerInfo = new WMSLayerInfo();
                    layerInfo.setLayerName(layerName);
                    layerInfo.setSrs(srs);
                    Node bbox = XMLUtils.getChild(layer, "LatLongBoundingBox");
                    if (bbox == null) {
                        bbox = XMLUtils.getChild(layer, "ows:WGS84BoundingBox");
                        String lowerCorner = XMLUtils.getSonValue(bbox, "ows:LowerCorner");
                        String[] values = WFSUtils.A(lowerCorner);
                        GridBbox latlonBoundingBox = new GridBbox();
                        latlonBoundingBox.setMinx(Double.parseDouble(values[0]));
                        latlonBoundingBox.setMiny(Double.parseDouble(values[1]));
                        String upperCorner = XMLUtils.getSonValue(bbox, "ows:UpperCorner");
                        values = WFSUtils.A(upperCorner);
                        latlonBoundingBox.setMaxx(Double.parseDouble(values[0]));
                        latlonBoundingBox.setMaxy(Double.parseDouble(values[1]));
                        layerInfo.setLatlonBox(latlonBoundingBox);
                    } else {
                        GridBbox latlonBoundingBox = new GridBbox();
                        latlonBoundingBox.setMinx(Double.parseDouble(XMLUtils.getPropertyValue(bbox, "minx")));
                        latlonBoundingBox.setMiny(Double.parseDouble(XMLUtils.getPropertyValue(bbox, "miny")));
                        latlonBoundingBox.setMaxx(Double.parseDouble(XMLUtils.getPropertyValue(bbox, "maxx")));
                        latlonBoundingBox.setMaxy(Double.parseDouble(XMLUtils.getPropertyValue(bbox, "maxy")));
                        layerInfo.setLatlonBox(latlonBoundingBox);
                    }
                    result.add(layerInfo);
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static String getWFSAbilities(int executorType, String urlString) {
        return WFSUtils.getWFSAbilities(executorType, urlString, "UTF-8");
    }

    public static String getWFSAbilities(int executorType, String urlString, String resultCharset) {
        String contents = null;
        if (urlString != null) {
            try {
                URL url = new URL(String.valueOf(urlString) + "?VERSION=1.1.0&service=WFS&request=GetCapabilities");
                contents = XMLUtils.getRequestResult(url, resultCharset);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return contents;
    }

    private static String[] A(String source) {
        StringTokenizer st = new StringTokenizer(source, " ");
        String[] result = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            result[i] = st.nextToken();
            ++i;
        }
        return result;
    }

    public static GeographyFeature[] getFeaturesByGeoJSON(InputStream jsonIs, String charset) {
        int size;
        List features = twaver.A.A.C.H.E.A(jsonIs, true, charset);
        GeographyFeature[] resultFeatures = null;
        if (features != null && (size = features.size()) > 0) {
            resultFeatures = new A[size];
            int i = 0;
            while (i < size) {
                resultFeatures[i] = (A)features.get(i);
                ++i;
            }
        }
        return resultFeatures;
    }

    public static List getFeaturesFromTGeoXML(String xml, String charset) {
        ArrayList<A> result = new ArrayList<A>();
        Document doc = XMLUtils.createDocument(xml, charset);
        Node root = XMLUtils.getChild(doc, "layer");
        List features = XMLUtils.getChildren(root, "feature");
        int size = features.size();
        int i = 0;
        while (i < size) {
            Node featureNode = (Node)features.get(i);
            Node attributeRoot = XMLUtils.getChild(featureNode, "attribute");
            List attributeList = XMLUtils.getChildren(attributeRoot, "a");
            HashMap<String, String> attributes = new HashMap<String, String>();
            int ai = 0;
            while (ai < attributeList.size()) {
                Node aNode = (Node)attributeList.get(ai);
                String key = XMLUtils.getPropertyValue(aNode, "n");
                String value = XMLUtils.getPropertyValue(aNode, "v");
                attributes.put(key, value);
                ++ai;
            }
            Node shape = XMLUtils.getChild(featureNode, "shape");
            List surfaces = XMLUtils.getChildren(shape, "lines");
            Vector polygonArray = new Vector();
            Vector<Integer> segments = new Vector<Integer>();
            int sc = surfaces.size();
            int j = 0;
            while (j < sc) {
                Node surface = (Node)surfaces.get(j);
                List lines = XMLUtils.getChildren(surface, "l");
                int lc = lines.size();
                int v = 0;
                while (v < lc) {
                    Node lineNode = (Node)lines.get(v);
                    String cline = XMLUtils.getNodeValue(lineNode);
                    Vector<GeoCoordinate> line = new Vector<GeoCoordinate>();
                    String[] coStrings = cline.split(" ");
                    int coindex = 0;
                    while (coindex < coStrings.length) {
                        if (coindex == 0) {
                            segments.add(new Integer(0));
                        } else {
                            segments.add(new Integer(1));
                        }
                        String cs = coStrings[coindex];
                        String[] co = cs.split(",");
                        GeoCoordinate geo = new GeoCoordinate(Double.parseDouble(co[1]), Double.parseDouble(co[0]));
                        line.add(geo);
                        ++coindex;
                    }
                    polygonArray.addAll(line);
                    ++v;
                }
                ++j;
            }
            A feature = new A();
            Vector ps = new Vector();
            ps.add(polygonArray);
            ps.add(segments);
            feature.A(ps);
            if (attributes.size() > 0) {
                feature.A(attributes);
            }
            result.add(feature);
            ++i;
        }
        return result;
    }
}

