/*
 * Decompiled with CFR 0.152.
 */
package y.view;

import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import y.base.Edge;
import y.geom.YDimension;
import y.geom.YPoint;
import y.geom.YRectangle;
import y.io.BadVersionException;
import y.layout.DiscreteEdgeLabelModel;
import y.layout.EdgeLabelLayout;
import y.layout.EdgeLabelModel;
import y.layout.FreeEdgeLabelModel;
import y.layout.SliderEdgeLabelModel;
import y.view.EdgeRealizer;
import y.view.Graph2D;
import y.view.NodeRealizer;
import y.view.YLabel;

public class EdgeLabel
extends YLabel
implements EdgeLabelLayout {
    static final byte ab = 7;
    public static final byte HEAD = 10;
    public static final byte TAIL = 11;
    public static final byte CENTER = 12;
    public static final byte SHEAD = 13;
    public static final byte THEAD = 14;
    public static final byte STAIL = 15;
    public static final byte TTAIL = 16;
    public static final byte SCENTR = 17;
    public static final byte TCENTR = 18;
    public static final byte ANYWHERE = 99;
    public static final byte CENTER_RATIO = 19;
    public static final byte TAIL_RATIO = 20;
    public static final byte HEAD_RATIO = 21;
    public static final byte DYNAMIC = 24;
    public static final byte TWO_POS = 0;
    public static final byte CENTERED = 1;
    public static final byte SIX_POS = 2;
    public static final byte THREE_CENTER = 3;
    public static final byte FREE = 4;
    public static final byte CENTER_SLIDER = 5;
    public static final byte SIDE_SLIDER = 6;
    public static final byte UNDEFINED = 127;
    private static final byte[][] af = new byte[][]{{10, 11}, {12}, {10, 13, 14, 11, 15, 16}, {12, 17, 18}, {99}, {24}, {24}};
    private double ad = 0.5;
    private EdgeLabelModel ae = new DiscreteEdgeLabelModel(63);
    private Object aa = this.ae.getDefaultParameter();
    private EdgeRealizer ai;
    private double ac = 2.0;
    private byte ag = 0;
    YRectangle ah;

    public EdgeLabel(String string, byte by) {
        this.setModel(by);
        this.setText(string);
    }

    public EdgeLabel(String string) {
        this(string, 2);
    }

    public EdgeLabel() {
        this("");
    }

    public Object clone() {
        EdgeLabel edgeLabel = new EdgeLabel();
        edgeLabel.adoptValues(this);
        return edgeLabel;
    }

    public void calculateOffset() {
        try {
            Graph2D graph2D = this.getGraph2D();
            NodeRealizer nodeRealizer = graph2D.getRealizer(this.getEdge().source());
            NodeRealizer nodeRealizer2 = graph2D.getRealizer(this.getEdge().target());
            YPoint yPoint = this.getLabelModel().getLabelPlacement(new YDimension(this.getWidth(), this.getHeight()), this.ai, nodeRealizer, nodeRealizer2, this.getModelParameter());
            Point2D point2D = this.ai.getSourceIntersection();
            super.setOffset(yPoint.getX() - point2D.getX(), yPoint.getY() - point2D.getY());
        }
        catch (Exception exception) {}
    }

    public void setText(String string) {
        String string2 = this.getText();
        super.setText(string);
        Graph2D graph2D = this.getGraph2D();
        if (graph2D != null) {
            graph2D.fireGraph2DEvent(this, "text", string2, this.getText());
        }
    }

    public void setDistance(double d2) {
        this.ac = d2;
        if (this.ae instanceof SliderEdgeLabelModel) {
            ((SliderEdgeLabelModel)this.ae).setDistances(this.ac, this.ac);
        }
        if (this.ae instanceof DiscreteEdgeLabelModel) {
            ((DiscreteEdgeLabelModel)this.ae).setDistance(this.ac);
        }
        this.setOffsetDirty();
    }

    public void setOffset(double d2, double d3) {
        super.setOffset(d2, d3);
        this.ah = null;
        if (this.ae instanceof FreeEdgeLabelModel) {
            this.aa = ((FreeEdgeLabelModel)this.ae).createModelParameter(this.getBox(), this.ai, this.ai.getSourceRealizer(), this.ai.getTargetRealizer());
        }
    }

    public double getDistance() {
        return this.ac;
    }

    public void setPreferredPlacement(byte by) {
        this.ag = by;
    }

    public byte getPreferredPlacement() {
        return this.ag;
    }

    public void setRatio(double d2) {
        if (this.model != 5 && this.model != 6) {
            throw new IllegalStateException("label ratio cannot be set directly for current model");
        }
        this.ad = d2;
    }

    public double getRatio() {
        return this.ad;
    }

    public boolean hasFreePositioning() {
        return this.model == 4;
    }

    public boolean hasSliderPositioning() {
        return this.model == 5 || this.model == 6;
    }

    public void setModel(byte by) {
        if (by == this.model) {
            return;
        }
        if (by >= 0 && by <= 7) {
            EdgeLabelModel edgeLabelModel;
            this.model = by;
            EdgeLabelModel edgeLabelModel2 = this.ae;
            this.setOffsetDirty();
            switch (this.model) {
                case 0: {
                    this.ae = new DiscreteEdgeLabelModel(18);
                    break;
                }
                case 1: {
                    this.ae = new DiscreteEdgeLabelModel(128);
                    break;
                }
                case 2: {
                    this.ae = new DiscreteEdgeLabelModel(63);
                    break;
                }
                case 3: {
                    this.ae = new DiscreteEdgeLabelModel(448);
                    break;
                }
                case 4: {
                    this.ae = new FreeEdgeLabelModel();
                    break;
                }
                case 5: {
                    this.ae = new SliderEdgeLabelModel(0);
                    break;
                }
                case 6: {
                    this.ae = new SliderEdgeLabelModel(1);
                }
            }
            if (edgeLabelModel2 instanceof DiscreteEdgeLabelModel && this.ae instanceof DiscreteEdgeLabelModel && ((DiscreteEdgeLabelModel)(edgeLabelModel = (DiscreteEdgeLabelModel)this.ae)).isParameterValid(this.aa)) {
                return;
            }
            this.setDistance(this.ac);
            if (this.ae instanceof FreeEdgeLabelModel) {
                edgeLabelModel = (FreeEdgeLabelModel)this.ae;
                try {
                    this.aa = ((FreeEdgeLabelModel)edgeLabelModel).createModelParameter(this.getBox(), this.ai, this.ai.getSourceRealizer(), this.ai.getTargetRealizer());
                }
                catch (Exception exception) {}
            } else {
                this.aa = this.ae.getDefaultParameter();
            }
            this.placement = this.getPosition();
        }
    }

    public byte getPosition() {
        if (this.ae instanceof DiscreteEdgeLabelModel) {
            int n = (Integer)this.aa;
            switch (n) {
                case 1: {
                    return 13;
                }
                case 2: {
                    return 10;
                }
                case 4: {
                    return 14;
                }
                case 64: {
                    return 17;
                }
                case 128: {
                    return 12;
                }
                case 256: {
                    return 18;
                }
                case 8: {
                    return 15;
                }
                case 16: {
                    return 11;
                }
                case 32: {
                    return 16;
                }
            }
        }
        if (this.ae instanceof FreeEdgeLabelModel) {
            return 99;
        }
        if (this.ae instanceof SliderEdgeLabelModel) {
            return 24;
        }
        return 127;
    }

    public void setPosition(byte by) {
        if (!(this.ae instanceof DiscreteEdgeLabelModel)) {
            return;
        }
        DiscreteEdgeLabelModel discreteEdgeLabelModel = (DiscreteEdgeLabelModel)this.ae;
        int n = 0;
        switch (by) {
            case 13: {
                n = 1;
                break;
            }
            case 10: {
                n = 2;
                break;
            }
            case 14: {
                n = 4;
                break;
            }
            case 17: {
                n = 64;
                break;
            }
            case 12: {
                n = 128;
                break;
            }
            case 18: {
                n = 256;
                break;
            }
            case 15: {
                n = 8;
                break;
            }
            case 11: {
                n = 16;
                break;
            }
            case 16: {
                n = 32;
            }
        }
        Integer n2 = new Integer(n);
        if (!discreteEdgeLabelModel.isParameterValid(n2)) {
            System.err.println("ELabel::setPos: ERROR: pos " + by + " not valid for model " + this.model);
            return;
        }
        this.aa = n2;
        this.setOffsetDirty();
    }

    public static Map modelToStringMap() {
        HashMap<Byte, String> hashMap = new HashMap<Byte, String>(11);
        hashMap.put(new Byte(1), "Centered");
        hashMap.put(new Byte(0), "2 Pos");
        hashMap.put(new Byte(2), "6 Pos");
        hashMap.put(new Byte(3), "3 Pos Center");
        hashMap.put(new Byte(4), "Free");
        hashMap.put(new Byte(5), "Center Slider");
        hashMap.put(new Byte(6), "Side Slider");
        return hashMap;
    }

    public static Map positionToStringMap() {
        HashMap<Byte, String> hashMap = new HashMap<Byte, String>(21);
        hashMap.put(new Byte(10), "Head");
        hashMap.put(new Byte(11), "Tail");
        hashMap.put(new Byte(12), "Center");
        hashMap.put(new Byte(13), "Source Head");
        hashMap.put(new Byte(14), "Target Head");
        hashMap.put(new Byte(15), "Source Tail");
        hashMap.put(new Byte(16), "Target Tail");
        hashMap.put(new Byte(99), "Anywhere");
        hashMap.put(new Byte(19), "Center");
        hashMap.put(new Byte(20), "Tail");
        hashMap.put(new Byte(21), "Head");
        hashMap.put(new Byte(24), "Dynamic");
        hashMap.put(new Byte(17), "Source Center");
        hashMap.put(new Byte(18), "Target Center");
        hashMap.put(new Byte(127), "Undefined");
        return hashMap;
    }

    public static Map preferredPlacementsToStringMap() {
        HashMap<Byte, String> hashMap = new HashMap<Byte, String>(3);
        hashMap.put(new Byte(2), "At Target");
        hashMap.put(new Byte(1), "At Source");
        hashMap.put(new Byte(4), "At Center");
        hashMap.put(new Byte(0), "Anywhere");
        return hashMap;
    }

    public static final byte[] getModelPositions(byte by) {
        return af[by];
    }

    public byte[] getModelPositions() {
        return EdgeLabel.getModelPositions(this.getModel());
    }

    public static Vector availablePositions(Byte by) {
        Vector<Byte> vector = new Vector<Byte>(10);
        if (by != null) {
            byte[] byArray = EdgeLabel.getModelPositions(by);
            int n = 0;
            while (n < byArray.length) {
                vector.add(new Byte(byArray[n]));
                ++n;
            }
        } else {
            vector.add(new Byte(127));
        }
        return vector;
    }

    public Edge getEdge() {
        return this.ai != null ? this.ai.getEdge() : null;
    }

    protected Graph2D getGraph2D() {
        Edge edge = this.getEdge();
        if (edge == null) {
            return null;
        }
        Graph2D graph2D = (Graph2D)edge.getGraph();
        return graph2D;
    }

    public EdgeRealizer getOwner() {
        return this.ai;
    }

    public void bindRealizer(EdgeRealizer edgeRealizer) {
        this.ai = edgeRealizer;
        this.setOffsetDirty();
    }

    public EdgeLabelModel getLabelModel() {
        return this.ae;
    }

    public Object getModelParameter() {
        return this.aa;
    }

    public void setModelParameter(Object object) {
        this.aa = object;
        this.placement = this.getPosition();
        this.setOffsetDirty();
    }

    public void setLabelModel(EdgeLabelModel edgeLabelModel) {
        this.ae = edgeLabelModel;
        this.setOffsetDirty();
    }

    public void setOffsetDirty() {
        this.ah = null;
        super.setOffsetDirty();
    }

    public void setSizeDirty() {
        this.ah = null;
        super.setSizeDirty();
    }

    public YRectangle getBox() {
        Point2D point2D = this.ai.getSourceIntersection();
        if (this.ah != null) {
            return this.ah;
        }
        this.ah = new YRectangle(point2D.getX() + this.getOffsetX(), point2D.getY() + this.getOffsetY(), this.getWidth(), this.getHeight());
        return this.ah;
    }

    public YPoint getLocation() {
        Point2D point2D = this.getOwner().getSourceIntersection();
        return new YPoint(point2D.getX() + this.getOffsetX(), point2D.getY() + this.getOffsetY());
    }

    public void write(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeByte(1);
        super.write(objectOutputStream);
        objectOutputStream.writeFloat((float)this.ad);
    }

    public void read(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        switch (objectInputStream.readByte()) {
            case 0: {
                super.read(objectInputStream);
                this.setBackgroundPainted(objectInputStream.readBoolean());
                this.ad = objectInputStream.readFloat();
                break;
            }
            case 1: {
                EdgeRealizer edgeRealizer;
                super.read(objectInputStream);
                this.ad = objectInputStream.readFloat();
                if (this.model != 5 && this.model != 6 || (edgeRealizer = this.getOwner()) == null) break;
                NodeRealizer nodeRealizer = edgeRealizer.getSourceRealizer();
                NodeRealizer nodeRealizer2 = edgeRealizer.getTargetRealizer();
                Point2D point2D = edgeRealizer.getSourceIntersection();
                Object object = this.ae.createModelParameter(new YRectangle(point2D.getX() + this.offsetX, point2D.getY() + this.offsetY, this.width, this.height), this.getOwner(), this.getOwner().getSourceRealizer(), this.getOwner().getTargetRealizer());
                this.setModelParameter(object);
                break;
            }
            default: {
                throw new BadVersionException();
            }
        }
    }
}

