/*
 * Decompiled with CFR 0.152.
 */
package y.layout.hierarchic;

import y.algo.Cycles;
import y.algo.NodeOrders;
import y.algo.RankAssignments;
import y.base.DataProvider;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.EdgeList;
import y.base.EdgeMap;
import y.base.Graph;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeList;
import y.base.NodeMap;
import y.base.YCursor;
import y.base.YList;
import y.layout.LayoutGraph;
import y.layout.hierarchic.Layerer;
import y.util.D;
import y.util.Maps;

public class WeightedLayerer
implements Layerer {
    protected DataProvider weight;
    protected Object key = null;

    public WeightedLayerer() {
    }

    public WeightedLayerer(Object object) {
        this.key = object;
    }

    public int assignNodeLayer(LayoutGraph layoutGraph, NodeMap nodeMap, EdgeList edgeList) {
        if (this.key != null) {
            return this.assignNodeLayer(layoutGraph, nodeMap, edgeList, layoutGraph.getDataProvider(this.key));
        }
        return this.assignNodeLayer(layoutGraph, nodeMap, edgeList, null);
    }

    public int assignNodeLayer(LayoutGraph layoutGraph, NodeMap nodeMap, EdgeList edgeList, DataProvider dataProvider) {
        this.weight = dataProvider;
        D.bug(this, (Object)"Make acyclic");
        this.makeDFSAcyclic(layoutGraph, edgeList);
        D.bug(this, (Object)"Assign layers");
        int n = this.assignLayers(layoutGraph, nodeMap);
        D.bug(this, (Object)"done");
        return n;
    }

    public void makeDFSAcyclic(LayoutGraph layoutGraph, EdgeList edgeList) {
        EdgeMap edgeMap = Maps.createIndexEdgeMap(new boolean[layoutGraph.E()]);
        Cycles.findCycleEdgesDFS(layoutGraph, edgeMap);
        EdgeCursor edgeCursor = layoutGraph.edges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            if (edgeMap.getBool(edge)) {
                layoutGraph.reverseEdge(edge);
                edgeList.add(edge);
            }
            edgeCursor.next();
        }
    }

    public int assignLayers(Graph graph, NodeMap nodeMap) {
        int n = RankAssignments.simplex(graph, nodeMap, this.weight, null);
        return n;
    }

    public int assignLayersFast(Graph graph, NodeMap nodeMap) {
        NodeList nodeList = NodeOrders.dfsCompletion(graph);
        nodeList.reverse();
        NodeCursor nodeCursor = nodeList.nodes();
        while (nodeCursor.ok()) {
            nodeMap.setInt(nodeCursor.node(), 0);
            nodeCursor.next();
        }
        int n = 0;
        NodeCursor nodeCursor2 = nodeList.nodes();
        while (nodeCursor2.ok()) {
            Node node = nodeCursor2.node();
            int n2 = nodeMap.getInt(node);
            if (n2 > n) {
                n = n2;
            }
            EdgeCursor edgeCursor = node.outEdges();
            while (edgeCursor.ok()) {
                Edge edge = edgeCursor.edge();
                if (n2 + this.weight.getInt(edge) > nodeMap.getInt(edge.target())) {
                    nodeMap.setInt(edge.target(), n2 + this.weight.getInt(edge));
                }
                edgeCursor.next();
            }
            nodeCursor2.next();
        }
        return n + 1;
    }

    protected void downShiftNodes(Graph graph, NodeMap nodeMap, int n) {
        YList[] yListArray = new YList[n + 1];
        int n2 = 0;
        while (n2 <= n) {
            yListArray[n2] = new YList();
            ++n2;
        }
        NodeCursor nodeCursor = graph.nodes();
        while (nodeCursor.ok()) {
            yListArray[nodeMap.getInt(nodeCursor.node())].addLast(nodeCursor.node());
            nodeCursor.next();
        }
        int n3 = n - 1;
        while (n3 >= 0) {
            YList yList = yListArray[n3];
            YCursor yCursor = yList.cursor();
            while (yCursor.ok()) {
                Node node = (Node)yCursor.current();
                if (node.outDegree() != 0) {
                    int n4 = n;
                    EdgeCursor edgeCursor = node.outEdges();
                    while (edgeCursor.ok()) {
                        n4 = Math.min(n4, nodeMap.getInt(edgeCursor.edge().target()) - this.weight.getInt(edgeCursor.edge()));
                        edgeCursor.next();
                    }
                    if (n4 > nodeMap.getInt(node) && node.outDegree() >= node.inDegree()) {
                        nodeMap.setInt(node, n4);
                    }
                }
                yCursor.next();
            }
            --n3;
        }
    }
}

