/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.button;

import com.nepxion.swing.button.BasicButtonModel;
import com.nepxion.swing.button.JBasicButton;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class JBasicMenuButton
extends JBasicButton
implements MouseListener,
PopupMenuListener {
    protected JPopupMenu popupMenu;

    public JBasicMenuButton() {
        this.initComponents();
    }

    public JBasicMenuButton(Action action) {
        super(action);
        this.initComponents();
    }

    public JBasicMenuButton(String text) {
        super(text);
        this.initComponents();
    }

    public JBasicMenuButton(Icon icon) {
        super(icon);
        this.initComponents();
    }

    public JBasicMenuButton(String text, Icon icon) {
        super(text, icon);
        this.initComponents();
    }

    public JBasicMenuButton(String text, String toolTipText) {
        super(text);
        this.initComponents();
        this.setToolTipText(toolTipText);
    }

    public JBasicMenuButton(Icon icon, String toolTipText) {
        super(icon);
        this.initComponents();
        this.setToolTipText(toolTipText);
    }

    public JBasicMenuButton(String text, Icon icon, String toolTipText) {
        super(text, icon);
        this.initComponents();
        this.setToolTipText(toolTipText);
    }

    private void initComponents() {
        this.widthInset += 7;
        this.addMouseListener(this);
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public void setPopupMenu(JPopupMenu popupMenu) {
        this.popupMenu = popupMenu;
        this.popupMenu.addPopupMenuListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        BasicButtonModel buttonModel = (BasicButtonModel)this.getModel();
        if (!buttonModel.isEnabled()) {
            return;
        }
        if (SwingUtilities.isLeftMouseButton(e) && this.popupMenu != null) {
            this.popupMenu.show(this, 0, this.getSize().height);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        BasicButtonModel buttonModel = (BasicButtonModel)this.getModel();
        buttonModel.setMenuDropDown(true);
        this.repaint();
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        BasicButtonModel buttonModel = (BasicButtonModel)this.getModel();
        buttonModel.setMenuDropDown(false);
        this.repaint();
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }
}

