/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.fullscreen;

import com.nepxion.swing.fullscreen.FullScreenConstants;
import com.nepxion.swing.fullscreen.FullScreenSupport;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JMenuItem;

public class FullScreenRegister
extends MouseAdapter
implements ActionListener {
    private FullScreenSupport fullScreenSupport;
    private List buttons;

    public FullScreenRegister(FullScreenSupport fullScreenSupport) {
        this.fullScreenSupport = fullScreenSupport;
        this.buttons = new ArrayList();
    }

    public void register(Component component) {
        if (component != null) {
            component.addMouseListener(this);
        }
    }

    public void register(AbstractButton button) {
        if (button != null) {
            button.addActionListener(this);
            this.buttons.add(button);
        }
    }

    public void toggleFullScreen() {
        for (AbstractButton button : this.buttons) {
            this.adaptButtonFacade(button);
        }
        this.fullScreenSupport.toggleFullScreen();
    }

    private void adaptButtonFacade(AbstractButton button) {
        String text = null;
        Icon icon = null;
        boolean selected = false;
        if (this.fullScreenSupport.isFullScreen()) {
            text = FullScreenConstants.TEXT_MAXIMIZE;
            icon = FullScreenConstants.ICON_MAXIMIZE;
            selected = false;
        } else {
            text = FullScreenConstants.TEXT_RESTORE;
            icon = FullScreenConstants.ICON_MAXIMIZE_RESTORE;
            selected = true;
        }
        if (button instanceof JMenuItem) {
            button.setSelected(selected);
        } else {
            if (!button.getText().equals("")) {
                button.setText(text);
            }
            if (button.getIcon() != null) {
                button.setIcon(icon);
            }
            button.setToolTipText(text);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() > 1) {
            this.toggleFullScreen();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.toggleFullScreen();
    }
}

