/*
 * Decompiled with CFR 0.152.
 */
package twaver.network.ui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import twaver.Group;
import twaver.TDataBox;
import twaver.UndoRedoEvent;
import twaver.base.A.D.M;
import twaver.base.A.D.O;
import twaver.base.A.D.P;
import twaver.base.A.E.W;
import twaver.base.A.E.b;
import twaver.base.A.E.c;
import twaver.base.A.E.j;
import twaver.network.TNetwork;
import twaver.network.ui.BorderUI;
import twaver.network.ui.GroupHandlerAttachment;
import twaver.network.ui.NodeUI;

public class GroupUI
extends NodeUI {
    private int T;
    private int U;
    private int X;
    private Insets S;
    private boolean J;
    private boolean H;
    private boolean M;
    private Stroke N;
    private boolean Q;
    private boolean O;
    private Color L;
    private Color W;
    private boolean Y;
    private Color R;
    private O V;
    private Point K;
    private Shape I;
    private Group P;

    public GroupUI(TNetwork network, Group group) {
        super(network, group);
        this.P = group;
        this.J = group.isGroup3D();
        this.H = group.isGroupAntialias();
        this.T = group.getGroupDeep();
        this.U = group.getGroupAngle();
        this.M = group.isGroupOutline();
        this.N = b.F(this.element, "group.outline.stroke");
        this.Q = group.isGroupFill();
        this.O = group.isGroupOpaque();
        this.L = group.getGroupFillColor();
        this.W = group.getGroupOutlineColor();
        this.S = group.getGroupInsets();
        this.X = group.getGroupChildrenOutcrop();
        this.Y = group.isGroupGradient();
        this.R = group.getGroupGradientColor();
        this.V = b.I(group, "group.gradient.factory");
        this.attachments.add(new GroupHandlerAttachment(this));
    }

    public Group getGroup() {
        return this.P;
    }

    public boolean contains(int x, int y) {
        if (twaver.base.A.E.W.C(this.element)) {
            Area area = new Area(this.getShape());
            Area attachmentArea = this.getSeletableAttachementsArea();
            if (attachmentArea != null) {
                area.add(attachmentArea);
            }
            return area.contains(x, y);
        }
        return super.contains(x, y);
    }

    public void performAction(int gesture, MouseEvent e2) {
        if (gesture == 2 && this.P.isGroupDoubleClickEnable()) {
            this.reverseExpand();
        }
    }

    protected void reverseExpand() {
        Group group = (Group)this.element;
        if (!group.isEmpty()) {
            this.network.getDataBox().getUndoRedoManager().setIgnorePropertyChange(true);
            group.setExpand(!group.isExpand());
            this.network.getDataBox().getUndoRedoManager().setIgnorePropertyChange(false);
            TDataBox box = this.network.getDataBox();
            if (box.getUndoRedoManager().getLimit() > 0) {
                UndoRedoEvent event = new UndoRedoEvent(group);
                box.getUndoRedoManager().addEvent(event);
            }
        }
    }

    protected boolean isCustomDraw() {
        if (twaver.base.A.E.W.C(this.element)) {
            return false;
        }
        return super.isCustomDraw();
    }

    public Point getHotspot() {
        this.updateCacheShape();
        return (Point)this.K.clone();
    }

    public void updateClientProperty(String propertyName) {
        if (!propertyName.startsWith("group.")) {
            super.updateClientProperty(propertyName);
            return;
        }
        if (propertyName.equals("group.outline")) {
            this.M = this.P.isGroupOutline();
        } else if (propertyName.equals("group.outline.stroke")) {
            this.N = b.F(this.element, "group.outline.stroke");
        } else if (propertyName.equals("group.fill")) {
            this.Q = this.P.isGroupFill();
        } else if (propertyName.equals("group.opaque")) {
            this.O = this.P.isGroupOpaque();
        } else if (propertyName.equals("group.outline.color")) {
            this.W = this.P.getGroupOutlineColor();
        } else if (propertyName.equals("group.fill.color")) {
            this.L = this.P.getGroupFillColor();
        } else if (propertyName.equals("group.3d")) {
            this.J = this.P.isGroup3D();
        } else if (propertyName.equals("group.deep")) {
            this.T = this.P.getGroupDeep();
        } else if (propertyName.equals("group.angle")) {
            this.U = this.P.getGroupAngle();
        } else if (propertyName.equals("group.antialias")) {
            this.H = this.P.isGroupAntialias();
        } else if (propertyName.equals("group.insets")) {
            this.S = this.P.getGroupInsets();
        } else if (propertyName.equals("group.children.outcrop")) {
            this.X = this.P.getGroupChildrenOutcrop();
        } else if (propertyName.equals("group.gradient")) {
            this.Y = this.P.isGroupGradient();
        } else if (propertyName.equals("group.gradient.color")) {
            this.R = this.P.getGroupGradientColor();
        } else if (propertyName.equals("group.gradient.factory")) {
            this.V = b.I(this.P, "group.gradient.factory");
        }
    }

    public void paint(Graphics2D g2d) {
        this.updateCacheShape();
        if (twaver.base.A.E.W.C(this.element)) {
            Shape shape;
            BorderUI border = this.getBorder();
            if (border != null && border.isUnderneath()) {
                this.paintBorder(g2d);
            }
            Object oldAntialiasValue = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            if (this.H) {
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            } else {
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
            Composite oldComposite = null;
            if (this.renderAlpha != 1.0f) {
                oldComposite = g2d.getComposite();
                AlphaComposite composite = AlphaComposite.getInstance(3, this.renderAlpha);
                g2d.setComposite(composite);
            }
            if ((shape = this.getShape()) instanceof M) {
                this.A(g2d, (M)shape);
            } else if (shape instanceof P) {
                this.A(g2d, (P)shape);
            } else {
                this.A(g2d, shape);
            }
            if (oldComposite != null) {
                g2d.setComposite(oldComposite);
            }
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAntialiasValue);
            if (border != null && !border.isUnderneath()) {
                this.paintBorder(g2d);
            }
            this.paintAttachments(g2d);
        } else {
            super.paint(g2d);
        }
    }

    private void A(Graphics2D g2, Shape shape) {
        Color color;
        if (this.Q) {
            color = this.E();
            this.B(g2, color, shape);
            g2.fill(shape);
        }
        if ((color = this.D()) != null) {
            g2.setStroke(this.N);
            g2.setColor(color);
            g2.draw(shape);
        }
    }

    private void B(Graphics2D g2, Color color, Shape shape) {
        if (this.Y) {
            Paint paint = this.V.A(shape.getBounds(), this.R, color);
            g2.setPaint(paint);
        } else {
            this.setBodyPaint(g2, color);
        }
    }

    private void A(Graphics2D g2, M e3) {
        Color color;
        if (this.Q) {
            color = this.E();
            this.B(g2, color, e3.A());
            g2.fill(e3.A());
            g2.setColor(color.darker());
            g2.fill(e3.B());
        }
        if ((color = this.D()) != null) {
            g2.setStroke(this.N);
            g2.setColor(color);
            g2.draw(e3.A());
            g2.draw(e3.B());
        }
    }

    private void A(Graphics2D g2, P p3) {
        Color color;
        if (this.Q) {
            color = this.E();
            this.B(g2, color, p3);
            g2.fill(p3);
            g2.setColor(color.darker());
            g2.fill(p3.E());
            g2.setColor(color.brighter());
            g2.fill(p3.F());
        }
        if ((color = this.D()) != null) {
            g2.setStroke(this.N);
            g2.setColor(color);
            g2.draw(p3);
            g2.draw(p3.E());
            g2.draw(p3.F());
        }
    }

    public Rectangle getUIBounds() {
        Rectangle bounds;
        Rectangle borderRect;
        Rectangle result = this.getShape().getBounds();
        BorderUI borderUI = this.getBorder();
        if (borderUI != null && (borderRect = borderUI.getBounds()) != null) {
            result.add(borderRect);
        }
        if ((bounds = this.getAttachementsBounds()) != null) {
            result.add(bounds);
        }
        return result;
    }

    protected Shape createShape() {
        int groupType = this.P.getGroupType();
        if (groupType == 1) {
            return c.A(this);
        }
        if (groupType == 4) {
            return c.D(this);
        }
        if (groupType == 5) {
            return c.E(this);
        }
        if (groupType == 2) {
            if (this.J) {
                return c.C(this);
            }
            return c.G(this);
        }
        if (groupType == 3) {
            if (this.J) {
                return c.I(this);
            }
            return c.H(this);
        }
        if (groupType == 6) {
            return c.B(this);
        }
        return null;
    }

    protected void updateCacheShape() {
        if (this.I != null) {
            return;
        }
        Group group = (Group)this.element;
        this.K = null;
        if (group.isExpand()) {
            this.I = this.createShape();
        }
        if (this.I == null) {
            this.I = twaver.base.A.E.W.E(group);
            if (this.isCustomDraw()) {
                this.K = super.getHotspot();
            }
        }
        if (this.K == null) {
            Shape shape = this.getShape();
            this.K = j.A(shape, group);
        }
        if (this.I == null) {
            this.updateCacheShape();
        }
    }

    public Shape getShape() {
        this.updateCacheShape();
        return this.I;
    }

    public void invalidateShape() {
        this.I = null;
        ((Group)this.element).firePropertyChange("groupUIShape", false, true);
    }

    private Color D() {
        Color color = super.getStateOutlineColor();
        if (color != null) {
            return color;
        }
        if (this.M) {
            return this.W;
        }
        return null;
    }

    private Color E() {
        Color color = super.getPaintBodyColor(this.L);
        if (this.O) {
            return color;
        }
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), 125);
    }

    public int getAngle() {
        return this.U;
    }

    public int getDeep() {
        return this.T;
    }

    public Insets getGroupInsets() {
        return this.S;
    }

    public int getOutcrop() {
        return this.X;
    }

    public Shape getBorderShape() {
        if (twaver.base.A.E.W.C(this.element)) {
            return this.getShape();
        }
        return null;
    }
}

