/*
 * Decompiled with CFR 0.152.
 */
package twaver.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.JTextComponent;
import twaver.ElementAttribute;
import twaver.ElementAttributeVisibleFilter;
import twaver.TPropertyDescriptor;
import twaver.TUIManager;
import twaver.TWaverConst;
import twaver.TWaverUtil;
import twaver.table.Category;
import twaver.table.PropertySheetEvent;
import twaver.table.PropertySheetListener;
import twaver.table.TPropertySheet;
import twaver.table.renderer.StringRenderer;
import twaver.table.renderer.TextAreaRenderer;

public class TPropertySheetPane
extends JPanel {
    private ActionListener A = new ActionListener(){

        public void actionPerformed(ActionEvent e2) {
            Object source = e2.getSource();
            if (source == TPropertySheetPane.this.categoryButton) {
                if (TPropertySheetPane.this.categoryButton.isSelected()) {
                    TPropertySheetPane.this.sheet.setMode(1);
                } else {
                    TPropertySheetPane.this.sheet.setMode(0);
                }
            } else if (source == TPropertySheetPane.this.sortButton) {
                TPropertySheetPane.this.sheet.setSortingProperties(TPropertySheetPane.this.sortButton.isSelected());
            } else if (source == TPropertySheetPane.this.extraIndentButton) {
                TPropertySheetPane.this.sheet.setPropertyExtraIndent(TPropertySheetPane.this.extraIndentButton.isSelected());
            } else if (source == TPropertySheetPane.this.singleRootVisibleButton) {
                TPropertySheetPane.this.sheet.setSingleRootCategoryVisible(TPropertySheetPane.this.singleRootVisibleButton.isSelected());
            } else if (source == TPropertySheetPane.this.descriptionButton) {
                TPropertySheetPane.this.descriptionPane.setVisible(TPropertySheetPane.this.descriptionButton.isSelected());
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        1.access$000(this.this$1).sheet.ensureSelectedRowVisible();
                        1.access$000(this.this$1).updateDescription();
                    }
                });
            } else if (source == TPropertySheetPane.this.expandButton) {
                TPropertySheetPane.this.sheet.expandAllCategories();
            } else if (source == TPropertySheetPane.this.collapseButton) {
                TPropertySheetPane.this.sheet.collapseAllCategories();
            }
        }

        static /* synthetic */ TPropertySheetPane access$000(1 x0) {
            return x0.TPropertySheetPane.this;
        }
    };
    protected TextAreaRenderer textAreaRenderer = new TextAreaRenderer();
    protected TPropertySheet sheet = null;
    protected boolean isIgnoreCaseSearch = true;
    protected JToolBar toolbar = new JToolBar();
    protected AbstractButton categoryButton = this.createButton("category", true);
    protected AbstractButton sortButton = this.createButton("sort", true);
    protected AbstractButton extraIndentButton = this.createButton("indent", true);
    protected AbstractButton singleRootVisibleButton = this.createButton("root", true);
    protected AbstractButton descriptionButton = this.createButton("description", true);
    protected AbstractButton expandButton = this.createButton("expand", false);
    protected AbstractButton collapseButton = this.createButton("collapse", false);
    protected JTextField searchField = new JTextField();
    protected JPanel descriptionPane = new JPanel(new BorderLayout());
    protected JLabel descriptionTitle = new JLabel();
    private boolean B = TUIManager.getBoolean("sheet.show.value.in.description");
    protected _A description = new _A();
    protected JScrollPane descriptionScrollPane = new JScrollPane(this.description){
        {
            this.A();
        }

        private void A() {
            this.setBorder(null);
            this.setHorizontalScrollBarPolicy(31);
            this.setVerticalScrollBarPolicy(21);
        }

        public void updateUI() {
            super.updateUI();
            this.A();
        }
    };

    private Component A(int rowIndex) {
        TableCellRenderer renderer = this.getDescriptionRenderer(rowIndex);
        if (renderer != null) {
            Object value = this.sheet.getValueAt(rowIndex, 1);
            return renderer.getTableCellRendererComponent(this.sheet, value, false, false, rowIndex, 1);
        }
        return null;
    }

    public TableCellRenderer getDescriptionRenderer(int rowIndex) {
        TableCellRenderer renderer = this.sheet.getCellRenderer(rowIndex, 1);
        if (renderer instanceof StringRenderer) {
            renderer = this.textAreaRenderer;
        }
        return renderer;
    }

    public TPropertySheetPane(TPropertySheet sheet) {
        this(sheet, true);
    }

    public TPropertySheetPane(final TPropertySheet sheet, boolean simpleStyle) {
        this.sheet = sheet;
        this.setLayout(new BorderLayout(0, 1));
        this.toolbar.setMinimumSize(TWaverConst.EMPTY_DIMENSION);
        this.toolbar.setRollover(true);
        this.toolbar.setFloatable(false);
        this.initToolBar();
        if (this.toolbar.getComponentCount() == 0) {
            this.setSimpleStyle(simpleStyle);
        }
        this.categoryButton.setSelected(sheet.getMode() == 1);
        this.sortButton.setSelected(sheet.isSortingProperties());
        this.extraIndentButton.setSelected(sheet.isPropertyExtraIndent());
        this.singleRootVisibleButton.setSelected(sheet.isSingleRootCategoryVisible());
        boolean value = TUIManager.getBoolean("sheet.description.visible");
        this.descriptionButton.setSelected(value);
        this.descriptionPane.setVisible(value);
        this.descriptionTitle.setFont(TUIManager.getDefaultBoldFont());
        this.descriptionPane.add((Component)this.descriptionTitle, "North");
        this.descriptionPane.add((Component)this.descriptionScrollPane, "Center");
        this.add((Component)this.toolbar, "North");
        this.add((Component)new JScrollPane(sheet), "Center");
        this.add((Component)this.descriptionPane, "South");
        this.sheet.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("sheet.mode".equals(propertyName) || "sheet.sorting.properties".equals(propertyName) || "sheet.single.root.category.visible".equals(propertyName) || "sheet.property.extra.indent".equals(propertyName)) {
                    TPropertySheetPane.this.updateButtonsState();
                }
            }
        });
        this.sheet.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e2) {
                if (!e2.getValueIsAdjusting()) {
                    TPropertySheetPane.this.updateDescription();
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e2) {
                TPropertySheetPane.this.updateDescription();
            }
        });
        this.sheet.addPropertySheetListener(new PropertySheetListener(){

            public void propertySheetChanged(PropertySheetEvent event) {
                if (event.getType() == 1 && event.getRowIndex() == TPropertySheetPane.this.description.B()) {
                    TPropertySheetPane.this.updateDescription();
                }
            }
        });
        this.searchField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e2) {
                sheet.resetModel();
            }
        });
        this.sheet.A(new ElementAttributeVisibleFilter(){

            public boolean isVisible(ElementAttribute attribute) {
                return TPropertySheetPane.this.isVisible(attribute);
            }
        });
        this.updateButtonsState();
        this.updateDescription();
    }

    protected boolean isVisible(ElementAttribute attribute) {
        String text = this.searchField.getText();
        if (text == null || text.length() == 0) {
            return true;
        }
        TPropertyDescriptor property = this.sheet.getPropertyDescriptorByPropertyName(attribute.getKey());
        String displayName = property.getDisplayName();
        if (displayName == null) {
            return false;
        }
        if (this.isIgnoreCaseSearch) {
            return displayName.toLowerCase().indexOf(text.toLowerCase()) >= 0;
        }
        return displayName.indexOf(text) >= 0;
    }

    public void updateDescription() {
        if (!this.description.isVisible()) {
            return;
        }
        String title = null;
        String content = null;
        int rowHeight = this.sheet.getRowHeight();
        int rowIndex = this.sheet.getSelectionModel().getLeadSelectionIndex();
        List model = this.sheet.getPropertySheetModel().A();
        this.description.A(-1);
        Dimension size = new Dimension(this.description.getWidth(), rowHeight);
        this.description.setPreferredSize(size);
        this.description.setSize(size);
        if (rowIndex >= 0 && rowIndex < model.size()) {
            Object rowObject = model.get(rowIndex);
            if (rowObject instanceof Category) {
                Category category = (Category)rowObject;
                title = category.getDisplayName();
                String desc = category.getDescription();
                if (desc == null) {
                    desc = "";
                }
                if (this.B) {
                    title = title + ": " + desc;
                } else {
                    content = desc;
                }
            } else if (rowObject instanceof TPropertyDescriptor) {
                TPropertyDescriptor property = (TPropertyDescriptor)rowObject;
                title = property.getDisplayName();
                String desc = property.getElementAttribute().getDescription();
                if (desc == null) {
                    desc = "";
                }
                if (this.B) {
                    this.description.A(rowIndex);
                    title = title + ": " + desc;
                    Component component = this.A(rowIndex);
                    if (component != null) {
                        component.setSize(this.description.getWidth(), this.sheet.getRowHeight());
                        size = new Dimension(this.description.getWidth(), component.getPreferredSize().height);
                        if (size.height < rowHeight) {
                            size.height = rowHeight;
                        }
                        this.description.setPreferredSize(size);
                        this.description.setSize(size);
                    }
                } else {
                    content = desc;
                }
            }
        }
        this.descriptionTitle.setText(title);
        this.description.setText(content);
        this.description.repaint();
    }

    protected void initToolBar() {
    }

    public void setSimpleStyle(boolean simpleStyle) {
        this.toolbar.removeAll();
        if (simpleStyle) {
            this.toolbar.add(this.categoryButton);
            this.toolbar.add(this.sortButton);
            this.toolbar.add(this.descriptionButton);
            this.toolbar.add(this.searchField);
        } else {
            this.toolbar.add(this.categoryButton);
            this.toolbar.add(this.sortButton);
            this.toolbar.addSeparator();
            this.toolbar.add(this.expandButton);
            this.toolbar.add(this.collapseButton);
            this.toolbar.addSeparator();
            this.toolbar.add(this.descriptionButton);
            this.toolbar.addSeparator();
            this.toolbar.add(this.singleRootVisibleButton);
            this.toolbar.add(this.extraIndentButton);
            this.toolbar.addSeparator();
            this.toolbar.add(this.searchField);
        }
    }

    protected void updateButtonsState() {
        this.categoryButton.setSelected(this.sheet.getMode() == 1);
        this.sortButton.setSelected(this.sheet.isSortingProperties());
        this.extraIndentButton.setSelected(this.sheet.isPropertyExtraIndent());
        this.singleRootVisibleButton.setSelected(this.sheet.isSingleRootCategoryVisible());
    }

    protected AbstractButton createButton(String name, boolean isToggle) {
        Icon icon = TWaverUtil.getIcon("/resource/image/table/" + name + ".png");
        AbstractButton button = null;
        button = isToggle ? new JToggleButton(icon) : new JButton(icon);
        button.setToolTipText(TWaverUtil.getString("sheet." + name));
        button.setMargin(TWaverConst.NONE_INSETS);
        button.addActionListener(this.A);
        return button;
    }

    public TPropertySheet getPropertySheet() {
        return this.sheet;
    }

    public AbstractButton getCategoryButton() {
        return this.categoryButton;
    }

    public AbstractButton getCollapseButton() {
        return this.collapseButton;
    }

    public AbstractButton getDescriptionButton() {
        return this.descriptionButton;
    }

    public JTextComponent getDescriptionComponent() {
        return this.description;
    }

    public JPanel getDescriptionPane() {
        return this.descriptionPane;
    }

    public JLabel getDescriptionTitleLabel() {
        return this.descriptionTitle;
    }

    public AbstractButton getExpandButton() {
        return this.expandButton;
    }

    public AbstractButton getExtraIndentButton() {
        return this.extraIndentButton;
    }

    public AbstractButton getSingleRootVisibleButton() {
        return this.singleRootVisibleButton;
    }

    public AbstractButton getSortButton() {
        return this.sortButton;
    }

    public JToolBar getToolbar() {
        return this.toolbar;
    }

    public JScrollPane getDescriptionScrollPane() {
        return this.descriptionScrollPane;
    }

    public JTextField getSearchField() {
        return this.searchField;
    }

    public boolean isIgnoreCaseSearch() {
        return this.isIgnoreCaseSearch;
    }

    public void setIgnoreCaseSearch(boolean isIgnoreCaseSearch) {
        this.isIgnoreCaseSearch = isIgnoreCaseSearch;
    }

    public boolean isShowValueInDescription() {
        return this.B;
    }

    public void setShowValueInDescription(boolean showValueInDescription) {
        this.B = showValueInDescription;
        this.updateDescription();
    }

    class _A
    extends JTextArea {
        private CellRendererPane A = new CellRendererPane();
        private int B = -1;

        public _A() {
            this.add(this.A);
            this.A();
        }

        public int B() {
            return this.B;
        }

        private void A(int rowIndex) {
            this.B = rowIndex;
        }

        private void A() {
            this.setBorder(null);
            this.setEditable(false);
            this.setLineWrap(true);
            this.setForeground(UIManager.getColor("Label.foreground"));
            this.setBackground(UIManager.getColor("Label.background"));
        }

        public void paintComponent(Graphics g2) {
            Component component;
            super.paintComponent(g2);
            if (TPropertySheetPane.this.B && this.B != -1 && (component = TPropertySheetPane.this.A(this.B)) != null) {
                Rectangle cellRect = this.getBounds();
                this.A.paintComponent(g2, component, TPropertySheetPane.this.sheet, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
            }
        }

        public void updateUI() {
            super.updateUI();
            this.A();
        }
    }
}

