/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.renderer.list;

import com.nepxion.swing.element.IElementNode;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.border.Border;

public class ElementListCellRenderer
extends DefaultListCellRenderer {
    private JList list;
    private Border cellBorder;
    private Icon cellIcon;
    private int cellHeight = -1;

    public ElementListCellRenderer() {
        this((Border)null);
    }

    public ElementListCellRenderer(int cellHeight) {
        this((Border)null, cellHeight);
    }

    public ElementListCellRenderer(Icon cellIcon) {
        this((Border)null, cellIcon);
    }

    public ElementListCellRenderer(Border cellBorder) {
        this(cellBorder, null);
    }

    public ElementListCellRenderer(JList list) {
        this(list, (Border)null);
    }

    public ElementListCellRenderer(Icon cellIcon, int cellHeight) {
        this((Border)null, cellIcon, cellHeight);
    }

    public ElementListCellRenderer(Border cellBorder, int cellHeight) {
        this(cellBorder, null, cellHeight);
    }

    public ElementListCellRenderer(Border cellBorder, Icon cellIcon) {
        this(cellBorder, cellIcon, -1);
    }

    public ElementListCellRenderer(JList list, int cellHeight) {
        this(list, (Border)null, cellHeight);
    }

    public ElementListCellRenderer(JList list, Icon cellIcon) {
        this(list, null, cellIcon);
    }

    public ElementListCellRenderer(JList list, Border cellBorder) {
        this(list, cellBorder, null);
    }

    public ElementListCellRenderer(Border cellBorder, Icon cellIcon, int cellHeight) {
        this(null, cellBorder, cellIcon, cellHeight);
    }

    public ElementListCellRenderer(JList list, Icon cellIcon, int cellHeight) {
        this(list, null, cellIcon, cellHeight);
    }

    public ElementListCellRenderer(JList list, Border cellBorder, int cellHeight) {
        this(list, cellBorder, null, cellHeight);
    }

    public ElementListCellRenderer(JList list, Border cellBorder, Icon cellIcon) {
        this(list, cellBorder, cellIcon, -1);
    }

    public ElementListCellRenderer(JList list, Border cellBorder, Icon cellIcon, int cellHeight) {
        this.list = list;
        this.cellIcon = cellIcon;
        this.setCellBorder(cellBorder);
        this.setCellHeight(cellHeight);
        this.setOpaque(true);
    }

    public JList getList() {
        return this.list;
    }

    public void setList(JList list) {
        this.list = list;
    }

    public Border getCellBorder() {
        return this.cellBorder;
    }

    public void setCellBorder(Border cellBorder) {
        this.cellBorder = cellBorder;
    }

    public Icon getCellIcon() {
        return this.cellIcon;
    }

    public void setCellIcon(Icon cellIcon) {
        this.cellIcon = cellIcon;
    }

    public int getCellHeight() {
        return this.cellHeight;
    }

    public void setCellHeight(int cellHeight) {
        this.cellHeight = cellHeight;
        if (this.list != null && cellHeight > 0) {
            this.list.setFixedCellHeight(cellHeight);
        }
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (this.cellHeight > 0 && list.getFixedCellHeight() != this.cellHeight) {
            list.setFixedCellHeight(this.cellHeight);
        }
        if (value instanceof IElementNode) {
            IElementNode elementNode = (IElementNode)value;
            this.setText(elementNode.getText());
            if (this.cellIcon != null) {
                this.setIcon(this.cellIcon);
            } else {
                this.setIcon(elementNode.getIcon());
            }
            this.setToolTipText(elementNode.getToolTipText());
        } else if (value instanceof Icon) {
            this.setIcon((Icon)value);
        } else {
            if (value != null) {
                this.setText(value.toString());
                this.setToolTipText(value.toString());
            }
            if (this.cellIcon != null) {
                this.setIcon(this.cellIcon);
            }
        }
        if (this.cellBorder != null) {
            this.setBorder(BorderFactory.createCompoundBorder(super.getBorder(), this.cellBorder));
        }
        return this;
    }
}

