/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.framework.reflection;

import com.nepxion.swing.container.ContainerManager;
import com.nepxion.swing.panel.JReflectionPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JDesktopPane;
import javax.swing.JPanel;

public class JReflectionHierarchy
extends JPanel {
    private JDesktopPane desktopPane;
    private JReflectionPanel reflectionPanel;
    private Component contentPane;
    private int widthOffset;
    private int heightOffset;

    public JReflectionHierarchy(final int widthOffset, final int heightOffset) {
        this.widthOffset = widthOffset;
        this.heightOffset = heightOffset;
        this.reflectionPanel = new JReflectionPanel();
        this.desktopPane = new JDesktopPane();
        this.desktopPane.setDragMode(1);
        this.desktopPane.add(this.reflectionPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)this.desktopPane, "Center");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Dimension desktopSize = JReflectionHierarchy.this.desktopPane.getSize();
                Point desktopPoint = JReflectionHierarchy.this.desktopPane.getLocation();
                Dimension panelSize = new Dimension(desktopSize.width - widthOffset * 2, desktopSize.height - heightOffset * 2);
                JReflectionHierarchy.this.reflectionPanel.setSize(panelSize);
                JReflectionHierarchy.this.reflectionPanel.setLocation((desktopSize.width - panelSize.width) / 2 + desktopPoint.x, (desktopSize.height - panelSize.height) / 2 + desktopPoint.y);
                ContainerManager.update(JReflectionHierarchy.this.reflectionPanel);
            }
        });
    }

    public int getWidthOffset() {
        return this.widthOffset;
    }

    public int getHeightOffset() {
        return this.heightOffset;
    }

    public Component getContentPane() {
        return this.contentPane;
    }

    public void setContentPane(Component contentPane) {
        if (this.contentPane == contentPane) {
            return;
        }
        if (this.contentPane != null) {
            this.reflectionPanel.remove(this.contentPane);
        }
        this.contentPane = contentPane;
        this.reflectionPanel.setContent(contentPane);
        ContainerManager.update(this.reflectionPanel);
    }
}

