package com.freemud.springbootdemo.config;

import com.alibaba.druid.pool.DruidDataSource;
import org.springframework.boot.autoconfigure.jdbc.DataSourceBuilder;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

import javax.sql.DataSource;

/**
 * Created by chenwenshun on 2018/8/31.
 */
@Configuration
public class DataSourceConfig {

    @Bean
    @ConfigurationProperties(prefix = "datasource.druid")
    @Primary
    public DataSource dataSource(){
        return DataSourceBuilder.create()
                .type(DruidDataSource.class)
                .build();
    }

//    @Bean
//    @ConfigurationProperties(prefix = "datasource2.druid")
//    public DataSource dataSource2(){
//        return DataSourceBuilder.create()
//                .type(DruidDataSource.class)
//                .build();
//    }


}
